/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendSuggestionsEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.brigadier.TagParseCommandSyntaxException;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.connection.DisconnectionReason;
import io.papermc.paper.connection.PaperPlayerGameConnection;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.event.connection.configuration.PlayerConnectionReconfigureEvent;
import io.papermc.paper.event.packet.ClientTickEndEvent;
import io.papermc.paper.event.packet.UncheckedSignChangeEvent;
import io.papermc.paper.event.player.CartographyItemEvent;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.event.player.PlayerClientLoadedWorldEvent;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.player.PlayerPickBlockEvent;
import io.papermc.paper.event.player.PlayerPickEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.translation.Translator;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.HashedStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTestInstanceBlockStatus;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChangeGameModePacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSubscriptionRequestPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromBlockPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerLoadedPacket;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetTestBlockPacket;
import net.minecraft.network.protocol.game.ServerboundTestInstanceBlockActionPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TickThrottler;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftInput;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.craftbukkit.v1_21_R6.util.LazyPlayerSet;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.player.PlayerBookTooLargeEvent;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements GameProtocols.a,
PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger h = LogUtils.getLogger();
    private static final int i = -1;
    private static final int j = 4096;
    private static final int k = 80;
    private static final IChatBaseComponent l = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    private static final IChatBaseComponent m = IChatBaseComponent.c("chat.disabled.invalid_command_signature").a(EnumChatFormat.m);
    private static final int n = 1000;
    public EntityPlayer f;
    public final PlayerChunkSender g;
    private int o;
    private int p = -1;
    private final TickThrottler q = new TickThrottler(20, 200);
    private final TickThrottler tabSpamThrottler;
    private final TickThrottler r;
    private final TickThrottler recipeSpamPackets;
    private double s;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;
    @Nullable
    private net.minecraft.world.entity.Entity y;
    private double z;
    private double A;
    private double B;
    private double C;
    private double D;
    private double E;
    @Nullable
    private Vec3D F;
    private int G;
    private int H;
    private boolean I;
    private int J;
    private boolean K;
    private int L;
    private int M;
    private int N;
    private boolean O;
    private int lastTick;
    private int allowedPlayerTicks;
    private int lastDropTick;
    private int lastBookTick;
    private int dropCount;
    private boolean hasMoved;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private float lastPitch;
    private float lastYaw;
    private boolean justTeleported;
    @Nullable
    private RemoteChatSession P;
    private boolean hasLoggedExpiry;
    private SignedMessageChain.b Q;
    private final LastSeenMessagesValidator R;
    private int S;
    private final MessageSignatureCache T;
    private final FutureChain U;
    private boolean V;
    private static final int MAX_SIGN_LINE_LENGTH = Integer.getInteger("Paper.maxSignLength", 80);
    private final ClientTickEndEvent tickEndEvent;
    public final PaperPlayerGameConnection playerGameConnection;
    private final LoadingCache<CraftPlayer, Boolean> kickPermissionCache;
    private static final ExecutorService TAB_COMPLETE_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Tab Complete Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.m)).build());
    private int limitedPackets;
    private long lastLimitedPacket;

    public PlayerConnection(MinecraftServer server, NetworkManager connection, EntityPlayer player, CommonListenerCookie cookie) {
        super(server, connection, cookie);
        this.tabSpamThrottler = new TickThrottler(GlobalConfiguration.get().spamLimiter.tabSpamIncrement, GlobalConfiguration.get().spamLimiter.tabSpamLimit);
        this.r = new TickThrottler(20, 1480);
        this.recipeSpamPackets = new TickThrottler(GlobalConfiguration.get().spamLimiter.recipeSpamIncrement, GlobalConfiguration.get().spamLimiter.recipeSpamLimit);
        this.lastTick = MinecraftServer.currentTick;
        this.allowedPlayerTicks = 1;
        this.lastDropTick = MinecraftServer.currentTick;
        this.lastBookTick = MinecraftServer.currentTick;
        this.dropCount = 0;
        this.hasMoved = false;
        this.lastPosX = Double.MAX_VALUE;
        this.lastPosY = Double.MAX_VALUE;
        this.lastPosZ = Double.MAX_VALUE;
        this.lastPitch = Float.MAX_VALUE;
        this.lastYaw = Float.MAX_VALUE;
        this.justTeleported = false;
        this.hasLoggedExpiry = false;
        this.R = new LastSeenMessagesValidator(20);
        this.T = MessageSignatureCache.a();
        this.kickPermissionCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<CraftPlayer, Boolean>(this){

            public Boolean load(CraftPlayer player) {
                return player.hasPermission("purpur.bypassIdleKick");
            }
        });
        this.lastLimitedPacket = -1L;
        this.g = new PlayerChunkSender(connection.e());
        this.f = player;
        player.g = this;
        player.Y().a();
        this.Q = SignedMessageChain.b.unsigned(player.cT(), server::aC);
        this.U = new FutureChain(server.chatExecutor);
        this.tickEndEvent = new ClientTickEndEvent((Player)player.getBukkitEntity());
        this.playerGameConnection = new PaperPlayerGameConnection(this);
    }

    @Override
    public PlayerCommonConnection getApiConnection() {
        return this.playerGameConnection;
    }

    @Override
    public Audience getAudience() {
        return this.getCraftPlayer();
    }

    @Override
    public void d() {
        if (this.p > -1) {
            this.b(new ClientboundBlockChangedAckPacket(this.p));
            this.p = -1;
        }
        if (this.d.J() || !this.p()) {
            this.e();
            this.q.b();
            this.r.b();
            this.tabSpamThrottler.b();
            this.recipeSpamPackets.b();
            if (this.f.P() > 0L && this.d.au() > 0 && SystemUtils.c() - this.f.P() > TimeUnit.MINUTES.toMillis(this.d.au()) && !this.f.k) {
                this.f.setAfk(true);
                if (!this.f.A().purpurConfig.idleTimeoutKick || !Boolean.parseBoolean(System.getenv("PURPUR_FORCE_IDLE_KICK")) && ((Boolean)this.kickPermissionCache.getUnchecked((Object)this.f.getBukkitEntity())).booleanValue()) {
                    return;
                }
                this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.idling"), PlayerKickEvent.Cause.IDLING);
            }
        }
    }

    private boolean p() {
        this.l();
        this.f.Y = this.f.dK();
        this.f.Z = this.f.dM();
        this.f.aa = this.f.dQ();
        this.f.h();
        this.f.a(this.s, this.t, this.u, this.f.dX(), this.f.dZ());
        ++this.o;
        this.N = this.M;
        if (this.I && !this.f.gg() && !this.f.cl() && !this.f.eV()) {
            if (++this.J > this.a(this.f)) {
                this.disconnect(GlobalConfiguration.get().messages.kick.flyingPlayer, PlayerKickEvent.Cause.FLYING_PLAYER);
                return true;
            }
        } else {
            this.I = false;
            this.J = 0;
        }
        this.y = this.f.dp();
        if (this.y != this.f && this.y.dg() == this.f) {
            this.z = this.y.dK();
            this.A = this.y.dM();
            this.B = this.y.dQ();
            this.C = this.y.dK();
            this.D = this.y.dM();
            this.E = this.y.dQ();
            if (this.K && this.y.dg() == this.f) {
                if (++this.L > this.a(this.y)) {
                    this.disconnect(GlobalConfiguration.get().messages.kick.flyingVehicle, PlayerKickEvent.Cause.FLYING_VEHICLE);
                    return true;
                }
            } else {
                this.K = false;
                this.L = 0;
            }
        } else {
            this.y = null;
            this.K = false;
            this.L = 0;
        }
        if (!this.hasLoggedExpiry && this.P != null && this.P.d().b().a()) {
            h.info("Player profile key for {} has expired!", (Object)this.f.ap());
            this.hasLoggedExpiry = true;
        }
        return false;
    }

    private int a(net.minecraft.world.entity.Entity entity) {
        double gravity = entity.bp();
        if (gravity < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d2 = 0.08 / gravity;
        return MathHelper.c(80.0 * Math.max(d2, 1.0));
    }

    public void l() {
        this.s = this.f.dK();
        this.t = this.f.dM();
        this.u = this.f.dQ();
        this.v = this.f.dK();
        this.w = this.f.dM();
        this.x = this.f.dQ();
    }

    @Override
    public boolean c() {
        return this.e.i() && !this.V;
    }

    @Override
    public boolean a(Packet<?> packet) {
        return super.a(packet) || this.V && this.e.i() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile i() {
        return this.f.gz();
    }

    private <T, R> CompletableFuture<R> a(T message, BiFunction<ITextFilter, T, CompletableFuture<R>> processor) {
        return processor.apply(this.f.Y(), (ITextFilter)message).thenApply(result -> {
            if (!this.c()) {
                h.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return result;
        });
    }

    private CompletableFuture<FilteredText> a(String text) {
        return this.a(text, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> texts) {
        return this.a(texts, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packet) {
        Input lastInput;
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (!packet.b().equals(this.f.ah())) {
            PlayerInputEvent event = new PlayerInputEvent((Player)this.f.getBukkitEntity(), (org.bukkit.Input)new CraftInput(packet.b()));
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if ((lastInput = this.f.ah()).f() != packet.b().f()) {
            PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packet.b().f());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled() && this.f.hb()) {
                this.f.h(packet.b().f());
            }
        }
        this.f.a(packet.b());
        if (this.f.hb()) {
            this.f.J();
        }
        if (packet.b().f() && this.f.A().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.f.k();
        }
    }

    private static boolean b(double x2, double y2, double z2, float yRot, float xRot) {
        return Double.isNaN(x2) || Double.isNaN(y2) || Double.isNaN(z2) || !Floats.isFinite((float)xRot) || !Floats.isFinite((float)yRot);
    }

    private static double a(double value) {
        return MathHelper.a(value, -3.0E7, 3.0E7);
    }

    private static double b(double value) {
        return MathHelper.a(value, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (PlayerConnection.b(packet.b().a(), packet.b().b(), packet.b().c(), packet.e(), packet.f())) {
            this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"), PlayerKickEvent.Cause.INVALID_VEHICLE_MOVEMENT);
        } else if (!this.q() && this.f.hb()) {
            net.minecraft.world.entity.Entity rootVehicle = this.f.dp();
            if (this.F != null || this.f.fv() || rootVehicle.ec()) {
                return;
            }
            if (rootVehicle != this.f && rootVehicle.dg() == this.f && rootVehicle == this.y) {
                boolean teleportBack;
                EntityLiving livingEntity;
                double d2;
                double d1;
                double d3;
                WorldServer serverLevel = this.f.A();
                double prevX = this.f.dK();
                double prevY = this.f.dM();
                double prevZ = this.f.dQ();
                float prevYaw = this.f.dX();
                float prevPitch = this.f.dZ();
                double x2 = rootVehicle.dK();
                double y2 = rootVehicle.dM();
                double z2 = rootVehicle.dQ();
                double toX = d3 = PlayerConnection.a(packet.b().a());
                double toY = d1 = PlayerConnection.b(packet.b().b());
                double toZ = d2 = PlayerConnection.a(packet.b().c());
                float f2 = MathHelper.h(packet.e());
                float f1 = MathHelper.h(packet.f());
                double d32 = d3 - this.z;
                double d4 = d1 - this.A;
                double d5 = d2 - this.B;
                double d6 = rootVehicle.dI().h();
                double d7 = d32 * d32 + d4 * d4 + d5 * d5;
                double currDeltaX = toX - x2;
                double currDeltaY = toY - y2;
                double currDeltaZ = toZ - z2;
                d7 = Math.max(d7, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                double otherFieldX = toX - this.C;
                double otherFieldY = toY - this.D;
                double otherFieldZ = toZ - this.E;
                d7 = Math.max(d7, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.M;
                int i2 = this.M - this.N;
                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                    h.debug(this.f.cV() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                    i2 = 1;
                }
                this.allowedPlayerTicks = d7 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.f.gC().b ? (double)(this.f.gC().m * 20.0f) : (double)(this.f.gC().n * 10.0f);
                speed *= 2.0;
                if (!(!this.f.A().paperConfig().chunks.preventMovingIntoUnloadedChunks || serverLevel.areChunksLoadedForMove(this.f.de().b(new Vec3D(toX, toY, toZ).d(this.f.dD()))) && serverLevel.areChunksLoadedForMove(rootVehicle.de().b(new Vec3D(toX, toY, toZ).d(rootVehicle.dD()))))) {
                    this.e.a(PacketPlayOutVehicleMove.a(rootVehicle));
                    return;
                }
                if (d7 - d6 > Math.max(100.0, MathHelper.l(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed)) && !this.h()) {
                    h.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{rootVehicle.ap(), this.f.ap(), d32, d4, d5});
                    this.b(PacketPlayOutVehicleMove.a(rootVehicle));
                    return;
                }
                AxisAlignedBB boundingBox = rootVehicle.de();
                d32 = d3 - this.C;
                d4 = d1 - this.D;
                d5 = d2 - this.E;
                boolean flag = rootVehicle.af;
                if (rootVehicle instanceof EntityLiving && (livingEntity = (EntityLiving)rootVehicle).fe()) {
                    livingEntity.l();
                }
                rootVehicle.a(EnumMoveType.b, new Vec3D(d32, d4, d5));
                boolean didCollide = toX != rootVehicle.dK() || toY != rootVehicle.dM() || toZ != rootVehicle.dQ();
                double verticalDelta = d4;
                d32 = d3 - rootVehicle.dK();
                d4 = d1 - rootVehicle.dM();
                if (d4 > -0.5 || d4 < 0.5) {
                    d4 = 0.0;
                }
                d5 = d2 - rootVehicle.dQ();
                d7 = d32 * d32 + d4 * d4 + d5 * d5;
                boolean flag1 = false;
                if (d7 > SpigotConfig.movedWronglyThreshold) {
                    flag1 = true;
                    h.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{rootVehicle.ap(), this.f.ap(), Math.sqrt(d7)});
                }
                if (!(teleportBack = flag1)) {
                    AxisAlignedBB newBox = rootVehicle.de();
                    if (didCollide || !boundingBox.equals(newBox)) {
                        teleportBack = this.hasNewCollision(serverLevel, rootVehicle, boundingBox, newBox);
                    }
                }
                if (teleportBack) {
                    rootVehicle.a(x2, y2, z2, f2, f1);
                    this.b(PacketPlayOutVehicleMove.a(rootVehicle));
                    rootVehicle.aU();
                    return;
                }
                rootVehicle.a(d3, d1, d2, f2, f1);
                this.f.a(d3, d1, d2, this.f.dX(), this.f.dZ());
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = prevX;
                    this.lastPosY = prevY;
                    this.lastPosZ = prevZ;
                    this.lastYaw = prevYaw;
                    this.lastPitch = prevPitch;
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = CraftLocation.toBukkit(packet.b(), player.getWorld(), packet.e(), packet.f());
                double delta = MathHelper.l(this.lastPosX - to.getX()) + MathHelper.l(this.lastPosY - to.getY()) + MathHelper.l(this.lastPosZ - to.getZ());
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fv()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    if (!to.getWorld().getUID().equals(from.getWorld().getUID()) || to.getBlockX() != from.getBlockX() || to.getBlockY() != from.getBlockY() || to.getBlockZ() != from.getBlockZ() || to.getYaw() != from.getYaw() || to.getPitch() != from.getPitch()) {
                        this.f.J();
                    }
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.internalTeleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.f.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.f.A().n().a(this.f);
                Vec3D vec3 = new Vec3D(rootVehicle.dK() - x2, rootVehicle.dM() - y2, rootVehicle.dQ() - z2);
                this.a(vec3);
                rootVehicle.a(packet.g(), vec3);
                rootVehicle.a(vec3.g, vec3.h, vec3.i, packet.g());
                this.f.a(vec3.g, vec3.h, vec3.i);
                this.K = verticalDelta >= -0.03125 && !flag && !this.d.aj() && !rootVehicle.eh() && !rootVehicle.bn() && this.b(rootVehicle);
                this.C = rootVehicle.dK();
                this.D = rootVehicle.dM();
                this.E = rootVehicle.dQ();
            }
        }
    }

    private boolean b(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB box = entity.de().g(0.0625).b(0.0, -0.55, 0.0);
        int minX = MathHelper.a(box.a);
        int minY = MathHelper.a(box.b);
        int minZ = MathHelper.a(box.c);
        int maxX = MathHelper.a(box.d);
        int maxY = MathHelper.a(box.e);
        int maxZ = MathHelper.a(box.f);
        net.minecraft.world.level.World level = entity.an();
        BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int x2 = minX; x2 <= maxX; ++x2) {
                    pos.d(x2, y2, z2);
                    IBlockData blockState = level.getBlockStateIfLoaded(pos);
                    if (blockState == null || blockState.l()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void a(PacketPlayInTeleportAccept packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (packet.b() == this.G) {
            if (this.F == null) {
                h.warn("Disconnected on accept teleport packet. Was not expecting position data from client at this time");
                this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
                return;
            }
            this.f.a(this.F.g, this.F.h, this.F.i, this.f.dX(), this.f.dZ());
            this.v = this.F.g;
            this.w = this.F.h;
            this.x = this.F.i;
            this.f.T();
            this.F = null;
            this.f.A().n().a(this.f);
        }
    }

    @Override
    public void a(ServerboundPlayerLoadedPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.hb()) {
            return;
        }
        PlayerClientLoadedWorldEvent event = new PlayerClientLoadedWorldEvent((Player)this.f.getBukkitEntity(), false);
        event.callEvent();
        this.f.w(true);
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        CraftingManager.d recipeFromDisplay = this.d.aN().a(packet.b());
        if (recipeFromDisplay != null) {
            this.f.L().d(recipeFromDisplay.b().a());
        }
    }

    @Override
    public void a(ServerboundSelectBundleItemPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.f.cl.a(packet.b(), packet.e());
    }

    @Override
    public void a(PacketPlayInRecipeSettings packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        CraftEventFactory.callRecipeBookSettingsEvent(this.f, packet.b(), packet.e(), packet.f());
        this.f.L().a(packet.b(), packet.e(), packet.f());
    }

    @Override
    public void a(PacketPlayInAdvancements packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (packet.e() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey resourceLocation = Objects.requireNonNull(packet.f());
            AdvancementHolder advancementHolder = this.d.aF().a(resourceLocation);
            if (advancementHolder != null) {
                this.f.U().a(advancementHolder);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packet) {
        int index;
        if (!(this.tabSpamThrottler.isIncrementAndUnderThreshold() || this.d.am().f(this.f.gA()) || this.d.a(this.f.gA()))) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        if (packet.e().length() > 64 && ((index = packet.e().indexOf(32)) == -1 || index >= 64)) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        TAB_COMPLETE_EXECUTOR.execute(() -> this.handleCustomCommandSuggestions0(packet));
    }

    private void handleCustomCommandSuggestions0(PacketPlayInTabComplete packet) {
        Object completions;
        StringReader stringReader = new StringReader(packet.e());
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)this.getCraftPlayer(), packet.e(), true, null);
        event.callEvent();
        Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
        if (!event.isHandled()) {
            if (event.isCancelled()) {
                return;
            }
            this.d.scheduleOnMain(() -> this.sendServerSuggestions(packet, stringReader));
        } else if (!completions.isEmpty()) {
            SuggestionsBuilder builder0 = new SuggestionsBuilder(packet.e(), stringReader.getTotalLength());
            SuggestionsBuilder builder = builder0.createOffset(builder0.getInput().lastIndexOf(32) + 1);
            Iterator iterator = completions.iterator();
            while (iterator.hasNext()) {
                AsyncTabCompleteEvent.Completion completion = (AsyncTabCompleteEvent.Completion)iterator.next();
                Integer intSuggestion = Ints.tryParse((String)completion.suggestion());
                if (intSuggestion != null) {
                    builder.suggest(intSuggestion.intValue(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    continue;
                }
                builder.suggest(completion.suggestion(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
            }
            Suggestions suggestions = (Suggestions)builder.buildFuture().join();
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, packet.e());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.e.a(new PacketPlayOutTabComplete(packet.b(), PlayerConnection.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        }
    }

    private static Suggestions limitTo(Suggestions suggestions, int size) {
        return suggestions.getList().size() <= size ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, size));
    }

    private void sendServerSuggestions(PacketPlayInTabComplete packet, StringReader stringReader) {
        ParseResults<CommandListenerWrapper> parseResults = this.d.aJ().a().parse(stringReader, this.f.C());
        if (!parseResults.getExceptions().isEmpty() && parseResults.getExceptions().values().stream().anyMatch(e2 -> e2 instanceof TagParseCommandSyntaxException)) {
            this.disconnect((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        this.d.aJ().a().getCompletionSuggestions(parseResults).thenAccept(suggestions -> {
            if (!SpigotConfig.sendNamespaced && suggestions.getRange().getStart() <= 1) {
                suggestions.getList().removeIf(suggestion -> suggestion.getText().contains(":"));
            }
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, packet.e());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.b(new PacketPlayOutTabComplete(packet.b(), PlayerConnection.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (!this.d.y_()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.f.gX() || this.f.gQ() && this.f.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract baseCommandBlock = null;
            TileEntityCommand commandBlockEntity = null;
            BlockPosition pos = packet.b();
            TileEntity blockEntity = this.f.A().c_(pos);
            if (blockEntity instanceof TileEntityCommand) {
                commandBlockEntity = (TileEntityCommand)blockEntity;
                baseCommandBlock = commandBlockEntity.a();
            }
            String command = packet.e();
            boolean isTrackOutput = packet.f();
            if (baseCommandBlock != null) {
                TileEntityCommand.Type mode = commandBlockEntity.l();
                IBlockData blockState = this.f.A().a_(pos);
                EnumDirection direction = blockState.c(BlockCommand.b);
                IBlockData blockState1 = switch (packet.i()) {
                    case TileEntityCommand.Type.a -> Blocks.lD.m();
                    case TileEntityCommand.Type.b -> Blocks.lC.m();
                    default -> Blocks.gC.m();
                };
                IBlockData blockState2 = (IBlockData)((IBlockData)blockState1.b(BlockCommand.b, direction)).b(BlockCommand.c, packet.g());
                if (blockState2 != blockState) {
                    this.f.A().a(pos, blockState2, 2);
                    blockEntity.c(blockState2);
                    this.f.A().m(pos).a(blockEntity);
                }
                baseCommandBlock.a(command);
                baseCommandBlock.a(isTrackOutput);
                if (!isTrackOutput) {
                    baseCommandBlock.b(null);
                }
                commandBlockEntity.b(packet.h());
                if (mode != packet.i()) {
                    commandBlockEntity.f();
                }
                baseCommandBlock.b();
                if (!UtilColor.b(command)) {
                    this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{command}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (!this.d.y_()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.f.gX() || this.f.gQ() && this.f.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandBlock = packet.a(this.f.A());
            if (commandBlock != null) {
                commandBlock.a(packet.b());
                commandBlock.a(packet.e());
                if (!packet.e()) {
                    commandBlock.b(null);
                }
                commandBlock.b();
                this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{packet.b()}));
            }
        }
    }

    @Override
    public void a(ServerboundPickItemFromBlockPacket packet) {
        boolean flag;
        IBlockData blockState;
        net.minecraft.world.item.ItemStack cloneItemStack;
        WorldServer serverLevel = this.f.A();
        PlayerConnectionUtils.a(packet, this, serverLevel);
        BlockPosition blockPos = packet.b();
        if (this.f.a(blockPos, 1.0) && serverLevel.p(blockPos) && !(cloneItemStack = (blockState = serverLevel.a_(blockPos)).a((IWorldReader)serverLevel, blockPos, flag = this.f.gk() && packet.e())).f()) {
            if (flag && this.f.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                PlayerConnection.a(blockState, serverLevel, blockPos, cloneItemStack);
            }
            this.tryPickItem(cloneItemStack, blockPos, null, packet.e());
        }
    }

    private static void a(IBlockData state, WorldServer level, BlockPosition pos, net.minecraft.world.item.ItemStack stack) {
        TileEntity blockEntity;
        TileEntity tileEntity = blockEntity = state.x() ? level.c_(pos) : null;
        if (blockEntity != null) {
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(blockEntity.v(), h);){
                TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, level.L_());
                blockEntity.f(tagValueOutput);
                blockEntity.b(tagValueOutput);
                ItemBlock.a(stack, blockEntity.s(), tagValueOutput);
                stack.b(blockEntity.t());
            }
        }
    }

    @Override
    public void a(ServerboundPickItemFromEntityPacket packet) {
        net.minecraft.world.item.ItemStack pickResult;
        WorldServer serverLevel = this.f.A();
        PlayerConnectionUtils.a(packet, this, serverLevel);
        net.minecraft.world.entity.Entity entityOrPart = serverLevel.b(packet.b());
        if (entityOrPart != null && this.f.b(entityOrPart, 3.0) && (pickResult = entityOrPart.dU()) != null && !pickResult.f()) {
            this.tryPickItem(pickResult, null, entityOrPart, packet.e());
        }
    }

    private void tryPickItem(net.minecraft.world.item.ItemStack stack, @Nullable BlockPosition blockPos, @Nullable net.minecraft.world.entity.Entity entity, boolean includeData) {
        if (stack.a(this.f.A().O())) {
            PlayerPickEntityEvent event;
            PlayerInventory inventory = this.f.gB();
            int i2 = inventory.d(stack);
            int sourceSlot = i2;
            int targetSlot = PlayerInventory.e(sourceSlot) ? sourceSlot : inventory.l();
            CraftPlayer bukkitPlayer = this.f.getBukkitEntity();
            Object object = event = entity != null ? new PlayerPickEntityEvent((Player)bukkitPlayer, (Entity)entity.getBukkitEntity(), includeData, targetSlot, sourceSlot) : new PlayerPickBlockEvent((Player)bukkitPlayer, (Block)CraftBlock.at(this.f.A(), blockPos), includeData, targetSlot, sourceSlot);
            if (!event.callEvent()) {
                return;
            }
            i2 = event.getSourceSlot();
            if (i2 != -1) {
                if (PlayerInventory.e(i2) && PlayerInventory.e(event.getTargetSlot())) {
                    inventory.c(event.getTargetSlot());
                } else {
                    inventory.pickSlot(i2, event.getTargetSlot());
                }
            } else if (this.f.gk()) {
                inventory.addAndPickItem(stack, event.getTargetSlot());
            }
            this.b(new PacketPlayOutHeldItemSlot(inventory.g()));
            this.f.ck.d();
            if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                this.f.L();
            }
        }
    }

    @Override
    public void a(PacketPlayInItemName packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        Container container = this.f.cl;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil anvilMenu = (ContainerAnvil)container;
            if (!anvilMenu.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)anvilMenu);
                return;
            }
            anvilMenu.a(packet.b());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        Container container = this.f.cl;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon beaconMenu = (ContainerBeacon)container;
            if (!this.f.cl.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cl);
                return;
            }
            beaconMenu.a(packet.b(), packet.e());
        }
    }

    @Override
    public void a(PacketPlayInStruct packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.gX()) {
            BlockPosition pos = packet.b();
            IBlockData blockState = this.f.A().a_(pos);
            TileEntity tileEntity = this.f.A().c_(pos);
            if (tileEntity instanceof TileEntityStructure) {
                TileEntityStructure structureBlockEntity = (TileEntityStructure)tileEntity;
                structureBlockEntity.a(packet.f());
                structureBlockEntity.a(packet.g());
                structureBlockEntity.a(packet.h());
                structureBlockEntity.a(packet.i());
                structureBlockEntity.a(packet.j());
                structureBlockEntity.a(packet.k());
                structureBlockEntity.b(packet.l());
                structureBlockEntity.a(packet.m());
                structureBlockEntity.b(packet.n());
                structureBlockEntity.e(packet.o());
                structureBlockEntity.f(packet.p());
                structureBlockEntity.a(packet.q());
                structureBlockEntity.a(packet.r());
                if (structureBlockEntity.f()) {
                    String structureName = structureBlockEntity.d();
                    if (packet.e() == TileEntityStructure.UpdateType.b) {
                        if (structureBlockEntity.D()) {
                            this.f.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{structureName}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{structureName}), false);
                        }
                    } else if (packet.e() == TileEntityStructure.UpdateType.c) {
                        if (!structureBlockEntity.F()) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{structureName}), false);
                        } else if (structureBlockEntity.a(this.f.A())) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{structureName}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{structureName}), false);
                        }
                    } else if (packet.e() == TileEntityStructure.UpdateType.d) {
                        if (structureBlockEntity.C()) {
                            this.f.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{structureName}), false);
                        } else {
                            this.f.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.f.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packet.g()}), false);
                }
                structureBlockEntity.e();
                this.f.A().a(pos, blockState, blockState, 3);
            }
        }
    }

    @Override
    public void a(ServerboundSetTestBlockPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.gX()) {
            BlockPosition blockPos = packet.b();
            IBlockData blockState = this.f.A().a_(blockPos);
            TileEntity tileEntity = this.f.A().c_(blockPos);
            if (tileEntity instanceof TestBlockEntity) {
                TestBlockEntity testBlockEntity = (TestBlockEntity)tileEntity;
                testBlockEntity.a(packet.e());
                testBlockEntity.a(packet.f());
                testBlockEntity.e();
                this.f.A().a(blockPos, blockState, testBlockEntity.o(), 3);
            }
        }
    }

    @Override
    public void a(ServerboundTestInstanceBlockActionPacket packet) {
        TileEntity tileEntity;
        PlayerConnectionUtils.a(packet, this, this.f.A());
        BlockPosition blockPos = packet.b();
        if (this.f.gX() && (tileEntity = this.f.A().c_(blockPos)) instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity testInstanceBlockEntity = (TestInstanceBlockEntity)tileEntity;
            if (packet.e() != ServerboundTestInstanceBlockActionPacket.a.b && packet.e() != ServerboundTestInstanceBlockActionPacket.a.a) {
                testInstanceBlockEntity.a(packet.f());
                if (packet.e() == ServerboundTestInstanceBlockActionPacket.a.d) {
                    testInstanceBlockEntity.a(this.f::a);
                } else if (packet.e() == ServerboundTestInstanceBlockActionPacket.a.e) {
                    testInstanceBlockEntity.b(this.f::a);
                } else if (packet.e() == ServerboundTestInstanceBlockActionPacket.a.f) {
                    testInstanceBlockEntity.c(this.f::a);
                } else if (packet.e() == ServerboundTestInstanceBlockActionPacket.a.g) {
                    testInstanceBlockEntity.d(this.f::a);
                }
                IBlockData blockState = this.f.A().a_(blockPos);
                this.f.A().a(blockPos, Blocks.a.m(), blockState, 3);
            } else {
                IRegistry<GameTestInstance> registry = this.f.ej().f(Registries.bp);
                Optional optional = packet.f().a().flatMap(registry::a);
                IChatBaseComponent component = optional.isPresent() ? ((GameTestInstance)((Holder.c)optional.get()).a()).c() : IChatBaseComponent.c("test_instance.description.no_test").a(EnumChatFormat.m);
                Optional<Object> optional1 = packet.e() == ServerboundTestInstanceBlockActionPacket.a.b ? packet.f().a().flatMap(resourceKey -> TestInstanceBlockEntity.a(this.f.A(), resourceKey)) : Optional.empty();
                this.e.a(new ClientboundTestInstanceBlockStatus(component, optional1));
            }
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.gX()) {
            BlockPosition pos = packet.b();
            IBlockData blockState = this.f.A().a_(pos);
            TileEntity tileEntity = this.f.A().c_(pos);
            if (tileEntity instanceof TileEntityJigsaw) {
                TileEntityJigsaw jigsawBlockEntity = (TileEntityJigsaw)tileEntity;
                jigsawBlockEntity.a(packet.e());
                jigsawBlockEntity.b(packet.f());
                jigsawBlockEntity.a(ResourceKey.a(Registries.bn, packet.g()));
                jigsawBlockEntity.a(packet.h());
                jigsawBlockEntity.a(packet.i());
                jigsawBlockEntity.a(packet.k());
                jigsawBlockEntity.b(packet.j());
                jigsawBlockEntity.e();
                this.f.A().a(pos, blockState, blockState, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.gX()) {
            BlockPosition pos = packet.b();
            TileEntity tileEntity = this.f.A().c_(pos);
            if (tileEntity instanceof TileEntityJigsaw) {
                TileEntityJigsaw jigsawBlockEntity = (TileEntityJigsaw)tileEntity;
                jigsawBlockEntity.a(this.f.A(), packet.e(), packet.f());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        int item = packet.b();
        Container container = this.f.cl;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant merchantMenu = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(item, merchantMenu);
            if (tradeSelectEvent.isCancelled()) {
                this.f.cl.b();
                return;
            }
            if (!merchantMenu.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)merchantMenu);
                return;
            }
            merchantMenu.e(item);
            merchantMenu.h(item);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packet) {
        IntOr.Disabled pageMax = GlobalConfiguration.get().itemValidation.bookSize.pageMax;
        if (!this.cserver.isPrimaryThread() && pageMax.enabled()) {
            List<String> pageList = packet.e();
            long byteTotal = 0L;
            int maxBookPageSize = pageMax.intValue();
            double multiplier = Math.clamp(GlobalConfiguration.get().itemValidation.bookSize.totalMultiplier, 0.3, 1.0);
            long byteAllowed = maxBookPageSize;
            int slot = packet.b();
            net.minecraft.world.item.ItemStack itemstack = PlayerInventory.e(slot) || slot == 40 ? this.f.gB().a(slot) : net.minecraft.world.item.ItemStack.l;
            for (String page : pageList) {
                int byteLength = page.getBytes(StandardCharsets.UTF_8).length;
                byteTotal += (long)byteLength;
                int length = page.length();
                int multiByteCharacters = 0;
                if (byteLength != length) {
                    for (char c2 : page.toCharArray()) {
                        if (c2 <= '\u007f') continue;
                        ++multiByteCharacters;
                    }
                }
                byteAllowed = (long)((double)byteAllowed + (double)maxBookPageSize * Math.clamp((double)length / 255.0, 0.1, 1.0) * multiplier);
                if (multiByteCharacters <= 1) continue;
                byteAllowed -= (long)multiByteCharacters;
            }
            if (byteTotal > byteAllowed) {
                h.warn("{} tried to send too large of a book. Book size: {} - Allowed: {} - Pages: {}", new Object[]{this.f.cV(), byteTotal, byteAllowed, pageList.size()});
                PlayerBookTooLargeEvent event = new PlayerBookTooLargeEvent((Player)this.f.getBukkitEntity(), itemstack.asBukkitCopy());
                if (event.shouldKickPlayer()) {
                    this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.b("Book too large!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                }
                return;
            }
        }
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.b("Book edited too quickly!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int slot = packet.b();
        if (PlayerInventory.e(slot) || slot == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packet.f();
            optional.ifPresent(list::add);
            list.addAll(packet.e());
            boolean hasEditPerm = this.getCraftPlayer().hasPermission("purpur.book.color.edit");
            boolean hasSignPerm = hasEditPerm || this.getCraftPlayer().hasPermission("purpur.book.color.sign");
            Consumer<List> consumer = optional.isPresent() ? texts -> this.signBook((FilteredText)texts.get(0), texts.subList(1, texts.size()), slot, hasSignPerm) : list1 -> this.updateBookContents((List<FilteredText>)list1, slot, hasEditPerm);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.d);
        }
    }

    private void a(List<FilteredText> pages, int index) {
        this.updateBookContents(pages, index, false);
    }

    private void updateBookContents(List<FilteredText> pages, int index, boolean hasPerm) {
        net.minecraft.world.item.ItemStack handItem = this.f.gB().a(index);
        net.minecraft.world.item.ItemStack item = handItem.v();
        if (item.c(DataComponents.U)) {
            List<Filterable<String>> list = pages.stream().map(filteredText -> this.a((FilteredText)filteredText).a((T s2) -> this.color((String)s2, hasPerm))).toList();
            item.b(DataComponents.U, new WritableBookContent(list));
            this.f.gB().a(index, CraftEventFactory.handleEditBookEvent(this.f, index, handItem, item));
        }
    }

    private void a(FilteredText title, List<FilteredText> pages, int index) {
        this.signBook(title, pages, index, false);
    }

    private void signBook(FilteredText title, List<FilteredText> pages, int index, boolean hasPerm) {
        net.minecraft.world.item.ItemStack item = this.f.gB().a(index);
        if (item.c(DataComponents.U)) {
            net.minecraft.world.item.ItemStack itemStack = item.a((IMaterial)Items.wh);
            itemStack.e(DataComponents.U);
            List<Filterable<IChatBaseComponent>> list = pages.stream().map(filteredText -> this.a((FilteredText)filteredText).a((T s2) -> this.hexColor((String)s2, hasPerm))).toList();
            itemStack.b(DataComponents.V, new WrittenBookContent(this.a(title), this.f.ap(), 0, list, true));
            CraftEventFactory.handleEditBookEvent(this.f, index, item, itemStack);
            this.f.gB().a(index, item);
        }
    }

    private Filterable<String> a(FilteredText filteredText) {
        return this.f.Z() ? Filterable.a(filteredText.b()) : Filterable.a(filteredText);
    }

    private IChatBaseComponent hexColor(String str, boolean hasPerm) {
        return hasPerm ? PaperAdventure.asVanilla((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(str)) : IChatBaseComponent.b(str);
    }

    private String color(String str, boolean hasPerm) {
        return hasPerm ? ChatColor.color((String)str, (boolean)false) : str;
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packet) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.s(2) && (entity = this.f.A().a(packet.e())) != null) {
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(entity.en(), h);){
                TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, entity.ej());
                entity.d(tagValueOutput);
                NBTTagCompound compoundTag = tagValueOutput.b();
                this.b(new PacketPlayOutNBTQuery(packet.b(), compoundTag));
            }
        }
    }

    @Override
    public void a(ServerboundContainerSlotStateChangedPacket packet) {
        CrafterMenu crafterMenu;
        Object object;
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (!this.f.at() && packet.e() == this.f.cl.l && (object = this.f.cl) instanceof CrafterMenu && (object = (crafterMenu = (CrafterMenu)object).m()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)object;
            crafterBlockEntity.a(packet.b(), packet.f());
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.s(2)) {
            TileEntity blockEntity = this.f.A().c_(packet.e());
            NBTTagCompound compoundTag = blockEntity != null ? blockEntity.c(this.f.ej()) : null;
            this.b(new PacketPlayOutNBTQuery(packet.b(), compoundTag));
        }
    }

    @Override
    public void a(PacketPlayInFlying packet) {
        boolean invalidPitch;
        PlayerConnectionUtils.a(packet, this, this.f.A());
        boolean invalidX = Double.isNaN(packet.a(0.0));
        boolean invalidY = Double.isNaN(packet.b(0.0));
        boolean invalidZ = Double.isNaN(packet.c(0.0));
        boolean invalidYaw = !Floats.isFinite((float)packet.a(0.0f));
        boolean bl = invalidPitch = !Floats.isFinite((float)packet.b(0.0f));
        if (invalidX || invalidY || invalidZ || invalidYaw || invalidPitch) {
            h.warn(String.format("Disconnected on move player packet. Invalid data: x=%b, y=%b, z=%b, yaw=%b, pitch=%b", invalidX, invalidY, invalidZ, invalidYaw, invalidPitch));
            this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
        } else {
            WorldServer serverLevel = this.f.A();
            if (!this.f.k && !this.f.fv()) {
                if (this.o == 0) {
                    this.l();
                }
                if (this.f.hb()) {
                    float f1;
                    float f2;
                    float toYaw = f2 = MathHelper.h(packet.a(this.f.dX()));
                    float toPitch = f1 = MathHelper.h(packet.b(this.f.dZ()));
                    if (this.q()) {
                        this.f.b(f2, f1);
                    } else {
                        double d2;
                        double d1;
                        double d3;
                        double toX = d3 = PlayerConnection.a(packet.a(this.f.dK()));
                        double toY = d1 = PlayerConnection.b(packet.b(this.f.dM()));
                        double toZ = d2 = PlayerConnection.a(packet.c(this.f.dQ()));
                        if (this.f.cl()) {
                            this.f.a(this.f.dK(), this.f.dM(), this.f.dQ(), f2, f1);
                            this.f.A().n().a(this.f);
                            this.allowedPlayerTicks = 20;
                        } else {
                            double prevX = this.f.dK();
                            double prevY = this.f.dM();
                            double prevZ = this.f.dQ();
                            float prevYaw = this.f.dX();
                            float prevPitch = this.f.dZ();
                            double x2 = this.f.dK();
                            double y2 = this.f.dM();
                            double z2 = this.f.dQ();
                            double d32 = d3 - this.s;
                            double d4 = d1 - this.t;
                            double d5 = d2 - this.u;
                            double d6 = this.f.dI().h();
                            double d7 = d32 * d32 + d4 * d4 + d5 * d5;
                            double currDeltaX = toX - prevX;
                            double currDeltaY = toY - prevY;
                            double currDeltaZ = toZ - prevZ;
                            d7 = Math.max(d7, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                            double otherFieldX = d3 - this.v;
                            double otherFieldY = d1 - this.w;
                            double otherFieldZ = d2 - this.x;
                            d7 = Math.max(d7, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                            if (this.f.gg()) {
                                if (d7 > 1.0) {
                                    this.a(this.f.dK(), this.f.dM(), this.f.dQ(), f2, f1);
                                }
                            } else {
                                PlayerFailMoveEvent event;
                                PlayerFailMoveEvent event2;
                                boolean didCollide;
                                boolean flag;
                                boolean isFallFlying = this.f.fY();
                                if (serverLevel.w().i()) {
                                    PlayerFailMoveEvent event3;
                                    ++this.M;
                                    int i2 = this.M - this.N;
                                    this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                    this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                    this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                    if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                        h.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.f.ap(), (Object)i2);
                                        i2 = 1;
                                    }
                                    this.allowedPlayerTicks = packet.i || d7 > 0.0 ? --this.allowedPlayerTicks : 20;
                                    double speed = this.f.gC().b ? (double)(this.f.gC().m * 20.0f) : (double)(this.f.gC().n * 10.0f);
                                    if (!(!this.f.A().paperConfig().chunks.preventMovingIntoUnloadedChunks || this.f.dK() == toX && this.f.dQ() == toZ || serverLevel.areChunksLoadedForMove(this.f.de().b(new Vec3D(toX, toY, toZ).d(this.f.dD()))) || (event3 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_INTO_UNLOADED_CHUNK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed())) {
                                        this.internalTeleport(PositionMoveRotation.a(this.f), Collections.emptySet());
                                        return;
                                    }
                                    if (this.a(isFallFlying)) {
                                        PlayerFailMoveEvent event4;
                                        float f22;
                                        float f3 = f22 = isFallFlying ? 300.0f : 100.0f;
                                        if (d7 - d6 > Math.max((double)f22, MathHelper.l(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed)) && !(event4 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed()) {
                                            if (event4.getLogWarning()) {
                                                h.warn("{} moved too quickly! {},{},{}", new Object[]{this.f.ap(), d32, d4, d5});
                                            }
                                            this.a(this.f.dK(), this.f.dM(), this.f.dQ(), this.f.dX(), this.f.dZ());
                                            return;
                                        }
                                    }
                                }
                                AxisAlignedBB boundingBox = this.f.de();
                                d32 = d3 - this.v;
                                d4 = d1 - this.w;
                                d5 = d2 - this.x;
                                boolean bl2 = flag = d4 > 0.0;
                                if (this.f.aS() && !packet.b() && flag) {
                                    PlayerJumpEvent event5;
                                    CraftPlayer player = this.getCraftPlayer();
                                    Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                    Location to = player.getLocation().clone();
                                    if (packet.h) {
                                        to.setX(packet.a);
                                        to.setY(packet.b);
                                        to.setZ(packet.c);
                                    }
                                    if (packet.i) {
                                        to.setYaw(packet.d);
                                        to.setPitch(packet.e);
                                    }
                                    if ((event5 = new PlayerJumpEvent((Player)player, from, to)).callEvent()) {
                                        this.f.u();
                                    } else {
                                        from = event5.getFrom();
                                        this.internalTeleport(new PositionMoveRotation(CraftLocation.toVec3(from), Vec3D.c, from.getYaw(), from.getPitch()), Collections.emptySet());
                                        return;
                                    }
                                }
                                boolean flag1 = this.f.af;
                                this.f.a(EnumMoveType.b, new Vec3D(d32, d4, d5));
                                ((net.minecraft.world.entity.Entity)this.f).bc = packet.b();
                                boolean bl3 = didCollide = toX != this.f.dK() || toY != this.f.dM() || toZ != this.f.dQ();
                                if (this.F != null) {
                                    return;
                                }
                                double verticalDelta = d4;
                                d32 = d3 - this.f.dK();
                                d4 = d1 - this.f.dM();
                                if (d4 > -0.5 || d4 < 0.5) {
                                    d4 = 0.0;
                                }
                                d5 = d2 - this.f.dQ();
                                d7 = d32 * d32 + d4 * d4 + d5 * d5;
                                boolean movedWrongly = false;
                                if (!(this.f.S() || !(d7 > SpigotConfig.movedWronglyThreshold) || this.f.gg() || this.f.gQ() || this.f.at() || (event2 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_WRONGLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed())) {
                                    movedWrongly = true;
                                    if (event2.getLogWarning()) {
                                        h.warn("{} moved wrongly!, ({})", (Object)this.f.ap(), (Object)verticalDelta);
                                    }
                                }
                                boolean allowMovement = this.f.ar || this.f.gg() || !movedWrongly;
                                this.f.a(d3, d1, d2, f2, f1);
                                if (!this.f.ar && !this.f.gg() && allowMovement) {
                                    AxisAlignedBB newBox = this.f.de();
                                    if (didCollide || !boundingBox.equals(newBox)) {
                                        boolean bl4 = allowMovement = !this.hasNewCollision(serverLevel, this.f, boundingBox, newBox);
                                    }
                                }
                                if (!allowMovement && (event = this.fireFailMove(PlayerFailMoveEvent.FailReason.CLIPPED_INTO_BLOCK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed()) {
                                    allowMovement = true;
                                }
                                if (allowMovement) {
                                    this.f.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                    CraftPlayer player = this.getCraftPlayer();
                                    if (!this.hasMoved) {
                                        this.lastPosX = prevX;
                                        this.lastPosY = prevY;
                                        this.lastPosZ = prevZ;
                                        this.lastYaw = prevYaw;
                                        this.lastPitch = prevPitch;
                                        this.hasMoved = true;
                                    }
                                    Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                    Location to = player.getLocation().clone();
                                    if (packet.h) {
                                        to.setX(packet.a);
                                        to.setY(packet.b);
                                        to.setZ(packet.c);
                                    }
                                    if (packet.i) {
                                        to.setYaw(packet.d);
                                        to.setPitch(packet.e);
                                    }
                                    double delta = MathHelper.l(this.lastPosX - to.getX()) + MathHelper.l(this.lastPosY - to.getY()) + MathHelper.l(this.lastPosZ - to.getZ());
                                    float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                    if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fv()) {
                                        this.lastPosX = to.getX();
                                        this.lastPosY = to.getY();
                                        this.lastPosZ = to.getZ();
                                        this.lastYaw = to.getYaw();
                                        this.lastPitch = to.getPitch();
                                        if (!to.getWorld().getUID().equals(from.getWorld().getUID()) || to.getBlockX() != from.getBlockX() || to.getBlockY() != from.getBlockY() || to.getBlockZ() != from.getBlockZ() || to.getYaw() != from.getYaw() || to.getPitch() != from.getPitch()) {
                                            this.f.J();
                                        }
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event6 = new PlayerMoveEvent((Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event6);
                                        if (event6.isCancelled()) {
                                            this.internalTeleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event6.getTo()) && !event6.isCancelled()) {
                                            this.f.getBukkitEntity().teleport(event6.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                    this.f.a(d3, d1, d2, f2, f1);
                                    boolean isAutoSpinAttack = this.f.fL();
                                    this.I = verticalDelta >= -0.03125 && !flag1 && !this.f.at() && !this.d.aj() && !this.f.gC().c && !this.f.d(MobEffects.y) && !isFallFlying && !isAutoSpinAttack && this.b(this.f);
                                    this.f.A().n().a(this.f);
                                    Vec3D vec3 = new Vec3D(this.f.dK() - x2, this.f.dM() - y2, this.f.dQ() - z2);
                                    this.f.a(packet.b(), packet.e(), vec3);
                                    this.f.a(vec3.g, vec3.h, vec3.i, packet.b());
                                    this.a(vec3);
                                    if (flag) {
                                        this.f.l();
                                    }
                                    if (packet.b() || this.f.eu() || this.f.fe() || this.f.at() || isFallFlying || isAutoSpinAttack) {
                                        this.f.hg();
                                    }
                                    if (!(!this.f.A().purpurConfig.dontRunWithScissors || !this.f.cv() || this.f.A().purpurConfig.ignoreScissorsInWater && this.f.bu() || this.f.A().purpurConfig.ignoreScissorsInLava && this.f.bJ() || !this.isScissors(this.f.b(EnumHand.a)) && !this.isScissors(this.f.b(EnumHand.b)) || (int)(Math.random() * 10.0) != 0)) {
                                        this.f.a(this.f.A(), this.f.ei().scissors(), (float)this.f.A().purpurConfig.scissorsRunningDamage);
                                        if (!PurpurConfig.dontRunWithScissors.isBlank()) {
                                            this.f.sendActionBarMessage(PurpurConfig.dontRunWithScissors);
                                        }
                                    }
                                    this.f.a(this.f.dK() - x2, this.f.dM() - y2, this.f.dQ() - z2);
                                    this.v = this.f.dK();
                                    this.w = this.f.dM();
                                    this.x = this.f.dQ();
                                } else {
                                    this.internalTeleport(x2, y2, z2, f2, f1);
                                    this.f.a(this.f.dK() - x2, this.f.dM() - y2, this.f.dQ() - z2, packet.b());
                                    this.f.aU();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean isScissors(net.minecraft.world.item.ItemStack stack) {
        if (!stack.a(Items.tZ)) {
            return false;
        }
        MinecraftKey itemModelReference = stack.a(DataComponents.i);
        if (itemModelReference != null && itemModelReference.equals(this.f.A().purpurConfig.dontRunWithScissorsItemModelReference)) {
            return true;
        }
        return stack.a(DataComponents.p, CustomModelData.a).equals(CustomModelData.a);
    }

    private boolean a(boolean isElytraMovement) {
        if (this.h()) {
            return false;
        }
        if (this.f.S()) {
            return false;
        }
        GameRules gameRules = this.f.A().S();
        return !gameRules.c(GameRules.u) && (!isElytraMovement || !gameRules.c(GameRules.v));
    }

    private boolean q() {
        if (this.F != null) {
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.H = this.o;
        return false;
    }

    private boolean hasNewCollision(WorldServer level, net.minecraft.world.entity.Entity entity, AxisAlignedBB oldBox, AxisAlignedBB newBox) {
        int i2;
        ArrayList<AxisAlignedBB> collisionsBB = new ArrayList<AxisAlignedBB>();
        ArrayList<VoxelShape> collisionsVoxel = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisions(level, entity, newBox, collisionsVoxel, collisionsBB, 6, null, null);
        int len = collisionsBB.size();
        for (i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB box = (AxisAlignedBB)collisionsBB.get(i2);
            if (CollisionUtil.voxelShapeIntersect(box, oldBox)) continue;
            return true;
        }
        len = collisionsVoxel.size();
        for (i2 = 0; i2 < len; ++i2) {
            VoxelShape voxel = (VoxelShape)collisionsVoxel.get(i2);
            if (CollisionUtil.voxelShapeIntersectNoEmpty(voxel, oldBox)) continue;
            return true;
        }
        return false;
    }

    private boolean a(IWorldReader level, net.minecraft.world.entity.Entity entity, AxisAlignedBB box, double x2, double y2, double z2) {
        AxisAlignedBB aabb = entity.de().d(x2 - entity.dK(), y2 - entity.dM(), z2 - entity.dQ());
        Iterable<VoxelShape> preMoveCollisions = level.a(entity, aabb.h(1.0E-5f), box.g());
        VoxelShape voxelShape = VoxelShapes.a(box.h(1.0E-5f));
        for (VoxelShape voxelShape1 : preMoveCollisions) {
            if (VoxelShapes.c(voxelShape1, voxelShape, OperatorBoolean.i)) continue;
            return true;
        }
        return false;
    }

    public void a(double x2, double y2, double z2, float yRot, float xRot) {
        this.teleport(x2, y2, z2, yRot, xRot, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double x2, double y2, double z2, float yRot, float xRot, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(new PositionMoveRotation(new Vec3D(x2, y2, z2), Vec3D.c, yRot, xRot), Collections.emptySet(), cause);
    }

    public void a(PositionMoveRotation posMoveRotation, Set<Relative> relatives) {
        this.teleport(posMoveRotation, relatives, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(PositionMoveRotation posMoveRotation, Set<Relative> relatives, PlayerTeleportEvent.TeleportCause cause) {
        PositionMoveRotation absolutePosition;
        Location to;
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        if (from.equals((Object)(to = CraftLocation.toBukkit((absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this.f), posMoveRotation, relatives)).a(), (net.minecraft.world.level.World)this.f.A(), absolutePosition.c(), absolutePosition.d())))) {
            this.internalTeleport(posMoveRotation, relatives);
            return true;
        }
        EnumSet<TeleportFlag.Relative> relativeFlags = EnumSet.noneOf(TeleportFlag.Relative.class);
        for (Relative relativeArgument : relatives) {
            TeleportFlag.Relative flag = CraftEntity.deltaRelativeToAPI(relativeArgument);
            if (flag == null) continue;
            relativeFlags.add(flag);
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause, Set.copyOf(relativeFlags));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            relatives = Set.of();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            posMoveRotation = new PositionMoveRotation(CraftLocation.toVec3(to), Vec3D.c, to.getYaw(), to.getPitch());
        }
        this.internalTeleport(posMoveRotation, relatives);
        return !event.isCancelled();
    }

    public void internalTeleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch());
    }

    public void internalTeleport(double x2, double y2, double z2, float yRot, float xRot) {
        this.internalTeleport(new PositionMoveRotation(new Vec3D(x2, y2, z2), Vec3D.c, yRot, xRot), Collections.emptySet());
    }

    public void internalTeleport(PositionMoveRotation posMoveRotation, Set<Relative> relatives) {
        AsyncCatcher.catchOp("teleport");
        if (this.f.ec()) {
            h.info("Attempt to teleport removed player {} restricted", (Object)this.f.cV());
            if (this.d.isDebugging()) {
                TraceUtil.dumpTraceForThread("Attempt to teleport removed player");
            }
            return;
        }
        if (Float.isNaN(posMoveRotation.c())) {
            posMoveRotation = new PositionMoveRotation(posMoveRotation.a(), posMoveRotation.b(), 0.0f, posMoveRotation.d());
        }
        if (Float.isNaN(posMoveRotation.d())) {
            posMoveRotation = new PositionMoveRotation(posMoveRotation.a(), posMoveRotation.b(), posMoveRotation.c(), 0.0f);
        }
        this.justTeleported = true;
        this.H = this.o;
        if (++this.G == Integer.MAX_VALUE) {
            this.G = 0;
        }
        this.f.a(posMoveRotation, relatives);
        this.F = this.f.dD();
        this.lastPosX = this.F.g;
        this.lastPosY = this.F.h;
        this.lastPosZ = this.F.i;
        this.lastYaw = this.f.dX();
        this.lastPitch = this.f.dZ();
        this.b(PacketPlayOutPosition.a(this.G, posMoveRotation, relatives));
    }

    @Override
    public void a(PacketPlayInBlockDig packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (this.f.hb()) {
            BlockPosition pos = packet.b();
            this.f.J();
            PacketPlayInBlockDig.EnumPlayerDigType action = packet.f();
            switch (action) {
                case g: {
                    if (!this.f.at()) {
                        net.minecraft.world.item.ItemStack itemInHand = this.f.b(EnumHand.b);
                        CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemInHand);
                        CraftItemStack offHand = CraftItemStack.asCraftMirror(this.f.b(EnumHand.a));
                        PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (ItemStack)mainHand.clone(), (ItemStack)offHand.clone());
                        this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                        if (swapItemsEvent.isCancelled()) {
                            return;
                        }
                        if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                            this.f.a(EnumHand.b, this.f.b(EnumHand.a));
                        } else {
                            this.f.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                        }
                        if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                            this.f.a(EnumHand.a, itemInHand);
                        } else {
                            this.f.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                        }
                        this.f.fU();
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.f.L();
                        }
                    }
                    return;
                }
                case e: {
                    if (!this.f.at()) {
                        if (this.lastDropTick != MinecraftServer.currentTick) {
                            this.dropCount = 0;
                            this.lastDropTick = MinecraftServer.currentTick;
                        } else {
                            ++this.dropCount;
                            if (this.dropCount >= 20) {
                                h.warn(this.f.cV() + " dropped their items too quickly!");
                                this.disconnect((IChatBaseComponent)IChatBaseComponent.b("You dropped your items too quickly (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                                return;
                            }
                        }
                        this.f.a(false);
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.f.L();
                        }
                    }
                    return;
                }
                case d: {
                    if (!this.f.at()) {
                        this.f.a(true);
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.f.L();
                        }
                    }
                    return;
                }
                case f: {
                    this.f.fT();
                    if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                        this.f.L();
                    }
                    return;
                }
                case a: 
                case b: 
                case c: {
                    if (this.f.A().getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4) == null || !this.f.a(pos, 1.0)) {
                        this.f.g.a(packet.g());
                        return;
                    }
                    this.f.h.capturedBlockEntity = false;
                    this.f.h.captureSentBlockEntities = true;
                    this.f.h.a(pos, action, packet.e(), this.f.A().ar(), packet.g());
                    this.a(packet.g());
                    this.f.h.captureSentBlockEntities = false;
                    if (this.f.h.capturedBlockEntity) {
                        this.b(new ClientboundBlockChangedAckPacket(this.p));
                        this.f.g.p = -1;
                        this.f.h.capturedBlockEntity = false;
                        TileEntity blockEntity = this.f.A().c_(pos);
                        if (blockEntity != null) {
                            this.f.g.b(blockEntity.ax_());
                        }
                    }
                    if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                        this.f.L();
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid player action");
        }
    }

    private static boolean a(EntityPlayer player, net.minecraft.world.item.ItemStack stack) {
        ItemBucket bucketItem;
        if (stack.f()) {
            return false;
        }
        Item item = stack.h();
        return (item instanceof ItemBlock || item instanceof ItemBucket && (bucketItem = (ItemBucket)item).a() != FluidTypes.a) && !player.gW().a(stack);
    }

    private static int getSpamThreshold() {
        return GlobalConfiguration.get().spamLimiter.incomingPacketThreshold;
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < (long)PlayerConnection.getSpamThreshold() && this.limitedPackets++ >= 8) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= (long)PlayerConnection.getSpamThreshold()) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        if (this.f.hb()) {
            this.a(packet.f());
            WorldServer serverLevel = this.f.A();
            EnumHand hand = packet.b();
            net.minecraft.world.item.ItemStack itemInHand = this.f.b(hand);
            if (itemInHand.a(serverLevel.O())) {
                MovingObjectPositionBlock hitResult = packet.e();
                Vec3D location = hitResult.g();
                if (!(Double.isFinite(location.a()) && Double.isFinite(location.b()) && Double.isFinite(location.c()))) {
                    return;
                }
                BlockPosition blockPos = hitResult.b();
                if (this.f.a(blockPos, 1.0)) {
                    Vec3D vec3 = location.d(Vec3D.b(blockPos));
                    double d2 = 1.0000001;
                    if (Math.abs(vec3.a()) < 1.0000001 && Math.abs(vec3.b()) < 1.0000001 && Math.abs(vec3.c()) < 1.0000001) {
                        EnumDirection direction = hitResult.c();
                        this.f.J();
                        int maxY = this.f.A().ar();
                        if (blockPos.v() <= maxY) {
                            if (this.F == null && (serverLevel.a((net.minecraft.world.entity.Entity)this.f, blockPos) || serverLevel.paperConfig().spawn.allowUsingSignsInsideSpawnProtection && serverLevel.a_(blockPos).b() instanceof BlockSign)) {
                                EnumInteractionResult.d success;
                                this.f.fU();
                                EnumInteractionResult interactionResult = this.f.h.a(this.f, serverLevel, itemInHand, hand, hitResult);
                                if (interactionResult.a()) {
                                    CriterionTriggers.P.a(this.f, hitResult.b(), itemInHand.v());
                                }
                                if (direction == EnumDirection.b && !interactionResult.a() && blockPos.v() >= maxY && PlayerConnection.a(this.f, itemInHand)) {
                                    IChatMutableComponent component = IChatBaseComponent.a("build.tooHigh", maxY).a(EnumChatFormat.m);
                                    this.f.b(component, true);
                                } else if (interactionResult instanceof EnumInteractionResult.d && (success = (EnumInteractionResult.d)interactionResult).e() == EnumInteractionResult.e.c && !this.f.h.interactResult) {
                                    this.f.a(hand, true);
                                }
                            } else {
                                this.f.cl.forceHeldSlot(hand);
                            }
                        } else {
                            IChatMutableComponent component1 = IChatBaseComponent.a("build.tooHigh", maxY).a(EnumChatFormat.m);
                            this.f.b(component1, true);
                        }
                        this.b(new PacketPlayOutBlockChange(serverLevel, blockPos));
                        this.b(new PacketPlayOutBlockChange(serverLevel, blockPos.a(direction)));
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.f.L();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        if (this.f.hb()) {
            this.a(packet.e());
            WorldServer serverLevel = this.f.A();
            EnumHand hand = packet.b();
            net.minecraft.world.item.ItemStack itemInHand = this.f.b(hand);
            this.f.J();
            if (!itemInHand.f() && itemInHand.a(serverLevel.O())) {
                EnumInteractionResult.d success;
                boolean cancelled;
                float f2 = MathHelper.h(packet.f());
                float f1 = MathHelper.h(packet.g());
                if (f1 != this.f.dZ() || f2 != this.f.dX()) {
                    this.f.b(f2, f1);
                }
                double x2 = this.f.dK();
                double eyeY = this.f.dO();
                double z2 = this.f.dQ();
                Vec3D from = new Vec3D(x2, eyeY, z2);
                float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
                float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
                float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
                float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
                float f7 = f4 * f5;
                float f8 = f3 * f5;
                double d3 = this.f.hd();
                Vec3D to = from.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
                MovingObjectPositionBlock hitResult = this.f.A().a(new RayTrace(from, to, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.f));
                if (hitResult == null || hitResult.d() != MovingObjectPosition.EnumMovingObjectType.b) {
                    if (this.f.h.shiftClickMended(itemInHand)) {
                        return;
                    }
                    event = CraftEventFactory.callPlayerInteractEvent(this.f, Action.RIGHT_CLICK_AIR, itemInHand, hand);
                    cancelled = event.useItemInHand() == Event.Result.DENY;
                } else {
                    cancelled = this.f.h.firedInteract && this.f.h.interactPosition.equals(hitResult.b()) && this.f.h.interactHand == hand && net.minecraft.world.item.ItemStack.c(this.f.h.interactItemStack, itemInHand) ? this.f.h.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.f, Action.RIGHT_CLICK_BLOCK, hitResult.b(), hitResult.c(), itemInHand, true, hand, hitResult.g())).useItemInHand() == Event.Result.DENY;
                    this.f.h.firedInteract = false;
                }
                if (cancelled) {
                    this.f.resyncUsingItem(this.f);
                    this.f.cl.forceHeldSlotAndArmor(hand);
                    return;
                }
                itemInHand = this.f.b(hand);
                if (itemInHand.f()) {
                    return;
                }
                EnumInteractionResult enumInteractionResult = this.f.h.a(this.f, serverLevel, itemInHand, hand);
                if (enumInteractionResult instanceof EnumInteractionResult.d && (success = (EnumInteractionResult.d)enumInteractionResult).e() == EnumInteractionResult.e.c) {
                    this.f.a(hand, true);
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.at()) {
            for (WorldServer serverLevel : this.d.Q()) {
                net.minecraft.world.entity.Entity entity = packet.a(serverLevel);
                if (entity == null) continue;
                this.f.teleportTo(serverLevel, entity.dK(), entity.dM(), entity.dQ(), Set.of(), entity.dX(), entity.dZ(), true, PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInBoatMove packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        net.minecraft.world.entity.Entity entity = this.f.dv();
        if (entity instanceof AbstractBoat) {
            AbstractBoat abstractBoat = (AbstractBoat)entity;
            abstractBoat.a(packet.b(), packet.e());
        }
    }

    @Override
    public void a(DisconnectionDetails details) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        h.info("{} lost connection: {}", (Object)this.f.ap(), (Object)details.a().getString());
        Component quitMessage = details.quitMessage().map(PaperAdventure::asAdventure).orElse(null);
        this.removePlayerFromWorld(quitMessage);
        super.a(details);
    }

    private void r() {
        this.removePlayerFromWorld(null);
    }

    private void removePlayerFromWorld(@Nullable Component quitMessage) {
        this.U.close();
        this.f.v();
        Component component = quitMessage = quitMessage == null ? this.d.am().remove(this.f) : this.d.am().remove(this.f, quitMessage);
        if (quitMessage != null && !quitMessage.equals((Object)Component.empty())) {
            this.d.am().a(PaperAdventure.asVanilla(quitMessage), false);
        }
        this.f.Y().b();
    }

    public void a(int sequence) {
        if (sequence < 0) {
            this.disconnect((IChatBaseComponent)IChatBaseComponent.b("Expected packet sequence nr >= 0"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.p = Math.max(sequence, this.p);
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (packet.b() >= 0 && packet.b() < PlayerInventory.i()) {
            if (packet.b() == this.f.gB().g()) {
                return;
            }
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.f.gB().g(), packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.b(new PacketPlayOutHeldItemSlot(this.f.gB().g()));
                this.f.J();
                return;
            }
            if (this.f.gB().g() != packet.b() && this.f.fP() == EnumHand.a) {
                this.f.fU();
            }
            this.f.gB().c(packet.b());
            this.f.J();
            if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                this.f.L();
            }
        } else {
            h.warn("{} tried to set an invalid carried item", (Object)this.f.ap());
            this.disconnect((IChatBaseComponent)IChatBaseComponent.b("Invalid hotbar selection (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
        }
    }

    @Override
    public void a(PacketPlayInChat packet) {
        if (this.d.al()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.a(packet.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.b(), false, () -> {
                PlayerChatMessage signedMessage;
                try {
                    signedMessage = this.a(packet, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.a var6) {
                    this.a(var6);
                    return;
                }
                CompletionStage completableFuture = this.a(signedMessage.c()).thenApplyAsync(Function.identity(), (Executor)this.d.chatExecutor);
                CompletableFuture<IChatBaseComponent> componentFuture = this.d.bq().decorate(this.f, null, signedMessage.d());
                this.U.append(CompletableFuture.allOf(new CompletableFuture[]{completableFuture, componentFuture}), arg_0 -> this.lambda$handleChat$13(signedMessage, componentFuture, (CompletableFuture)completableFuture, arg_0));
            }, false);
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket packet) {
        this.tryHandleChat(packet.b(), true, () -> {
            if (this.f.w()) {
                return;
            }
            this.b(packet.b());
            this.detectRateSpam("/" + packet.b());
        }, true);
    }

    private void b(String command) {
        String prefixedCommand = "/" + command;
        if (SpigotConfig.logCommands) {
            h.info("{} issued server command: {}", (Object)this.f.cV(), (Object)prefixedCommand);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), prefixedCommand, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseResults = this.c(command);
        if (this.d.aC() && SignableCommand.a(parseResults)) {
            h.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.f.gz().name(), (Object)command);
            this.f.a(m);
        } else {
            this.d.aJ().a(parseResults, command);
        }
    }

    @Override
    public void a(ServerboundChatCommandSignedPacket packet) {
        Optional<LastSeenMessages> optional = this.a(packet.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.b(), true, () -> {
                if (this.f.w()) {
                    return;
                }
                this.a(packet, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + packet.b());
            }, true);
        }
    }

    private void a(ServerboundChatCommandSignedPacket packet, LastSeenMessages lastSeenMessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + packet.b();
        if (SpigotConfig.logCommands) {
            h.info("{} issued server command: {}", (Object)this.f.cV(), command);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseResults = this.c(packet.b());
        try {
            map = this.a(packet, SignableCommand.b(parseResults), lastSeenMessages);
        }
        catch (SignedMessageChain.a var6) {
            this.a(var6);
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!((String)command).equals(packet.b())) {
            parseResults = this.c((String)command);
            map = Collections.emptyMap();
        }
        CommandSigningContext.a commandSigningContext = new CommandSigningContext.a(map);
        parseResults = net.minecraft.commands.CommandDispatcher.a(parseResults, commandSourceStack -> commandSourceStack.a(commandSigningContext, this.U));
        this.d.aJ().a(parseResults, (String)command);
    }

    private void a(SignedMessageChain.a exception) {
        h.warn("Failed to update secure chat state for {}: '{}'", (Object)this.f.gz().name(), (Object)exception.a().getString());
        this.f.a(exception.a().f().a(EnumChatFormat.m));
    }

    private <S> Map<String, PlayerChatMessage> a(ServerboundChatCommandSignedPacket packet, SignableCommand<S> command, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        List<ArgumentSignatures.a> list = packet.g().a();
        List<SignableCommand.a<S>> list1 = command.a();
        if (list.isEmpty()) {
            return this.b(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.a a2 : list) {
            SignableCommand.a<S> argument = command.a(a2.a());
            if (argument == null) {
                this.Q.setChainBroken();
                throw PlayerConnection.a(packet.b(), list, list1);
            }
            SignedMessageBody signedMessageBody = new SignedMessageBody(argument.c(), packet.e(), packet.f(), lastSeenMessages);
            map.put(argument.a(), this.Q.unpack(a2.b(), signedMessageBody));
        }
        for (SignableCommand.a a3 : list1) {
            if (map.containsKey(a3.a())) continue;
            throw PlayerConnection.a(packet.b(), list, list1);
        }
        return map;
    }

    private <S> Map<String, PlayerChatMessage> b(List<SignableCommand.a<S>> arguments) throws SignedMessageChain.a {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.a<S> argument : arguments) {
            SignedMessageBody signedMessageBody = SignedMessageBody.a(argument.c());
            map.put(argument.a(), this.Q.unpack(null, signedMessageBody));
        }
        return map;
    }

    private static <S> SignedMessageChain.a a(String command, List<ArgumentSignatures.a> signedArguments, List<SignableCommand.a<S>> unsignedArguments) {
        String string = signedArguments.stream().map(ArgumentSignatures.a::a).collect(Collectors.joining(", "));
        String string1 = unsignedArguments.stream().map(SignableCommand.a::a).collect(Collectors.joining(", "));
        h.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{command, string, string1});
        return new SignedMessageChain.a(m);
    }

    private ParseResults<CommandListenerWrapper> c(String command) {
        CommandDispatcher<CommandListenerWrapper> dispatcher = this.d.aJ().a();
        return dispatcher.parse(command, this.f.C());
    }

    private void tryHandleChat(String message, boolean bypassHiddenChat, Runnable handler, boolean sync) {
        if (PlayerConnection.d(message)) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
        } else if (this.f.ec() || !bypassHiddenChat && this.f.G() == EnumChatVisibility.c) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m), false));
        } else {
            this.f.J();
            if (sync) {
                this.d.execute(handler);
            } else {
                handler.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b update) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.R;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> var10000;
            try {
                LastSeenMessages lastSeenMessages = this.R.a(update);
                var10000 = Optional.of(lastSeenMessages);
            }
            catch (LastSeenMessagesValidator.a var5) {
                h.error("Failed to validate message acknowledgements from {}: {}", (Object)this.f.ap(), (Object)var5.getMessage());
                this.disconnectAsync(l, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
                return Optional.empty();
            }
            return var10000;
        }
    }

    public static boolean d(String message) {
        for (int i2 = 0; i2 < message.length(); ++i2) {
            if (UtilColor.a(message.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String msg, PlayerChatMessage original, boolean async) {
        if (msg.isEmpty() || this.f.G() == EnumChatVisibility.c) {
            return;
        }
        if (this.f.G() != EnumChatVisibility.b) {
            if (!async && !Bukkit.isPrimaryThread()) {
                AsyncCatcher.catchOp("Asynchronous player chat is not allowed here");
            }
            new ChatProcessor(this.d, this.f, original, async).process();
        }
    }

    @Deprecated
    public void handleCommand(String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        this.b(command);
    }

    private PlayerChatMessage a(PacketPlayInChat packet, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        SignedMessageBody signedMessageBody = new SignedMessageBody(packet.b(), packet.e(), packet.f(), lastSeenMessages);
        return this.Q.unpack(packet.g(), signedMessageBody);
    }

    private void a(PlayerChatMessage message) {
        String rawMessage = message.c();
        if (rawMessage.isEmpty()) {
            h.warn("{} tried to send an empty message", (Object)this.f.cV());
        } else if (this.getCraftPlayer().isConversing()) {
            String conversationInput = rawMessage;
            this.d.processQueue.add(() -> this.getCraftPlayer().acceptConversationInput(conversationInput));
        } else if (this.f.G() == EnumChatVisibility.b) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m), false));
        } else {
            this.chat(rawMessage, message, true);
        }
        this.detectRateSpam(rawMessage);
    }

    private void detectRateSpam(String message) {
        if (SpigotConfig.enableSpamExclusions) {
            for (String exclude : SpigotConfig.spamExclusions) {
                if (exclude == null || !message.startsWith(exclude)) continue;
                return;
            }
        }
        if (!(this.q.isIncrementAndUnderThreshold() || this.d.am().f(this.f.gA()) || this.d.a(this.f.gA()))) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket packet) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.R;
        synchronized (lastSeenMessagesValidator) {
            try {
                this.R.a(packet.b());
            }
            catch (LastSeenMessagesValidator.a var5) {
                h.error("Failed to validate message acknowledgement offset from {}: {}", (Object)this.f.ap(), (Object)var5.getMessage());
                this.disconnectAsync(l, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        this.f.J();
        float f1 = this.f.dZ();
        float f2 = this.f.dX();
        double d0 = this.f.dK();
        double d1 = this.f.dM() + (double)this.f.df();
        double d2 = this.f.dQ();
        Location origin = new Location((World)this.f.A().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.f.hd(), this.f.he());
        RayTraceResult result = this.f.A().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.0, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.f.getBukkitEntity() && this.f.getBukkitEntity().canSee((Entity)entity) && !handle.at() && handle.bT() && !handle.A(this.f);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_AIR, this.f.gB().h(), EnumHand.a);
        } else {
            EnumGamemode gameType = this.f.h.b();
            if (gameType == EnumGamemode.c && result.getHitBlock() != null) {
                CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_BLOCK, ((CraftBlock)result.getHitBlock()).getPosition(), CraftBlock.blockFaceToNotch(result.getHitBlockFace()), this.f.gB().h(), EnumHand.a);
            } else if (gameType != EnumGamemode.b && result.getHitEntity() != null && origin.toVector().distanceSquared(result.getHitPosition()) > this.f.he() * this.f.he()) {
                CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_AIR, this.f.gB().h(), EnumHand.a);
            }
        }
        PlayerArmSwingEvent event = new PlayerArmSwingEvent((Player)this.getCraftPlayer(), CraftEquipmentSlot.getHand(packet.b()));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.f.a(packet.b());
    }

    @Override
    public void a(PacketPlayInEntityAction packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.hb()) {
            if (this.f.ec()) {
                return;
            }
            switch (packet.e()) {
                case b: 
                case c: {
                    PlayerToggleSprintEvent event = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packet.e() == PacketPlayInEntityAction.EnumPlayerAction.b);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) break;
                    return;
                }
            }
            this.f.J();
            switch (packet.e()) {
                case b: {
                    this.f.i(true);
                    break;
                }
                case c: {
                    this.f.i(false);
                    break;
                }
                case a: {
                    if (!this.f.gg()) break;
                    this.f.a(false, true);
                    this.F = this.f.dD();
                    break;
                }
                case d: {
                    net.minecraft.world.entity.Entity entity = this.f.dv();
                    if (!(entity instanceof IJumpable)) break;
                    IJumpable playerRideableJumping = (IJumpable)((Object)entity);
                    int data = packet.f();
                    if (!playerRideableJumping.a() || data <= 0) break;
                    playerRideableJumping.c(data);
                    break;
                }
                case e: {
                    net.minecraft.world.entity.Entity entity = this.f.dv();
                    if (!(entity instanceof IJumpable)) break;
                    IJumpable playerRideableJumping = (IJumpable)((Object)entity);
                    playerRideableJumping.b();
                    break;
                }
                case f: {
                    net.minecraft.world.entity.Entity entity = this.f.du();
                    if (!(entity instanceof HasCustomInventoryScreen)) break;
                    HasCustomInventoryScreen hasCustomInventoryScreen = (HasCustomInventoryScreen)((Object)entity);
                    hasCustomInventoryScreen.b(this.f);
                    break;
                }
                case g: {
                    if (this.f.gI()) break;
                    this.f.fB();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid client command!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage chatMessage, ChatMessageType.a boundChatType) {
        if (!this.getCraftPlayer().canSeePlayer(chatMessage.k().c())) {
            this.a(chatMessage.d(), boundChatType);
            return;
        }
        MessageSignatureCache messageSignatureCache = this.T;
        synchronized (messageSignatureCache) {
            this.b(new ClientboundPlayerChatPacket(this.S++, chatMessage.k().c(), chatMessage.k().b(), chatMessage.l(), chatMessage.m().a(this.T), chatMessage.n(), chatMessage.o(), boundChatType));
            MessageSignature messageSignature = chatMessage.l();
            if (messageSignature != null) {
                int i2;
                this.T.a(chatMessage.m(), chatMessage.l());
                LastSeenMessagesValidator lastSeenMessagesValidator = this.R;
                synchronized (lastSeenMessagesValidator) {
                    this.R.a(messageSignature);
                    i2 = this.R.a();
                }
                if (i2 > 4096) {
                    this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"), PlayerKickEvent.Cause.TOO_MANY_PENDING_CHATS);
                }
            }
        }
    }

    public void a(IChatBaseComponent message, ChatMessageType.a boundChatType) {
        this.b(new ClientboundDisguisedChatPacket(message, boundChatType));
    }

    public SocketAddress m() {
        return this.e.d();
    }

    public SocketAddress getRawAddress() {
        if (this.e.n.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.e.n.remoteAddress();
    }

    public void n() {
        this.V = true;
        this.r();
        this.b(ClientboundStartConfigurationPacket.a);
        this.e.a(ConfigurationProtocols.d);
    }

    @Override
    public void a(ServerboundPingRequestPacket packet) {
        this.e.a(new ClientboundPongResponsePacket(packet.b()));
    }

    @Override
    public void a(final PacketPlayInUseEntity packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (this.f.hb()) {
            final WorldServer serverLevel = this.f.A();
            final net.minecraft.world.entity.Entity target = packet.a(serverLevel);
            if (target == this.f && !this.f.at()) {
                this.disconnect((IChatBaseComponent)IChatBaseComponent.b("Cannot interact with self!"), PlayerKickEvent.Cause.SELF_INTERACTION);
                return;
            }
            this.f.J();
            this.f.h(packet.b());
            if (target != null) {
                if (!serverLevel.u().a(target.dF())) {
                    return;
                }
                AxisAlignedBB boundingBox = target.de();
                if (this.f.a(boundingBox, GlobalConfiguration.get().misc.clientInteractionLeniencyDistance.or(3.0))) {
                    if (target instanceof EntityInsentient) {
                        EntityInsentient mob = (EntityInsentient)target;
                        mob.ticksSinceLastInteraction = 0;
                    }
                    packet.a(new PacketPlayInUseEntity.c(){

                        private void performInteraction(EnumHand hand, a entityInteraction, PlayerInteractEntityEvent event) {
                            net.minecraft.world.item.ItemStack itemInHand = PlayerConnection.this.f.b(hand);
                            if (itemInHand.a(serverLevel.O())) {
                                net.minecraft.world.item.ItemStack itemStack = itemInHand.v();
                                Item itemType = itemInHand.h();
                                boolean triggerLeashUpdate = itemStack.a(Items.wU) && target instanceof Leashable;
                                PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                                boolean resendData = event.isCancelled() || !PlayerConnection.this.f.b(hand).a(itemType);
                                PlayerConnection.this.f.processClick(hand);
                                if (itemType == Items.sl && target instanceof Bucketable && target instanceof EntityLiving && resendData) {
                                    target.resendPossiblyDesyncedEntityData(PlayerConnection.this.f);
                                    PlayerConnection.this.f.cl.b();
                                }
                                if (triggerLeashUpdate && resendData) {
                                    PlayerConnection.this.b(new PacketPlayOutAttachEntity(target, ((Leashable)((Object)target)).ak_()));
                                }
                                if (resendData) {
                                    target.refreshEntityData(PlayerConnection.this.f);
                                    if (target instanceof Allay || target instanceof EntityHorseAbstract) {
                                        PlayerConnection.this.b(new PacketPlayOutEntityEquipment(target.az(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((EntityLiving)target).a((EnumItemSlot)slot).v())).collect(Collectors.toList()), true));
                                        PlayerConnection.this.f.cl.b();
                                    } else {
                                        PlayerConnection.this.f.cl.forceHeldSlot(hand);
                                    }
                                }
                                if (event.isCancelled()) {
                                    return;
                                }
                                EnumInteractionResult result = entityInteraction.run(PlayerConnection.this.f, target, hand);
                                if (result instanceof EnumInteractionResult.d) {
                                    EnumInteractionResult.d success = (EnumInteractionResult.d)result;
                                    net.minecraft.world.item.ItemStack itemStack1 = success.c() ? itemStack : net.minecraft.world.item.ItemStack.l;
                                    CriterionTriggers.T.a(PlayerConnection.this.f, itemStack1, target);
                                    if (success.e() == EnumInteractionResult.e.c) {
                                        PlayerConnection.this.f.a(hand, true);
                                    }
                                }
                            }
                        }

                        @Override
                        public void a(EnumHand hand) {
                            this.performInteraction(hand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)target.getBukkitEntity(), CraftEquipmentSlot.getHand(hand)));
                        }

                        @Override
                        public void a(EnumHand hand, Vec3D interactionLocation) {
                            this.performInteraction(hand, (player, entity, interactionHand) -> entity.a(player, interactionLocation, interactionHand), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)target.getBukkitEntity(), CraftVector.toBukkit(interactionLocation), CraftEquipmentSlot.getHand(hand)));
                        }

                        @Override
                        public void a() {
                            EntityArrow abstractArrow;
                            if (!(target instanceof EntityItem || target instanceof EntityExperienceOrb || target == PlayerConnection.this.f && !PlayerConnection.this.f.at() || target instanceof EntityArrow && !(abstractArrow = (EntityArrow)target).cO())) {
                                net.minecraft.world.item.ItemStack itemInHand = PlayerConnection.this.f.b(EnumHand.a);
                                if (itemInHand.a(serverLevel.O())) {
                                    PlayerConnection.this.f.e(target);
                                }
                            } else {
                                PlayerConnection.this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"), PlayerKickEvent.Cause.INVALID_ENTITY_ATTACKED);
                                h.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.f.ap());
                            }
                        }
                    });
                }
            } else {
                packet.a(new PacketPlayInUseEntity.c(){

                    @Override
                    public void a(EnumHand hand) {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.f, packet, hand, null);
                    }

                    @Override
                    public void a(EnumHand hand, Vec3D pos) {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.f, packet, hand, pos);
                    }

                    @Override
                    public void a() {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.f, packet, EnumHand.a, null);
                    }
                });
            }
            if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                this.f.L();
            }
        }
    }

    @Override
    public void a(PacketPlayInClientCommand packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.f.J();
        PacketPlayInClientCommand.EnumClientCommand action = packet.b();
        switch (action) {
            case a: {
                if (this.f.k) {
                    this.f.k = false;
                    this.f = this.d.am().respawn(this.f, true, Entity.RemovalReason.e, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    this.l();
                    CriterionTriggers.w.a(this.f, net.minecraft.world.level.World.j, net.minecraft.world.level.World.h);
                    break;
                }
                if (this.f.eU() > 0.0f) {
                    return;
                }
                this.f = this.d.am().respawn(this.f, false, Entity.RemovalReason.a, PlayerRespawnEvent.RespawnReason.DEATH);
                this.l();
                if (!this.d.w_()) break;
                this.f.setGameMode(EnumGamemode.d, PlayerGameModeChangeEvent.Cause.HARDCORE_DEATH, null);
                this.f.A().S().b(GameRules.s).set(false, this.f.A());
                break;
            }
            case b: {
                this.f.K().a(this.f);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packet) {
        this.handleContainerClose(packet, InventoryCloseEvent.Reason.PLAYER);
    }

    public void handleContainerClose(PacketPlayInCloseWindow packet, InventoryCloseEvent.Reason reason) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.f, reason);
        this.f.s();
    }

    @Override
    public void a(PacketPlayInWindowClick packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        this.f.J();
        if (this.f.cl.l == packet.b() && this.f.cl.b(this.f)) {
            boolean cancelled = this.f.at();
            if (!this.f.cl.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cl);
            } else {
                short slotNum = packet.f();
                if (!this.f.cl.a(slotNum)) {
                    h.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.f.ap(), (int)slotNum, this.f.cl.k.size()});
                } else {
                    boolean flag = packet.e() != this.f.cl.j();
                    this.f.cl.h();
                    if (slotNum < -1 && slotNum != -999) {
                        return;
                    }
                    InventoryView inventory = this.f.cl.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType((int)slotNum);
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    switch (packet.h()) {
                        case a: {
                            if (packet.g() == 0) {
                                click = ClickType.LEFT;
                            } else if (packet.g() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packet.g() != 0 && packet.g() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (slotNum == -999) {
                                if (this.f.cl.g().f()) break;
                                action = packet.g() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cl.b(slotNum);
                            if (slot == null) break;
                            net.minecraft.world.item.ItemStack clickedItem = slot.g();
                            net.minecraft.world.item.ItemStack cursor = this.f.cl.g();
                            if (clickedItem.f()) {
                                if (cursor.f()) break;
                                if (cursor.h() instanceof BundleItem && cursor.c(DataComponents.Q) && packet.g() != 0) {
                                    action = cursor.a(DataComponents.Q).g() ? InventoryAction.NOTHING : InventoryAction.PLACE_FROM_BUNDLE;
                                    break;
                                }
                                action = packet.g() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.f)) break;
                            if (cursor.f()) {
                                if (slot.g().h() instanceof BundleItem && slot.g().c(DataComponents.Q) && packet.g() != 0) {
                                    action = slot.g().a(DataComponents.Q).g() ? InventoryAction.NOTHING : InventoryAction.PICKUP_FROM_BUNDLE;
                                    break;
                                }
                                action = packet.g() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                int toPickup;
                                if (net.minecraft.world.item.ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packet.g() == 0 ? cursor.M() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.k() - clickedItem.M());
                                    if ((toPlace = Math.min(toPlace, slot.c.ap_() - clickedItem.M())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.M()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.M() > slot.a()) break;
                                if (cursor.h() instanceof BundleItem && cursor.c(DataComponents.Q) && packet.g() == 0) {
                                    toPickup = cursor.a(DataComponents.Q).getMaxAmountToAdd(slot.g());
                                    if (toPickup >= slot.g().M()) {
                                        action = InventoryAction.PICKUP_ALL_INTO_BUNDLE;
                                        break;
                                    }
                                    if (toPickup == 0) {
                                        action = InventoryAction.NOTHING;
                                        break;
                                    }
                                    action = InventoryAction.PICKUP_SOME_INTO_BUNDLE;
                                    break;
                                }
                                if (slot.g().h() instanceof BundleItem && slot.g().c(DataComponents.Q) && packet.g() == 0) {
                                    toPickup = slot.g().a(DataComponents.Q).getMaxAmountToAdd(cursor);
                                    if (toPickup >= cursor.M()) {
                                        action = InventoryAction.PLACE_ALL_INTO_BUNDLE;
                                        break;
                                    }
                                    if (toPickup == 0) {
                                        action = InventoryAction.NOTHING;
                                        break;
                                    }
                                    action = InventoryAction.PLACE_SOME_INTO_BUNDLE;
                                    break;
                                }
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!net.minecraft.world.item.ItemStack.c(cursor, clickedItem) || clickedItem.M() < 0 || clickedItem.M() + cursor.M() > cursor.k()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packet.g() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packet.g() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packet.g() != 0 && packet.g() != 1) break;
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cl.b(slotNum);
                            if (slot != null && slot.a(this.f) && slot.h()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packet.g() < 0 || packet.g() >= 9) && packet.g() != 40) break;
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = packet.g() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.f.cl.b(slotNum);
                            if (clickedSlot.a(this.f)) {
                                net.minecraft.world.item.ItemStack hotbar = this.f.gB().a(packet.g());
                                if (!hotbar.f() && clickedSlot.a(hotbar) || hotbar.f() && clickedSlot.h()) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packet.g() == 2) {
                                click = ClickType.MIDDLE;
                                if (slotNum < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.f.cl.b(slotNum);
                                if (slot != null && slot.h() && this.f.gC().d && this.f.cl.g().f()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (slotNum >= 0) {
                                if (packet.g() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.f.cl.b(slotNum);
                                    if (slot != null && slot.h() && slot.a(this.f) && !slot.g().f() && slot.g().h() != Items.a) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packet.g() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.f.cl.b(slotNum);
                                if (slot != null && slot.h() && slot.a(this.f) && !slot.g().f() && slot.g().h() != Items.a) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packet.g() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case f: {
                            Container containerMenu = this.f.cl;
                            int currentStatus = this.f.cl.w;
                            int newStatus = Container.d(packet.g());
                            if (!(currentStatus != 1 || newStatus != 2 && currentStatus != newStatus || containerMenu.g().f() || newStatus == 0 || newStatus == 1 || newStatus != 2 || this.f.cl.x.isEmpty() || this.f.cl.x.size() != 1)) {
                                int index = containerMenu.x.iterator().next().d;
                                containerMenu.f();
                                this.a(new PacketPlayInWindowClick(packet.b(), packet.e(), (short)index, (byte)containerMenu.v, InventoryClickType.a, packet.i(), packet.j()));
                                return;
                            }
                            this.f.cl.a(slotNum, (int)packet.g(), packet.h(), this.f);
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (slotNum < 0 || this.f.cl.g().f()) break;
                            net.minecraft.world.item.ItemStack cursor = this.f.cl.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.h())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.h()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packet.h() != InventoryClickType.f) {
                        CartographyInventory cartographyInventory;
                        SmithingInventory smithingInv;
                        ItemStack result;
                        CraftingInventory craftingInv;
                        Recipe recipe;
                        if (this.f.cl.w != 0) {
                            action = InventoryAction.NOTHING;
                        }
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, (int)slotNum, click, action, (int)packet.g()) : new InventoryClickEvent(inventory, type, (int)slotNum, click, action);
                        Inventory top = inventory.getTopInventory();
                        if (slotNum == 0 && top instanceof CraftingInventory && (recipe = (craftingInv = (CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, (int)slotNum, click, action, (int)packet.g()) : new CraftItemEvent(recipe, inventory, type, (int)slotNum, click, action);
                        }
                        if (slotNum == 3 && top instanceof SmithingInventory && (result = (smithingInv = (SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, (int)slotNum, click, action, (int)packet.g()) : new SmithItemEvent(inventory, type, (int)slotNum, click, action);
                        }
                        if (slotNum == 2 && top instanceof CartographyInventory && (result = (cartographyInventory = (CartographyInventory)top).getResult()) != null && !result.isEmpty()) {
                            event = click == ClickType.NUMBER_KEY ? new CartographyItemEvent(inventory, type, (int)slotNum, click, action, (int)packet.g()) : new CartographyItemEvent(inventory, type, (int)slotNum, click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.f.cl;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.f.cl != oldContainer) {
                            this.f.cl.i();
                            this.f.cl.e();
                            return;
                        }
                        if (event.getResult() != Event.Result.DENY) {
                            this.f.cl.a(slotNum, (int)packet.g(), packet.h(), this.f);
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.f.cl.b();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packet.i())) {
                        this.f.cl.a(entry.getIntKey(), (HashedStack)entry.getValue());
                    }
                    this.f.cl.a(packet.j());
                    this.f.cl.i();
                    if (flag) {
                        this.f.cl.e();
                    } else {
                        this.f.cl.d();
                    }
                    if (packet.g() == 40 && this.f.cl != this.f.ck) {
                        this.f.dD.sendOffHandSlotChange();
                    }
                    if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                        this.f.L();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packet) {
        if (!Bukkit.isPrimaryThread() && !this.recipeSpamPackets.isIncrementAndUnderThreshold()) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.f.J();
        if (!this.f.at() && this.f.cl.l == packet.b()) {
            if (!this.f.cl.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cl);
            } else {
                CraftingManager.d recipeFromDisplay = this.d.aN().a(packet.e());
                if (recipeFromDisplay != null) {
                    Container container;
                    RecipeHolder recipeHolder = recipeFromDisplay.b();
                    if (this.f.L().b(recipeHolder.a()) && (container = this.f.cl) instanceof ContainerRecipeBook) {
                        ContainerRecipeBook recipeBookMenu = (ContainerRecipeBook)container;
                        if (recipeHolder.b().aq_().c()) {
                            h.debug("Player {} tried to place impossible recipe {}", (Object)this.f, (Object)recipeHolder.a().a());
                            return;
                        }
                        NamespacedKey recipeName = CraftNamespacedKey.fromMinecraft(recipeHolder.a().a());
                        boolean makeAll = packet.f();
                        com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent paperEvent = new com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent((Player)this.f.getBukkitEntity(), recipeName, makeAll);
                        if (!paperEvent.callEvent()) {
                            return;
                        }
                        recipeName = paperEvent.getRecipe();
                        makeAll = paperEvent.isMakeAll();
                        if (PlayerRecipeBookClickEvent.getHandlerList().getRegisteredListeners().length > 0) {
                            Recipe recipe = this.cserver.getRecipe(recipeName);
                            if (recipe == null) {
                                return;
                            }
                            PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.f, recipe, makeAll);
                            recipeName = ((Keyed)event.getRecipe()).getKey();
                            makeAll = event.isShiftClick();
                        }
                        if (!(this.f.cl instanceof ContainerRecipeBook)) {
                            return;
                        }
                        recipeHolder = this.d.aN().b(ResourceKey.a(Registries.bD, CraftNamespacedKey.toMinecraft(recipeName))).orElse(null);
                        if (recipeHolder == null) {
                            return;
                        }
                        ContainerRecipeBook.a postPlaceAction = recipeBookMenu.a(makeAll, this.f.gQ(), recipeHolder, this.f.A(), this.f.gB());
                        if (postPlaceAction == ContainerRecipeBook.a.b) {
                            this.b(new PacketPlayOutAutoRecipe(this.f.cl.l, recipeFromDisplay.a().b()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        this.f.J();
        if (this.f.cl.l == packet.b() && !this.f.at()) {
            if (!this.f.cl.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cl);
            } else {
                boolean flag = this.f.cl.a((EntityHuman)this.f, packet.e());
                if (flag) {
                    this.f.cl.d();
                }
                if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                    this.f.L();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.gk()) {
            boolean flag2;
            boolean flag = packet.b() < 0;
            net.minecraft.world.item.ItemStack itemStack = packet.e();
            if (!itemStack.a(this.f.A().O())) {
                return;
            }
            boolean flag1 = packet.b() >= 1 && packet.b() <= 45;
            boolean bl = flag2 = itemStack.f() || itemStack.M() <= itemStack.k();
            if (flag || flag1 && !net.minecraft.world.item.ItemStack.a(this.f.ck.b(packet.b()).g(), packet.e())) {
                CraftInventoryView inventory = this.f.ck.getBukkitView();
                ItemStack item = CraftItemStack.asBukkitCopy(packet.e());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packet.b() < 36) {
                    type = packet.b() >= 5 && packet.b() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packet.b(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemStack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packet.b() >= 0) {
                            this.f.g.b(new PacketPlayOutSetSlot(this.f.ck.l, this.f.ck.k(), packet.b(), this.f.ck.b(packet.b()).g()));
                            this.f.g.b(new ClientboundSetCursorItemPacket(net.minecraft.world.item.ItemStack.l.v()));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.f.ck.b(packet.b()).e(itemStack);
                this.f.ck.a((int)packet.b(), itemStack);
                this.f.ck.d();
                if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                    this.f.L();
                }
            } else if (flag && flag2) {
                if (this.r.c()) {
                    this.r.a();
                    this.f.a(itemStack, true);
                } else {
                    h.warn("Player {} was dropping items too fast in creative mode, ignoring.", (Object)this.f.ap());
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packet) {
        String[] lines = packet.f();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int offset;
            if (MAX_SIGN_LINE_LENGTH <= 0 || lines[i2].length() <= MAX_SIGN_LINE_LENGTH || (offset = lines[i2].codePoints().limit(MAX_SIGN_LINE_LENGTH).map(Character::charCount).sum()) >= lines[i2].length()) continue;
            lines[i2] = lines[i2].substring(0, offset);
        }
        List<String> list = Stream.of(lines).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(texts -> this.a(packet, (List<FilteredText>)texts), (Executor)this.d);
    }

    private void a(PacketPlayInUpdateSign packet, List<FilteredText> filteredText) {
        if (this.f.fv()) {
            return;
        }
        this.f.J();
        WorldServer serverLevel = this.f.A();
        BlockPosition pos = packet.b();
        if (serverLevel.D(pos)) {
            if (!new UncheckedSignChangeEvent((Player)this.f.getBukkitEntity(), MCUtil.toPosition(pos), packet.e() ? Side.FRONT : Side.BACK, filteredText.stream().map(line -> Component.text((String)line.d())).toList()).callEvent()) {
                return;
            }
            TileEntity tileEntity = serverLevel.c_(pos);
            if (!(tileEntity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign signBlockEntity = (TileEntitySign)tileEntity;
            signBlockEntity.a((EntityHuman)this.f, packet.e(), filteredText);
        }
    }

    @Override
    public void a(PacketPlayInAbilities packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.gC().c && this.f.gC().b != packet.b()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.f.getBukkitEntity(), packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.f.gC().b = packet.b();
            } else {
                this.f.z();
            }
        }
    }

    @Override
    public void a(ServerboundClientInformationPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (packet.b().c() < 0) {
            h.warn("Disconnecting {} for invalid view distance: {}", (Object)this.f.cV(), (Object)packet.b().c());
            this.disconnect((IChatBaseComponent)IChatBaseComponent.b("Invalid client settings"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        boolean isModelPartShown = this.f.a(PlayerModelPart.g);
        this.f.a(packet.b());
        this.e.n.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.b().b()));
        if (this.f.a(PlayerModelPart.g) != isModelPartShown) {
            this.d.am().a(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.h, this.f));
        }
    }

    @Override
    public void a(PacketPlayInDifficultyChange packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (!this.f.s(2) && !this.h()) {
            h.warn("Player {} tried to change difficulty to {} without required permissions", (Object)this.f.gz().name(), (Object)packet.b().b());
        }
    }

    @Override
    public void a(ServerboundChangeGameModePacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (!this.f.s(2) && !this.f.getBukkitEntity().hasPermission("purpur.debug.f3n")) {
            h.warn("Player {} tried to change game mode to {} without required permissions", (Object)this.f.gz().name(), (Object)packet.b().e().getString());
        } else {
            CommandGamemode.setGameMode(this.f.C(), this.f, packet.b(), PlayerGameModeChangeEvent.Cause.GAMEMODE_SWITCHER);
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.s(2) || this.h()) {
            this.d.b(packet.b());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        RemoteChatSession.a data = packet.b();
        ProfilePublicKey.a data1 = this.P != null ? this.P.d().b() : null;
        ProfilePublicKey.a data2 = data.b();
        if (!Objects.equals(data1, data2)) {
            if (data1 != null && data2.b().isBefore(data1.b())) {
                this.disconnect(ProfilePublicKey.a, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator signatureValidator = this.d.av().a();
                    if (signatureValidator == null) {
                        h.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.f.gz().name());
                        return;
                    }
                    this.a(data.a(this.f.gz(), signatureValidator));
                }
                catch (ProfilePublicKey.b var6) {
                    this.disconnect(var6.a(), var6.kickCause);
                }
            }
        }
    }

    @Override
    public void a(ServerboundConfigurationAcknowledgedPacket packet) {
        if (!this.V) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        ServerConfigurationPacketListenerImpl listener = new ServerConfigurationPacketListenerImpl(this.d, this.e, this.a(this.f.E()));
        this.e.a(ConfigurationProtocols.b, listener);
        new PlayerConnectionReconfigureEvent((PlayerConfigurationConnection)listener.paperConnection).callEvent();
    }

    @Override
    public void a(ServerboundChunkBatchReceivedPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.g.a(packet.b());
    }

    @Override
    public void a(ServerboundDebugSubscriptionRequestPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.f.a(packet.b());
    }

    private void a(RemoteChatSession chatSession) {
        this.P = chatSession;
        this.hasLoggedExpiry = false;
        this.Q = chatSession.a(this.f.cT());
        this.U.append(() -> this.d.h(() -> {
            this.f.a(chatSession);
            this.d.am().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), (Collection<EntityPlayer>)List.of(this.f)), this.f);
        }));
    }

    @Override
    public void a(ServerboundCustomPayloadPacket packet) {
        super.a(packet);
    }

    @Override
    public void a(ServerboundClientTickEndPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.tickEndEvent.callEvent();
        if (!this.O) {
            this.f.a(Vec3D.c);
        }
        this.O = false;
    }

    private void a(Vec3D movement) {
        if (movement.h() > (double)1.0E-5f) {
            this.f.J();
        }
        this.f.a(movement);
        this.O = true;
    }

    @Override
    public boolean a() {
        return this.f.gk();
    }

    @Override
    public EntityPlayer o() {
        return this.f;
    }

    private PlayerFailMoveEvent fireFailMove(PlayerFailMoveEvent.FailReason failReason, double toX, double toY, double toZ, float toYaw, float toPitch, boolean logWarning) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
        Location to = new Location(player.getWorld(), toX, toY, toZ, toYaw, toPitch);
        PlayerFailMoveEvent event = new PlayerFailMoveEvent((Player)player, failReason, false, logWarning, from, to);
        event.callEvent();
        return event;
    }

    public CraftPlayer getCraftPlayer() {
        return this.f == null ? null : this.f.getBukkitEntity();
    }

    @Override
    public void disconnectAsync(DisconnectionDetails disconnectionInfo) {
        if (this.cserver.isPrimaryThread()) {
            this.b(disconnectionInfo);
            return;
        }
        this.e.m();
        this.d.scheduleOnMain(() -> {
            this.b(disconnectionInfo);
            if (this.f.quitReason == null) {
                this.e.enableAutoRead();
            }
        });
    }

    public final boolean isDisconnected() {
        return !this.f.joining && !this.e.i() || this.processedDisconnect;
    }

    @Override
    public void a(ServerboundResourcePackPacket packet) {
        PlayerResourcePackStatusEvent.Status packStatus;
        super.a(packet);
        this.e.resourcePackStatus = packStatus = PlayerResourcePackStatusEvent.Status.values()[packet.e().ordinal()];
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), packet.b(), packStatus));
    }

    public void disconnect(Component reason) {
        this.disconnect(reason, PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnect(PaperAdventure.asVanilla(reason), DisconnectionReason.game(cause));
    }

    public void disconnect(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnect(reason, DisconnectionReason.game(cause));
    }

    public void disconnectAsync(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(PaperAdventure.asVanilla(reason), cause);
    }

    public void disconnectAsync(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(reason, DisconnectionReason.game(cause));
    }

    public PaperPlayerGameConnection paperConnection() {
        return this.playerGameConnection;
    }

    private /* synthetic */ void lambda$handleChat$13(PlayerChatMessage signedMessage, CompletableFuture componentFuture, CompletableFuture completableFuture, Void $) {
        PlayerChatMessage playerChatMessage = signedMessage.a((IChatBaseComponent)componentFuture.join()).a(((FilteredText)completableFuture.join()).e());
        this.a(playerChatMessage);
    }

    @FunctionalInterface
    static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

