/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network.config;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.MoonriseChunkLoadCounter;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.papermc.paper.connection.PaperConfigurationTask;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.event.player.AsyncPlayerSpawnLocationEvent;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class PrepareSpawnTask
implements ConfigurationTask {
    static final Logger c = LogUtils.getLogger();
    public static final ConfigurationTask.a a = new ConfigurationTask.a("prepare_spawn");
    public static final int b = 3;
    final MinecraftServer d;
    final NameAndId e;
    final LevelLoadListener f;
    @Nullable
    private c g;
    private final GameProfile profile;
    private final ServerConfigurationPacketListenerImpl listener;
    private boolean newPlayer;

    public PrepareSpawnTask(MinecraftServer server, GameProfile profile, ServerConfigurationPacketListenerImpl listener) {
        this.profile = profile;
        this.listener = listener;
        this.d = server;
        this.e = new NameAndId(profile);
        this.f = LevelLoadListener.noop();
    }

    @Override
    public void a(Consumer<Packet<?>> task) {
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(c);){
            WorldServer serverLevel1;
            WorldServer vanillaDefaultLevel;
            ResourceKey<World> resourceKey;
            Optional<ValueInput> optional;
            block16: {
                org.bukkit.World bWorld;
                block18: {
                    Optional<String> worldName;
                    block17: {
                        optional = this.d.am().c(this.e).map(compoundTag -> TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)this.d.bg(), compoundTag));
                        this.newPlayer = optional.isEmpty();
                        resourceKey = null;
                        boolean[] invalidPlayerWorld = new boolean[]{false};
                        if (!optional.isPresent()) break block16;
                        ValueInput playerData = optional.get();
                        Optional<Long> worldUUIDMost = playerData.f("WorldUUIDMost");
                        Optional<Long> worldUUIDLeast = playerData.f("WorldUUIDLeast");
                        worldName = playerData.g("world");
                        if (!worldUUIDMost.isPresent() || !worldUUIDLeast.isPresent()) break block17;
                        bWorld = Bukkit.getServer().getWorld(new UUID(worldUUIDMost.get(), worldUUIDLeast.get()));
                        break block18;
                    }
                    if (!worldName.isPresent()) break block16;
                    bWorld = Bukkit.getServer().getWorld(worldName.get());
                }
                if (bWorld != null) {
                    resourceKey = ((CraftWorld)bWorld).getHandle().al();
                } else {
                    resourceKey = World.h;
                    invalidPlayerWorld[0] = true;
                }
            }
            EntityPlayer.c savedPosition = optional.flatMap(valueInput -> valueInput.a(EntityPlayer.c.a)).orElse(EntityPlayer.c.b);
            WorldData.a respawnData = this.d.bf().H().a();
            if (resourceKey == null) {
                resourceKey = savedPosition.a().orElse(null);
            }
            if ((vanillaDefaultLevel = this.d.a(respawnData.a())) == null) {
                vanillaDefaultLevel = this.d.O();
            }
            if (resourceKey == null) {
                serverLevel1 = vanillaDefaultLevel;
            } else {
                serverLevel1 = this.d.a(resourceKey);
                if (serverLevel1 == null) {
                    c.warn("Unknown respawn dimension {}, defaulting to overworld", resourceKey);
                    serverLevel1 = vanillaDefaultLevel;
                }
            }
            WorldServer serverLevel = serverLevel1;
            CompletableFuture completableFuture = savedPosition.b().map(CompletableFuture::completedFuture).orElseGet(() -> PlayerSpawnFinder.a(serverLevel, respawnData.b()));
            Vec2F vec2 = savedPosition.c().orElse(new Vec2F(respawnData.d(), respawnData.e()));
            this.g = new a(serverLevel, completableFuture, vec2);
        }
    }

    @Override
    public boolean a() {
        c c2 = this.g;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{a.class, b.class}, (Object)c2, n2)) {
            case -1 -> false;
            case 0 -> {
                a preparing = (a)c2;
                b ready = preparing.b();
                if (ready != null) {
                    this.g = ready;
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                b ready = (b)c2;
                yield true;
            }
            default -> throw new MatchException(null, null);
        };
    }

    public EntityPlayer a(NetworkManager connection, CommonListenerCookie cookie) {
        c c2 = this.g;
        if (c2 instanceof b) {
            b ready = (b)c2;
            return ready.a(connection, cookie);
        }
        throw new IllegalStateException("Player spawn was not ready");
    }

    public void c() {
        c c2 = this.g;
        if (c2 instanceof b) {
            b ready = (b)c2;
            ready.a();
        }
    }

    public void d() {
        c c2 = this.g;
        if (c2 instanceof a) {
            a preparing = (a)c2;
            preparing.a();
        }
        this.g = null;
    }

    @Override
    public ConfigurationTask.a b() {
        return a;
    }

    final class a
    implements c {
        private WorldServer b;
        private CompletableFuture<Vec3D> c;
        private Vec2F d;
        @Nullable
        private CompletableFuture<?> e;
        @Nullable
        private CompletableFuture<Location> eventFuture;
        private final ChunkLoadCounter f = new MoonriseChunkLoadCounter();

        a(WorldServer spawnLevel, CompletableFuture<Vec3D> spawnPosition, Vec2F spawnAngle) {
            this.b = spawnLevel;
            this.c = spawnPosition;
            this.d = spawnAngle;
        }

        public void a() {
            this.c.cancel(false);
        }

        @Nullable
        public b b() {
            if (!this.c.isDone()) {
                return null;
            }
            Vec3D vec3 = this.c.join();
            if (this.e == null) {
                if (this.eventFuture == null && PlayerSpawnLocationEvent.getHandlerList().getRegisteredListeners().length != 0) {
                    EntityPlayer serverPlayer;
                    if (PrepareSpawnTask.this.listener.e.savedPlayerForLegacyEvents != null) {
                        serverPlayer = PrepareSpawnTask.this.listener.e.savedPlayerForLegacyEvents;
                    } else {
                        PrepareSpawnTask.this.listener.e.savedPlayerForLegacyEvents = serverPlayer = new EntityPlayer(PrepareSpawnTask.this.d, PrepareSpawnTask.this.d.O(), PrepareSpawnTask.this.profile, ClientInformation.a());
                    }
                    PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)serverPlayer.getBukkitEntity(), CraftLocation.toBukkit(vec3, (World)this.b, this.d.j, this.d.k));
                    ev.callEvent();
                    vec3 = MCUtil.toVec3((Position)ev.getSpawnLocation());
                    this.b = ((CraftWorld)ev.getSpawnLocation().getWorld()).getHandle();
                    this.c = CompletableFuture.completedFuture(vec3);
                    this.d = new Vec2F(ev.getSpawnLocation().getYaw(), ev.getSpawnLocation().getPitch());
                }
                if (this.eventFuture == null && AsyncPlayerSpawnLocationEvent.getHandlerList().getRegisteredListeners().length != 0) {
                    Vec3D vec3final = vec3;
                    this.eventFuture = CompletableFuture.supplyAsync(() -> {
                        AsyncPlayerSpawnLocationEvent ev = new AsyncPlayerSpawnLocationEvent((PlayerConfigurationConnection)PrepareSpawnTask.this.listener.paperConnection, CraftLocation.toBukkit(vec3final, (World)this.b, this.d.j, this.d.k), PrepareSpawnTask.this.newPlayer);
                        ev.callEvent();
                        return ev.getSpawnLocation();
                    }, PaperConfigurationTask.CONFIGURATION_POOL);
                }
                if (this.eventFuture != null) {
                    if (!this.eventFuture.isDone()) {
                        return null;
                    }
                    Location location = this.eventFuture.join();
                    vec3 = MCUtil.toVec3((Position)location);
                    this.b = ((CraftWorld)location.getWorld()).getHandle();
                    this.c = CompletableFuture.completedFuture(vec3);
                    this.d = new Vec2F(location.getYaw(), location.getPitch());
                }
                ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(BlockPosition.a(vec3));
                this.e = ((MoonriseChunkLoadCounter)this.f).trackLoadWithRadius(this.b, chunkPos, 3, ChunkStatus.n, Priority.HIGH, () -> this.b.n().b(TicketType.g, chunkPos, 3));
                PrepareSpawnTask.this.f.a(LevelLoadListener.a.d, this.f.c());
                PrepareSpawnTask.this.f.a(this.b.al(), chunkPos);
            }
            PrepareSpawnTask.this.f.a(LevelLoadListener.a.d, this.f.a(), this.f.c());
            if (!this.e.isDone()) {
                return null;
            }
            PrepareSpawnTask.this.f.a(LevelLoadListener.a.d);
            PrepareSpawnTask prepareSpawnTask = PrepareSpawnTask.this;
            Objects.requireNonNull(prepareSpawnTask);
            return prepareSpawnTask.new b(this.b, vec3, this.d);
        }
    }

    static sealed interface c
    permits a, b {
    }

    final class b
    implements c {
        private final WorldServer b;
        private final Vec3D c;
        private final Vec2F d;

        b(WorldServer spawnLevel, Vec3D spawnPosition, Vec2F spawnAngle) {
            this.b = spawnLevel;
            this.c = spawnPosition;
            this.d = spawnAngle;
        }

        public void a() {
            this.b.n().b(TicketType.g, new ChunkCoordIntPair(BlockPosition.a(this.c)), 3);
        }

        public EntityPlayer a(NetworkManager connection, CommonListenerCookie cookie) {
            EntityPlayer var7;
            EntityPlayer serverPlayer;
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(BlockPosition.a(this.c));
            this.b.a(chunkPos, 3);
            if (connection.savedPlayerForLegacyEvents != null) {
                serverPlayer = connection.savedPlayerForLegacyEvents;
                connection.savedPlayerForLegacyEvents = null;
                ((EntityHuman)serverPlayer).cI = cookie.a();
                serverPlayer.updateOptionsNoEvents(cookie.c());
                serverPlayer.a(this.b);
            } else {
                serverPlayer = new EntityPlayer(PrepareSpawnTask.this.d, this.b, cookie.a(), cookie.c());
            }
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(serverPlayer.en(), c);){
                Optional<ValueInput> optional = PrepareSpawnTask.this.d.am().c(PrepareSpawnTask.this.e).map(tag -> {
                    CraftPlayer craftPlayer = serverPlayer.getBukkitEntity();
                    long modified = new File(PrepareSpawnTask.this.d.h.getPlayerDir(), serverPlayer.cU() + ".dat").lastModified();
                    if (modified < craftPlayer.getFirstPlayed()) {
                        craftPlayer.setFirstPlayed(modified);
                    }
                    return tag;
                }).map(compoundTag -> TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)PrepareSpawnTask.this.d.bg(), compoundTag));
                optional.ifPresent(serverPlayer::d);
                if (optional.isPresent()) {
                    serverPlayer.lastKnownName = optional.flatMap(t2 -> t2.a("bukkit")).flatMap(t2 -> t2.g("lastKnownName")).orElse(null);
                }
                if (optional.isEmpty()) {
                    serverPlayer.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
                }
                serverPlayer.b(this.c, this.d.j, this.d.k);
                PrepareSpawnTask.this.d.am().a(connection, serverPlayer, cookie);
                optional.ifPresent(valueInput -> {
                    serverPlayer.c((ValueInput)valueInput);
                    serverPlayer.b((ValueInput)valueInput);
                });
                var7 = serverPlayer;
            }
            return var7;
        }
    }
}

