/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class PathPackResources
extends ResourcePackAbstract {
    private static final Logger c = LogUtils.getLogger();
    private static final Joiner d = Joiner.on((String)"/");
    private final Path e;

    public PathPackResources(PackLocationInfo location, Path root) {
        super(location);
        this.e = root;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> a(String ... elements) {
        FileUtils.a(elements);
        Path path = FileUtils.a(this.e, List.of(elements));
        return Files.exists(path, new LinkOption[0]) ? IoSupplier.create(path) : null;
    }

    public static boolean a(Path path) {
        if (!SharedConstants.am) {
            return true;
        }
        if (path.getFileSystem() != FileSystems.getDefault()) {
            return true;
        }
        try {
            return path.toRealPath(new LinkOption[0]).endsWith(path);
        }
        catch (IOException var2) {
            c.warn("Failed to resolve real path for {}", (Object)path, (Object)var2);
            return false;
        }
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> a(EnumResourcePackType packType, MinecraftKey location) {
        Path path = this.e.resolve(packType.a()).resolve(location.b());
        return PathPackResources.a(location, path);
    }

    @Nullable
    public static IoSupplier<InputStream> a(MinecraftKey location, Path path) {
        return (IoSupplier)FileUtils.e(location.a()).mapOrElse(elements -> {
            Path path1 = FileUtils.a(path, elements);
            return PathPackResources.b(path1);
        }, error -> {
            c.error("Invalid path {}: {}", (Object)location, (Object)error.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> b(Path path) {
        return Files.exists(path, new LinkOption[0]) && PathPackResources.a(path) ? IoSupplier.create(path) : null;
    }

    @Override
    public void a(EnumResourcePackType packType, String namespace, String path, IResourcePack.a resourceOutput) {
        FileUtils.e(path).ifSuccess(tets -> {
            Path path1 = this.e.resolve(packType.a()).resolve(namespace);
            PathPackResources.a(namespace, path1, tets, resourceOutput);
        }).ifError(error -> c.error("Invalid path {}: {}", (Object)path, (Object)error.message()));
    }

    public static void a(String namespace, Path namespacePath, List<String> decomposedPath, IResourcePack.a resourceOutput) {
        Path path = FileUtils.a(namespacePath, decomposedPath);
        try (Stream<Path> stream2 = Files.find(path, Integer.MAX_VALUE, PathPackResources::a, new FileVisitOption[0]);){
            stream2.forEach(path1 -> {
                String string = d.join((Iterable)namespacePath.relativize((Path)path1));
                MinecraftKey resourceLocation = MinecraftKey.b(namespace, string);
                if (resourceLocation == null) {
                    SystemUtils.b(String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", namespace, string));
                } else {
                    resourceOutput.accept(resourceLocation, IoSupplier.create(path1));
                }
            });
        }
        catch (NoSuchFileException | NotDirectoryException stream2) {
        }
        catch (IOException var11) {
            c.error("Failed to list path {}", (Object)path, (Object)var11);
        }
    }

    private static boolean a(Path path, BasicFileAttributes attributes) {
        return !SharedConstants.be ? attributes.isRegularFile() : attributes.isRegularFile() && !StringUtils.equalsIgnoreCase((CharSequence)path.getFileName().toString(), (CharSequence)".ds_store");
    }

    @Override
    public Set<String> a(EnumResourcePackType type) {
        HashSet set = Sets.newHashSet();
        Path path = this.e.resolve(type.a());
        try (DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(path);){
            for (Path path1 : directoryStream2) {
                String string = path1.getFileName().toString();
                if (!Files.isDirectory(path1, new LinkOption[0])) {
                    c.error("Invalid directory entry: {} in {}.", new Object[]{string, this.e, new NotDirectoryException(string)});
                    continue;
                }
                if (MinecraftKey.j(string)) {
                    set.add(string);
                    continue;
                }
                c.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)string, (Object)this.e);
            }
        }
        catch (NoSuchFileException | NotDirectoryException directoryStream2) {
        }
        catch (IOException var11) {
            c.error("Failed to list path {}", (Object)path, (Object)var11);
        }
        return set;
    }

    @Override
    public void close() {
    }

    public static class a
    implements ResourcePackLoader.c {
        private final Path a;

        public a(Path content) {
            this.a = content;
        }

        @Override
        public IResourcePack a(PackLocationInfo location) {
            return new PathPackResources(location, this.a);
        }

        @Override
        public IResourcePack a(PackLocationInfo location, ResourcePackLoader.a metadata) {
            IResourcePack packResources = this.a(location);
            List<String> list = metadata.d();
            if (list.isEmpty()) {
                return packResources;
            }
            ArrayList<IResourcePack> list1 = new ArrayList<IResourcePack>(list.size());
            for (String string : list) {
                Path path = this.a.resolve(string);
                list1.add(new PathPackResources(location, path));
            }
            return new CompositePackResources(packResources, list1);
        }
    }
}

