/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.linkfs;

import com.google.common.base.Splitter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.packs.linkfs.LinkFSFileStore;
import net.minecraft.server.packs.linkfs.LinkFSPath;
import net.minecraft.server.packs.linkfs.LinkFSProvider;
import net.minecraft.server.packs.linkfs.PathContents;

public class LinkFileSystem
extends FileSystem {
    private static final Set<String> b = Set.of("basic");
    public static final String a = "/";
    private static final Splitter c = Splitter.on((char)'/');
    private final FileStore d;
    private final FileSystemProvider e = new LinkFSProvider();
    private final LinkFSPath f;

    LinkFileSystem(String name, b root) {
        this.d = new LinkFSFileStore(name);
        this.f = LinkFileSystem.a(root, this, "", null);
    }

    private static LinkFSPath a(b directory, LinkFileSystem fileSystem, String name, @Nullable LinkFSPath parent) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        LinkFSPath linkFsPath = new LinkFSPath(fileSystem, name, parent, new PathContents.a((Map<String, LinkFSPath>)map));
        directory.b.forEach((fileName, path) -> map.put(fileName, (Object)new LinkFSPath(fileSystem, (String)fileName, linkFsPath, new PathContents.b((Path)path))));
        directory.a.forEach((fileName, directory1) -> map.put(fileName, (Object)LinkFileSystem.a(directory1, fileSystem, fileName, linkFsPath)));
        map.trim();
        return linkFsPath;
    }

    @Override
    public FileSystemProvider provider() {
        return this.e;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return a;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return List.of(this.f);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return List.of(this.d);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return b;
    }

    @Override
    public Path getPath(String first, String ... more) {
        String string;
        Stream<String> stream = Stream.of(first);
        if (more.length > 0) {
            stream = Stream.concat(stream, Stream.of(more));
        }
        if ((string = stream.collect(Collectors.joining(a))).equals(a)) {
            return this.f;
        }
        if (string.startsWith(a)) {
            LinkFSPath linkFsPath = this.f;
            for (String string1 : c.split((CharSequence)string.substring(1))) {
                if (string1.isEmpty()) {
                    throw new IllegalArgumentException("Empty paths not allowed");
                }
                linkFsPath = linkFsPath.a(string1);
            }
            return linkFsPath;
        }
        LinkFSPath linkFsPath = null;
        for (String string1 : c.split((CharSequence)string)) {
            if (string1.isEmpty()) {
                throw new IllegalArgumentException("Empty paths not allowed");
            }
            linkFsPath = new LinkFSPath(this, string1, linkFsPath, PathContents.b);
        }
        if (linkFsPath == null) {
            throw new IllegalArgumentException("Empty paths not allowed");
        }
        return linkFsPath;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    public FileStore a() {
        return this.d;
    }

    public LinkFSPath b() {
        return this.f;
    }

    public static a c() {
        return new a();
    }

    record b(Map<String, b> a, Map<String, Path> b) {
        public b() {
            this(new HashMap<String, b>(), new HashMap<String, Path>());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "children;files", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "children;files", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "children;files", "a", "b"}, this, o2);
        }
    }

    public static class a {
        private final b a = new b();

        public a a(List<String> pathString, String fileName, Path filePath) {
            b directoryEntry = this.a;
            for (String string : pathString) {
                directoryEntry = directoryEntry.a.computeIfAbsent(string, string1 -> new b());
            }
            directoryEntry.b.put(fileName, filePath);
            return this;
        }

        public a a(List<String> pathString, Path filePath) {
            if (pathString.isEmpty()) {
                throw new IllegalArgumentException("Path can't be empty");
            }
            int i2 = pathString.size() - 1;
            return this.a(pathString.subList(0, i2), pathString.get(i2), filePath);
        }

        public FileSystem a(String name) {
            return new LinkFileSystem(name, this.a);
        }
    }
}

