/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;

public abstract class PackDetector<T> {
    private final DirectoryValidator a;

    protected PackDetector(DirectoryValidator validator) {
        this.a = validator;
    }

    @Nullable
    public T a(Path path, List<ForbiddenSymlinkInfo> forbiddenSymlinkInfos) throws IOException {
        BasicFileAttributes attributes;
        Path path1 = path;
        try {
            attributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (NoSuchFileException var6) {
            return null;
        }
        if (attributes.isSymbolicLink()) {
            this.a.a(path, forbiddenSymlinkInfos);
            if (!forbiddenSymlinkInfos.isEmpty()) {
                return null;
            }
            path1 = Files.readSymbolicLink(path);
            attributes = Files.readAttributes(path1, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        if (attributes.isDirectory()) {
            this.a.b(path1, forbiddenSymlinkInfos);
            if (!forbiddenSymlinkInfos.isEmpty()) {
                return null;
            }
            return !Files.isRegularFile(path1.resolve("pack.mcmeta"), new LinkOption[0]) ? null : (T)this.c(path1);
        }
        return attributes.isRegularFile() && path1.getFileName().toString().endsWith(".zip") ? (T)this.d(path1) : null;
    }

    @Nullable
    protected abstract T d(Path var1) throws IOException;

    @Nullable
    protected abstract T c(Path var1) throws IOException;
}

