/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.ResourcePackFile;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.slf4j.Logger;

public class ResourcePackSourceFolder
implements ResourcePackSource {
    static final Logger a = LogUtils.getLogger();
    private static final PackSelectionConfig b = new PackSelectionConfig(false, ResourcePackLoader.Position.a, false);
    private final Path c;
    private final EnumResourcePackType d;
    private final PackSource e;
    private final DirectoryValidator f;

    public ResourcePackSourceFolder(Path folder, EnumResourcePackType packType, PackSource packSource, DirectoryValidator validator) {
        this.c = folder;
        this.d = packType;
        this.e = packSource;
        this.f = validator;
    }

    private static String a(Path path) {
        return path.getFileName().toString();
    }

    @Override
    public void loadPacks(Consumer<ResourcePackLoader> onLoad) {
        try {
            FileUtils.c(this.c);
            ResourcePackSourceFolder.a(this.c, this.f, (path, resources) -> {
                PackLocationInfo packLocationInfo = this.b((Path)path);
                ResourcePackLoader metaAndCreate = ResourcePackLoader.a(packLocationInfo, resources, this.d, b);
                if (metaAndCreate != null) {
                    onLoad.accept(metaAndCreate);
                }
            });
        }
        catch (IOException var3) {
            a.warn("Failed to list packs in {}", (Object)this.c, (Object)var3);
        }
    }

    private PackLocationInfo b(Path path) {
        String string = ResourcePackSourceFolder.a(path);
        return new PackLocationInfo("file/" + string, IChatBaseComponent.b(string), this.e, Optional.empty());
    }

    public static void a(Path folder, DirectoryValidator validator, BiConsumer<Path, ResourcePackLoader.c> output) throws IOException {
        a folderPackDetector = new a(validator);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(folder);){
            for (Path path : directoryStream) {
                try {
                    ArrayList<ForbiddenSymlinkInfo> list = new ArrayList<ForbiddenSymlinkInfo>();
                    ResourcePackLoader.c resourcesSupplier = (ResourcePackLoader.c)folderPackDetector.a(path, list);
                    if (!list.isEmpty()) {
                        a.warn("Ignoring potential pack entry: {}", (Object)ContentValidationException.a(path, list));
                        continue;
                    }
                    if (resourcesSupplier != null) {
                        output.accept(path, resourcesSupplier);
                        continue;
                    }
                    a.info("Found non-pack entry '{}', ignoring", (Object)path);
                }
                catch (IOException var10) {
                    a.warn("Failed to read properties of '{}', ignoring", (Object)path, (Object)var10);
                }
            }
        }
    }

    public static class a
    extends PackDetector<ResourcePackLoader.c> {
        public a(DirectoryValidator validator) {
            super(validator);
        }

        @Nullable
        protected ResourcePackLoader.c a(Path path) {
            FileSystem fileSystem = path.getFileSystem();
            if (fileSystem != FileSystems.getDefault() && !(fileSystem instanceof LinkFileSystem)) {
                a.info("Can't open pack archive at {}", (Object)path);
                return null;
            }
            return new ResourcePackFile.a(path);
        }

        protected ResourcePackLoader.c b(Path path) {
            return new PathPackResources.a(path);
        }
    }
}

