/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public abstract class ResourceDataJson<T>
extends ResourceDataAbstract<Map<MinecraftKey, T>> {
    private static final Logger a = LogUtils.getLogger();
    private final DynamicOps<JsonElement> b;
    private final Codec<T> c;
    private final FileToIdConverter d;

    protected ResourceDataJson(HolderLookup.a provider, Codec<T> codec, ResourceKey<? extends IRegistry<T>> registryKey) {
        this(provider.a(JsonOps.INSTANCE), codec, FileToIdConverter.a(registryKey));
    }

    protected ResourceDataJson(Codec<T> codec, FileToIdConverter lister) {
        this((DynamicOps<JsonElement>)JsonOps.INSTANCE, codec, lister);
    }

    private ResourceDataJson(DynamicOps<JsonElement> ops, Codec<T> codec, FileToIdConverter lister) {
        this.b = ops;
        this.c = codec;
        this.d = lister;
    }

    protected Map<MinecraftKey, T> a(IResourceManager resourceManager, GameProfilerFiller profiler) {
        HashMap map = new HashMap();
        ResourceDataJson.a(resourceManager, this.d, this.b, this.c, map);
        return map;
    }

    public static <T> void a(IResourceManager resourceManager, ResourceKey<? extends IRegistry<T>> registryKey, DynamicOps<JsonElement> ops, Codec<T> codec, Map<MinecraftKey, T> output) {
        ResourceDataJson.a(resourceManager, FileToIdConverter.a(registryKey), ops, codec, output);
    }

    public static <T> void a(IResourceManager resourceManager, FileToIdConverter lister, DynamicOps<JsonElement> ops, Codec<T> codec, Map<MinecraftKey, T> output) {
        for (Map.Entry<MinecraftKey, IResource> entry : lister.a(resourceManager).entrySet()) {
            MinecraftKey resourceLocation = entry.getKey();
            MinecraftKey resourceLocation1 = lister.b(resourceLocation);
            try {
                BufferedReader reader = entry.getValue().e();
                try {
                    codec.parse(ops, (Object)StrictJsonParser.a(reader)).ifSuccess(object -> {
                        if (output.putIfAbsent(resourceLocation1, object) != null) {
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourceLocation1));
                        }
                    }).ifError(error -> a.error("Couldn't parse data file '{}' from '{}': {}", new Object[]{resourceLocation1, resourceLocation, error}));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var14) {
                a.error("Couldn't parse data file '{}' from '{}'", new Object[]{resourceLocation1, resourceLocation, var14});
            }
        }
    }
}

