/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.UtilColor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class CachedUserNameToIdResolver
implements UserNameToIdResolver {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 1000;
    private static final int c = 1;
    private boolean d = true;
    private final Map<String, a> e = new ConcurrentHashMap<String, a>();
    private final Map<UUID, a> f = new ConcurrentHashMap<UUID, a>();
    private final GameProfileRepository g;
    private final Gson h = new GsonBuilder().create();
    private final File i;
    private final AtomicLong j = new AtomicLong();
    protected final ReentrantLock stateLock = new ReentrantLock();
    protected final ReentrantLock lookupLock = new ReentrantLock();

    public CachedUserNameToIdResolver(GameProfileRepository profileRepository, File file) {
        this.g = profileRepository;
        this.i = file;
        Lists.reverse(this.d()).forEach(this::a);
    }

    private void a(a profileInfo) {
        try {
            this.stateLock.lock();
            NameAndId nameAndId = profileInfo.a();
            profileInfo.a(this.b());
            this.e.put(nameAndId.b().toLowerCase(Locale.ROOT), profileInfo);
            this.f.put(nameAndId.a(), profileInfo);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private Optional<NameAndId> a(GameProfileRepository profileRepository, String name) {
        if (!UtilColor.f(name)) {
            return this.b(name);
        }
        boolean shouldLookup = !StringUtils.isBlank((CharSequence)name) && GlobalConfiguration.get().proxies.isProxyOnlineMode();
        Optional<NameAndId> optional = shouldLookup ? profileRepository.findProfileByName(name).map(NameAndId::new) : Optional.empty();
        return optional.isEmpty() ? this.b(name) : optional;
    }

    private Optional<NameAndId> b(String name) {
        return !GlobalConfiguration.get().proxies.isProxyOnlineMode() ? Optional.of(NameAndId.a(name)) : Optional.empty();
    }

    @Override
    public void a(boolean resolveOfflineUsers) {
        this.d = resolveOfflineUsers;
    }

    @Override
    public void a(NameAndId nameAndId) {
        this.b(nameAndId);
    }

    private a b(NameAndId nameAndId) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        instance.add(2, 1);
        Date time = instance.getTime();
        a gameProfileInfo = new a(nameAndId, time);
        this.a(gameProfileInfo);
        if (!SpigotConfig.saveUserCacheOnStopOnly) {
            this.save(true);
        }
        return gameProfileInfo;
    }

    private long b() {
        return this.j.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public NameAndId getIfCached(String name) {
        try {
            this.stateLock.lock();
            a entry = this.e.get(name.toLowerCase(Locale.ROOT));
            if (entry == null) {
                NameAndId nameAndId = null;
                return nameAndId;
            }
            entry.a(this.b());
            NameAndId nameAndId = entry.a();
            return nameAndId;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<NameAndId> a(String name) {
        String string = name.toLowerCase(Locale.ROOT);
        boolean stateLocked = true;
        try {
            Optional<NameAndId> optional;
            this.stateLock.lock();
            a gameProfileInfo = this.e.get(string);
            boolean flag = false;
            if (gameProfileInfo != null && new Date().getTime() >= gameProfileInfo.b.getTime()) {
                this.f.remove(gameProfileInfo.a().a());
                this.e.remove(gameProfileInfo.a().b().toLowerCase(Locale.ROOT));
                flag = true;
                gameProfileInfo = null;
            }
            if (gameProfileInfo != null) {
                gameProfileInfo.a(this.b());
                optional = Optional.of(gameProfileInfo.a());
                stateLocked = false;
                this.stateLock.unlock();
            } else {
                Optional<NameAndId> optional1;
                stateLocked = false;
                this.stateLock.unlock();
                try {
                    this.lookupLock.lock();
                    optional1 = this.a(this.g, name);
                }
                finally {
                    this.lookupLock.unlock();
                }
                if (optional1.isPresent()) {
                    optional = Optional.of(this.b(optional1.get()).a());
                    flag = false;
                } else {
                    optional = Optional.empty();
                }
            }
            if (flag && !SpigotConfig.saveUserCacheOnStopOnly) {
                this.save(true);
            }
            Optional<NameAndId> optional2 = optional;
            return optional2;
        }
        finally {
            if (stateLocked) {
                this.stateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<NameAndId> a(UUID uuid) {
        try {
            this.stateLock.lock();
            a gameProfileInfo = this.f.get(uuid);
            if (gameProfileInfo == null) {
                Optional<NameAndId> optional = Optional.empty();
                return optional;
            }
            gameProfileInfo.a(this.b());
            Optional<NameAndId> optional = Optional.of(gameProfileInfo.a());
            return optional;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static DateFormat c() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<a> d() {
        ArrayList list = Lists.newArrayList();
        try (BufferedReader reader = Files.newReader((File)this.i, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonArray = (JsonArray)this.h.fromJson((Reader)reader, JsonArray.class);
            if (jsonArray != null) {
                DateFormat dateFormat = CachedUserNameToIdResolver.c();
                jsonArray.forEach(jsonElement -> CachedUserNameToIdResolver.a(jsonElement, dateFormat).ifPresent(list::add));
                ArrayList arrayList = list;
                return arrayList;
            }
            ArrayList var9 = list;
            return var9;
        }
        catch (FileNotFoundException var9) {
            return list;
        }
        catch (JsonSyntaxException | NullPointerException ex) {
            a.warn("Usercache.json is corrupted or has bad formatting. Deleting it to prevent further issues.");
            this.i.delete();
            return list;
        }
        catch (JsonParseException | IOException var8) {
            a.warn("Failed to load profile cache {}", (Object)this.i, (Object)var8);
        }
        return list;
    }

    @Override
    public void a() {
        this.save(false);
    }

    @Override
    public void save(boolean asyncSave) {
        JsonArray jsonArray = new JsonArray();
        DateFormat dateFormat = CachedUserNameToIdResolver.c();
        this.listTopMRUProfiles(SpigotConfig.userCacheCap).forEach(gameProfileInfo -> jsonArray.add(CachedUserNameToIdResolver.a(gameProfileInfo, dateFormat)));
        String string = this.h.toJson((JsonElement)jsonArray);
        Runnable save = () -> {
            try (BufferedWriter writer = Files.newWriter((File)this.i, (Charset)StandardCharsets.UTF_8);){
                writer.write(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        if (asyncSave) {
            MCUtil.scheduleAsyncTask(save);
        } else {
            save.run();
        }
    }

    private Stream<a> a(int limit) {
        return this.listTopMRUProfiles(limit).stream();
    }

    private List<a> listTopMRUProfiles(int limit) {
        try {
            this.stateLock.lock();
            List<a> list = this.f.values().stream().sorted(Comparator.comparing(a::c).reversed()).limit(limit).toList();
            return list;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static JsonElement a(a profileInfo, DateFormat format) {
        JsonObject jsonObject = new JsonObject();
        profileInfo.a().b(jsonObject);
        jsonObject.addProperty("expiresOn", format.format(profileInfo.b()));
        return jsonObject;
    }

    private static Optional<a> a(JsonElement element, DateFormat format) {
        JsonElement jsonElement;
        JsonObject asJsonObject;
        NameAndId nameAndId;
        if (element.isJsonObject() && (nameAndId = NameAndId.a(asJsonObject = element.getAsJsonObject())) != null && (jsonElement = asJsonObject.get("expiresOn")) != null) {
            String asString = jsonElement.getAsString();
            try {
                Date date = format.parse(asString);
                return Optional.of(new a(nameAndId, date));
            }
            catch (ParseException var7) {
                a.warn("Failed to parse date {}", (Object)asString, (Object)var7);
            }
        }
        return Optional.empty();
    }

    static class a {
        private final NameAndId a;
        final Date b;
        private volatile long c;

        a(NameAndId nameAndId, Date expirationDate) {
            this.a = nameAndId;
            this.b = expirationDate;
        }

        public NameAndId a() {
            return this.a;
        }

        public Date b() {
            return this.b;
        }

        public void a(long lastAccess) {
            this.c = lastAccess;
        }

        public long c() {
            return this.c;
        }
    }
}

