/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.JsonListEntry;

public abstract class ExpirableListEntry<T>
extends JsonListEntry<T> {
    public static final SimpleDateFormat a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    public static final String b = "forever";
    protected final Date c;
    protected final String d;
    @Nullable
    protected final Date e;
    @Nullable
    protected final String f;

    public ExpirableListEntry(@Nullable T user, @Nullable Date created, @Nullable String source, @Nullable Date expires, @Nullable String reason) {
        super(user);
        this.c = created == null ? new Date() : created;
        this.d = source == null ? "(Unknown)" : source;
        this.e = expires;
        this.f = reason;
    }

    protected ExpirableListEntry(@Nullable T user, JsonObject entryData) {
        super(ExpirableListEntry.checkExpiry(user, entryData));
        Date date1;
        Date date;
        try {
            date = entryData.has("created") ? a.parse(entryData.get("created").getAsString()) : new Date();
        }
        catch (ParseException var7) {
            date = new Date();
        }
        this.c = date;
        this.d = entryData.has("source") ? entryData.get("source").getAsString() : "(Unknown)";
        try {
            date1 = entryData.has("expires") ? a.parse(entryData.get("expires").getAsString()) : null;
        }
        catch (ParseException var6) {
            date1 = null;
        }
        this.e = date1;
        this.f = entryData.has("reason") ? entryData.get("reason").getAsString() : null;
    }

    public Date a() {
        return this.c;
    }

    public String b() {
        return this.d;
    }

    @Nullable
    public Date c() {
        return this.e;
    }

    @Nullable
    public String d() {
        return this.f;
    }

    public IChatBaseComponent e() {
        String reason = this.d();
        return reason == null ? IChatBaseComponent.c("multiplayer.disconnect.banned.reason.default") : IChatBaseComponent.b(reason);
    }

    public abstract IChatBaseComponent f();

    @Override
    boolean g() {
        return this.e != null && this.e.before(new Date());
    }

    @Override
    protected void a(JsonObject data) {
        data.addProperty("created", a.format(this.c));
        data.addProperty("source", this.d);
        data.addProperty("expires", this.e == null ? b : a.format(this.e));
        data.addProperty("reason", this.f);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            ExpirableListEntry banListEntry = (ExpirableListEntry)other;
            return Objects.equals(this.d, banListEntry.d) && Objects.equals(this.e, banListEntry.e) && Objects.equals(this.f, banListEntry.f) && Objects.equals(this.h(), banListEntry.h());
        }
        return false;
    }

    private static <T> T checkExpiry(T object, JsonObject jsonobject) {
        Date expires = null;
        try {
            expires = jsonobject.has("expires") ? a.parse(jsonobject.get("expires").getAsString()) : null;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (expires == null || expires.after(new Date())) {
            return object;
        }
        return null;
    }
}

