/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.ExpirableListEntry;
import net.minecraft.server.players.NameAndId;

public class GameProfileBanEntry
extends ExpirableListEntry<NameAndId> {
    private static final IChatBaseComponent g = IChatBaseComponent.c("commands.banlist.entry.unknown");

    public GameProfileBanEntry(@Nullable NameAndId user) {
        this(user, (Date)null, (String)null, (Date)null, (String)null);
    }

    public GameProfileBanEntry(@Nullable NameAndId user, @Nullable Date created, @Nullable String source, @Nullable Date expires, @Nullable String reason) {
        super(user, created, source, expires, reason);
    }

    public GameProfileBanEntry(JsonObject entryData) {
        super(GameProfileBanEntry.parseNameAndId(entryData), entryData);
    }

    @Override
    protected void a(JsonObject data) {
        if (this.h() != null) {
            ((NameAndId)this.h()).b(data);
            super.a(data);
        }
    }

    @Override
    public IChatBaseComponent f() {
        NameAndId nameAndId = (NameAndId)this.h();
        return nameAndId != null ? IChatBaseComponent.b(nameAndId.b()) : g;
    }

    @Nullable
    private static NameAndId parseNameAndId(JsonObject json) {
        UUID uuid = null;
        String name = null;
        if (json.has("uuid")) {
            String asString = json.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(asString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (json.has("name")) {
            name = json.get("name").getAsString();
        }
        if (uuid != null || name != null) {
            return new NameAndId(uuid, name);
        }
        return null;
    }
}

