/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

public abstract class JsonList<K, V extends JsonListEntry<K>> {
    private static final Logger b = LogUtils.getLogger();
    private static final Gson c = new GsonBuilder().setPrettyPrinting().create();
    private final File d;
    private final Map<String, V> e = Maps.newConcurrentMap();
    protected final NotificationService a;

    public JsonList(File file, NotificationService notificationService) {
        this.d = file;
        this.a = notificationService;
    }

    public File c() {
        return this.d;
    }

    public boolean a(V entry) {
        String keyForUser = this.b(((JsonListEntry)entry).h());
        JsonListEntry storedUserEntry = (JsonListEntry)this.e.get(keyForUser);
        if (entry.equals(storedUserEntry)) {
            return false;
        }
        this.e.put(keyForUser, entry);
        try {
            this.f();
        }
        catch (IOException var5) {
            b.warn("Could not save the list after adding a user.", (Throwable)var5);
        }
        return true;
    }

    @Nullable
    public V c(K user) {
        return (V)this.e.computeIfPresent(this.b(user), (key, value) -> value.g() ? null : value);
    }

    public boolean a(K user) {
        JsonListEntry storedUserEntry = (JsonListEntry)this.e.remove(this.b(user));
        if (storedUserEntry == null) {
            return false;
        }
        try {
            this.f();
        }
        catch (IOException var4) {
            b.warn("Could not save the list after removing a user.", (Throwable)var4);
        }
        return true;
    }

    public boolean b(JsonListEntry<K> entry) {
        return this.a(Objects.requireNonNull(entry.h()));
    }

    public void a() {
        this.e.clear();
        try {
            this.f();
        }
        catch (IOException var2) {
            b.warn("Could not save the list after removing a user.", (Throwable)var2);
        }
    }

    public String[] b() {
        return this.e.keySet().toArray(new String[0]);
    }

    public boolean d() {
        return this.e.isEmpty();
    }

    protected String b(K user) {
        return user.toString();
    }

    protected boolean d(K entry) {
        this.h();
        return this.e.containsKey(this.b(entry));
    }

    private void h() {
        this.e.values().removeIf(JsonListEntry::g);
    }

    protected abstract JsonListEntry<K> a(JsonObject var1);

    public Collection<V> e() {
        return this.e.values();
    }

    public void f() throws IOException {
        this.h();
        JsonArray jsonArray = new JsonArray();
        this.e.values().stream().map(storedEntry -> SystemUtils.a(new JsonObject(), storedEntry::a)).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        try (BufferedWriter writer = Files.newWriter((File)this.d, (Charset)StandardCharsets.UTF_8);){
            c.toJson((JsonElement)jsonArray, c.newJsonWriter((Writer)writer));
        }
    }

    public void g() throws IOException {
        if (this.d.exists()) {
            try (BufferedReader reader = Files.newReader((File)this.d, (Charset)StandardCharsets.UTF_8);){
                this.e.clear();
                JsonArray jsonArray = (JsonArray)c.fromJson((Reader)reader, JsonArray.class);
                if (jsonArray == null) {
                    return;
                }
                for (JsonElement jsonElement : jsonArray) {
                    JsonObject jsonObject = ChatDeserializer.m(jsonElement, "entry");
                    JsonListEntry<K> storedUserEntry = this.a(jsonObject);
                    if (storedUserEntry.h() == null) continue;
                    this.e.put(this.b(storedUserEntry.h()), storedUserEntry);
                }
            }
            catch (JsonParseException | NullPointerException ex) {
                File backup = new File(String.valueOf(this.d) + ".backup");
                b.warn("Unable to read file {}, backing it up to {} and creating new copy.", new Object[]{this.d, backup, ex});
                this.d.renameTo(backup);
                this.d.delete();
            }
        }
    }
}

