/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.console.TerminalConsoleCommandSender;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.connection.DisconnectionReason;
import io.papermc.paper.event.player.PlayerServerFullCheckEvent;
import io.papermc.paper.util.MCUtil;
import java.io.File;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.jetbrains.annotations.NotNull;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.task.BossBarTask;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class PlayerList {
    public static final File a = new File("banned-players.json");
    public static final File b = new File("banned-ips.json");
    public static final File c = new File("ops.json");
    public static final File d = new File("whitelist.json");
    public static final IChatBaseComponent e = IChatBaseComponent.c("chat.filtered_full");
    public static final IChatBaseComponent f = IChatBaseComponent.c("multiplayer.disconnect.duplicate_login");
    private static final Logger g = LogUtils.getLogger();
    private static final int h = 600;
    private static final SimpleDateFormat i = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer j;
    public final List<EntityPlayer> k = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> l = Maps.newHashMap();
    private final GameProfileBanList m;
    private final IpBanList n;
    private final OpList o;
    private final WhiteList p;
    public final WorldNBTStorage s;
    private final LayeredRegistryAccess<RegistryLayer> t;
    private int u;
    private int v;
    private boolean w;
    private int x;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();
    @Nullable
    public String collideRuleTeamName;

    public PlayerList(MinecraftServer server, LayeredRegistryAccess<RegistryLayer> registries, WorldNBTStorage playerIo, NotificationService notificationService) {
        this.cserver = server.server = new CraftServer((DedicatedServer)server, this);
        server.console = new TerminalConsoleCommandSender();
        this.j = server;
        this.t = registries;
        this.s = playerIo;
        this.p = new WhiteList(d, notificationService);
        this.o = new OpList(c, notificationService);
        this.m = new GameProfileBanList(a, notificationService);
        this.n = new IpBanList(b, notificationService);
    }

    public abstract void loadAndSaveFiles();

    public void a(NetworkManager connection, EntityPlayer player, CommonListenerCookie cookie) {
        player.isRealPlayer = true;
        player.loginTime = System.currentTimeMillis();
        NameAndId nameAndId = player.gA();
        UserNameToIdResolver userNameToIdResolver = this.j.av().f();
        Optional<NameAndId> optional = userNameToIdResolver.a(nameAndId.a());
        String string = optional.map(NameAndId::b).orElse(nameAndId.b());
        if (player.lastKnownName != null) {
            string = player.lastKnownName;
            player.lastKnownName = null;
        }
        userNameToIdResolver.a(nameAndId);
        WorldServer serverLevel = player.A();
        String loggableAddress = connection.a(this.j.br());
        WorldData levelData = serverLevel.F_();
        PlayerConnection serverGamePacketListenerImpl = new PlayerConnection(this.j, connection, player, cookie);
        connection.a(GameProtocols.b.a(RegistryFriendlyByteBuf.a(this.j.bg()), serverGamePacketListenerImpl), serverGamePacketListenerImpl);
        GameRules gameRules = serverLevel.S();
        boolean _boolean = gameRules.c(GameRules.F);
        boolean _boolean1 = gameRules.c(GameRules.r);
        boolean _boolean2 = gameRules.c(GameRules.y);
        serverGamePacketListenerImpl.b(new PacketPlayOutLogin(player.az(), levelData.k(), this.j.P(), this.n(), serverLevel.spigotConfig.viewDistance, serverLevel.spigotConfig.simulationDistance, _boolean1, !_boolean, _boolean2, player.b(serverLevel), this.j.aC()));
        player.getBukkitEntity().sendSupportedChannels();
        serverGamePacketListenerImpl.b(new PacketPlayOutServerDifficulty(levelData.p(), levelData.q()));
        serverGamePacketListenerImpl.b(new PacketPlayOutAbilities(player.gC()));
        serverGamePacketListenerImpl.b(new PacketPlayOutHeldItemSlot(player.gB().g()));
        CraftingManager recipeManager = this.j.aN();
        serverGamePacketListenerImpl.b(new PacketPlayOutRecipeUpdate(recipeManager.b(), recipeManager.c()));
        this.d(player);
        player.K().c();
        player.L().a(player);
        this.a(serverLevel.g(), player);
        this.j.ax();
        IChatMutableComponent mutableComponent = player.gz().name().equalsIgnoreCase(string) ? IChatBaseComponent.a("multiplayer.player.joined", player.S_()) : IChatBaseComponent.a("multiplayer.player.joined.renamed", player.S_(), string);
        mutableComponent.a(EnumChatFormat.o);
        IChatBaseComponent joinMessage = mutableComponent;
        serverGamePacketListenerImpl.a(player.dK(), player.dM(), player.dQ(), player.dX(), player.dZ());
        ServerPing status = this.j.aw();
        if (status != null && !cookie.d()) {
            player.a(status);
        }
        this.k.add(player);
        this.playersByName.put(player.cV().toLowerCase(Locale.ROOT), player);
        this.l.put(player.cT(), player);
        player.suppressTrackerForLogin = true;
        this.a(player, serverLevel);
        serverLevel.a(player);
        this.j.aR().a(player);
        player.c();
        CraftPlayer bukkitPlayer = player.getBukkitEntity();
        player.cl.transferTo(player.cl, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, PaperAdventure.asAdventure(mutableComponent));
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!player.g.c()) {
            return;
        }
        Component jm = playerJoinEvent.joinMessage();
        if (jm != null && !jm.equals((Object)Component.empty())) {
            joinMessage = PaperAdventure.asVanilla(jm);
            this.j.am().a(joinMessage, false);
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(List.of(player));
        ArrayList onlinePlayers = Lists.newArrayListWithExpectedSize((int)(this.k.size() - 1));
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            EntityPlayer entityplayer1 = this.k.get(i2);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                if (entityplayer1.getBukkitEntity().isListed(bukkitPlayer)) {
                    entityplayer1.g.b(packet);
                } else {
                    entityplayer1.g.b(ClientboundPlayerInfoUpdatePacket.createSinglePlayerInitializing(player, false));
                }
            }
            if (entityplayer1 == player || !bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            onlinePlayers.add(entityplayer1);
        }
        if (!onlinePlayers.isEmpty()) {
            player.g.b(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(onlinePlayers, player));
        }
        player.sentListPacket = true;
        player.suppressTrackerForLogin = false;
        player.A().n().a.a((Entity)player);
        this.a(player, serverLevel);
        if (player.A() == serverLevel && !serverLevel.C().contains(player)) {
            serverLevel.a(player);
            this.j.aR().a(player);
        }
        serverLevel = player.A();
        this.c(player);
        player.c();
        this.j.E().a(player);
        ScoreboardServer scoreboard = this.c().a(net.minecraft.world.level.World.h).g();
        ScoreboardTeam collideRuleTeam = scoreboard.b(this.collideRuleTeamName);
        if (this.collideRuleTeamName != null && collideRuleTeam != null && player.cD() == null) {
            ((Scoreboard)scoreboard).a(player.cV(), collideRuleTeam);
        }
        BossBarTask.addToAll(player);
        g.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{player.ap(), loggableAddress, player.az(), serverLevel.J.d(), player.dK(), player.dM(), player.dQ()});
        if (player.eV()) {
            Holder.c plains = serverLevel.L_().f(Registries.aN).b(Biomes.b);
            player.g.b(new ClientboundLevelChunkWithLightPacket(new ChunkEmpty((net.minecraft.world.level.World)serverLevel, player.dH(), plains), serverLevel.E_(), null, null, true));
        }
    }

    public void a(ScoreboardServer scoreboard, EntityPlayer player) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam playerTeam : scoreboard.f()) {
            player.g.b(PacketPlayOutScoreboardTeam.a(playerTeam, true));
        }
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            ScoreboardObjective displayObjective = scoreboard.a(displaySlot);
            if (displayObjective == null || set.contains(displayObjective)) continue;
            for (Packet<?> packet : scoreboard.d(displayObjective)) {
                player.g.b(packet);
            }
            set.add(displayObjective);
        }
    }

    private void broadcastWorldborder(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> dimension) {
        for (EntityPlayer serverPlayer : this.k) {
            if (serverPlayer.A().al() != dimension || serverPlayer.getBukkitEntity().getWorldBorder() != null) continue;
            serverPlayer.g.b(packet);
        }
    }

    public void a(final WorldServer level) {
        level.u().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder border, double size) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderSizePacket(border), level.al());
            }

            @Override
            public void a(WorldBorder border, double oldSize, double newSize, long time) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderLerpSizePacket(border), level.al());
            }

            @Override
            public void a(WorldBorder border, double x2, double z2) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderCenterPacket(border), level.al());
            }

            @Override
            public void a(WorldBorder border, int warningTime) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderWarningDelayPacket(border), level.al());
            }

            @Override
            public void b(WorldBorder border, int warningBlocks) {
                PlayerList.this.broadcastWorldborder(new ClientboundSetBorderWarningDistancePacket(border), level.al());
            }

            @Override
            public void b(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(WorldBorder border, double safeZone) {
            }
        });
    }

    public Optional<NBTTagCompound> c(NameAndId nameAndId) {
        NBTTagCompound loadedPlayerTag = this.j.bf().v();
        if (this.j.a(nameAndId) && loadedPlayerTag != null) {
            g.debug("loading single player");
            return Optional.of(loadedPlayerTag);
        }
        return this.s.a(nameAndId);
    }

    protected void a(EntityPlayer player) {
        AdvancementDataPlayer playerAdvancements;
        if (!player.getBukkitEntity().isPersistent()) {
            return;
        }
        player.lastSave = MinecraftServer.currentTick;
        this.s.a(player);
        ServerStatisticManager serverStatsCounter = player.K();
        if (serverStatsCounter != null) {
            serverStatsCounter.a();
        }
        if ((playerAdvancements = player.U()) != null) {
            playerAdvancements.b();
        }
    }

    @Nullable
    public Component remove(EntityPlayer player) {
        return this.remove(player, (Component)Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? player.getBukkitEntity().displayName() : PaperAdventure.asAdventure(player.S_())}));
    }

    @Nullable
    public Component remove(EntityPlayer player, Component leaveMessage) {
        Object rootVehicle;
        BossBarTask.removeFromAll(player.getBukkitEntity());
        WorldServer serverLevel = player.A();
        player.a(StatisticList.j);
        if (player.cl != player.ck) {
            player.closeContainer(InventoryCloseEvent.Reason.DISCONNECT);
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)player.getBukkitEntity(), leaveMessage, player.quitReason);
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        player.getBukkitEntity().disconnect();
        if (this.j.bO()) {
            player.h();
        }
        if (this.collideRuleTeamName != null) {
            ScoreboardServer scoreBoard = this.j.a(net.minecraft.world.level.World.h).g();
            ScoreboardTeam team = scoreBoard.e(this.collideRuleTeamName);
            if (player.cD() == team && team != null) {
                ((Scoreboard)scoreBoard).b(player.cV(), team);
            }
        }
        if (!player.cl.g().f()) {
            ItemStack carried = player.cl.g();
            player.cl.a(ItemStack.l);
            player.a(carried, false);
        }
        this.a(player);
        if (player.cl() && ((Entity)(rootVehicle = player.dp())).do()) {
            g.debug("Removing player mount");
            player.cb();
            ((Entity)rootVehicle).dl().forEach(entity -> {
                EntityVillagerAbstract villager;
                EntityHuman human;
                if (entity instanceof EntityVillagerAbstract && (human = (villager = (EntityVillagerAbstract)entity).gI()) != null) {
                    villager.g((EntityHuman)null);
                }
                entity.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT);
            });
        }
        player.av();
        for (EntityEnderPearl thrownEnderpearl : player.aj()) {
            if (thrownEnderpearl.an().paperConfig().misc.legacyEnderPearlBehavior) continue;
            thrownEnderpearl.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT);
        }
        serverLevel.a(player, Entity.RemovalReason.d);
        player.retireScheduler();
        player.U().a();
        this.k.remove(player);
        this.playersByName.remove(player.cV().toLowerCase(Locale.ROOT));
        this.j.aR().b(player);
        UUID uuid = player.cT();
        EntityPlayer serverPlayer = this.l.get(uuid);
        if (serverPlayer == player) {
            this.l.remove(uuid);
            this.j.E().b(player);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(player.cT()));
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            EntityPlayer otherPlayer = this.k.get(i2);
            if (otherPlayer.getBukkitEntity().canSee(player.getBukkitEntity())) {
                otherPlayer.g.b(packet);
                continue;
            }
            otherPlayer.getBukkitEntity().onEntityRemove(player);
        }
        this.cserver.getScoreboardManager().removePlayer(player.getBukkitEntity());
        return playerQuitEvent.quitMessage();
    }

    public LoginResult canPlayerLogin(SocketAddress socketAddress, NameAndId nameAndId) {
        GameProfileBanEntry userBanListEntry;
        if (this.m.a(nameAndId) && (userBanListEntry = (GameProfileBanEntry)this.m.c(nameAndId)) != null) {
            IChatMutableComponent mutableComponent = IChatBaseComponent.a("multiplayer.disconnect.banned.reason", userBanListEntry.e());
            if (userBanListEntry.c() != null) {
                mutableComponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned.expiration", new Object[]{i.format(userBanListEntry.c())}));
            }
            return new LoginResult(mutableComponent, PlayerLoginEvent.Result.KICK_BANNED);
        }
        LoginResult whitelistEventResult = this.isWhiteListedLogin(nameAndId);
        if (whitelistEventResult.result == PlayerLoginEvent.Result.KICK_WHITELIST) {
            return whitelistEventResult;
        }
        if (this.n.a(socketAddress)) {
            IpBanEntry ipBanListEntry = this.n.b(socketAddress);
            IChatMutableComponent mutableComponent = IChatBaseComponent.a("multiplayer.disconnect.banned_ip.reason", ipBanListEntry.e());
            if (ipBanListEntry.c() != null) {
                mutableComponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned_ip.expiration", new Object[]{i.format(ipBanListEntry.c())}));
            }
            return new LoginResult(mutableComponent, PlayerLoginEvent.Result.KICK_BANNED);
        }
        return this.canBypassFullServerLogin(nameAndId, new LoginResult(IChatBaseComponent.c("multiplayer.disconnect.server_full"), PlayerLoginEvent.Result.KICK_FULL));
    }

    public boolean disconnectAllPlayersWithProfile(GameProfile profile) {
        UUID profileId = profile.id();
        Set set = Sets.newIdentityHashSet();
        for (EntityPlayer serverPlayer : this.k) {
            if (!serverPlayer.cT().equals(profileId) && (!GlobalConfiguration.get().proxies.isProxyOnlineMode() || !serverPlayer.gz().name().equalsIgnoreCase(profile.name()))) continue;
            set.add(serverPlayer);
        }
        EntityPlayer serverPlayer1 = this.l.get(profileId);
        if (serverPlayer1 != null) {
            set.add(serverPlayer1);
        }
        for (EntityPlayer serverPlayer2 : set) {
            serverPlayer2.g.disconnect(f, DisconnectionReason.DUPLICATE_LOGIN_MESSAGE);
        }
        return !set.isEmpty();
    }

    public EntityPlayer respawn(EntityPlayer player, boolean keepInventory, Entity.RemovalReason reason, PlayerRespawnEvent.RespawnReason respawnReason) {
        BlockPosition blockPos;
        IBlockData blockState;
        WorldData.a respawnData;
        WorldServer level1;
        EntityPlayer.RespawnResult result = player.findRespawnPositionAndUseSpawnBlock0(!keepInventory, TeleportTransition.a, respawnReason);
        if (result == null) {
            return player;
        }
        TeleportTransition teleportTransition = result.transition();
        WorldServer fromLevel = player.A();
        this.k.remove(player);
        this.playersByName.remove(player.cV().toLowerCase(Locale.ROOT));
        player.A().a(player, reason);
        WorldServer level = teleportTransition.b();
        EntityPlayer serverPlayer = player;
        serverPlayer.g = player.g;
        serverPlayer.a(player, keepInventory);
        serverPlayer.e(player.az());
        serverPlayer.a(player.as());
        for (String string : player.aA()) {
            serverPlayer.a(string);
        }
        if (!keepInventory) {
            player.reset();
        }
        serverPlayer.spawnIn(level);
        serverPlayer.ee();
        serverPlayer.h(false);
        Vec3D vec3 = teleportTransition.c();
        serverPlayer.b(vec3.g, vec3.h, vec3.i, teleportTransition.e(), teleportTransition.f());
        serverPlayer.g.l();
        level.n().b(TicketType.POST_TELEPORT, new ChunkCoordIntPair(MathHelper.a(vec3.a()) >> 4, MathHelper.a(vec3.c()) >> 4), 1);
        if (teleportTransition.g()) {
            serverPlayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
            serverPlayer.setRespawnPosition(null, false, PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN);
        }
        byte b2 = keepInventory ? (byte)1 : 0;
        WorldServer serverLevel = serverPlayer.A();
        WorldData levelData = serverLevel.F_();
        serverPlayer.g.b(new PacketPlayOutRespawn(serverPlayer.b(serverLevel), b2));
        serverPlayer.g.internalTeleport(serverPlayer.dK(), serverPlayer.dM(), serverPlayer.dQ(), serverPlayer.dX(), serverPlayer.dZ());
        serverPlayer.g.b(new PacketPlayOutSpawnPosition(level.A()));
        serverPlayer.g.b(new PacketPlayOutServerDifficulty(levelData.p(), levelData.q()));
        serverPlayer.g.b(new PacketPlayOutExperience(serverPlayer.ct, serverPlayer.cs, serverPlayer.cr));
        this.c(serverPlayer);
        this.a(serverPlayer, level);
        this.d(serverPlayer);
        level.b(serverPlayer);
        this.k.add(serverPlayer);
        this.playersByName.put(serverPlayer.cV().toLowerCase(Locale.ROOT), serverPlayer);
        this.l.put(serverPlayer.cT(), serverPlayer);
        serverPlayer.c();
        serverPlayer.x(serverPlayer.eU());
        this.e(player);
        player.z();
        EntityPlayer.RespawnConfig respawnConfig = serverPlayer.V();
        if (!keepInventory && respawnConfig != null && (level1 = this.j.a((respawnData = respawnConfig.a()).a())) != null && (blockState = level1.a_(blockPos = respawnData.b())).a(Blocks.ql)) {
            serverPlayer.g.b(new PacketPlayOutNamedSoundEffect(SoundEffects.xq, SoundCategory.e, blockPos.u(), blockPos.v(), blockPos.w(), 1.0f, 1.0f, level.I_().g()));
        }
        if (serverPlayer.g.isDisconnected()) {
            this.a(serverPlayer);
        }
        if (fromLevel != level) {
            new PlayerChangedWorldEvent((Player)serverPlayer.getBukkitEntity(), (World)fromLevel.getWorld()).callEvent();
            serverPlayer.h(level);
        }
        new PlayerPostRespawnEvent((Player)serverPlayer.getBukkitEntity(), CraftLocation.toBukkit(teleportTransition.c(), (net.minecraft.world.level.World)level, teleportTransition.e(), teleportTransition.f()), result.isBedSpawn(), result.isAnchorSpawn(), teleportTransition.g(), respawnReason).callEvent();
        return serverPlayer;
    }

    public void c(EntityPlayer player) {
        this.a((EntityLiving)player, player.g);
    }

    public void a(EntityLiving entity, PlayerConnection connection) {
        this.sendActiveEffects(entity, connection::b);
    }

    public void sendActiveEffects(EntityLiving entity, Consumer<Packet<? super PacketListenerPlayOut>> packetConsumer) {
        for (MobEffect mobEffectInstance : entity.eR()) {
            packetConsumer.accept(new PacketPlayOutEntityEffect(entity.az(), mobEffectInstance, false));
        }
    }

    public void d(EntityPlayer player) {
        this.sendPlayerPermissionLevel(player, true);
    }

    public void sendPlayerPermissionLevel(EntityPlayer player, boolean recalculatePermissions) {
        int profilePermissions = this.j.b(player.gA());
        this.sendPlayerPermissionLevel(player, profilePermissions, recalculatePermissions);
    }

    public void d() {
        if (++this.x > 600) {
            for (int i2 = 0; i2 < this.k.size(); ++i2) {
                EntityPlayer target = this.k.get(i2);
                target.g.b(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.e), Collections2.filter(this.k, t2 -> target.getBukkitEntity().canSee(t2.getBukkitEntity()))));
            }
            this.x = 0;
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        for (EntityPlayer entityplayer : this.k) {
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            entityplayer.g.b(packet);
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        for (int i2 = 0; i2 < world.C().size(); ++i2) {
            ((EntityPlayer)world.C().get((int)i2)).g.b(packet);
        }
    }

    public void a(Packet<?> packet) {
        for (EntityPlayer serverPlayer : this.k) {
            serverPlayer.g.b(packet);
        }
    }

    public void broadcastMiniMessage(@Nullable String message, boolean overlay) {
        if (message != null && !message.isEmpty()) {
            this.broadcastMessage(MiniMessage.miniMessage().deserialize((Object)message), overlay);
        }
    }

    public void broadcastMessage(@Nullable Component message, boolean overlay) {
        if (message != null) {
            this.a(PaperAdventure.asVanilla(message), overlay);
        }
    }

    public void a(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> dimension) {
        for (EntityPlayer serverPlayer : this.k) {
            if (serverPlayer.A().al() != dimension) continue;
            serverPlayer.g.b(packet);
        }
    }

    public void a(EntityHuman player, IChatBaseComponent message) {
        ScoreboardTeam team = player.cD();
        if (team != null) {
            for (String string : ((ScoreboardTeamBase)team).h()) {
                EntityPlayer playerByName = this.a(string);
                if (playerByName == null || playerByName == player) continue;
                playerByName.a(message);
            }
        }
    }

    public void b(EntityHuman player, IChatBaseComponent message) {
        ScoreboardTeam team = player.cD();
        if (team == null) {
            this.a(message, false);
        } else {
            for (int i2 = 0; i2 < this.k.size(); ++i2) {
                EntityPlayer serverPlayer = this.k.get(i2);
                if (serverPlayer.cD() == team) continue;
                serverPlayer.a(message);
            }
        }
    }

    public String[] e() {
        String[] strings = new String[this.k.size()];
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            strings[i2] = this.k.get(i2).gz().name();
        }
        return strings;
    }

    public GameProfileBanList f() {
        return this.m;
    }

    public IpBanList g() {
        return this.n;
    }

    public void d(NameAndId nameAndId) {
        this.a(nameAndId, Optional.empty(), Optional.empty());
    }

    public void a(NameAndId nameAndId, Optional<Integer> level, Optional<Boolean> bypassesPlayerLimit) {
        this.o.a(new OpListEntry(nameAndId, level.orElse(this.j.k()), bypassesPlayerLimit.orElse(this.o.b(nameAndId))));
        EntityPlayer player = this.b(nameAndId.a());
        if (player != null) {
            this.d(player);
        }
    }

    public void e(NameAndId nameAndId) {
        EntityPlayer player;
        if (this.o.a(nameAndId) && (player = this.b(nameAndId.a())) != null) {
            this.d(player);
        }
    }

    private void a(EntityPlayer player, int permLevel) {
        this.sendPlayerPermissionLevel(player, permLevel, true);
    }

    public void sendPlayerPermissionLevel(EntityPlayer player, int permLevel, boolean recalculatePermissions) {
        if (player.g != null) {
            byte b2 = permLevel <= 0 ? (byte)24 : (permLevel >= 4 ? (byte)28 : (byte)((byte)(24 + permLevel)));
            if (b2 < 28 && player.getBukkitEntity().hasPermission("purpur.debug.f3n")) {
                b2 = 28;
            }
            player.g.b(new PacketPlayOutEntityStatus(player, b2));
        }
        if (recalculatePermissions) {
            player.getBukkitEntity().recalculatePermissions();
            this.j.aJ().a(player);
        }
        if (PurpurConfig.enderChestSixRows && PurpurConfig.enderChestPermissionRows) {
            CraftPlayer bukkit = player.getBukkitEntity();
            if (bukkit.hasPermission("purpur.enderchest.rows.six")) {
                player.sixRowEnderchestSlotCount = 54;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.five")) {
                player.sixRowEnderchestSlotCount = 45;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.four")) {
                player.sixRowEnderchestSlotCount = 36;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.three")) {
                player.sixRowEnderchestSlotCount = 27;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.two")) {
                player.sixRowEnderchestSlotCount = 18;
            } else if (bukkit.hasPermission("purpur.enderchest.rows.one")) {
                player.sixRowEnderchestSlotCount = 9;
            }
        } else {
            player.sixRowEnderchestSlotCount = -1;
        }
    }

    public LoginResult canBypassFullServerLogin(NameAndId nameAndId, LoginResult currentResult) {
        boolean shouldKick = this.k.size() >= this.n() && !this.b(nameAndId);
        PlayerServerFullCheckEvent fullCheckEvent = new PlayerServerFullCheckEvent((PlayerProfile)new CraftPlayerProfile(nameAndId), PaperAdventure.asAdventure(currentResult.message), shouldKick);
        fullCheckEvent.callEvent();
        if (fullCheckEvent.isAllowed()) {
            return LoginResult.ALLOW;
        }
        return new LoginResult(PaperAdventure.asVanilla(fullCheckEvent.kickMessage()), currentResult.result);
    }

    public LoginResult isWhiteListedLogin(NameAndId nameAndId) {
        boolean isOp = this.o.d(nameAndId);
        boolean isWhitelisted = !this.o() || isOp || this.p.d(nameAndId);
        TextComponent configuredMessage = LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.whitelistMessage);
        ProfileWhitelistVerifyEvent event = new ProfileWhitelistVerifyEvent((PlayerProfile)new CraftPlayerProfile(nameAndId), this.o(), isWhitelisted, isOp, (Component)configuredMessage);
        event.callEvent();
        if (!event.isWhitelisted()) {
            return new LoginResult(PaperAdventure.asVanilla((Component)(event.kickMessage() == null ? configuredMessage : event.kickMessage())), PlayerLoginEvent.Result.KICK_WHITELIST);
        }
        return LoginResult.ALLOW;
    }

    @DoNotUse
    public boolean a(NameAndId nameAndId) {
        return !this.o() || this.o.d(nameAndId) || this.p.d(nameAndId);
    }

    public boolean f(NameAndId nameAndId) {
        return this.o.d(nameAndId) || this.j.a(nameAndId) && this.j.bf().l() || this.w;
    }

    @Nullable
    public EntityPlayer a(String username) {
        return this.playersByName.get(username.toLowerCase(Locale.ROOT));
    }

    public void a(@Nullable EntityHuman except, double x2, double y2, double z2, double radius, ResourceKey<net.minecraft.world.level.World> dimension, Packet<?> packet) {
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            double d2;
            double d1;
            double d3;
            EntityPlayer serverPlayer = this.k.get(i2);
            if (except != null && !serverPlayer.getBukkitEntity().canSee(except.getBukkitEntity()) || serverPlayer == except || serverPlayer.A().al() != dimension || !((d3 = x2 - serverPlayer.dK()) * d3 + (d1 = y2 - serverPlayer.dM()) * d1 + (d2 = z2 - serverPlayer.dQ()) * d2 < radius * radius)) continue;
            serverPlayer.g.b(packet);
        }
    }

    public void h() {
        this.saveAll(-1);
    }

    public void saveAll(int interval) {
        MCUtil.ensureMain("Save Players", () -> {
            int numSaved = 0;
            long now = MinecraftServer.currentTick;
            for (int i2 = 0; i2 < this.k.size(); ++i2) {
                EntityPlayer player = this.k.get(i2);
                if (interval != -1 && now - player.lastSave < (long)interval) continue;
                this.a(player);
                if (interval != -1 && ++numSaved >= GlobalConfiguration.get().playerAutoSave.maxPerTick()) break;
            }
            return null;
        });
    }

    public WhiteList i() {
        return this.p;
    }

    public String[] j() {
        return this.p.b();
    }

    public OpList k() {
        return this.o;
    }

    public String[] l() {
        return this.o.b();
    }

    public void a() {
    }

    public void a(EntityPlayer player, WorldServer level) {
        WorldBorder worldBorder = level.u();
        player.g.b(new ClientboundInitializeBorderPacket(worldBorder));
        player.g.b(new PacketPlayOutUpdateTime(level.ag(), level.ah(), level.S().c(GameRules.m)));
        player.g.b(new PacketPlayOutSpawnPosition(level.A()));
        player.g.b(new PacketPlayOutViewDistance(level.spigotConfig.viewDistance));
        player.g.b(new ClientboundSetSimulationDistancePacket(level.spigotConfig.simulationDistance));
        if (level.aj()) {
            player.setPlayerWeather(WeatherType.DOWNFALL, false);
            player.updateWeather(-level.w, level.w, -level.y, level.y);
        }
        player.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.o, 0.0f));
        this.j.aV().a(player);
    }

    public void e(EntityPlayer player) {
        player.ck.b();
        Collection<AttributeModifiable> syncableAttributes = player.fp().c();
        player.getBukkitEntity().injectScaledMaxHealth(syncableAttributes, true);
        player.g.b(new PacketPlayOutUpdateAttributes(player.az(), syncableAttributes));
        player.refreshEntityData(player);
        player.g.b(new PacketPlayOutHeldItemSlot(player.gB().g()));
        int i2 = player.A().S().c(GameRules.r) ? 22 : 23;
        player.g.b(new PacketPlayOutEntityStatus(player, (byte)i2));
        float immediateRespawn = player.A().S().c(GameRules.F) ? 1.0f : 0.0f;
        player.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.m, immediateRespawn));
    }

    public int m() {
        return this.k.size();
    }

    public int n() {
        return this.j.t();
    }

    public boolean o() {
        return this.j.aT();
    }

    public List<EntityPlayer> b(String address) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer serverPlayer : this.k) {
            if (!serverPlayer.D().equals(address)) continue;
            list.add(serverPlayer);
        }
        return list;
    }

    public int p() {
        return this.u;
    }

    public int q() {
        return this.v;
    }

    public MinecraftServer c() {
        return this.j;
    }

    @Nullable
    public NBTTagCompound r() {
        return null;
    }

    public void a(boolean allowCommandsForAllPlayers) {
        this.w = allowCommandsForAllPlayers;
    }

    public void s() {
        this.removeAll(false);
    }

    public void removeAll(boolean isRestarting) {
        ScoreboardServer scoreboard;
        ScoreboardTeam team;
        for (EntityPlayer player : this.k) {
            if (isRestarting) {
                player.g.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.restartMessage), PlayerKickEvent.Cause.UNKNOWN);
                continue;
            }
            player.g.disconnect(Objects.requireNonNullElseGet(this.j.server.shutdownMessage(), Component::empty));
        }
        if (this.collideRuleTeamName != null && (team = (scoreboard = this.c().a(net.minecraft.world.level.World.h).g()).e(this.collideRuleTeamName)) != null) {
            scoreboard.d(team);
        }
    }

    public void a(IChatBaseComponent message, boolean overlay) {
        this.a(message, (EntityPlayer serverPlayer) -> message, overlay);
    }

    public void a(IChatBaseComponent serverMessage, Function<EntityPlayer, IChatBaseComponent> playerMessageFactory, boolean overlay) {
        this.j.a(serverMessage);
        for (EntityPlayer serverPlayer : this.k) {
            IChatBaseComponent component = playerMessageFactory.apply(serverPlayer);
            if (component == null) continue;
            serverPlayer.b(component, overlay);
        }
    }

    public void a(PlayerChatMessage message, CommandListenerWrapper sender, ChatMessageType.a boundChatType) {
        this.a(message, sender::a, sender.i(), boundChatType);
    }

    public void a(PlayerChatMessage message, EntityPlayer sender, ChatMessageType.a boundChatType) {
        this.broadcastChatMessage(message, sender, boundChatType, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, EntityPlayer sender, ChatMessageType.a boundChatType, @Nullable Function<Audience, IChatBaseComponent> unsignedFunction) {
        this.broadcastChatMessage(message, sender::c, sender, boundChatType, unsignedFunction);
    }

    private void a(PlayerChatMessage message, Predicate<EntityPlayer> shouldFilterMessageTo, @Nullable EntityPlayer sender, ChatMessageType.a boundChatType) {
        this.broadcastChatMessage(message, shouldFilterMessageTo, sender, boundChatType, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, Predicate<EntityPlayer> shouldFilterMessageTo, @Nullable EntityPlayer sender, ChatMessageType.a boundChatType, @Nullable Function<Audience, IChatBaseComponent> unsignedFunction) {
        boolean flag = this.a(message);
        this.j.a(unsignedFunction == null ? message.d() : unsignedFunction.apply((Audience)this.j.console), boundChatType, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.a(message);
        boolean flag1 = false;
        ClientboundDisguisedChatPacket disguised = sender != null && unsignedFunction == null ? new ClientboundDisguisedChatPacket(outgoingChatMessage.a(), boundChatType) : null;
        for (EntityPlayer serverPlayer : this.k) {
            boolean flag2 = shouldFilterMessageTo.test(serverPlayer);
            if (sender != null && !serverPlayer.getBukkitEntity().canSee(sender.getBukkitEntity())) {
                serverPlayer.g.b(unsignedFunction != null ? new ClientboundDisguisedChatPacket(unsignedFunction.apply((Audience)serverPlayer.getBukkitEntity()), boundChatType) : disguised);
                continue;
            }
            serverPlayer.sendChatMessage(outgoingChatMessage, flag2, boundChatType, unsignedFunction == null ? null : unsignedFunction.apply((Audience)serverPlayer.getBukkitEntity()));
            flag1 |= flag2 && message.j();
        }
        if (flag1 && sender != null) {
            sender.a(e);
        }
    }

    public boolean a(PlayerChatMessage message) {
        return message.i() && !message.a(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer player) {
        ServerStatisticManager serverstatisticmanager = player.K();
        return serverstatisticmanager == null ? this.getPlayerStats(player.cT(), player.gz().name()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverStatsCounter;
        EntityPlayer player = this.b(uuid);
        ServerStatisticManager serverStatisticManager = serverStatsCounter = player == null ? null : player.K();
        if (serverStatsCounter == null) {
            File file2;
            Path path;
            File file = this.j.a(SavedFile.b).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtils.a(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtils.b(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverStatsCounter = new ServerStatisticManager(this.j, file1);
        }
        return serverStatsCounter;
    }

    public AdvancementDataPlayer f(EntityPlayer player) {
        UUID uuid = player.cT();
        AdvancementDataPlayer playerAdvancements = player.U();
        if (playerAdvancements == null) {
            Path path = this.j.a(SavedFile.a).resolve(String.valueOf(uuid) + ".json");
            playerAdvancements = new AdvancementDataPlayer(this.j.aE(), this, this.j.aF(), path, player);
        }
        playerAdvancements.a(player);
        return playerAdvancements;
    }

    public void a(int viewDistance) {
        this.u = viewDistance;
        for (WorldServer serverLevel : this.j.Q()) {
            if (serverLevel == null) continue;
            serverLevel.n().a(viewDistance);
        }
    }

    public void b(int simulationDistance) {
        this.v = simulationDistance;
        for (WorldServer serverLevel : this.j.Q()) {
            if (serverLevel == null) continue;
            serverLevel.n().b(simulationDistance);
        }
    }

    public List<EntityPlayer> t() {
        return this.k;
    }

    @Nullable
    public EntityPlayer b(UUID playerUUID) {
        return this.l.get(playerUUID);
    }

    @Nullable
    public EntityPlayer c(String name) {
        for (EntityPlayer serverPlayer : this.k) {
            if (!serverPlayer.gz().name().equalsIgnoreCase(name)) continue;
            return serverPlayer;
        }
        return null;
    }

    public boolean b(NameAndId nameAndId) {
        return false;
    }

    public void u() {
        this.reloadAdvancementData();
        this.reloadTagData();
        this.reloadRecipes();
    }

    public void reloadAdvancementData() {
        for (EntityPlayer player : this.k) {
            player.U().a(this.j.aF());
            player.U().a(player, false);
        }
    }

    public void reloadTagData() {
        this.a(new ClientboundUpdateTagsPacket(TagNetworkSerialization.a(this.t)));
    }

    public void reloadRecipes() {
        CraftingManager recipeManager = this.j.aN();
        PacketPlayOutRecipeUpdate clientboundUpdateRecipesPacket = new PacketPlayOutRecipeUpdate(recipeManager.b(), recipeManager.c());
        for (EntityPlayer serverPlayer : this.k) {
            serverPlayer.g.b(clientboundUpdateRecipesPacket);
            serverPlayer.L().a(serverPlayer);
        }
    }

    public boolean v() {
        return this.w;
    }

    public record LoginResult(@Nullable IChatBaseComponent message, @NotNull PlayerLoginEvent.Result result) {
        public static LoginResult ALLOW = new LoginResult(null, PlayerLoginEvent.Result.ALLOWED);

        public boolean isAllowed() {
            return this == ALLOW;
        }
    }
}

