/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    public static final String b = "recipeBook";
    private static final Logger e = LogUtils.getLogger();
    private final a f;
    @VisibleForTesting
    public final Set<ResourceKey<IRecipe<?>>> c = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<IRecipe<?>>> d = Sets.newIdentityHashSet();

    public RecipeBookServer(a displayResolver) {
        this.f = displayResolver;
    }

    public void a(ResourceKey<IRecipe<?>> recipe) {
        this.c.add(recipe);
    }

    public boolean b(ResourceKey<IRecipe<?>> recipe) {
        return this.c.contains(recipe);
    }

    public void c(ResourceKey<IRecipe<?>> recipe) {
        this.c.remove(recipe);
        this.d.remove(recipe);
    }

    public void d(ResourceKey<IRecipe<?>> recipe) {
        this.d.remove(recipe);
    }

    private void e(ResourceKey<IRecipe<?>> recipe) {
        this.d.add(recipe);
    }

    public int a(Collection<RecipeHolder<?>> recipes, EntityPlayer player) {
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>();
        for (RecipeHolder<?> recipeHolder : recipes) {
            PlayerRecipeDiscoverEvent event;
            ResourceKey<IRecipe<?>> resourceKey = recipeHolder.a();
            if (this.c.contains(resourceKey) || recipeHolder.b().ar_() || (event = CraftEventFactory.callPlayerRecipeListUpdateEvent(player, recipeHolder)).isCancelled()) continue;
            this.a(resourceKey);
            this.e(resourceKey);
            this.f.displaysForRecipe(resourceKey, entry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)entry, event.shouldShowNotification(), true)));
            CriterionTriggers.g.a(player, recipeHolder);
        }
        if (!list.isEmpty() && player.g != null) {
            player.g.b(new ClientboundRecipeBookAddPacket(list, false));
        }
        return list.size();
    }

    public int b(Collection<RecipeHolder<?>> recipes, EntityPlayer player) {
        ArrayList list = Lists.newArrayList();
        for (RecipeHolder<?> recipeHolder : recipes) {
            ResourceKey<IRecipe<?>> resourceKey = recipeHolder.a();
            if (!this.c.contains(resourceKey)) continue;
            this.c(resourceKey);
            this.f.displaysForRecipe(resourceKey, entry -> list.add(entry.a()));
        }
        if (!list.isEmpty() && player.g != null) {
            player.g.b(new ClientboundRecipeBookRemovePacket(list));
        }
        return list.size();
    }

    private void a(List<ResourceKey<IRecipe<?>>> recipes, Consumer<ResourceKey<IRecipe<?>>> output, Predicate<ResourceKey<IRecipe<?>>> isRecognized) {
        for (ResourceKey<IRecipe<?>> resourceKey : recipes) {
            if (!isRecognized.test(resourceKey)) {
                if (PurpurConfig.loggerSuppressUnrecognizedRecipeErrors) continue;
                e.error("Tried to load unrecognized recipe: {} removed now.", resourceKey);
                continue;
            }
            output.accept(resourceKey);
        }
    }

    public void a(EntityPlayer player) {
        player.g.b(new ClientboundRecipeBookSettingsPacket(this.a().a()));
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>(this.c.size());
        for (ResourceKey<IRecipe<?>> resourceKey : this.c) {
            this.f.displaysForRecipe(resourceKey, entry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)entry, false, this.d.contains(resourceKey))));
        }
        player.g.b(new ClientboundRecipeBookAddPacket(list, true));
    }

    public void a(RecipeBookServer other) {
        this.a(other.b());
    }

    public b b() {
        return new b(this.a.a(), List.copyOf(this.c), List.copyOf(this.d));
    }

    private void a(b recipeBook) {
        this.c.clear();
        this.d.clear();
        this.a.a(recipeBook.b);
        this.c.addAll(recipeBook.c);
        this.d.addAll(recipeBook.d);
    }

    public void a(b recipeBook, Predicate<ResourceKey<IRecipe<?>>> predicate) {
        this.a.a(recipeBook.b);
        this.a(recipeBook.c, this.c::add, predicate);
        this.a(recipeBook.d, this.d::add, predicate);
    }

    @FunctionalInterface
    public static interface a {
        public void displaysForRecipe(ResourceKey<IRecipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }

    public static final class b
    extends Record {
        private final RecipeBookSettings b;
        private final List<ResourceKey<IRecipe<?>>> c;
        private final List<ResourceKey<IRecipe<?>>> d;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)RecipeBookSettings.b.forGetter(b::a), (App)IRecipe.b.listOf().fieldOf("recipes").forGetter(b::b), (App)IRecipe.b.listOf().fieldOf("toBeDisplayed").forGetter(b::c)).apply((Applicative)instance, b::new));

        public b(RecipeBookSettings settings, List<ResourceKey<IRecipe<?>>> known, List<ResourceKey<IRecipe<?>>> highlight) {
            this.b = settings;
            this.c = known;
            this.d = highlight;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "settings;known;highlight", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "settings;known;highlight", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "settings;known;highlight", "b", "c", "d"}, this, o2);
        }

        public RecipeBookSettings a() {
            return this.b;
        }

        public List<ResourceKey<IRecipe<?>>> b() {
            return this.c;
        }

        public List<ResourceKey<IRecipe<?>>> c() {
            return this.d;
        }
    }
}

