/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutStatistic;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatisticManager
extends StatisticManager {
    private static final Logger b = LogUtils.getLogger();
    private static final Codec<Map<Statistic<?>, Integer>> c = Codec.dispatchedMap(BuiltInRegistries.w.q(), SystemUtils.b(ServerStatisticManager::a)).xmap(map -> {
        HashMap map1 = new HashMap();
        map.forEach((statType, map2) -> map1.putAll(map2));
        return map1;
    }, map -> map.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Statistic)entry.getKey()).a(), SystemUtils.a())));
    private final MinecraftServer d;
    private final File e;
    private final Set<Statistic<?>> f = Sets.newHashSet();

    private static <T> Codec<Map<Statistic<?>, Integer>> a(StatisticWrapper<T> type) {
        Codec<T> codec = type.b().q();
        Codec codec1 = codec.flatComapMap(type::b, stat -> stat.a() == type ? DataResult.success(stat.b()) : DataResult.error(() -> "Expected type " + String.valueOf(type) + ", but got " + String.valueOf(stat.a())));
        return Codec.unboundedMap((Codec)codec1, (Codec)Codec.INT);
    }

    public ServerStatisticManager(MinecraftServer server, File file) {
        this.d = server;
        this.e = file;
        if (file.isFile()) {
            try {
                this.a(server.aE(), FileUtils.readFileToString((File)file));
            }
            catch (IOException var4) {
                b.error("Couldn't read statistics file {}", (Object)file, (Object)var4);
            }
            catch (JsonParseException var5) {
                b.error("Couldn't parse statistics file {}", (Object)file, (Object)var5);
            }
        }
        for (Map.Entry<MinecraftKey, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Statistic<MinecraftKey> wrapper = StatisticList.i.b(Objects.requireNonNull(BuiltInRegistries.l.a(entry.getKey())));
            this.a.put(wrapper, entry.getValue().intValue());
        }
    }

    public void a() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.e, (String)this.b());
        }
        catch (IOException var2) {
            b.error("Couldn't save stats", (Throwable)var2);
        }
    }

    @Override
    public void a(EntityHuman player, Statistic<?> stat, int value) {
        MinecraftKey key;
        Object obj;
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        if (stat.a() == StatisticList.i && (obj = stat.b()) instanceof MinecraftKey && SpigotConfig.forcedStats.get(key = (MinecraftKey)obj) != null) {
            return;
        }
        super.a(player, stat, value);
        this.f.add(stat);
    }

    private Set<Statistic<?>> d() {
        HashSet set = Sets.newHashSet(this.f);
        this.f.clear();
        return set;
    }

    public void a(DataFixer fixerUpper, String json) {
        try {
            JsonElement jsonElement = StrictJsonParser.a(json);
            if (jsonElement.isJsonNull()) {
                b.error("Unable to parse Stat data from {}", (Object)this.e);
                return;
            }
            Dynamic<JsonElement> dynamic = new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, jsonElement);
            dynamic = DataFixTypes.h.a(fixerUpper, dynamic, GameProfileSerializer.b(dynamic, 1343));
            this.a.putAll(c.parse(dynamic.get("stats").orElseEmptyMap()).resultOrPartial(string -> b.error("Failed to parse statistics for {}: {}", (Object)this.e, string)).orElse(Map.of()));
        }
        catch (JsonParseException var5) {
            b.error("Unable to parse Stat data from {}", (Object)this.e, (Object)var5);
        }
    }

    protected String b() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("stats", (JsonElement)c.encodeStart((DynamicOps)JsonOps.INSTANCE, this.a).getOrThrow());
        jsonObject.addProperty("DataVersion", (Number)SharedConstants.b().a().b());
        return jsonObject.toString();
    }

    public void c() {
        this.f.addAll((Collection<Statistic<?>>)this.a.keySet());
    }

    public void a(EntityPlayer player) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Statistic<?> stat : this.d()) {
            map.put(stat, this.a(stat));
        }
        player.g.b(new PacketPlayOutStatistic((Object2IntMap<Statistic<?>>)map));
    }
}

