/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;

public class ARGB {
    public static int a(int color) {
        return color >>> 24;
    }

    public static int b(int color) {
        return color >> 16 & 0xFF;
    }

    public static int c(int color) {
        return color >> 8 & 0xFF;
    }

    public static int d(int color) {
        return color & 0xFF;
    }

    public static int a(int alpha, int red, int green, int blue) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int a(int red, int green, int blue) {
        return ARGB.a(255, red, green, blue);
    }

    public static int a(Vec3D color) {
        return ARGB.a(ARGB.b((float)color.a()), ARGB.b((float)color.b()), ARGB.b((float)color.c()));
    }

    public static int a(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        return color2 == -1 ? color1 : ARGB.a(ARGB.a(color1) * ARGB.a(color2) / 255, ARGB.b(color1) * ARGB.b(color2) / 255, ARGB.c(color1) * ARGB.c(color2) / 255, ARGB.d(color1) * ARGB.d(color2) / 255);
    }

    public static int a(int color, float scale) {
        return ARGB.a(color, scale, scale, scale);
    }

    public static int a(int color, float redScale, float greenScale, float blueScale) {
        return ARGB.a(ARGB.a(color), Math.clamp((long)((int)((float)ARGB.b(color) * redScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.c(color) * greenScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.d(color) * blueScale)), 0, 255));
    }

    public static int b(int color, int scale) {
        return ARGB.a(ARGB.a(color), Math.clamp((long)ARGB.b(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.c(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.d(color) * (long)scale / 255L, 0, 255));
    }

    public static int e(int color) {
        int i2 = (int)((float)ARGB.b(color) * 0.3f + (float)ARGB.c(color) * 0.59f + (float)ARGB.d(color) * 0.11f);
        return ARGB.a(i2, i2, i2);
    }

    public static int a(float delta, int color1, int color2) {
        int i2 = MathHelper.a(delta, ARGB.a(color1), ARGB.a(color2));
        int i1 = MathHelper.a(delta, ARGB.b(color1), ARGB.b(color2));
        int i22 = MathHelper.a(delta, ARGB.c(color1), ARGB.c(color2));
        int i3 = MathHelper.a(delta, ARGB.d(color1), ARGB.d(color2));
        return ARGB.a(i2, i1, i22, i3);
    }

    public static int f(int color) {
        return color | 0xFF000000;
    }

    public static int g(int color) {
        return color & 0xFFFFFF;
    }

    public static int c(int alpha, int color) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int a(float alpha, int color) {
        return ARGB.b(alpha) << 24 | color & 0xFFFFFF;
    }

    public static int a(float alpha) {
        return ARGB.b(alpha) << 24 | 0xFFFFFF;
    }

    public static int a(float alpha, float red, float green, float blue) {
        return ARGB.a(ARGB.b(alpha), ARGB.b(red), ARGB.b(green), ARGB.b(blue));
    }

    public static Vector3f h(int color) {
        float f2 = (float)ARGB.b(color) / 255.0f;
        float f1 = (float)ARGB.c(color) / 255.0f;
        float f22 = (float)ARGB.d(color) / 255.0f;
        return new Vector3f(f2, f1, f22);
    }

    public static int d(int color1, int color2) {
        return ARGB.a((ARGB.a(color1) + ARGB.a(color2)) / 2, (ARGB.b(color1) + ARGB.b(color2)) / 2, (ARGB.c(color1) + ARGB.c(color2)) / 2, (ARGB.d(color1) + ARGB.d(color2)) / 2);
    }

    public static int b(float value) {
        return MathHelper.d(value * 255.0f);
    }

    public static float i(int color) {
        return ARGB.o(ARGB.a(color));
    }

    public static float j(int color) {
        return ARGB.o(ARGB.b(color));
    }

    public static float k(int color) {
        return ARGB.o(ARGB.c(color));
    }

    public static float l(int color) {
        return ARGB.o(ARGB.d(color));
    }

    private static float o(int value) {
        return (float)value / 255.0f;
    }

    public static int m(int color) {
        return color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16;
    }

    public static int n(int color) {
        return ARGB.m(color);
    }

    public static int b(int color, float brightness) {
        float f2;
        int i2 = ARGB.b(color);
        int i1 = ARGB.c(color);
        int i22 = ARGB.d(color);
        int i3 = ARGB.a(color);
        int max = Math.max(Math.max(i2, i1), i22);
        int min = Math.min(Math.min(i2, i1), i22);
        float f3 = max - min;
        float f1 = max != 0 ? f3 / (float)max : 0.0f;
        if (f1 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f32 = (float)(max - i2) / f3;
            float f4 = (float)(max - i1) / f3;
            float f5 = (float)(max - i22) / f3;
            f2 = i2 == max ? f5 - f4 : (i1 == max ? 2.0f + f32 - f5 : 4.0f + f4 - f32);
            if ((f2 /= 6.0f) < 0.0f) {
                f2 += 1.0f;
            }
        }
        if (f1 == 0.0f) {
            i1 = i22 = Math.round(brightness * 255.0f);
            i2 = i22;
            return ARGB.a(i3, i2, i1, i22);
        }
        float f3x = (f2 - (float)Math.floor(f2)) * 6.0f;
        float f4x = f3x - (float)Math.floor(f3x);
        float f5x = brightness * (1.0f - f1);
        float f6 = brightness * (1.0f - f1 * f4x);
        float f7 = brightness * (1.0f - f1 * (1.0f - f4x));
        switch ((int)f3x) {
            case 0: {
                i2 = Math.round(brightness * 255.0f);
                i1 = Math.round(f7 * 255.0f);
                i22 = Math.round(f5x * 255.0f);
                break;
            }
            case 1: {
                i2 = Math.round(f6 * 255.0f);
                i1 = Math.round(brightness * 255.0f);
                i22 = Math.round(f5x * 255.0f);
                break;
            }
            case 2: {
                i2 = Math.round(f5x * 255.0f);
                i1 = Math.round(brightness * 255.0f);
                i22 = Math.round(f7 * 255.0f);
                break;
            }
            case 3: {
                i2 = Math.round(f5x * 255.0f);
                i1 = Math.round(f6 * 255.0f);
                i22 = Math.round(brightness * 255.0f);
                break;
            }
            case 4: {
                i2 = Math.round(f7 * 255.0f);
                i1 = Math.round(f5x * 255.0f);
                i22 = Math.round(brightness * 255.0f);
                break;
            }
            case 5: {
                i2 = Math.round(brightness * 255.0f);
                i1 = Math.round(f5x * 255.0f);
                i22 = Math.round(f6 * 255.0f);
            }
        }
        return ARGB.a(i3, i2, i1, i22);
    }
}

