/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;

public class ChatDeserializer {
    private static final Gson a = new GsonBuilder().create();

    public static boolean a(JsonObject json, String memberName) {
        return ChatDeserializer.f(json, memberName) && json.getAsJsonPrimitive(memberName).isString();
    }

    public static boolean a(JsonElement json) {
        return json.isJsonPrimitive() && json.getAsJsonPrimitive().isString();
    }

    public static boolean b(JsonObject json, String memberName) {
        return ChatDeserializer.f(json, memberName) && json.getAsJsonPrimitive(memberName).isNumber();
    }

    public static boolean b(JsonElement json) {
        return json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber();
    }

    public static boolean c(JsonObject json, String memberName) {
        return ChatDeserializer.f(json, memberName) && json.getAsJsonPrimitive(memberName).isBoolean();
    }

    public static boolean c(JsonElement json) {
        return json.isJsonPrimitive() && json.getAsJsonPrimitive().isBoolean();
    }

    public static boolean d(JsonObject json, String memberName) {
        return ChatDeserializer.g(json, memberName) && json.get(memberName).isJsonArray();
    }

    public static boolean e(JsonObject json, String memberName) {
        return ChatDeserializer.g(json, memberName) && json.get(memberName).isJsonObject();
    }

    public static boolean f(JsonObject json, String memberName) {
        return ChatDeserializer.g(json, memberName) && json.get(memberName).isJsonPrimitive();
    }

    public static boolean g(@Nullable JsonObject json, String memberName) {
        return json != null && json.get(memberName) != null;
    }

    public static JsonElement h(JsonObject json, String memberName) {
        JsonElement jsonElement = json.get(memberName);
        if (jsonElement != null && !jsonElement.isJsonNull()) {
            return jsonElement;
        }
        throw new JsonSyntaxException("Missing field " + memberName);
    }

    public static String a(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return json.getAsString();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a string, was " + ChatDeserializer.d(json));
    }

    public static String i(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.a(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a string");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static String a(JsonObject json, String memberName, @Nullable String fallback) {
        return json.has(memberName) ? ChatDeserializer.a(json.get(memberName), memberName) : fallback;
    }

    public static Holder<Item> b(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            String asString = json.getAsString();
            return BuiltInRegistries.h.c(MinecraftKey.a(asString)).orElseThrow(() -> new JsonSyntaxException("Expected " + memberName + " to be an item, was unknown string '" + asString + "'"));
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an item, was " + ChatDeserializer.d(json));
    }

    public static Holder<Item> j(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.b(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static Holder<Item> a(JsonObject json, String memberName, @Nullable Holder<Item> fallback) {
        return json.has(memberName) ? ChatDeserializer.b(json.get(memberName), memberName) : fallback;
    }

    public static boolean c(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return json.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Boolean, was " + ChatDeserializer.d(json));
    }

    public static boolean k(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.c(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Boolean");
    }

    public static boolean a(JsonObject json, String memberName, boolean fallback) {
        return json.has(memberName) ? ChatDeserializer.c(json.get(memberName), memberName) : fallback;
    }

    public static double d(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsDouble();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Double, was " + ChatDeserializer.d(json));
    }

    public static double l(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.d(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Double");
    }

    public static double a(JsonObject json, String memberName, double fallback) {
        return json.has(memberName) ? ChatDeserializer.d(json.get(memberName), memberName) : fallback;
    }

    public static float e(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Float, was " + ChatDeserializer.d(json));
    }

    public static float m(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.e(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Float");
    }

    public static float a(JsonObject json, String memberName, float fallback) {
        return json.has(memberName) ? ChatDeserializer.e(json.get(memberName), memberName) : fallback;
    }

    public static long f(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsLong();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Long, was " + ChatDeserializer.d(json));
    }

    public static long n(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.f(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Long");
    }

    public static long a(JsonObject json, String memberName, long fallback) {
        return json.has(memberName) ? ChatDeserializer.f(json.get(memberName), memberName) : fallback;
    }

    public static int g(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Int, was " + ChatDeserializer.d(json));
    }

    public static int o(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.g(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Int");
    }

    public static int a(JsonObject json, String memberName, int fallback) {
        return json.has(memberName) ? ChatDeserializer.g(json.get(memberName), memberName) : fallback;
    }

    public static byte h(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsByte();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Byte, was " + ChatDeserializer.d(json));
    }

    public static byte p(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.h(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Byte");
    }

    public static byte a(JsonObject json, String memberName, byte fallback) {
        return json.has(memberName) ? ChatDeserializer.h(json.get(memberName), memberName) : fallback;
    }

    public static char i(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsCharacter();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Character, was " + ChatDeserializer.d(json));
    }

    public static char q(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.i(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Character");
    }

    public static char a(JsonObject json, String memberName, char fallback) {
        return json.has(memberName) ? ChatDeserializer.i(json.get(memberName), memberName) : fallback;
    }

    public static BigDecimal j(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsBigDecimal();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a BigDecimal, was " + ChatDeserializer.d(json));
    }

    public static BigDecimal r(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.j(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a BigDecimal");
    }

    public static BigDecimal a(JsonObject json, String memberName, BigDecimal fallback) {
        return json.has(memberName) ? ChatDeserializer.j(json.get(memberName), memberName) : fallback;
    }

    public static BigInteger k(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsBigInteger();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a BigInteger, was " + ChatDeserializer.d(json));
    }

    public static BigInteger s(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.k(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a BigInteger");
    }

    public static BigInteger a(JsonObject json, String memberName, BigInteger fallback) {
        return json.has(memberName) ? ChatDeserializer.k(json.get(memberName), memberName) : fallback;
    }

    public static short l(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsShort();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Short, was " + ChatDeserializer.d(json));
    }

    public static short t(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.l(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Short");
    }

    public static short a(JsonObject json, String memberName, short fallback) {
        return json.has(memberName) ? ChatDeserializer.l(json.get(memberName), memberName) : fallback;
    }

    public static JsonObject m(JsonElement json, String memberName) {
        if (json.isJsonObject()) {
            return json.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a JsonObject, was " + ChatDeserializer.d(json));
    }

    public static JsonObject u(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.m(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a JsonObject");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static JsonObject a(JsonObject json, String memberName, @Nullable JsonObject fallback) {
        return json.has(memberName) ? ChatDeserializer.m(json.get(memberName), memberName) : fallback;
    }

    public static JsonArray n(JsonElement json, String memberName) {
        if (json.isJsonArray()) {
            return json.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a JsonArray, was " + ChatDeserializer.d(json));
    }

    public static JsonArray v(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return ChatDeserializer.n(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a JsonArray");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static JsonArray a(JsonObject json, String memberName, @Nullable JsonArray fallback) {
        return json.has(memberName) ? ChatDeserializer.n(json.get(memberName), memberName) : fallback;
    }

    public static <T> T a(@Nullable JsonElement json, String memberName, JsonDeserializationContext context, Class<? extends T> adapter) {
        if (json != null) {
            return (T)context.deserialize(json, adapter);
        }
        throw new JsonSyntaxException("Missing " + memberName);
    }

    public static <T> T a(JsonObject json, String memberName, JsonDeserializationContext context, Class<? extends T> adapter) {
        if (json.has(memberName)) {
            return ChatDeserializer.a(json.get(memberName), memberName, context, adapter);
        }
        throw new JsonSyntaxException("Missing " + memberName);
    }

    @Nullable
    @Contract(value="_,_,!null,_,_->!null;_,_,null,_,_->_")
    public static <T> T a(JsonObject json, String memberName, @Nullable T fallback, JsonDeserializationContext context, Class<? extends T> adapter) {
        return json.has(memberName) ? ChatDeserializer.a(json.get(memberName), memberName, context, adapter) : fallback;
    }

    public static String d(@Nullable JsonElement json) {
        String string = StringUtils.abbreviateMiddle((String)String.valueOf(json), (String)"...", (int)10);
        if (json == null) {
            return "null (missing)";
        }
        if (json.isJsonNull()) {
            return "null (json)";
        }
        if (json.isJsonArray()) {
            return "an array (" + string + ")";
        }
        if (json.isJsonObject()) {
            return "an object (" + string + ")";
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive asJsonPrimitive = json.getAsJsonPrimitive();
            if (asJsonPrimitive.isNumber()) {
                return "a number (" + string + ")";
            }
            if (asJsonPrimitive.isBoolean()) {
                return "a boolean (" + string + ")";
            }
        }
        return string;
    }

    public static <T> T a(Gson gson, Reader reader, Class<T> adapter) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setStrictness(Strictness.STRICT);
            Object object = gson.getAdapter(adapter).read(jsonReader);
            if (object == null) {
                throw new JsonParseException("JSON data was null or empty");
            }
            return (T)object;
        }
        catch (IOException var5) {
            throw new JsonParseException((Throwable)var5);
        }
    }

    @Nullable
    public static <T> T a(Gson gson, Reader reader, TypeToken<T> token) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setStrictness(Strictness.STRICT);
            return (T)gson.getAdapter(token).read(jsonReader);
        }
        catch (IOException var4) {
            throw new JsonParseException((Throwable)var4);
        }
    }

    public static <T> T b(Gson gson, Reader reader, TypeToken<T> type) {
        T object = ChatDeserializer.a(gson, reader, type);
        if (object == null) {
            throw new JsonParseException("JSON data was null or empty");
        }
        return object;
    }

    @Nullable
    public static <T> T a(Gson gson, String json, TypeToken<T> type) {
        return ChatDeserializer.a(gson, (Reader)new StringReader(json), type);
    }

    public static <T> T a(Gson gson, String json, Class<T> adapter) {
        return ChatDeserializer.a(gson, (Reader)new StringReader(json), adapter);
    }

    public static JsonObject a(String json) {
        return ChatDeserializer.a(new StringReader(json));
    }

    public static JsonObject a(Reader reader) {
        return ChatDeserializer.a(a, reader, JsonObject.class);
    }

    public static JsonArray b(String string) {
        return ChatDeserializer.b(new StringReader(string));
    }

    public static JsonArray b(Reader reader) {
        return ChatDeserializer.a(a, reader, JsonArray.class);
    }

    public static String e(JsonElement json) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            ChatDeserializer.a(jsonWriter, json, Comparator.naturalOrder());
        }
        catch (IOException var4) {
            throw new AssertionError((Object)var4);
        }
        return stringWriter.toString();
    }

    public static void a(JsonWriter writer, @Nullable JsonElement jsonElement, @Nullable Comparator<String> sorter) throws IOException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            writer.nullValue();
        } else if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive asJsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (asJsonPrimitive.isNumber()) {
                writer.value(asJsonPrimitive.getAsNumber());
            } else if (asJsonPrimitive.isBoolean()) {
                writer.value(asJsonPrimitive.getAsBoolean());
            } else {
                writer.value(asJsonPrimitive.getAsString());
            }
        } else if (jsonElement.isJsonArray()) {
            writer.beginArray();
            for (JsonElement jsonElement1 : jsonElement.getAsJsonArray()) {
                ChatDeserializer.a(writer, jsonElement1, sorter);
            }
            writer.endArray();
        } else {
            if (!jsonElement.isJsonObject()) {
                throw new IllegalArgumentException("Couldn't write " + String.valueOf(jsonElement.getClass()));
            }
            writer.beginObject();
            for (Map.Entry<String, JsonElement> entry : ChatDeserializer.a(jsonElement.getAsJsonObject().entrySet(), sorter)) {
                writer.name(entry.getKey());
                ChatDeserializer.a(writer, entry.getValue(), sorter);
            }
            writer.endObject();
        }
    }

    private static Collection<Map.Entry<String, JsonElement>> a(Collection<Map.Entry<String, JsonElement>> entries, @Nullable Comparator<String> sorter) {
        if (sorter == null) {
            return entries;
        }
        ArrayList<Map.Entry<String, JsonElement>> list = new ArrayList<Map.Entry<String, JsonElement>>(entries);
        list.sort(Map.Entry.comparingByKey(sorter));
        return list;
    }

    public static boolean a(JsonElement element, int maxLength) {
        try {
            Streams.write((JsonElement)element, (JsonWriter)new JsonWriter(Streams.writerForAppendable((Appendable)new a(maxLength))));
            return false;
        }
        catch (IllegalStateException var3) {
            return true;
        }
        catch (IOException var4) {
            throw new UncheckedIOException(var4);
        }
    }

    static class a
    implements Appendable {
        private int a;
        private final int b;

        public a(int limit) {
            this.b = limit;
        }

        private Appendable a(int count) {
            this.a += count;
            if (this.a > this.b) {
                throw new IllegalStateException("Character count over limit: " + this.a + " > " + this.b);
            }
            return this;
        }

        @Override
        public Appendable append(CharSequence sequence) {
            return this.a(sequence.length());
        }

        @Override
        public Appendable append(CharSequence sequence, int start, int end) {
            return this.a(end - start);
        }

        @Override
        public Appendable append(char character) {
            return this.a(1);
        }
    }
}

