/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.BoundedFloatFunction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.lang3.mutable.MutableObject;

public interface CubicSpline<C, I extends BoundedFloatFunction<C>>
extends BoundedFloatFunction<C> {
    @VisibleForDebug
    public String c();

    public CubicSpline<C, I> a(d<I> var1);

    public static <C, I extends BoundedFloatFunction<C>> Codec<CubicSpline<C, I>> a(Codec<I> valueCodec) {
        record A<C, I extends BoundedFloatFunction<C>>(float a, CubicSpline<C, I> b, float c) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "location;value;derivative", "a", "b", "c"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "location;value;derivative", "a", "b", "c"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "location;value;derivative", "a", "b", "c"}, this, o2);
            }
        }
        MutableObject mutableObject = new MutableObject();
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("location").forGetter(A::a), (App)Codec.lazyInitialized(() -> ((MutableObject)mutableObject).getValue()).fieldOf("value").forGetter(A::b), (App)Codec.FLOAT.fieldOf("derivative").forGetter(A::c)).apply((Applicative)instance, (location, value, derivative) -> new A(location.floatValue(), value, derivative.floatValue())));
        Codec codec1 = RecordCodecBuilder.create(locations -> locations.group((App)valueCodec.fieldOf("coordinate").forGetter(e::d), (App)ExtraCodecs.b(codec.listOf()).fieldOf("points").forGetter(multipoint -> IntStream.range(0, multipoint.c.length).mapToObj(i2 -> new A(multipoint.e()[i2], multipoint.f().get(i2), multipoint.g()[i2])).toList())).apply((Applicative)locations, (coordinate, list) -> {
            float[] floats = new float[list.size()];
            ImmutableList.Builder builder = ImmutableList.builder();
            float[] floats1 = new float[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                A point = (A)list.get(i2);
                floats[i2] = point.a();
                builder.add(point.b());
                floats1[i2] = point.c();
            }
            return e.a(coordinate, floats, builder.build(), floats1);
        }));
        mutableObject.setValue((Object)Codec.either((Codec)Codec.FLOAT, (Codec)codec1).xmap(either -> (CubicSpline)((Object)either.map(c::new, multipoint -> multipoint)), cubicSpline -> {
            Either either;
            if (cubicSpline instanceof c) {
                c constant = (c)cubicSpline;
                either = Either.left(Float.valueOf(constant.d()));
            } else {
                either = Either.right((e)cubicSpline);
            }
            return either;
        }));
        return (Codec)mutableObject.getValue();
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(float value) {
        return new c(value);
    }

    public static <C, I extends BoundedFloatFunction<C>> b<C, I> a(I coordinate) {
        return new b(coordinate);
    }

    public static <C, I extends BoundedFloatFunction<C>> b<C, I> a(I coordinate, BoundedFloatFunction<Float> valueTransformer) {
        return new b(coordinate, valueTransformer);
    }

    @VisibleForDebug
    public record c<C, I extends BoundedFloatFunction<C>>(float b) implements CubicSpline<C, I>
    {
        @Override
        public float a(C value) {
            return this.b;
        }

        @Override
        public String c() {
            return String.format(Locale.ROOT, "k=%.3f", Float.valueOf(this.b));
        }

        @Override
        public float a() {
            return this.b;
        }

        @Override
        public CubicSpline<C, I> a(d<I> visitor) {
            return this;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "value", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "value", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "value", "b"}, this, o2);
        }

        public float d() {
            return this.b;
        }
    }

    public static final class b<C, I extends BoundedFloatFunction<C>> {
        private final I a;
        private final BoundedFloatFunction<Float> b;
        private final FloatList c = new FloatArrayList();
        private final List<CubicSpline<C, I>> d = Lists.newArrayList();
        private final FloatList e = new FloatArrayList();

        protected b(I coordinate) {
            this(coordinate, BoundedFloatFunction.a);
        }

        protected b(I coordinate, BoundedFloatFunction<Float> valueTransformer) {
            this.a = coordinate;
            this.b = valueTransformer;
        }

        public b<C, I> a(float location, float value) {
            return this.a(location, new c(this.b.a(Float.valueOf(value))), 0.0f);
        }

        public b<C, I> a(float location, float value, float derivative) {
            return this.a(location, new c(this.b.a(Float.valueOf(value))), derivative);
        }

        public b<C, I> a(float location, CubicSpline<C, I> value) {
            return this.a(location, value, 0.0f);
        }

        private b<C, I> a(float location, CubicSpline<C, I> value, float derivative) {
            if (!this.c.isEmpty() && location <= this.c.getFloat(this.c.size() - 1)) {
                throw new IllegalArgumentException("Please register points in ascending order");
            }
            this.c.add(location);
            this.d.add(value);
            this.e.add(derivative);
            return this;
        }

        public CubicSpline<C, I> a() {
            if (this.c.isEmpty()) {
                throw new IllegalStateException("No elements added");
            }
            return net.minecraft.util.CubicSpline$e.a(this.a, this.c.toFloatArray(), ImmutableList.copyOf(this.d), this.e.toFloatArray());
        }
    }

    @VisibleForDebug
    public record e<C, I extends BoundedFloatFunction<C>>(I b, float[] c, List<CubicSpline<C, I>> d, float[] e, float f, float g) implements CubicSpline<C, I>
    {
        private final I b;
        private final float[] c;
        private final List<CubicSpline<C, I>> d;
        private final float[] e;
        private final float f;
        private final float g;

        public e {
            net.minecraft.util.CubicSpline$e.a(locations, values, derivatives);
        }

        static <C, I extends BoundedFloatFunction<C>> e<C, I> a(I coordinate, float[] locations, List<CubicSpline<C, I>> values, float[] derivatives) {
            float f5;
            float f4;
            net.minecraft.util.CubicSpline$e.a(locations, values, derivatives);
            int i2 = locations.length - 1;
            float f2 = Float.POSITIVE_INFINITY;
            float f1 = Float.NEGATIVE_INFINITY;
            float f22 = coordinate.a();
            float f3 = coordinate.b();
            if (f22 < locations[0]) {
                f4 = net.minecraft.util.CubicSpline$e.a(f22, locations, values.get(0).a(), derivatives, 0);
                f5 = net.minecraft.util.CubicSpline$e.a(f22, locations, values.get(0).b(), derivatives, 0);
                f2 = Math.min(f2, Math.min(f4, f5));
                f1 = Math.max(f1, Math.max(f4, f5));
            }
            if (f3 > locations[i2]) {
                f4 = net.minecraft.util.CubicSpline$e.a(f3, locations, values.get(i2).a(), derivatives, i2);
                f5 = net.minecraft.util.CubicSpline$e.a(f3, locations, values.get(i2).b(), derivatives, i2);
                f2 = Math.min(f2, Math.min(f4, f5));
                f1 = Math.max(f1, Math.max(f4, f5));
            }
            for (CubicSpline<C, I> cubicSpline : values) {
                f2 = Math.min(f2, cubicSpline.a());
                f1 = Math.max(f1, cubicSpline.b());
            }
            for (int i1 = 0; i1 < i2; ++i1) {
                f5 = locations[i1];
                float f6 = locations[i1 + 1];
                float f7 = f6 - f5;
                CubicSpline<C, I> cubicSpline1 = values.get(i1);
                CubicSpline<C, I> cubicSpline2 = values.get(i1 + 1);
                float f8 = cubicSpline1.a();
                float f9 = cubicSpline1.b();
                float f10 = cubicSpline2.a();
                float f11 = cubicSpline2.b();
                float f12 = derivatives[i1];
                float f13 = derivatives[i1 + 1];
                if (f12 == 0.0f && f13 == 0.0f) continue;
                float f14 = f12 * f7;
                float f15 = f13 * f7;
                float min = Math.min(f8, f10);
                float max = Math.max(f9, f11);
                float f16 = f14 - f11 + f8;
                float f17 = f14 - f10 + f9;
                float f18 = -f15 + f10 - f9;
                float f19 = -f15 + f11 - f8;
                float min1 = Math.min(f16, f18);
                float max1 = Math.max(f17, f19);
                f2 = Math.min(f2, min + 0.25f * min1);
                f1 = Math.max(f1, max + 0.25f * max1);
            }
            return new e<C, I>(coordinate, locations, values, derivatives, f2, f1);
        }

        private static float a(float coordinate, float[] locations, float value, float[] derivatives, int index) {
            float f2 = derivatives[index];
            return f2 == 0.0f ? value : value + f2 * (coordinate - locations[index]);
        }

        private static <C, I extends BoundedFloatFunction<C>> void a(float[] locations, List<CubicSpline<C, I>> values, float[] derivatives) {
            if (locations.length != values.size() || locations.length != derivatives.length) {
                throw new IllegalArgumentException("All lengths must be equal, got: " + locations.length + " " + values.size() + " " + derivatives.length);
            }
            if (locations.length == 0) {
                throw new IllegalArgumentException("Cannot create a multipoint spline with no points");
            }
        }

        @Override
        public float a(C value) {
            float f2 = this.b.a(value);
            int i2 = net.minecraft.util.CubicSpline$e.a(this.c, f2);
            int i1 = this.c.length - 1;
            if (i2 < 0) {
                return net.minecraft.util.CubicSpline$e.a(f2, this.c, this.d.get(0).a(value), this.e, 0);
            }
            if (i2 == i1) {
                return net.minecraft.util.CubicSpline$e.a(f2, this.c, this.d.get(i1).a(value), this.e, i1);
            }
            float f1 = this.c[i2];
            float f22 = this.c[i2 + 1];
            float f3 = (f2 - f1) / (f22 - f1);
            BoundedFloatFunction boundedFloatFunction = this.d.get(i2);
            BoundedFloatFunction boundedFloatFunction1 = this.d.get(i2 + 1);
            float f4 = this.e[i2];
            float f5 = this.e[i2 + 1];
            float f6 = boundedFloatFunction.a(value);
            float f7 = boundedFloatFunction1.a(value);
            float f8 = f4 * (f22 - f1) - (f7 - f6);
            float f9 = -f5 * (f22 - f1) + (f7 - f6);
            return MathHelper.h(f3, f6, f7) + f3 * (1.0f - f3) * MathHelper.h(f3, f8, f9);
        }

        private static int a(float[] locations, float start) {
            return MathHelper.a(0, locations.length, (int i2) -> start < locations[i2]) - 1;
        }

        @Override
        @VisibleForTesting
        public String c() {
            return "Spline{coordinate=" + String.valueOf(this.b) + ", locations=" + this.a(this.c) + ", derivatives=" + this.a(this.e) + ", values=" + this.d.stream().map(CubicSpline::c).collect(Collectors.joining(", ", "[", "]")) + "}";
        }

        private String a(float[] locations) {
            return "[" + IntStream.range(0, locations.length).mapToDouble(i2 -> locations[i2]).mapToObj(d2 -> String.format(Locale.ROOT, "%.3f", d2)).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        public CubicSpline<C, I> a(d<I> visitor) {
            return net.minecraft.util.CubicSpline$e.a((BoundedFloatFunction)visitor.visit(this.b), this.c, this.f().stream().map(cubicSpline -> cubicSpline.a(visitor)).toList(), this.e);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "coordinate;locations;values;derivatives;minValue;maxValue", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "coordinate;locations;values;derivatives;minValue;maxValue", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "coordinate;locations;values;derivatives;minValue;maxValue", "b", "c", "d", "e", "f", "g"}, this, o2);
        }

        public I d() {
            return this.b;
        }

        public float[] e() {
            return this.c;
        }

        public List<CubicSpline<C, I>> f() {
            return this.d;
        }

        public float[] g() {
            return this.e;
        }

        @Override
        public float a() {
            return this.f;
        }

        @Override
        public float b() {
            return this.g;
        }
    }

    public static interface d<I> {
        public I visit(I var1);
    }
}

