/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.SystemUtils;

public class EntitySlice<T>
extends AbstractCollection<T> {
    private final Map<Class<?>, List<T>> a = Maps.newHashMap();
    private final Class<T> b;
    private final List<T> c = Lists.newArrayList();

    public EntitySlice(Class<T> baseClass) {
        this.b = baseClass;
        this.a.put(baseClass, this.c);
    }

    @Override
    public boolean add(T value) {
        boolean flag = false;
        for (Map.Entry<Class<?>, List<T>> entry : this.a.entrySet()) {
            if (!entry.getKey().isInstance(value)) continue;
            flag |= entry.getValue().add(value);
        }
        return flag;
    }

    @Override
    public boolean remove(Object key) {
        boolean flag = false;
        for (Map.Entry<Class<?>, List<T>> entry : this.a.entrySet()) {
            if (!entry.getKey().isInstance(key)) continue;
            List<T> list = entry.getValue();
            flag |= list.remove(key);
        }
        return flag;
    }

    @Override
    public boolean contains(Object key) {
        return this.a(key.getClass()).contains(key);
    }

    public <S> Collection<S> a(Class<S> type) {
        if (!this.b.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Don't know how to search for " + String.valueOf(type));
        }
        List list = this.a.computeIfAbsent(type, clazz -> this.c.stream().filter(clazz::isInstance).collect(SystemUtils.b()));
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Iterator<T> iterator() {
        return this.c.isEmpty() ? Collections.emptyIterator() : Iterators.unmodifiableIterator(this.c.iterator());
    }

    public List<T> a() {
        return ImmutableList.copyOf(this.c);
    }

    @Override
    public int size() {
        return this.c.size();
    }
}

