/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;

public final class InclusiveRange<T extends Comparable<T>>
extends Record {
    private final T b;
    private final T c;
    public static final Codec<InclusiveRange<Integer>> a = InclusiveRange.a(Codec.INT);

    public InclusiveRange(T minInclusive, T maxInclusive) {
        if (minInclusive.compareTo(maxInclusive) > 0) {
            throw new IllegalArgumentException("min_inclusive must be less than or equal to max_inclusive");
        }
        this.b = minInclusive;
        this.c = maxInclusive;
    }

    public InclusiveRange(T value) {
        this(value, value);
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> a(Codec<T> codec) {
        return ExtraCodecs.a(codec, "min_inclusive", "max_inclusive", InclusiveRange::a, InclusiveRange::a, InclusiveRange::b);
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> a(Codec<T> codec, T min, T max) {
        return InclusiveRange.a(codec).validate(value -> {
            if (value.a().compareTo(min) < 0) {
                return DataResult.error(() -> "Range limit too low, expected at least " + String.valueOf(min) + " [" + String.valueOf(value.a()) + "-" + String.valueOf(value.b()) + "]");
            }
            return value.b().compareTo(max) > 0 ? DataResult.error(() -> "Range limit too high, expected at most " + String.valueOf(max) + " [" + String.valueOf(value.a()) + "-" + String.valueOf(value.b()) + "]") : DataResult.success((Object)value);
        });
    }

    public static <T extends Comparable<T>> DataResult<InclusiveRange<T>> a(T min, T max) {
        return min.compareTo(max) <= 0 ? DataResult.success(new InclusiveRange<T>(min, max)) : DataResult.error(() -> "min_inclusive must be less than or equal to max_inclusive");
    }

    public <S extends Comparable<S>> InclusiveRange<S> a(Function<? super T, ? extends S> mapper) {
        return new InclusiveRange<Comparable>((Comparable)mapper.apply(this.b), (Comparable)mapper.apply(this.c));
    }

    public boolean a(T value) {
        return value.compareTo(this.b) >= 0 && value.compareTo(this.c) <= 0;
    }

    public boolean a(InclusiveRange<T> value) {
        return value.a().compareTo(this.b) >= 0 && value.c.compareTo(this.c) <= 0;
    }

    @Override
    public String toString() {
        return "[" + String.valueOf(this.b) + ", " + String.valueOf(this.c) + "]";
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InclusiveRange.class, "minInclusive;maxInclusive", "b", "c"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InclusiveRange.class, "minInclusive;maxInclusive", "b", "c"}, this, o2);
    }

    public T a() {
        return this.b;
    }

    public T b() {
        return this.c;
    }
}

