/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class ParticleUtils {
    public static void a(World level, BlockPosition pos, ParticleParam options, IntProvider count) {
        for (EnumDirection direction : EnumDirection.values()) {
            ParticleUtils.a(level, pos, options, count, direction, () -> ParticleUtils.a(level.z), 0.55);
        }
    }

    public static void a(World level, BlockPosition pos, ParticleParam options, IntProvider count, EnumDirection direction, Supplier<Vec3D> speedSupplier, double spread) {
        int i2 = count.a(level.z);
        for (int i1 = 0; i1 < i2; ++i1) {
            ParticleUtils.a(level, pos, direction, options, speedSupplier.get(), spread);
        }
    }

    private static Vec3D a(RandomSource random) {
        return new Vec3D(MathHelper.a(random, -0.5, 0.5), MathHelper.a(random, -0.5, 0.5), MathHelper.a(random, -0.5, 0.5));
    }

    public static void a(EnumDirection.EnumAxis axis, World level, BlockPosition pos, double spread, ParticleParam options, UniformInt count) {
        Vec3D vec3 = Vec3D.b(pos);
        boolean flag = axis == EnumDirection.EnumAxis.a;
        boolean flag1 = axis == EnumDirection.EnumAxis.b;
        boolean flag2 = axis == EnumDirection.EnumAxis.c;
        int i2 = count.a(level.z);
        for (int i1 = 0; i1 < i2; ++i1) {
            double d2 = vec3.g + MathHelper.a(level.z, -1.0, 1.0) * (flag ? 0.5 : spread);
            double d1 = vec3.h + MathHelper.a(level.z, -1.0, 1.0) * (flag1 ? 0.5 : spread);
            double d22 = vec3.i + MathHelper.a(level.z, -1.0, 1.0) * (flag2 ? 0.5 : spread);
            double d3 = flag ? MathHelper.a(level.z, -1.0, 1.0) : 0.0;
            double d4 = flag1 ? MathHelper.a(level.z, -1.0, 1.0) : 0.0;
            double d5 = flag2 ? MathHelper.a(level.z, -1.0, 1.0) : 0.0;
            level.a(options, d2, d1, d22, d3, d4, d5);
        }
    }

    public static void a(World level, BlockPosition pos, EnumDirection direction, ParticleParam options, Vec3D speed, double spread) {
        Vec3D vec3 = Vec3D.b(pos);
        int stepX = direction.j();
        int stepY = direction.k();
        int stepZ = direction.l();
        double d2 = vec3.g + (stepX == 0 ? MathHelper.a(level.z, -0.5, 0.5) : (double)stepX * spread);
        double d1 = vec3.h + (stepY == 0 ? MathHelper.a(level.z, -0.5, 0.5) : (double)stepY * spread);
        double d22 = vec3.i + (stepZ == 0 ? MathHelper.a(level.z, -0.5, 0.5) : (double)stepZ * spread);
        double d3 = stepX == 0 ? speed.a() : 0.0;
        double d4 = stepY == 0 ? speed.b() : 0.0;
        double d5 = stepZ == 0 ? speed.c() : 0.0;
        level.a(options, d2, d1, d22, d3, d4, d5);
    }

    public static void a(World level, BlockPosition pos, RandomSource random, ParticleParam options) {
        double d2 = (double)pos.u() + random.j();
        double d1 = (double)pos.v() - 0.05;
        double d22 = (double)pos.w() + random.j();
        level.a(options, d2, d1, d22, 0.0, 0.0, 0.0);
    }

    public static void a(GeneratorAccess level, BlockPosition pos, int count, ParticleParam options) {
        double d2 = 0.5;
        IBlockData blockState = level.a_(pos);
        double d1 = blockState.l() ? 1.0 : blockState.f(level, pos).c(EnumDirection.EnumAxis.b);
        ParticleUtils.a(level, pos, count, 0.5, d1, true, options);
    }

    public static void a(GeneratorAccess level, BlockPosition pos, int count, double xzSpread, double ySpread, boolean allowInAir, ParticleParam options) {
        RandomSource random = level.I_();
        for (int i2 = 0; i2 < count; ++i2) {
            double d2 = random.k() * 0.02;
            double d1 = random.k() * 0.02;
            double d22 = random.k() * 0.02;
            double d3 = 0.5 - xzSpread;
            double d4 = (double)pos.u() + d3 + random.j() * xzSpread * 2.0;
            double d5 = (double)pos.v() + random.j() * ySpread;
            double d6 = (double)pos.w() + d3 + random.j() * xzSpread * 2.0;
            if (!allowInAir && level.a_(BlockPosition.a(d4, d5, d6).e()).l()) continue;
            level.a(options, d4, d5, d6, d2, d1, d22);
        }
    }

    public static void a(GeneratorAccess level, BlockPosition pos, int power) {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d6;
        Vec3D vec3 = pos.b().b(0.0, 0.5, 0.0);
        ParticleParamBlock blockParticleOption = new ParticleParamBlock(Particles.bf, level.a_(pos));
        int i2 = 0;
        while ((float)i2 < (float)power / 3.0f) {
            d6 = vec3.g + level.I_().k() / 2.0;
            d1 = vec3.h;
            d2 = vec3.i + level.I_().k() / 2.0;
            d3 = level.I_().k() * (double)0.2f;
            d4 = level.I_().k() * (double)0.2f;
            d5 = level.I_().k() * (double)0.2f;
            level.a(blockParticleOption, d6, d1, d2, d3, d4, d5);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < (float)power / 1.5f) {
            d6 = vec3.g + 3.5 * Math.cos(i2) + level.I_().k() / 2.0;
            d1 = vec3.h;
            d2 = vec3.i + 3.5 * Math.sin(i2) + level.I_().k() / 2.0;
            d3 = level.I_().k() * (double)0.05f;
            d4 = level.I_().k() * (double)0.05f;
            d5 = level.I_().k() * (double)0.05f;
            level.a(blockParticleOption, d6, d1, d2, d3, d4, d5);
            ++i2;
        }
    }
}

