/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryID;
import net.minecraft.util.datafix.DataBitsPacked;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterFlattenData;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class ChunkConverterPalette
extends DataFix {
    private static final int a = 128;
    private static final int b = 64;
    private static final int c = 32;
    private static final int d = 16;
    private static final int e = 8;
    private static final int f = 4;
    private static final int g = 2;
    private static final int h = 1;
    static final Logger i = LogUtils.getLogger();
    private static final int j = 4096;

    public ChunkConverterPalette(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public static String a(Dynamic<?> data) {
        return data.get("Name").asString("");
    }

    public static String a(Dynamic<?> data, String key) {
        return data.get("Properties").get(key).asString("");
    }

    public static int a(RegistryID<Dynamic<?>> palette, Dynamic<?> data) {
        int id = palette.a(data);
        if (id == -1) {
            id = palette.d(data);
        }
        return id;
    }

    private Dynamic<?> b(Dynamic<?> dynamic) {
        Optional optional = dynamic.get("Level").result();
        return optional.isPresent() && ((Dynamic)((Object)optional.get())).get("Sections").asStreamOpt().result().isPresent() ? dynamic.set("Level", new e((Dynamic)((Object)optional.get())).a()) : dynamic;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.d);
        Type type1 = this.getOutputSchema().getType(DataConverterTypes.d);
        return this.writeFixAndRead("ChunkPalettedStorageFix", type, type1, this::b);
    }

    public static int a(boolean west, boolean east, boolean north, boolean south) {
        int i2 = 0;
        if (north) {
            i2 = east ? (i2 |= 2) : (west ? (i2 |= 0x80) : (i2 |= 1));
        } else if (south) {
            i2 = west ? (i2 |= 0x20) : (east ? (i2 |= 8) : (i2 |= 0x10));
        } else if (east) {
            i2 |= 4;
        } else if (west) {
            i2 |= 0x40;
        }
        return i2;
    }

    static final class e {
        private int a;
        private final d[] b = new d[16];
        private final Dynamic<?> c;
        private final int d;
        private final int e;
        private final Int2ObjectMap<Dynamic<?>> f = new Int2ObjectLinkedOpenHashMap(16);

        public e(Dynamic<?> level) {
            this.c = level;
            this.d = level.get("xPos").asInt(0) << 4;
            this.e = level.get("zPos").asInt(0) << 4;
            level.get("TileEntities").asStreamOpt().ifSuccess(stream -> stream.forEach(dynamic -> {
                int i3;
                int i2 = dynamic.get("x").asInt(0) - this.d & 0xF;
                int _int1 = dynamic.get("y").asInt(0);
                int i4 = _int1 << 8 | (i3 = dynamic.get("z").asInt(0) - this.e & 0xF) << 4 | i2;
                if (this.f.put(i4, (Object)dynamic) != null) {
                    i.warn("In chunk: {}x{} found a duplicate block entity at position: [{}, {}, {}]", new Object[]{this.d, this.e, i2, _int1, i3});
                }
            }));
            boolean _boolean = level.get("convertedFromAlphaFormat").asBoolean(false);
            level.get("Sections").asStreamOpt().ifSuccess(stream -> stream.forEach(dynamic -> {
                d section1 = new d((Dynamic<?>)((Object)((Object)dynamic)));
                this.a = section1.b(this.a);
                this.b[section1.a] = section1;
            }));
            for (d section : this.b) {
                if (section == null) continue;
                block30: for (Int2ObjectMap.Entry entry : section.f.int2ObjectEntrySet()) {
                    int i2 = section.a << 12;
                    switch (entry.getIntKey()) {
                        case 2: {
                            Object name;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1 = (Integer)intListIterator.next();
                                block = this.a(i1 |= i2);
                                if (!"minecraft:grass_block".equals(ChunkConverterPalette.a(block)) || !"minecraft:snow".equals(name = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(i1, Direction.b)))) && !"minecraft:snow_layer".equals(name)) continue;
                                this.a(i1, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.e);
                            }
                            continue block30;
                        }
                        case 3: {
                            Object name;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1xxxxxxxxx = (Integer)intListIterator.next();
                                block = this.a(i1xxxxxxxxx |= i2);
                                if (!"minecraft:podzol".equals(ChunkConverterPalette.a(block)) || !"minecraft:snow".equals(name = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(i1xxxxxxxxx, Direction.b)))) && !"minecraft:snow_layer".equals(name)) continue;
                                this.a(i1xxxxxxxxx, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.d);
                            }
                            continue block30;
                        }
                        case 25: {
                            Object name;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1xxxxx = (Integer)intListIterator.next();
                                block = this.c(i1xxxxx |= i2);
                                if (block == null) continue;
                                name = Boolean.toString(block.get("powered").asBoolean(false)) + (byte)Math.min(Math.max(block.get("note").asInt(0), 0), 24);
                                this.a(i1xxxxx, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.p.getOrDefault(name, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.p.get("false0")));
                            }
                            continue block30;
                        }
                        case 26: {
                            Object string;
                            Dynamic<?> block1;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int _int;
                                int i1xxxx = (Integer)intListIterator.next();
                                block = this.b(i1xxxx |= i2);
                                block1 = this.a(i1xxxx);
                                if (block == null || (_int = block.get("color").asInt(0)) == 14 || _int < 0 || _int >= 16 || !net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.r.containsKey(string = ChunkConverterPalette.a(block1, "facing") + ChunkConverterPalette.a(block1, "occupied") + ChunkConverterPalette.a(block1, "part") + _int)) continue;
                                this.a(i1xxxx, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.r.get(string));
                            }
                            continue block30;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            Dynamic<?> block1;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1xxx = (Integer)intListIterator.next();
                                block = this.a(i1xxx |= i2);
                                if (!ChunkConverterPalette.a(block).endsWith("_door") || !"lower".equals(ChunkConverterPalette.a(block1 = this.a(i1xxx), "half"))) continue;
                                int _int = net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(i1xxx, Direction.b);
                                Dynamic<?> block2 = this.a(_int);
                                String name1 = ChunkConverterPalette.a(block1);
                                if (!name1.equals(ChunkConverterPalette.a(block2))) continue;
                                String property1 = ChunkConverterPalette.a(block1, "facing");
                                String property2 = ChunkConverterPalette.a(block1, "open");
                                String string1 = _boolean ? "left" : ChunkConverterPalette.a(block2, "hinge");
                                String string2 = _boolean ? "false" : ChunkConverterPalette.a(block2, "powered");
                                this.a(i1xxx, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.o.get(name1 + property1 + "lower" + string1 + property2 + string2));
                                this.a(_int, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.o.get(name1 + property1 + "upper" + string1 + property2 + string2));
                            }
                            continue block30;
                        }
                        case 86: {
                            Object name;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1xxxxxxxx = (Integer)intListIterator.next();
                                block = this.a(i1xxxxxxxx |= i2);
                                if (!"minecraft:carved_pumpkin".equals(ChunkConverterPalette.a(block)) || !"minecraft:grass_block".equals(name = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(i1xxxxxxxx, Direction.a)))) && !"minecraft:dirt".equals(name)) continue;
                                this.a(i1xxxxxxxx, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.c);
                            }
                            continue block30;
                        }
                        case 110: {
                            Object name;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1xxxxxxx = (Integer)intListIterator.next();
                                block = this.a(i1xxxxxxx |= i2);
                                if (!"minecraft:mycelium".equals(ChunkConverterPalette.a(block)) || !"minecraft:snow".equals(name = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(i1xxxxxxx, Direction.b)))) && !"minecraft:snow_layer".equals(name)) continue;
                                this.a(i1xxxxxxx, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.f);
                            }
                            continue block30;
                        }
                        case 140: {
                            Object name;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1xx = (Integer)intListIterator.next();
                                block = this.c(i1xx |= i2);
                                if (block == null) continue;
                                name = block.get("Item").asString("") + block.get("Data").asInt(0);
                                this.a(i1xx, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.m.getOrDefault(name, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.m.get("minecraft:air0")));
                            }
                            continue block30;
                        }
                        case 144: {
                            Object string;
                            Object name;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1xxxxxx = (Integer)intListIterator.next();
                                block = this.b(i1xxxxxx |= i2);
                                if (block == null) continue;
                                name = String.valueOf(block.get("SkullType").asInt(0));
                                String property = ChunkConverterPalette.a(this.a(i1xxxxxx), "facing");
                                string = !"up".equals(property) && !"down".equals(property) ? (String)name + property : (String)name + block.get("Rot").asInt(0);
                                block.remove("SkullType");
                                block.remove("facing");
                                block.remove("Rot");
                                this.a(i1xxxxxx, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.n.getOrDefault(string, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.n.get("0north")));
                            }
                            continue block30;
                        }
                        case 175: {
                            Dynamic<?> block1;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1x = (Integer)intListIterator.next();
                                block = this.a(i1x |= i2);
                                if (!"upper".equals(ChunkConverterPalette.a(block, "half"))) continue;
                                block1 = this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(i1x, Direction.a));
                                String property = ChunkConverterPalette.a(block1);
                                switch (property) {
                                    case "minecraft:sunflower": {
                                        this.a(i1x, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.g);
                                        break;
                                    }
                                    case "minecraft:lilac": {
                                        this.a(i1x, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.h);
                                        break;
                                    }
                                    case "minecraft:tall_grass": {
                                        this.a(i1x, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.i);
                                        break;
                                    }
                                    case "minecraft:large_fern": {
                                        this.a(i1x, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.j);
                                        break;
                                    }
                                    case "minecraft:rose_bush": {
                                        this.a(i1x, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.k);
                                        break;
                                    }
                                    case "minecraft:peony": {
                                        this.a(i1x, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.l);
                                    }
                                }
                            }
                            continue block30;
                        }
                        case 176: 
                        case 177: {
                            Object string;
                            Dynamic<?> block1;
                            Dynamic<?> block;
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int _int;
                                int i1xxxxxxxxxx = (Integer)intListIterator.next();
                                block = this.b(i1xxxxxxxxxx |= i2);
                                block1 = this.a(i1xxxxxxxxxx);
                                if (block == null || (_int = block.get("Base").asInt(0)) == 15 || _int < 0 || _int >= 16 || !net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.s.containsKey(string = ChunkConverterPalette.a(block1, entry.getIntKey() == 176 ? "rotation" : "facing") + "_" + _int)) continue;
                                this.a(i1xxxxxxxxxx, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.s.get(string));
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> b(int index) {
            return (Dynamic)((Object)this.f.get(index));
        }

        @Nullable
        private Dynamic<?> c(int index) {
            return (Dynamic)((Object)this.f.remove(index));
        }

        public static int a(int data, Direction direction) {
            return switch (direction.b().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    int i = (data & 0xF) + direction.a().a();
                    if (i >= 0 && i <= 15) {
                        yield data & 0xFFFFFFF0 | i;
                    }
                    yield -1;
                }
                case 1 -> {
                    int i = (data >> 8) + direction.a().a();
                    if (i >= 0 && i <= 255) {
                        yield data & 0xFF | i << 8;
                    }
                    yield -1;
                }
                case 2 -> {
                    int i = (data >> 4 & 0xF) + direction.a().a();
                    if (i >= 0 && i <= 15) {
                        yield data & 0xFFFFFF0F | i << 4;
                    }
                    yield -1;
                }
            };
        }

        private void a(int index, Dynamic<?> block) {
            d section;
            if (index >= 0 && index <= 65535 && (section = this.d(index)) != null) {
                section.a(index & 0xFFF, block);
            }
        }

        @Nullable
        private d d(int index) {
            int i2 = index >> 12;
            return i2 < this.b.length ? this.b[i2] : null;
        }

        public Dynamic<?> a(int index) {
            if (index >= 0 && index <= 65535) {
                d section = this.d(index);
                return section == null ? net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t : section.a(index & 0xFFF);
            }
            return net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t;
        }

        public Dynamic<?> a() {
            Dynamic<?> dynamic = this.c;
            dynamic = this.f.isEmpty() ? dynamic.remove("TileEntities") : dynamic.set("TileEntities", dynamic.createList(this.f.values().stream()));
            Dynamic dynamic1 = dynamic.emptyMap();
            ArrayList list = Lists.newArrayList();
            for (d section : this.b) {
                if (section == null) continue;
                list.add(section.a());
                dynamic1 = dynamic1.set(String.valueOf(section.a), dynamic1.createIntList(Arrays.stream(section.g.toIntArray())));
            }
            Dynamic dynamic2 = dynamic.emptyMap();
            dynamic2 = dynamic2.set("Sides", dynamic2.createByte((byte)this.a));
            dynamic2 = dynamic2.set("Indices", dynamic1);
            return dynamic.set("UpgradeData", dynamic2).set("Sections", dynamic2.createList(list.stream()));
        }
    }

    static class d {
        private final RegistryID<Dynamic<?>> b = RegistryID.c(32);
        private final List<Dynamic<?>> c;
        private final Dynamic<?> d;
        private final boolean e;
        final Int2ObjectMap<IntList> f = new Int2ObjectLinkedOpenHashMap();
        final IntList g = new IntArrayList();
        public final int a;
        private final Set<Dynamic<?>> h = Sets.newIdentityHashSet();
        private final int[] i = new int[4096];

        public d(Dynamic<?> section) {
            this.c = Lists.newArrayList();
            this.d = section;
            this.a = section.get("Y").asInt(0);
            this.e = section.get("Blocks").result().isPresent();
        }

        public Dynamic<?> a(int index) {
            if (index >= 0 && index <= 4095) {
                Dynamic<?> dynamic = this.b.a(this.i[index]);
                return dynamic == null ? net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t : dynamic;
            }
            return net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t;
        }

        public void a(int index, Dynamic<?> block) {
            if (this.h.add(block)) {
                this.c.add("%%FILTER_ME%%".equals(ChunkConverterPalette.a(block)) ? net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t : block);
            }
            this.i[index] = ChunkConverterPalette.a(this.b, block);
        }

        public int b(int sides) {
            if (!this.e) {
                return sides;
            }
            ByteBuffer byteBuffer = (ByteBuffer)this.d.get("Blocks").asByteBufferOpt().result().get();
            a dataLayer = this.d.get("Data").asByteBufferOpt().map(byteBuffer1 -> new a(DataFixUtils.toArray((ByteBuffer)byteBuffer1))).result().orElseGet(a::new);
            a dataLayer1 = this.d.get("Add").asByteBufferOpt().map(byteBuffer1 -> new a(DataFixUtils.toArray((ByteBuffer)byteBuffer1))).result().orElseGet(a::new);
            this.h.add(net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t);
            ChunkConverterPalette.a(this.b, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t);
            this.c.add(net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t);
            for (int i2 = 0; i2 < 4096; ++i2) {
                int i1 = i2 & 0xF;
                int i22 = i2 >> 8 & 0xF;
                int i3 = i2 >> 4 & 0xF;
                int i4 = dataLayer1.a(i1, i22, i3) << 12 | (byteBuffer.get(i2) & 0xFF) << 4 | dataLayer.a(i1, i22, i3);
                if (net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.b.get(i4 >> 4)) {
                    this.a(i4 >> 4, i2);
                }
                if (net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a.get(i4 >> 4)) {
                    int sideMask = ChunkConverterPalette.a(i1 == 0, i1 == 15, i3 == 0, i3 == 15);
                    if (sideMask == 0) {
                        this.g.add(i2);
                    } else {
                        sides |= sideMask;
                    }
                }
                this.a(i2, DataConverterFlattenData.b(i4));
            }
            return sides;
        }

        private void a(int index, int value) {
            IntList list = (IntList)this.f.get(index);
            if (list == null) {
                list = new IntArrayList();
                this.f.put(index, (Object)list);
            }
            list.add(value);
        }

        public Dynamic<?> a() {
            Dynamic<?> dynamic = this.d;
            if (!this.e) {
                return dynamic;
            }
            dynamic = dynamic.set("Palette", dynamic.createList(this.c.stream()));
            int max = Math.max(4, DataFixUtils.ceillog2((int)this.h.size()));
            DataBitsPacked packedBitStorage = new DataBitsPacked(max, 4096);
            for (int i2 = 0; i2 < this.i.length; ++i2) {
                packedBitStorage.a(i2, this.i[i2]);
            }
            dynamic = dynamic.set("BlockStates", dynamic.createLongList(Arrays.stream(packedBitStorage.a())));
            dynamic = dynamic.remove("Blocks");
            dynamic = dynamic.remove("Data");
            return dynamic.remove("Add");
        }
    }

    static class c {
        static final BitSet a = new BitSet(256);
        static final BitSet b = new BitSet(256);
        static final Dynamic<?> c = ExtraDataFixUtils.a("minecraft:pumpkin");
        static final Dynamic<?> d = ExtraDataFixUtils.a("minecraft:podzol", Map.of("snowy", "true"));
        static final Dynamic<?> e = ExtraDataFixUtils.a("minecraft:grass_block", Map.of("snowy", "true"));
        static final Dynamic<?> f = ExtraDataFixUtils.a("minecraft:mycelium", Map.of("snowy", "true"));
        static final Dynamic<?> g = ExtraDataFixUtils.a("minecraft:sunflower", Map.of("half", "upper"));
        static final Dynamic<?> h = ExtraDataFixUtils.a("minecraft:lilac", Map.of("half", "upper"));
        static final Dynamic<?> i = ExtraDataFixUtils.a("minecraft:tall_grass", Map.of("half", "upper"));
        static final Dynamic<?> j = ExtraDataFixUtils.a("minecraft:large_fern", Map.of("half", "upper"));
        static final Dynamic<?> k = ExtraDataFixUtils.a("minecraft:rose_bush", Map.of("half", "upper"));
        static final Dynamic<?> l = ExtraDataFixUtils.a("minecraft:peony", Map.of("half", "upper"));
        static final Map<String, Dynamic<?>> m = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            map.put("minecraft:air0", ExtraDataFixUtils.a("minecraft:flower_pot"));
            map.put("minecraft:red_flower0", ExtraDataFixUtils.a("minecraft:potted_poppy"));
            map.put("minecraft:red_flower1", ExtraDataFixUtils.a("minecraft:potted_blue_orchid"));
            map.put("minecraft:red_flower2", ExtraDataFixUtils.a("minecraft:potted_allium"));
            map.put("minecraft:red_flower3", ExtraDataFixUtils.a("minecraft:potted_azure_bluet"));
            map.put("minecraft:red_flower4", ExtraDataFixUtils.a("minecraft:potted_red_tulip"));
            map.put("minecraft:red_flower5", ExtraDataFixUtils.a("minecraft:potted_orange_tulip"));
            map.put("minecraft:red_flower6", ExtraDataFixUtils.a("minecraft:potted_white_tulip"));
            map.put("minecraft:red_flower7", ExtraDataFixUtils.a("minecraft:potted_pink_tulip"));
            map.put("minecraft:red_flower8", ExtraDataFixUtils.a("minecraft:potted_oxeye_daisy"));
            map.put("minecraft:yellow_flower0", ExtraDataFixUtils.a("minecraft:potted_dandelion"));
            map.put("minecraft:sapling0", ExtraDataFixUtils.a("minecraft:potted_oak_sapling"));
            map.put("minecraft:sapling1", ExtraDataFixUtils.a("minecraft:potted_spruce_sapling"));
            map.put("minecraft:sapling2", ExtraDataFixUtils.a("minecraft:potted_birch_sapling"));
            map.put("minecraft:sapling3", ExtraDataFixUtils.a("minecraft:potted_jungle_sapling"));
            map.put("minecraft:sapling4", ExtraDataFixUtils.a("minecraft:potted_acacia_sapling"));
            map.put("minecraft:sapling5", ExtraDataFixUtils.a("minecraft:potted_dark_oak_sapling"));
            map.put("minecraft:red_mushroom0", ExtraDataFixUtils.a("minecraft:potted_red_mushroom"));
            map.put("minecraft:brown_mushroom0", ExtraDataFixUtils.a("minecraft:potted_brown_mushroom"));
            map.put("minecraft:deadbush0", ExtraDataFixUtils.a("minecraft:potted_dead_bush"));
            map.put("minecraft:tallgrass2", ExtraDataFixUtils.a("minecraft:potted_fern"));
            map.put("minecraft:cactus0", ExtraDataFixUtils.a("minecraft:potted_cactus"));
        });
        static final Map<String, Dynamic<?>> n = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 0, "skeleton", "skull");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 1, "wither_skeleton", "skull");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 2, "zombie", "head");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 3, "player", "head");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 4, "creeper", "head");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 5, "dragon", "head");
        });
        static final Map<String, Dynamic<?>> o = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "oak_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "iron_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "spruce_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "birch_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "jungle_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "acacia_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "dark_oak_door");
        });
        static final Map<String, Dynamic<?>> p = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            for (int i2 = 0; i2 < 26; ++i2) {
                map.put("true" + i2, ExtraDataFixUtils.a("minecraft:note_block", Map.of("powered", "true", "note", String.valueOf(i2))));
                map.put("false" + i2, ExtraDataFixUtils.a("minecraft:note_block", Map.of("powered", "false", "note", String.valueOf(i2))));
            }
        });
        private static final Int2ObjectMap<String> q = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), map -> {
            map.put(0, (Object)"white");
            map.put(1, (Object)"orange");
            map.put(2, (Object)"magenta");
            map.put(3, (Object)"light_blue");
            map.put(4, (Object)"yellow");
            map.put(5, (Object)"lime");
            map.put(6, (Object)"pink");
            map.put(7, (Object)"gray");
            map.put(8, (Object)"light_gray");
            map.put(9, (Object)"cyan");
            map.put(10, (Object)"purple");
            map.put(11, (Object)"blue");
            map.put(12, (Object)"brown");
            map.put(13, (Object)"green");
            map.put(14, (Object)"red");
            map.put(15, (Object)"black");
        });
        static final Map<String, Dynamic<?>> r = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            for (Int2ObjectMap.Entry entry : q.int2ObjectEntrySet()) {
                if (Objects.equals(entry.getValue(), "red")) continue;
                net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, entry.getIntKey(), (String)entry.getValue());
            }
        });
        static final Map<String, Dynamic<?>> s = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            for (Int2ObjectMap.Entry entry : q.int2ObjectEntrySet()) {
                if (Objects.equals(entry.getValue(), "white")) continue;
                net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.b(map, 15 - entry.getIntKey(), (String)entry.getValue());
            }
        });
        static final Dynamic<?> t = ExtraDataFixUtils.a("minecraft:air");

        private c() {
        }

        private static void a(Map<String, Dynamic<?>> map, int id, String skullType, String suffix) {
            map.put(id + "north", ExtraDataFixUtils.a("minecraft:" + skullType + "_wall_" + suffix, Map.of("facing", "north")));
            map.put(id + "east", ExtraDataFixUtils.a("minecraft:" + skullType + "_wall_" + suffix, Map.of("facing", "east")));
            map.put(id + "south", ExtraDataFixUtils.a("minecraft:" + skullType + "_wall_" + suffix, Map.of("facing", "south")));
            map.put(id + "west", ExtraDataFixUtils.a("minecraft:" + skullType + "_wall_" + suffix, Map.of("facing", "west")));
            for (int i2 = 0; i2 < 16; ++i2) {
                map.put("" + id + i2, ExtraDataFixUtils.a("minecraft:" + skullType + "_" + suffix, Map.of("rotation", String.valueOf(i2))));
            }
        }

        private static void a(Map<String, Dynamic<?>> map, String doorId) {
            String string = "minecraft:" + doorId;
            map.put("minecraft:" + doorId + "eastlowerleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "eastlowerleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "eastlowerlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "eastlowerlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "eastlowerrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "eastlowerrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "eastlowerrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "eastlowerrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "eastupperleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "eastupperleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "eastupperlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "eastupperlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "eastupperrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "eastupperrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "eastupperrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "eastupperrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "northlowerleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "northlowerleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "northlowerlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "northlowerlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "northlowerrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "northlowerrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "northlowerrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "northlowerrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "northupperleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "northupperleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "northupperlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "northupperlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "northupperrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "northupperrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "northupperrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "northupperrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "southlowerleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "southlowerleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "southlowerlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "southlowerlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "southlowerrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "southlowerrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "southlowerrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "southlowerrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "southupperleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "southupperleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "southupperlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "southupperlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "southupperrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "southupperrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "southupperrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "southupperrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "westlowerleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "westlowerleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "westlowerlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "westlowerlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "westlowerrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "westlowerrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "westlowerrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "westlowerrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "westupperleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "westupperleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "westupperlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "westupperlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + doorId + "westupperrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + doorId + "westupperrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + doorId + "westupperrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + doorId + "westupperrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
        }

        private static void a(Map<String, Dynamic<?>> map, int id, String bedColor) {
            map.put("southfalsefoot" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "south", "occupied", "false", "part", "foot")));
            map.put("westfalsefoot" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "west", "occupied", "false", "part", "foot")));
            map.put("northfalsefoot" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "north", "occupied", "false", "part", "foot")));
            map.put("eastfalsefoot" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "east", "occupied", "false", "part", "foot")));
            map.put("southfalsehead" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "south", "occupied", "false", "part", "head")));
            map.put("westfalsehead" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "west", "occupied", "false", "part", "head")));
            map.put("northfalsehead" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "north", "occupied", "false", "part", "head")));
            map.put("eastfalsehead" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "east", "occupied", "false", "part", "head")));
            map.put("southtruehead" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "south", "occupied", "true", "part", "head")));
            map.put("westtruehead" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "west", "occupied", "true", "part", "head")));
            map.put("northtruehead" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "north", "occupied", "true", "part", "head")));
            map.put("easttruehead" + id, ExtraDataFixUtils.a("minecraft:" + bedColor + "_bed", Map.of("facing", "east", "occupied", "true", "part", "head")));
        }

        private static void b(Map<String, Dynamic<?>> map, int id, String bannerColor) {
            for (int i2 = 0; i2 < 16; ++i2) {
                map.put(i2 + "_" + id, ExtraDataFixUtils.a("minecraft:" + bannerColor + "_banner", Map.of("rotation", String.valueOf(i2))));
            }
            map.put("north_" + id, ExtraDataFixUtils.a("minecraft:" + bannerColor + "_wall_banner", Map.of("facing", "north")));
            map.put("south_" + id, ExtraDataFixUtils.a("minecraft:" + bannerColor + "_wall_banner", Map.of("facing", "south")));
            map.put("west_" + id, ExtraDataFixUtils.a("minecraft:" + bannerColor + "_wall_banner", Map.of("facing", "west")));
            map.put("east_" + id, ExtraDataFixUtils.a("minecraft:" + bannerColor + "_wall_banner", Map.of("facing", "east")));
        }

        static {
            b.set(2);
            b.set(3);
            b.set(110);
            b.set(140);
            b.set(144);
            b.set(25);
            b.set(86);
            b.set(26);
            b.set(176);
            b.set(177);
            b.set(175);
            b.set(64);
            b.set(71);
            b.set(193);
            b.set(194);
            b.set(195);
            b.set(196);
            b.set(197);
            a.set(54);
            a.set(146);
            a.set(25);
            a.set(26);
            a.set(51);
            a.set(53);
            a.set(67);
            a.set(108);
            a.set(109);
            a.set(114);
            a.set(128);
            a.set(134);
            a.set(135);
            a.set(136);
            a.set(156);
            a.set(163);
            a.set(164);
            a.set(180);
            a.set(203);
            a.set(55);
            a.set(85);
            a.set(113);
            a.set(188);
            a.set(189);
            a.set(190);
            a.set(191);
            a.set(192);
            a.set(93);
            a.set(94);
            a.set(101);
            a.set(102);
            a.set(160);
            a.set(106);
            a.set(107);
            a.set(183);
            a.set(184);
            a.set(185);
            a.set(186);
            a.set(187);
            a.set(132);
            a.set(139);
            a.set(199);
        }
    }

    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction a = new Direction(AxisDirection.b, Axis.b);
        public static final /* enum */ Direction b = new Direction(AxisDirection.a, Axis.b);
        public static final /* enum */ Direction c = new Direction(AxisDirection.b, Axis.c);
        public static final /* enum */ Direction d = new Direction(AxisDirection.a, Axis.c);
        public static final /* enum */ Direction e = new Direction(AxisDirection.b, Axis.a);
        public static final /* enum */ Direction f = new Direction(AxisDirection.a, Axis.a);
        private final Axis g;
        private final AxisDirection h;
        private static final /* synthetic */ Direction[] i;

        public static Direction[] values() {
            return (Direction[])i.clone();
        }

        public static Direction valueOf(String name) {
            return Enum.valueOf(Direction.class, name);
        }

        private Direction(AxisDirection axisDirection, Axis axis) {
            this.g = axis;
            this.h = axisDirection;
        }

        public AxisDirection a() {
            return this.h;
        }

        public Axis b() {
            return this.g;
        }

        private static /* synthetic */ Direction[] c() {
            return new Direction[]{a, b, c, d, e, f};
        }

        static {
            i = Direction.c();
        }

        public static final class Axis
        extends Enum<Axis> {
            public static final /* enum */ Axis a = new Axis();
            public static final /* enum */ Axis b = new Axis();
            public static final /* enum */ Axis c = new Axis();
            private static final /* synthetic */ Axis[] d;

            public static Axis[] values() {
                return (Axis[])d.clone();
            }

            public static Axis valueOf(String name) {
                return Enum.valueOf(Axis.class, name);
            }

            private static /* synthetic */ Axis[] a() {
                return new Axis[]{a, b, c};
            }

            static {
                d = Axis.a();
            }
        }

        public static final class AxisDirection
        extends Enum<AxisDirection> {
            public static final /* enum */ AxisDirection a = new AxisDirection(1);
            public static final /* enum */ AxisDirection b = new AxisDirection(-1);
            private final int c;
            private static final /* synthetic */ AxisDirection[] d;

            public static AxisDirection[] values() {
                return (AxisDirection[])d.clone();
            }

            public static AxisDirection valueOf(String name) {
                return Enum.valueOf(AxisDirection.class, name);
            }

            private AxisDirection(int step) {
                this.c = step;
            }

            public int a() {
                return this.c;
            }

            private static /* synthetic */ AxisDirection[] b() {
                return new AxisDirection[]{a, b};
            }

            static {
                d = AxisDirection.b();
            }
        }
    }

    static class a {
        private static final int a = 2048;
        private static final int b = 4;
        private final byte[] c;

        public a() {
            this.c = new byte[2048];
        }

        public a(byte[] data) {
            this.c = data;
            if (data.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + data.length);
            }
        }

        public int a(int x2, int y2, int z2) {
            int position = this.b(y2 << 8 | z2 << 4 | x2);
            return this.a(y2 << 8 | z2 << 4 | x2) ? this.c[position] & 0xF : this.c[position] >> 4 & 0xF;
        }

        private boolean a(int packedPos) {
            return (packedPos & 1) == 0;
        }

        private int b(int packedPos) {
            return packedPos >> 1;
        }
    }
}

