/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterBedBlock
extends DataFix {
    public DataConverterBedBlock(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.d);
        Type type1 = type.findFieldType("Level");
        Type type2 = type1.findFieldType("TileEntities");
        if (!(type2 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType listType = (List.ListType)type2;
        return this.a(type1, listType);
    }

    private <TE> TypeRewriteRule a(Type<?> levelType, List.ListType<TE> tileEntityTypes) {
        Type element = tileEntityTypes.getElement();
        OpticFinder opticFinder = DSL.fieldFinder((String)"Level", levelType);
        OpticFinder opticFinder1 = DSL.fieldFinder((String)"TileEntities", tileEntityTypes);
        int i2 = 416;
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("InjectBedBlockEntityType", (Type)this.getInputSchema().findChoiceType(DataConverterTypes.u), (Type)this.getOutputSchema().findChoiceType(DataConverterTypes.u), dynamicOps -> pair -> pair), (TypeRewriteRule)this.fixTypeEverywhereTyped("BedBlockEntityInjecter", this.getOutputSchema().getType(DataConverterTypes.d), typed -> {
            Typed typed1 = typed.getTyped(opticFinder);
            Dynamic dynamic = (Dynamic)((Object)((Object)typed1.get(DSL.remainderFinder())));
            int _int = dynamic.get("xPos").asInt(0);
            int _int1 = dynamic.get("zPos").asInt(0);
            ArrayList list = Lists.newArrayList((Iterable)((Iterable)typed1.getOrCreate(opticFinder1)));
            for (Dynamic dynamic1 : dynamic.get("Sections").asList(Function.identity())) {
                int _int2 = dynamic1.get("Y").asInt(0);
                Streams.mapWithIndex((IntStream)dynamic1.get("Blocks").asIntStream(), (i1, l2) -> {
                    if (416 == (i1 & 0xFF) << 4) {
                        int i2 = (int)l2;
                        int i3 = i2 & 0xF;
                        int i4 = i2 >> 8 & 0xF;
                        int i5 = i2 >> 4 & 0xF;
                        HashMap map = Maps.newHashMap();
                        map.put(dynamic1.createString("id"), dynamic1.createString("minecraft:bed"));
                        map.put(dynamic1.createString("x"), dynamic1.createInt(i3 + (_int << 4)));
                        map.put(dynamic1.createString("y"), dynamic1.createInt(i4 + (_int2 << 4)));
                        map.put(dynamic1.createString("z"), dynamic1.createInt(i5 + (_int1 << 4)));
                        map.put(dynamic1.createString("color"), dynamic1.createShort((short)14));
                        return map;
                    }
                    return null;
                }).forEachOrdered(map -> {
                    if (map != null) {
                        list.add(((Pair)element.read(dynamic1.createMap((Map)map)).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created bed block entity."))).getFirst());
                    }
                });
            }
            return !list.isEmpty() ? typed.set(opticFinder, typed1.set(opticFinder1, (Object)list)) : typed;
        }));
    }
}

