/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.stream.LongStream;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterBitStorageAlign
extends DataFix {
    private static final int a = 6;
    private static final int b = 16;
    private static final int c = 16;
    private static final int d = 4096;
    private static final int e = 9;
    private static final int f = 256;

    public DataConverterBitStorageAlign(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.d);
        Type type1 = type.findFieldType("Level");
        OpticFinder opticFinder = DSL.fieldFinder((String)"Level", (Type)type1);
        OpticFinder opticFinder1 = opticFinder.type().findField("Sections");
        Type element = ((List.ListType)opticFinder1.type()).getElement();
        OpticFinder opticFinder2 = DSL.typeFinder((Type)element);
        Type type2 = DSL.named((String)DataConverterTypes.w.typeName(), (Type)DSL.remainderType());
        OpticFinder opticFinder3 = DSL.fieldFinder((String)"Palette", (Type)DSL.list((Type)type2));
        return this.fixTypeEverywhereTyped("BitStorageAlignFix", type, this.getOutputSchema().getType(DataConverterTypes.d), typed -> typed.updateTyped(opticFinder, typed1 -> this.a(DataConverterBitStorageAlign.a(opticFinder1, opticFinder2, opticFinder3, typed1))));
    }

    private Typed<?> a(Typed<?> data) {
        return data.update(DSL.remainderFinder(), dynamic -> dynamic.update("Heightmaps", dynamic1 -> dynamic1.updateMapValues(pair -> pair.mapSecond(dynamic2 -> DataConverterBitStorageAlign.a(dynamic, dynamic2, 256, 9)))));
    }

    private static Typed<?> a(OpticFinder<?> sectionsFinder, OpticFinder<?> sectionElementFinder, OpticFinder<List<Pair<String, Dynamic<?>>>> paletteFinder, Typed<?> data) {
        return data.updateTyped(sectionsFinder, typed -> typed.updateTyped(sectionElementFinder, typed1 -> {
            int i2 = typed1.getOptional(paletteFinder).map(list -> Math.max(4, DataFixUtils.ceillog2((int)list.size()))).orElse(0);
            return i2 != 0 && !MathHelper.e(i2) ? typed1.update(DSL.remainderFinder(), dynamic -> dynamic.update("BlockStates", dynamic1 -> DataConverterBitStorageAlign.a(dynamic, dynamic1, 4096, i2))) : typed1;
        }));
    }

    private static Dynamic<?> a(Dynamic<?> output, Dynamic<?> data, int numBits, int bitWidth) {
        long[] longs = data.asLongStream().toArray();
        long[] longs1 = DataConverterBitStorageAlign.a(numBits, bitWidth, longs);
        return output.createLongList(LongStream.of(longs1));
    }

    public static long[] a(int numBits, int bitWidth, long[] inputData) {
        int i2 = inputData.length;
        if (i2 == 0) {
            return inputData;
        }
        long l2 = (1L << bitWidth) - 1L;
        int i1 = 64 / bitWidth;
        int i22 = (numBits + i1 - 1) / i1;
        long[] longs = new long[i22];
        int i3 = 0;
        int i4 = 0;
        long l1 = 0L;
        int i5 = 0;
        long l22 = inputData[0];
        long l3 = i2 > 1 ? inputData[1] : 0L;
        for (int i6 = 0; i6 < numBits; ++i6) {
            int i11;
            long l4;
            int i7 = i6 * bitWidth;
            int i8 = i7 >> 6;
            int i9 = (i6 + 1) * bitWidth - 1 >> 6;
            int i10 = i7 ^ i8 << 6;
            if (i8 != i5) {
                l22 = l3;
                l3 = i8 + 1 < i2 ? inputData[i8 + 1] : 0L;
                i5 = i8;
            }
            if (i8 == i9) {
                l4 = l22 >>> i10 & l2;
            } else {
                i11 = 64 - i10;
                l4 = (l22 >>> i10 | l3 << i11) & l2;
            }
            i11 = i4 + bitWidth;
            if (i11 >= 64) {
                longs[i3++] = l1;
                l1 = l4;
                i4 = bitWidth;
                continue;
            }
            l1 |= l4 << i4;
            i4 = i11;
        }
        if (l1 != 0L) {
            longs[i3] = l1;
        }
        return longs;
    }
}

