/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.DataConverterUUIDBase;
import org.slf4j.Logger;

public class DataConverterEntityUUID
extends DataConverterUUIDBase {
    private static final Logger b = LogUtils.getLogger();
    private static final Set<String> c = Sets.newHashSet();
    private static final Set<String> d = Sets.newHashSet();
    private static final Set<String> e = Sets.newHashSet();
    private static final Set<String> f = Sets.newHashSet();
    private static final Set<String> g = Sets.newHashSet();
    private static final Set<String> h = Sets.newHashSet();

    public DataConverterEntityUUID(Schema outputSchema) {
        super(outputSchema, DataConverterTypes.F);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("EntityUUIDFixes", this.getInputSchema().getType(this.a), typed -> {
            typed = typed.update(DSL.remainderFinder(), DataConverterEntityUUID::c);
            for (String string : c) {
                typed = this.a((Typed<?>)typed, string, DataConverterEntityUUID::l);
            }
            for (String string : d) {
                typed = this.a((Typed<?>)typed, string, DataConverterEntityUUID::l);
            }
            for (String string : e) {
                typed = this.a((Typed<?>)typed, string, DataConverterEntityUUID::m);
            }
            for (String string : f) {
                typed = this.a((Typed<?>)typed, string, DataConverterEntityUUID::n);
            }
            for (String string : g) {
                typed = this.a((Typed<?>)typed, string, DataConverterEntityUUID::b);
            }
            for (String string : h) {
                typed = this.a((Typed<?>)typed, string, DataConverterEntityUUID::o);
            }
            typed = this.a((Typed<?>)typed, "minecraft:bee", DataConverterEntityUUID::k);
            typed = this.a((Typed<?>)typed, "minecraft:zombified_piglin", DataConverterEntityUUID::k);
            typed = this.a((Typed<?>)typed, "minecraft:fox", DataConverterEntityUUID::j);
            typed = this.a((Typed<?>)typed, "minecraft:item", DataConverterEntityUUID::i);
            typed = this.a((Typed<?>)typed, "minecraft:shulker_bullet", DataConverterEntityUUID::h);
            typed = this.a((Typed<?>)typed, "minecraft:area_effect_cloud", DataConverterEntityUUID::g);
            typed = this.a((Typed<?>)typed, "minecraft:zombie_villager", DataConverterEntityUUID::f);
            typed = this.a((Typed<?>)typed, "minecraft:evoker_fangs", DataConverterEntityUUID::e);
            return this.a((Typed<?>)typed, "minecraft:piglin", DataConverterEntityUUID::d);
        });
    }

    private static Dynamic<?> d(Dynamic<?> piglinTag) {
        return piglinTag.update("Brain", dynamic -> dynamic.update("memories", dynamic1 -> dynamic1.update("minecraft:angry_at", dynamic2 -> DataConverterEntityUUID.a(dynamic2, "value", "value").orElseGet(() -> {
            b.warn("angry_at has no value.");
            return dynamic2;
        }))));
    }

    private static Dynamic<?> e(Dynamic<?> evokerFangsTag) {
        return DataConverterEntityUUID.c(evokerFangsTag, "OwnerUUID", "Owner").orElse(evokerFangsTag);
    }

    private static Dynamic<?> f(Dynamic<?> zombieVillagerTag) {
        return DataConverterEntityUUID.c(zombieVillagerTag, "ConversionPlayer", "ConversionPlayer").orElse(zombieVillagerTag);
    }

    private static Dynamic<?> g(Dynamic<?> areaEffectCloudTag) {
        return DataConverterEntityUUID.c(areaEffectCloudTag, "OwnerUUID", "Owner").orElse(areaEffectCloudTag);
    }

    private static Dynamic<?> h(Dynamic<?> shulkerBulletTag) {
        shulkerBulletTag = DataConverterEntityUUID.b(shulkerBulletTag, "Owner", "Owner").orElse(shulkerBulletTag);
        return DataConverterEntityUUID.b(shulkerBulletTag, "Target", "Target").orElse(shulkerBulletTag);
    }

    private static Dynamic<?> i(Dynamic<?> itemTag) {
        itemTag = DataConverterEntityUUID.b(itemTag, "Owner", "Owner").orElse(itemTag);
        return DataConverterEntityUUID.b(itemTag, "Thrower", "Thrower").orElse(itemTag);
    }

    private static Dynamic<?> j(Dynamic<?> foxTag) {
        Optional<Dynamic> optional = foxTag.get("TrustedUUIDs").result().map(dynamic -> foxTag.createList(dynamic.asStream().map(dynamic1 -> DataConverterEntityUUID.a(dynamic1).orElseGet(() -> {
            b.warn("Trusted contained invalid data.");
            return dynamic1;
        }))));
        return (Dynamic)((Object)DataFixUtils.orElse(optional.map(dynamic -> foxTag.remove("TrustedUUIDs").set("Trusted", (Dynamic<?>)((Object)dynamic))), foxTag));
    }

    private static Dynamic<?> k(Dynamic<?> tag) {
        return DataConverterEntityUUID.a(tag, "HurtBy", "HurtBy").orElse(tag);
    }

    private static Dynamic<?> l(Dynamic<?> ownerTag) {
        Dynamic<?> dynamic = DataConverterEntityUUID.m(ownerTag);
        return DataConverterEntityUUID.a(dynamic, "OwnerUUID", "Owner").orElse(dynamic);
    }

    private static Dynamic<?> m(Dynamic<?> animalTag) {
        Dynamic<?> dynamic = DataConverterEntityUUID.n(animalTag);
        return DataConverterEntityUUID.c(dynamic, "LoveCause", "LoveCause").orElse(dynamic);
    }

    private static Dynamic<?> n(Dynamic<?> mobTag) {
        return DataConverterEntityUUID.b(mobTag).update("Leash", dynamic -> DataConverterEntityUUID.c(dynamic, "UUID", "UUID").orElse((Dynamic<?>)((Object)dynamic)));
    }

    public static Dynamic<?> b(Dynamic<?> livingEntityTag) {
        return livingEntityTag.update("Attributes", dynamic -> livingEntityTag.createList(dynamic.asStream().map(dynamic1 -> dynamic1.update("Modifiers", dynamic2 -> dynamic1.createList(dynamic2.asStream().map(dynamic3 -> DataConverterEntityUUID.c(dynamic3, "UUID", "UUID").orElse((Dynamic<?>)((Object)((Object)((Object)((Object)dynamic3)))))))))));
    }

    private static Dynamic<?> o(Dynamic<?> projectileTag) {
        return (Dynamic)((Object)DataFixUtils.orElse(projectileTag.get("OwnerUUID").result().map(dynamic -> projectileTag.remove("OwnerUUID").set("Owner", (Dynamic<?>)((Object)dynamic))), projectileTag));
    }

    public static Dynamic<?> c(Dynamic<?> entityTag) {
        return DataConverterEntityUUID.c(entityTag, "UUID", "UUID").orElse(entityTag);
    }

    static {
        c.add("minecraft:donkey");
        c.add("minecraft:horse");
        c.add("minecraft:llama");
        c.add("minecraft:mule");
        c.add("minecraft:skeleton_horse");
        c.add("minecraft:trader_llama");
        c.add("minecraft:zombie_horse");
        d.add("minecraft:cat");
        d.add("minecraft:parrot");
        d.add("minecraft:wolf");
        e.add("minecraft:bee");
        e.add("minecraft:chicken");
        e.add("minecraft:cow");
        e.add("minecraft:fox");
        e.add("minecraft:mooshroom");
        e.add("minecraft:ocelot");
        e.add("minecraft:panda");
        e.add("minecraft:pig");
        e.add("minecraft:polar_bear");
        e.add("minecraft:rabbit");
        e.add("minecraft:sheep");
        e.add("minecraft:turtle");
        e.add("minecraft:hoglin");
        f.add("minecraft:bat");
        f.add("minecraft:blaze");
        f.add("minecraft:cave_spider");
        f.add("minecraft:cod");
        f.add("minecraft:creeper");
        f.add("minecraft:dolphin");
        f.add("minecraft:drowned");
        f.add("minecraft:elder_guardian");
        f.add("minecraft:ender_dragon");
        f.add("minecraft:enderman");
        f.add("minecraft:endermite");
        f.add("minecraft:evoker");
        f.add("minecraft:ghast");
        f.add("minecraft:giant");
        f.add("minecraft:guardian");
        f.add("minecraft:husk");
        f.add("minecraft:illusioner");
        f.add("minecraft:magma_cube");
        f.add("minecraft:pufferfish");
        f.add("minecraft:zombified_piglin");
        f.add("minecraft:salmon");
        f.add("minecraft:shulker");
        f.add("minecraft:silverfish");
        f.add("minecraft:skeleton");
        f.add("minecraft:slime");
        f.add("minecraft:snow_golem");
        f.add("minecraft:spider");
        f.add("minecraft:squid");
        f.add("minecraft:stray");
        f.add("minecraft:tropical_fish");
        f.add("minecraft:vex");
        f.add("minecraft:villager");
        f.add("minecraft:iron_golem");
        f.add("minecraft:vindicator");
        f.add("minecraft:pillager");
        f.add("minecraft:wandering_trader");
        f.add("minecraft:witch");
        f.add("minecraft:wither");
        f.add("minecraft:wither_skeleton");
        f.add("minecraft:zombie");
        f.add("minecraft:zombie_villager");
        f.add("minecraft:phantom");
        f.add("minecraft:ravager");
        f.add("minecraft:piglin");
        g.add("minecraft:armor_stand");
        h.add("minecraft:arrow");
        h.add("minecraft:dragon_fireball");
        h.add("minecraft:firework_rocket");
        h.add("minecraft:fireball");
        h.add("minecraft:llama_spit");
        h.add("minecraft:small_fireball");
        h.add("minecraft:snowball");
        h.add("minecraft:spectral_arrow");
        h.add("minecraft:egg");
        h.add("minecraft:ender_pearl");
        h.add("minecraft:experience_bottle");
        h.add("minecraft:potion");
        h.add("minecraft:trident");
        h.add("minecraft:wither_skull");
    }
}

