/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public abstract class DataConverterItemName
extends DataFix {
    private final String a;

    public DataConverterItemName(Schema outputSchema, String name) {
        super(outputSchema, false);
        this.a = name;
    }

    public TypeRewriteRule makeRule() {
        Type type = DSL.named((String)DataConverterTypes.H.typeName(), DataConverterSchemaNamed.a());
        if (!Objects.equals(this.getInputSchema().getType(DataConverterTypes.H), type)) {
            throw new IllegalStateException("item name type is not what was expected.");
        }
        return this.fixTypeEverywhere(this.a, type, dynamicOps -> pair -> pair.mapSecond(this::a));
    }

    protected abstract String a(String var1);

    public static DataFix a(Schema outputSchema, String name, final Function<String, String> fixer) {
        return new DataConverterItemName(outputSchema, name){

            @Override
            protected String a(String item) {
                return (String)fixer.apply(item);
            }
        };
    }
}

