/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterObjectiveRenderType
extends DataFix {
    public DataConverterObjectiveRenderType(Schema outputSchema) {
        super(outputSchema, false);
    }

    private static String a(String oldRenderType) {
        return oldRenderType.equals("health") ? "hearts" : "integer";
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.L);
        return this.fixTypeEverywhereTyped("ObjectiveRenderTypeFix", type, typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Optional optional = dynamic.get("RenderType").asString().result();
            if (optional.isEmpty()) {
                String string = dynamic.get("CriteriaName").asString("");
                String renderType = DataConverterObjectiveRenderType.a(string);
                return dynamic.set("RenderType", dynamic.createString(renderType));
            }
            return dynamic;
        }));
    }
}

