/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterPOIRebuild
extends DataFix {
    public DataConverterPOIRebuild(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = DSL.named((String)DataConverterTypes.s.typeName(), (Type)DSL.remainderType());
        if (!Objects.equals(type, this.getInputSchema().getType(DataConverterTypes.s))) {
            throw new IllegalStateException("Poi type is not what was expected.");
        }
        return this.fixTypeEverywhere("POI rebuild", type, dynamicOps -> pair -> pair.mapSecond(DataConverterPOIRebuild::a));
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic) {
        return dynamic.update("Sections", dynamic1 -> dynamic1.updateMapValues(pair -> pair.mapSecond(dynamic2 -> dynamic2.remove("Valid"))));
    }
}

