/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.DataConverterAddChoices;
import net.minecraft.util.datafix.fixes.DataConverterLeaves;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class DataConverterTrappedChest
extends DataFix {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 4096;
    private static final short c = 12;

    public DataConverterTrappedChest(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.d);
        Type type1 = type.findFieldType("Level");
        Type type2 = type1.findFieldType("TileEntities");
        if (!(type2 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType listType = (List.ListType)type2;
        OpticFinder opticFinder = DSL.fieldFinder((String)"TileEntities", (Type)listType);
        Type type3 = this.getInputSchema().getType(DataConverterTypes.d);
        OpticFinder opticFinder1 = type3.findField("Level");
        OpticFinder opticFinder2 = opticFinder1.type().findField("Sections");
        Type type4 = opticFinder2.type();
        if (!(type4 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        Type element = ((List.ListType)type4).getElement();
        OpticFinder opticFinder3 = DSL.typeFinder((Type)element);
        return TypeRewriteRule.seq((TypeRewriteRule)new DataConverterAddChoices(this.getOutputSchema(), "AddTrappedChestFix", DataConverterTypes.u).makeRule(), (TypeRewriteRule)this.fixTypeEverywhereTyped("Trapped Chest fix", type3, typed -> typed.updateTyped(opticFinder1, typed1 -> {
            Optional optionalTyped = typed1.getOptionalTyped(opticFinder2);
            if (optionalTyped.isEmpty()) {
                return typed1;
            }
            List allTyped = ((Typed)optionalTyped.get()).getAllTyped(opticFinder3);
            IntOpenHashSet set = new IntOpenHashSet();
            for (Typed typed2 : allTyped) {
                a trappedChestSection = new a(typed2, this.getInputSchema());
                if (trappedChestSection.b()) continue;
                for (int i2 = 0; i2 < 4096; ++i2) {
                    int block = trappedChestSection.c(i2);
                    if (!trappedChestSection.a(block)) continue;
                    set.add(trappedChestSection.c() << 12 | i2);
                }
            }
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)typed1.get(DSL.remainderFinder()))));
            int _int = dynamic.get("xPos").asInt(0);
            int _int1 = dynamic.get("zPos").asInt(0);
            TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(DataConverterTypes.u);
            return typed1.updateTyped(opticFinder, arg_0 -> DataConverterTrappedChest.a(taggedChoiceType, _int, _int1, (IntSet)set, arg_0));
        })));
    }

    private static /* synthetic */ Typed a(TaggedChoice.TaggedChoiceType taggedChoiceType, int _int, int _int1, IntSet set, Typed typed3) {
        return typed3.updateTyped(taggedChoiceType.finder(), typed4 -> {
            int i2;
            int _int2;
            Dynamic dynamic1 = (Dynamic)((Object)((Object)typed4.getOrCreate(DSL.remainderFinder())));
            int i1 = dynamic1.get("x").asInt(0) - (_int << 4);
            return set.contains(DataConverterLeaves.a(i1, _int2 = dynamic1.get("y").asInt(0), i2 = dynamic1.get("z").asInt(0) - (_int1 << 4))) ? typed4.update(taggedChoiceType.finder(), pair -> pair.mapFirst(string -> {
                if (!Objects.equals(string, "minecraft:chest")) {
                    a.warn("Block Entity was expected to be a chest");
                }
                return "minecraft:trapped_chest";
            })) : typed4;
        });
    }

    public static final class a
    extends DataConverterLeaves.b {
        @Nullable
        private IntSet h;

        public a(Typed<?> data, Schema schema) {
            super(data, schema);
        }

        @Override
        protected boolean a() {
            this.h = new IntOpenHashSet();
            for (int i2 = 0; i2 < this.e.size(); ++i2) {
                Dynamic<?> dynamic = this.e.get(i2);
                String string = dynamic.get("Name").asString("");
                if (!Objects.equals(string, "minecraft:trapped_chest")) continue;
                this.h.add(i2);
            }
            return this.h.isEmpty();
        }

        public boolean a(int id) {
            return this.h.contains(id);
        }
    }
}

