/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterUUID
extends DataFix {
    public DataConverterUUID(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("EntityStringUuidFix", this.getInputSchema().getType(DataConverterTypes.F), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Optional optional = dynamic.get("UUID").asString().result();
            if (optional.isPresent()) {
                UUID uuid = UUID.fromString((String)optional.get());
                return dynamic.remove("UUID").set("UUIDMost", dynamic.createLong(uuid.getMostSignificantBits())).set("UUIDLeast", dynamic.createLong(uuid.getLeastSignificantBits()));
            }
            return dynamic;
        }));
    }
}

