/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class EquipmentFormatFix
extends DataFix {
    public EquipmentFormatFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type typeRaw = this.getInputSchema().getTypeRaw(DataConverterTypes.v);
        Type typeRaw1 = this.getOutputSchema().getTypeRaw(DataConverterTypes.v);
        OpticFinder opticFinder = typeRaw.findField("id");
        return this.a(typeRaw, typeRaw1, opticFinder);
    }

    private <ItemStackOld, ItemStackNew> TypeRewriteRule a(Type<ItemStackOld> oldItemStackType, Type<ItemStackNew> newItemStackType, OpticFinder<?> optic) {
        Type type = DSL.named((String)DataConverterTypes.C.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(oldItemStackType))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(oldItemStackType))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", oldItemStackType)), (Type)DSL.optional((Type)DSL.field((String)"saddle", oldItemStackType))));
        Type type1 = DSL.named((String)DataConverterTypes.C.typeName(), (Type)DSL.optional((Type)DSL.field((String)"equipment", (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"mainhand", newItemStackType)), (Type)DSL.optional((Type)DSL.field((String)"offhand", newItemStackType)), (Type)DSL.optional((Type)DSL.field((String)"feet", newItemStackType)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"legs", newItemStackType)), (Type)DSL.optional((Type)DSL.field((String)"chest", newItemStackType)), (Type)DSL.optional((Type)DSL.field((String)"head", newItemStackType)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"body", newItemStackType)), (Type)DSL.optional((Type)DSL.field((String)"saddle", newItemStackType)), (Type)DSL.remainderType()))))));
        if (!type.equals((Object)this.getInputSchema().getType(DataConverterTypes.C))) {
            throw new IllegalStateException("Input entity_equipment type does not match expected");
        }
        if (!type1.equals((Object)this.getOutputSchema().getType(DataConverterTypes.C))) {
            throw new IllegalStateException("Output entity_equipment type does not match expected");
        }
        return this.fixTypeEverywhere("EquipmentFormatFix", type, type1, dynamicOps -> {
            Predicate<Object> predicate = object -> {
                Typed typed = new Typed(oldItemStackType, dynamicOps, object);
                return typed.getOptional(optic).isEmpty();
            };
            return pair -> {
                String string = (String)pair.getFirst();
                Pair pair1 = (Pair)pair.getSecond();
                List list = ((Either)pair1.getFirst()).map(Function.identity(), unit -> List.of());
                List list1 = ((Either)((Pair)pair1.getSecond()).getFirst()).map(Function.identity(), unit -> List.of());
                Either either = (Either)((Pair)((Pair)pair1.getSecond()).getSecond()).getFirst();
                Either either1 = (Either)((Pair)((Pair)pair1.getSecond()).getSecond()).getSecond();
                Either itemFromList = EquipmentFormatFix.a(0, list, predicate);
                Either itemFromList1 = EquipmentFormatFix.a(1, list, predicate);
                Either itemFromList2 = EquipmentFormatFix.a(2, list, predicate);
                Either itemFromList3 = EquipmentFormatFix.a(3, list, predicate);
                Either itemFromList4 = EquipmentFormatFix.a(0, list1, predicate);
                Either itemFromList5 = EquipmentFormatFix.a(1, list1, predicate);
                return EquipmentFormatFix.a(either, either1, itemFromList, itemFromList1, itemFromList2, itemFromList3, itemFromList4, itemFromList5) ? Pair.of((Object)string, Either.right(Unit.INSTANCE)) : Pair.of((Object)string, Either.left(Pair.of(itemFromList4, (Object)Pair.of(itemFromList5, (Object)Pair.of(itemFromList, (Object)Pair.of(itemFromList1, (Object)Pair.of(itemFromList2, (Object)Pair.of(itemFromList3, (Object)Pair.of((Object)either, (Object)Pair.of((Object)either1, new Dynamic(dynamicOps)))))))))));
            };
        });
    }

    @SafeVarargs
    private static boolean a(Either<?, Unit> ... items) {
        for (Either<?, Unit> either : items) {
            if (!either.right().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static <ItemStack> Either<ItemStack, Unit> a(int index, List<ItemStack> list, Predicate<ItemStack> predicate) {
        if (index >= list.size()) {
            return Either.right(Unit.INSTANCE);
        }
        ItemStack object = list.get(index);
        return predicate.test(object) ? Either.right(Unit.INSTANCE) : Either.left(object);
    }
}

