/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class OminousBannerRarityFix
extends DataFix {
    public OminousBannerRarityFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.u);
        Type type1 = this.getInputSchema().getType(DataConverterTypes.v);
        TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(DataConverterTypes.u);
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.H.typeName(), DataConverterSchemaNamed.a()));
        OpticFinder opticFinder1 = type.findField("components");
        OpticFinder opticFinder2 = type1.findField("components");
        OpticFinder opticFinder3 = opticFinder1.type().findField("minecraft:item_name");
        OpticFinder opticFinder4 = DSL.typeFinder((Type)this.getInputSchema().getType(DataConverterTypes.B));
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner block entity common rarity to uncommon rarity fix", type, typed -> {
            Object first = ((Pair)typed.get(taggedChoiceType.finder())).getFirst();
            return first.equals("minecraft:banner") ? this.a((Typed<?>)typed, (OpticFinder<?>)opticFinder1, (OpticFinder<?>)opticFinder3, (OpticFinder<Pair<String, String>>)opticFinder4) : typed;
        }), (TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner item stack common rarity to uncommon rarity fix", type1, typed -> {
            String string = typed.getOptional(opticFinder).map(Pair::getSecond).orElse("");
            return string.equals("minecraft:white_banner") ? this.a((Typed<?>)typed, (OpticFinder<?>)opticFinder2, (OpticFinder<?>)opticFinder3, (OpticFinder<Pair<String, String>>)opticFinder4) : typed;
        }));
    }

    private Typed<?> a(Typed<?> data, OpticFinder<?> componentField, OpticFinder<?> itemNameField, OpticFinder<Pair<String, String>> textComponentField) {
        return data.updateTyped(componentField, typed -> {
            boolean isPresent = typed.getOptionalTyped(itemNameField).flatMap(typed1 -> typed1.getOptional(textComponentField)).map(Pair::getSecond).flatMap(LegacyComponentDataFixUtils::d).filter(string -> string.equals("block.minecraft.ominous_banner")).isPresent();
            return isPresent ? typed.updateTyped(itemNameField, typed1 -> typed1.set(textComponentField, (Object)Pair.of((Object)DataConverterTypes.B.typeName(), (Object)LegacyComponentDataFixUtils.b("block.minecraft.ominous_banner")))).update(DSL.remainderFinder(), dynamic -> dynamic.set("minecraft:rarity", dynamic.createString("uncommon"))) : typed;
        });
    }
}

