/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import org.slf4j.Logger;

public class ParticleUnflatteningFix
extends DataFix {
    private static final Logger a = LogUtils.getLogger();

    public ParticleUnflatteningFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.A);
        Type type1 = this.getOutputSchema().getType(DataConverterTypes.A);
        return this.writeFixAndRead("ParticleUnflatteningFix", type, type1, this::a);
    }

    private <T> Dynamic<T> a(Dynamic<T> tag) {
        Optional optional = tag.asString().result();
        if (optional.isEmpty()) {
            return tag;
        }
        String string = (String)optional.get();
        String[] parts = string.split(" ", 2);
        String string1 = DataConverterSchemaNamed.a(parts[0]);
        Dynamic<T> dynamic = tag.createMap(Map.of(tag.createString("type"), tag.createString(string1)));
        return switch (string1) {
            case "minecraft:item" -> {
                if (parts.length > 1) {
                    yield this.a(dynamic, parts[1]);
                }
                yield dynamic;
            }
            case "minecraft:block", "minecraft:block_marker", "minecraft:falling_dust", "minecraft:dust_pillar" -> {
                if (parts.length > 1) {
                    yield this.b(dynamic, parts[1]);
                }
                yield dynamic;
            }
            case "minecraft:dust" -> {
                if (parts.length > 1) {
                    yield this.d(dynamic, parts[1]);
                }
                yield dynamic;
            }
            case "minecraft:dust_color_transition" -> {
                if (parts.length > 1) {
                    yield this.e(dynamic, parts[1]);
                }
                yield dynamic;
            }
            case "minecraft:sculk_charge" -> {
                if (parts.length > 1) {
                    yield this.f(dynamic, parts[1]);
                }
                yield dynamic;
            }
            case "minecraft:vibration" -> {
                if (parts.length > 1) {
                    yield this.g(dynamic, parts[1]);
                }
                yield dynamic;
            }
            case "minecraft:shriek" -> {
                if (parts.length > 1) {
                    yield this.h(dynamic, parts[1]);
                }
                yield dynamic;
            }
            default -> dynamic;
        };
    }

    private <T> Dynamic<T> a(Dynamic<T> tag, String item) {
        int index = item.indexOf("{");
        Dynamic dynamic = tag.createMap(Map.of(tag.createString("Count"), tag.createInt(1)));
        if (index == -1) {
            dynamic = dynamic.set("id", tag.createString(item));
        } else {
            dynamic = dynamic.set("id", tag.createString(item.substring(0, index)));
            Dynamic<T> dynamic1 = ParticleUnflatteningFix.a(tag.getOps(), item.substring(index));
            if (dynamic1 != null) {
                dynamic = dynamic.set("tag", dynamic1);
            }
        }
        return tag.set("item", dynamic);
    }

    @Nullable
    private static <T> Dynamic<T> a(DynamicOps<T> ops, String tag) {
        try {
            return new Dynamic<T>(ops, MojangsonParser.a(ops).b(tag));
        }
        catch (Exception var3) {
            a.warn("Failed to parse tag: {}", (Object)tag, (Object)var3);
            return null;
        }
    }

    private <T> Dynamic<T> b(Dynamic<T> tag, String block) {
        int index = block.indexOf("[");
        Dynamic dynamic = tag.emptyMap();
        if (index == -1) {
            dynamic = dynamic.set("Name", tag.createString(DataConverterSchemaNamed.a(block)));
        } else {
            dynamic = dynamic.set("Name", tag.createString(DataConverterSchemaNamed.a(block.substring(0, index))));
            Map<Dynamic<T>, Dynamic<T>> map = ParticleUnflatteningFix.c(tag, block.substring(index));
            if (!map.isEmpty()) {
                dynamic = dynamic.set("Properties", tag.createMap(map));
            }
        }
        return tag.set("block_state", dynamic);
    }

    private static <T> Map<Dynamic<T>, Dynamic<T>> c(Dynamic<T> tag, String properties) {
        try {
            HashMap<Dynamic<T>, Dynamic<T>> map = new HashMap<Dynamic<T>, Dynamic<T>>();
            StringReader stringReader = new StringReader(properties);
            stringReader.expect('[');
            stringReader.skipWhitespace();
            while (stringReader.canRead() && stringReader.peek() != ']') {
                stringReader.skipWhitespace();
                String string = stringReader.readString();
                stringReader.skipWhitespace();
                stringReader.expect('=');
                stringReader.skipWhitespace();
                String string1 = stringReader.readString();
                stringReader.skipWhitespace();
                map.put(tag.createString(string), tag.createString(string1));
                if (!stringReader.canRead()) continue;
                if (stringReader.peek() != ',') break;
                stringReader.skip();
            }
            stringReader.expect(']');
            return map;
        }
        catch (Exception var6) {
            a.warn("Failed to parse block properties: {}", (Object)properties, (Object)var6);
            return Map.of();
        }
    }

    private static <T> Dynamic<T> a(Dynamic<T> tag, StringReader reader) throws CommandSyntaxException {
        float _float = reader.readFloat();
        reader.expect(' ');
        float _float1 = reader.readFloat();
        reader.expect(' ');
        float _float2 = reader.readFloat();
        return tag.createList(Stream.of(Float.valueOf(_float), Float.valueOf(_float1), Float.valueOf(_float2)).map(arg_0 -> tag.createFloat(arg_0)));
    }

    private <T> Dynamic<T> d(Dynamic<T> tag, String options) {
        try {
            StringReader stringReader = new StringReader(options);
            Dynamic<T> vector = ParticleUnflatteningFix.a(tag, stringReader);
            stringReader.expect(' ');
            float _float = stringReader.readFloat();
            return tag.set("color", vector).set("scale", tag.createFloat(_float));
        }
        catch (Exception var6) {
            a.warn("Failed to parse particle options: {}", (Object)options, (Object)var6);
            return tag;
        }
    }

    private <T> Dynamic<T> e(Dynamic<T> tag, String options) {
        try {
            StringReader stringReader = new StringReader(options);
            Dynamic<T> vector = ParticleUnflatteningFix.a(tag, stringReader);
            stringReader.expect(' ');
            float _float = stringReader.readFloat();
            stringReader.expect(' ');
            Dynamic<T> vector1 = ParticleUnflatteningFix.a(tag, stringReader);
            return tag.set("from_color", vector).set("to_color", vector1).set("scale", tag.createFloat(_float));
        }
        catch (Exception var7) {
            a.warn("Failed to parse particle options: {}", (Object)options, (Object)var7);
            return tag;
        }
    }

    private <T> Dynamic<T> f(Dynamic<T> tag, String options) {
        try {
            StringReader stringReader = new StringReader(options);
            float _float = stringReader.readFloat();
            return tag.set("roll", tag.createFloat(_float));
        }
        catch (Exception var5) {
            a.warn("Failed to parse particle options: {}", (Object)options, (Object)var5);
            return tag;
        }
    }

    private <T> Dynamic<T> g(Dynamic<T> tag, String options) {
        try {
            StringReader stringReader = new StringReader(options);
            float f2 = (float)stringReader.readDouble();
            stringReader.expect(' ');
            float f1 = (float)stringReader.readDouble();
            stringReader.expect(' ');
            float f22 = (float)stringReader.readDouble();
            stringReader.expect(' ');
            int _int = stringReader.readInt();
            Dynamic dynamic = tag.createIntList(IntStream.of(MathHelper.d(f2), MathHelper.d(f1), MathHelper.d(f22)));
            Dynamic dynamic1 = tag.createMap(Map.of(tag.createString("type"), tag.createString("minecraft:block"), tag.createString("pos"), dynamic));
            return tag.set("destination", dynamic1).set("arrival_in_ticks", tag.createInt(_int));
        }
        catch (Exception var10) {
            a.warn("Failed to parse particle options: {}", (Object)options, (Object)var10);
            return tag;
        }
    }

    private <T> Dynamic<T> h(Dynamic<T> tag, String options) {
        try {
            StringReader stringReader = new StringReader(options);
            int _int = stringReader.readInt();
            return tag.set("delay", tag.createInt(_int));
        }
        catch (Exception var5) {
            a.warn("Failed to parse particle options: {}", (Object)options, (Object)var5);
            return tag;
        }
    }
}

