/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Term;

public final class Scope {
    private static final int b = -1;
    private static final Object c = new Object(){

        public String toString() {
            return "frame";
        }
    };
    private static final int d = 2;
    private Object[] e = new Object[128];
    private int f = 0;
    private int g = 0;
    private int depth;

    public Scope() {
        this.e[0] = c;
        this.e[1] = null;
    }

    private int c(Atom<?> name) {
        for (int i2 = this.f; i2 > this.g; i2 -= 2) {
            Object object = this.e[i2];
            assert (object instanceof Atom);
            if (object != name) continue;
            return i2 + 1;
        }
        return -1;
    }

    public int a(Atom<?> ... names) {
        for (int i2 = this.f; i2 > this.g; i2 -= 2) {
            Object object = this.e[i2];
            assert (object instanceof Atom);
            for (Atom<?> atom : names) {
                if (atom != object) continue;
                return i2 + 1;
            }
        }
        return -1;
    }

    private void a(int requiredCapacity) {
        int i1 = this.f + 1;
        int i2 = i1 + requiredCapacity * 2;
        int i3 = this.e.length;
        if (i2 >= i3) {
            int i32 = SystemUtils.a(i3, i2 + 1);
            Object[] objects = new Object[i32];
            System.arraycopy(this.e, 0, objects, 0, i3);
            this.e = objects;
        }
        assert (this.i());
    }

    private void h() {
        this.f += 2;
        this.e[this.f] = c;
        this.e[this.f + 1] = this.g;
        this.g = this.f;
    }

    public void a() {
        this.a(1);
        this.h();
        assert (this.i());
    }

    private int b(int markerIndex) {
        return (Integer)this.e[markerIndex + 1];
    }

    public void b() {
        assert (this.g != 0);
        this.f = this.g - 2;
        this.g = this.b(this.g);
        assert (this.i());
    }

    public void c() {
        int i2 = this.g;
        int i1 = (this.f - this.g) / 2;
        this.a(i1 + 1);
        this.h();
        int i22 = i2 + 2;
        int i3 = this.f;
        for (int i4 = 0; i4 < i1; ++i4) {
            i3 += 2;
            Object object = this.e[i22];
            assert (object != null);
            this.e[i3] = object;
            this.e[i3 + 1] = null;
            i22 += 2;
        }
        this.f = i3;
        assert (this.i());
    }

    public void d() {
        for (int i2 = this.f; i2 > this.g; i2 -= 2) {
            assert (this.e[i2] instanceof Atom);
            this.e[i2 + 1] = null;
        }
        assert (this.i());
    }

    public void e() {
        int previousMarkerIndex;
        int i2 = previousMarkerIndex = this.b(this.g);
        int i1 = this.g;
        while (i1 < this.f) {
            i2 += 2;
            Object object = this.e[i1 += 2];
            assert (object instanceof Atom);
            Object object1 = this.e[i1 + 1];
            Object object2 = this.e[i2];
            if (object2 != object) {
                this.e[i2] = object;
                this.e[i2 + 1] = object1;
                continue;
            }
            if (object1 == null) continue;
            this.e[i2 + 1] = object1;
        }
        this.f = i2;
        this.g = previousMarkerIndex;
        assert (this.i());
    }

    public <T> void a(Atom<T> atom, @Nullable T value) {
        int i2 = this.c(atom);
        if (i2 != -1) {
            this.e[i2] = value;
        } else {
            this.a(1);
            this.f += 2;
            this.e[this.f] = atom;
            this.e[this.f + 1] = value;
        }
        assert (this.i());
    }

    @Nullable
    public <T> T a(Atom<T> atom) {
        int i2 = this.c(atom);
        return (T)(i2 != -1 ? this.e[i2] : null);
    }

    public <T> T b(Atom<T> atom) {
        int i2 = this.c(atom);
        if (i2 == -1) {
            throw new IllegalArgumentException("No value for atom " + String.valueOf(atom));
        }
        return (T)this.e[i2];
    }

    public <T> T b(Atom<T> atom, T defaultValue) {
        int i2 = this.c(atom);
        return (T)(i2 != -1 ? this.e[i2] : defaultValue);
    }

    @Nullable
    @SafeVarargs
    public final <T> T b(Atom<? extends T> ... atoms) {
        int i2 = this.a(atoms);
        return (T)(i2 != -1 ? this.e[i2] : null);
    }

    @SafeVarargs
    public final <T> T c(Atom<? extends T> ... atoms) {
        int i2 = this.a(atoms);
        if (i2 == -1) {
            throw new IllegalArgumentException("No value for atoms " + Arrays.toString(atoms));
        }
        return (T)this.e[i2];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean flag = true;
        for (int i2 = 0; i2 <= this.f; i2 += 2) {
            Object object = this.e[i2];
            Object object1 = this.e[i2 + 1];
            if (object == c) {
                stringBuilder.append('|');
                flag = true;
                continue;
            }
            if (!flag) {
                stringBuilder.append(',');
            }
            flag = false;
            stringBuilder.append(object).append(':').append(object1);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    public Map<Atom<?>, ?> f() {
        HashMap<Atom, Object> map = new HashMap<Atom, Object>();
        for (int i2 = this.f; i2 > this.g; i2 -= 2) {
            Object object = this.e[i2];
            Object object1 = this.e[i2 + 1];
            map.put((Atom)object, object1);
        }
        return map;
    }

    public boolean g() {
        for (int i2 = this.f; i2 > 0; --i2) {
            if (this.e[i2] != c) continue;
            return false;
        }
        if (this.e[0] != c) {
            throw new IllegalStateException("Corrupted stack");
        }
        return true;
    }

    private boolean i() {
        Object object;
        assert (this.g >= 0);
        assert (this.f >= this.g);
        for (int i2 = 0; i2 <= this.f; i2 += 2) {
            object = this.e[i2];
            if (object == c || object instanceof Atom) continue;
            return false;
        }
        int ix = this.g;
        while (ix != 0) {
            object = this.e[ix];
            if (object != c) {
                return false;
            }
            ix = this.b(ix);
        }
        return true;
    }

    public static <S> Term<S> increaseDepth() {
        class IncreasingDepthTerm<W>
        implements Term<W> {
            public static final IncreasingDepthTerm INSTANCE;

            IncreasingDepthTerm() {
            }

            @Override
            public boolean a(ParseState<W> parseState, Scope scope, Control control) {
                if (++scope.depth > 512) {
                    parseState.b().a(parseState.g(), new IllegalStateException("Too deep"));
                    return false;
                }
                return true;
            }

            static {
                INSTANCE = new IncreasingDepthTerm();
            }
        }
        return IncreasingDepthTerm.INSTANCE;
    }

    public static <S> Term<S> decreaseDepth() {
        class DecreasingDepthTerm<W>
        implements Term<W> {
            public static final DecreasingDepthTerm INSTANCE;

            DecreasingDepthTerm() {
            }

            @Override
            public boolean a(ParseState<W> parseState, Scope scope, Control control) {
                --scope.depth;
                return true;
            }

            static {
                INSTANCE = new DecreasingDepthTerm();
            }
        }
        return DecreasingDepthTerm.INSTANCE;
    }
}

