/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.GameProfilerFillerActive;
import net.minecraft.util.profiling.MethodProfilerResult;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsFilled;
import net.minecraft.util.profiling.metrics.MetricCategory;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class MethodProfiler
implements GameProfilerFillerActive {
    private static final long a = Duration.ofMillis(100L).toNanos();
    private static final Logger c = LogUtils.getLogger();
    private final List<String> d = Lists.newArrayList();
    private final LongList e = new LongArrayList();
    private final Map<String, a> f = Maps.newHashMap();
    private final IntSupplier g;
    private final LongSupplier h;
    private final long i;
    private final int j;
    private String k = "";
    private boolean l;
    @Nullable
    private a m;
    private final BooleanSupplier n;
    private final Set<Pair<String, MetricCategory>> o = new ObjectArraySet();

    public MethodProfiler(LongSupplier getRealTime, IntSupplier getTickTime, BooleanSupplier suppressWarnings) {
        this.i = getRealTime.getAsLong();
        this.h = getRealTime;
        this.j = getTickTime.getAsInt();
        this.g = getTickTime;
        this.n = suppressWarnings;
    }

    @Override
    public void a() {
        if (this.l) {
            c.error("Profiler tick already started - missing endTick()?");
        } else {
            this.l = true;
            this.k = "";
            this.d.clear();
            this.a("root");
        }
    }

    @Override
    public void b() {
        if (!this.l) {
            c.error("Profiler tick already ended - missing startTick()?");
        } else {
            this.c();
            this.l = false;
            if (!this.k.isEmpty()) {
                c.error("Profiler tick ended before path was fully popped (remainder: '{}'). Mismatched push/pop?", LogUtils.defer(() -> MethodProfilerResults.b(this.k)));
            }
        }
    }

    @Override
    public void a(String name) {
        if (!this.l) {
            c.error("Cannot push '{}' to profiler if profiler tick hasn't started - missing startTick()?", (Object)name);
        } else {
            if (!this.k.isEmpty()) {
                this.k = this.k + "\u001e";
            }
            this.k = this.k + name;
            this.d.add(this.k);
            this.e.add(SystemUtils.d());
            this.m = null;
        }
    }

    @Override
    public void a(Supplier<String> nameSupplier) {
        this.a(nameSupplier.get());
    }

    @Override
    public void a(MetricCategory category) {
        this.o.add((Pair<String, MetricCategory>)Pair.of((Object)this.k, (Object)((Object)category)));
    }

    @Override
    public void c() {
        if (!this.l) {
            c.error("Cannot pop from profiler if profiler tick hasn't started - missing startTick()?");
        } else if (this.e.isEmpty()) {
            c.error("Tried to pop one too many times! Mismatched push() and pop()?");
        } else {
            long nanos = SystemUtils.d();
            long l2 = this.e.removeLong(this.e.size() - 1);
            this.d.removeLast();
            long l1 = nanos - l2;
            a currentEntry = this.f();
            currentEntry.c += l1;
            ++currentEntry.d;
            currentEntry.a = Math.max(currentEntry.a, l1);
            currentEntry.b = Math.min(currentEntry.b, l1);
            if (l1 > a && !this.n.getAsBoolean()) {
                c.warn("Something's taking too long! '{}' took aprox {} ms", LogUtils.defer(() -> MethodProfilerResults.b(this.k)), LogUtils.defer(() -> (double)l1 / 1000000.0));
            }
            this.k = this.d.isEmpty() ? "" : this.d.getLast();
            this.m = null;
        }
    }

    @Override
    public void b(String name) {
        this.c();
        this.a(name);
    }

    @Override
    public void b(Supplier<String> nameSupplier) {
        this.c();
        this.a(nameSupplier);
    }

    private a f() {
        if (this.m == null) {
            this.m = this.f.computeIfAbsent(this.k, string -> new a());
        }
        return this.m;
    }

    @Override
    public void a(String counterName, int increment) {
        this.f().e.addTo((Object)counterName, (long)increment);
    }

    @Override
    public void a(Supplier<String> counterNameSupplier, int increment) {
        this.f().e.addTo((Object)counterNameSupplier.get(), (long)increment);
    }

    @Override
    public MethodProfilerResults d() {
        return new MethodProfilerResultsFilled(this.f, this.i, this.j, this.h.getAsLong(), this.g.getAsInt());
    }

    @Override
    @Nullable
    public a c(String entryId) {
        return this.f.get(entryId);
    }

    @Override
    public Set<Pair<String, MetricCategory>> e() {
        return this.o;
    }

    public static class a
    implements MethodProfilerResult {
        long a = Long.MIN_VALUE;
        long b = Long.MAX_VALUE;
        long c;
        long d;
        final Object2LongOpenHashMap<String> e = new Object2LongOpenHashMap();

        @Override
        public long a() {
            return this.c;
        }

        @Override
        public long b() {
            return this.a;
        }

        @Override
        public long c() {
            return this.d;
        }

        @Override
        public Object2LongMap<String> d() {
            return Object2LongMaps.unmodifiable(this.e);
        }
    }
}

