/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import net.minecraft.FileUtils;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.SummaryReporter;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.jfr.event.ChunkGenerationEvent;
import net.minecraft.util.profiling.jfr.event.ChunkRegionReadEvent;
import net.minecraft.util.profiling.jfr.event.ChunkRegionWriteEvent;
import net.minecraft.util.profiling.jfr.event.NetworkSummaryEvent;
import net.minecraft.util.profiling.jfr.event.PacketReceivedEvent;
import net.minecraft.util.profiling.jfr.event.PacketSentEvent;
import net.minecraft.util.profiling.jfr.event.ServerTickTimeEvent;
import net.minecraft.util.profiling.jfr.event.StructureGenerationEvent;
import net.minecraft.util.profiling.jfr.event.WorldLoadFinishedEvent;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;

public class JfrProfiler
implements JvmProfiler {
    private static final Logger g = LogUtils.getLogger();
    public static final String a = "Minecraft";
    public static final String b = "World Generation";
    public static final String c = "Ticking";
    public static final String d = "Network";
    public static final String e = "Storage";
    private static final List<Class<? extends Event>> h = List.of(ChunkGenerationEvent.class, ChunkRegionReadEvent.class, ChunkRegionWriteEvent.class, PacketReceivedEvent.class, PacketSentEvent.class, NetworkSummaryEvent.class, ServerTickTimeEvent.class, StructureGenerationEvent.class, WorldLoadFinishedEvent.class);
    private static final String i = "/flightrecorder-config.jfc";
    private static final DateTimeFormatter j = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd-HHmmss").toFormatter().withZone(ZoneId.systemDefault());
    private static final JfrProfiler k = new JfrProfiler();
    @Nullable
    Recording l;
    private float m;
    private final Map<String, NetworkSummaryEvent.b> n = new ConcurrentHashMap<String, NetworkSummaryEvent.b>();

    private JfrProfiler() {
        h.forEach(FlightRecorder::register);
        FlightRecorder.addPeriodicEvent(ServerTickTimeEvent.class, () -> new ServerTickTimeEvent(this.m).commit());
        FlightRecorder.addPeriodicEvent(NetworkSummaryEvent.class, () -> {
            Iterator<NetworkSummaryEvent.b> iterator = this.n.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().a();
                iterator.remove();
            }
        });
    }

    public static JfrProfiler a() {
        return k;
    }

    @Override
    public boolean a(Environment environment) {
        URL resource = JfrProfiler.class.getResource(i);
        if (resource == null) {
            g.warn("Could not find default flight recorder config at {}", (Object)i);
            return false;
        }
        try {
            boolean var4;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resource.openStream()));){
                var4 = this.a(bufferedReader, environment);
            }
            return var4;
        }
        catch (IOException var8) {
            g.warn("Failed to start flight recorder using configuration at {}", (Object)resource, (Object)var8);
            return false;
        }
    }

    @Override
    public Path b() {
        if (this.l == null) {
            throw new IllegalStateException("Not currently profiling");
        }
        this.n.clear();
        Path destination = this.l.getDestination();
        this.l.stop();
        return destination;
    }

    @Override
    public boolean c() {
        return this.l != null;
    }

    @Override
    public boolean d() {
        return FlightRecorder.isAvailable();
    }

    private boolean a(Reader reader, Environment environment) {
        if (this.c()) {
            g.warn("Profiling already in progress");
            return false;
        }
        try {
            Configuration configuration = Configuration.create(reader);
            String string = j.format(Instant.now());
            this.l = SystemUtils.a(new Recording(configuration), recording -> {
                h.forEach(recording::enable);
                recording.setDumpOnExit(true);
                recording.setToDisk(true);
                recording.setName(String.format(Locale.ROOT, "%s-%s-%s", environment.a(), SharedConstants.b().c(), string));
            });
            Path path = Paths.get(String.format(Locale.ROOT, "debug/%s-%s.jfr", environment.a(), string), new String[0]);
            FileUtils.c(path.getParent());
            this.l.setDestination(path);
            this.l.start();
            this.f();
        }
        catch (IOException | ParseException var6) {
            g.warn("Failed to start jfr profiling", (Throwable)var6);
            return false;
        }
        g.info("Started flight recorder profiling id({}):name({}) - will dump to {} on exit or stop command", new Object[]{this.l.getId(), this.l.getName(), this.l.getDestination()});
        return true;
    }

    private void f() {
        FlightRecorder.addListener(new FlightRecorderListener(){
            final SummaryReporter a = new SummaryReporter(() -> {
                JfrProfiler.this.l = null;
            });

            @Override
            public void recordingStateChanged(Recording recording) {
                if (recording == JfrProfiler.this.l && recording.getState() == RecordingState.STOPPED) {
                    this.a.a(recording.getDestination());
                    FlightRecorder.removeListener(this);
                }
            }
        });
    }

    @Override
    public void a(float currentAverageTickTime) {
        if (ServerTickTimeEvent.TYPE.isEnabled()) {
            this.m = currentAverageTickTime;
        }
    }

    @Override
    public void a(EnumProtocol protocol, PacketType<?> packetType, SocketAddress address, int size) {
        if (PacketReceivedEvent.TYPE.isEnabled()) {
            new PacketReceivedEvent(protocol.a(), packetType.a().b(), packetType.b().toString(), address, size).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.a(address).b(size);
        }
    }

    @Override
    public void b(EnumProtocol protocol, PacketType<?> packetType, SocketAddress address, int size) {
        if (PacketSentEvent.TYPE.isEnabled()) {
            new PacketSentEvent(protocol.a(), packetType.a().b(), packetType.b().toString(), address, size).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.a(address).a(size);
        }
    }

    private NetworkSummaryEvent.b a(SocketAddress remoteAddress) {
        return this.n.computeIfAbsent(remoteAddress.toString(), NetworkSummaryEvent.b::new);
    }

    @Override
    public void a(RegionStorageInfo regionStorageInfo, ChunkCoordIntPair chunkPos, RegionFileCompression version, int bytes) {
        if (ChunkRegionReadEvent.TYPE.isEnabled()) {
            new ChunkRegionReadEvent(regionStorageInfo, chunkPos, version, bytes).commit();
        }
    }

    @Override
    public void b(RegionStorageInfo regionStorageInfo, ChunkCoordIntPair chunkPos, RegionFileCompression version, int bytes) {
        if (ChunkRegionWriteEvent.TYPE.isEnabled()) {
            new ChunkRegionWriteEvent(regionStorageInfo, chunkPos, version, bytes).commit();
        }
    }

    @Override
    @Nullable
    public ProfiledDuration e() {
        if (!WorldLoadFinishedEvent.TYPE.isEnabled()) {
            return null;
        }
        WorldLoadFinishedEvent worldLoadFinishedEvent = new WorldLoadFinishedEvent();
        worldLoadFinishedEvent.begin();
        return success -> worldLoadFinishedEvent.commit();
    }

    @Override
    @Nullable
    public ProfiledDuration a(ChunkCoordIntPair chunkPos, ResourceKey<World> level, String name) {
        if (!ChunkGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        ChunkGenerationEvent chunkGenerationEvent = new ChunkGenerationEvent(chunkPos, level, name);
        chunkGenerationEvent.begin();
        return success -> chunkGenerationEvent.commit();
    }

    @Override
    @Nullable
    public ProfiledDuration a(ChunkCoordIntPair chunkPos, ResourceKey<World> level, Holder<Structure> structure) {
        if (!StructureGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        StructureGenerationEvent structureGenerationEvent = new StructureGenerationEvent(chunkPos, structure, level);
        structureGenerationEvent.begin();
        return success -> {
            structureGenerationEvent.success = success;
            structureGenerationEvent.commit();
        };
    }
}

