/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.profiling.jfr.parse.JfrStatsParser;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SummaryReporter {
    private static final Logger a = LogUtils.getLogger();
    private final Runnable b;

    protected SummaryReporter(Runnable onDeregistration) {
        this.b = onDeregistration;
    }

    public void a(@Nullable Path outputPath) {
        if (outputPath != null) {
            JfrStatsResult jfrStatsResult;
            this.b.run();
            SummaryReporter.a(() -> "Dumped flight recorder profiling to " + String.valueOf(outputPath));
            try {
                jfrStatsResult = JfrStatsParser.a(outputPath);
            }
            catch (Throwable var5) {
                SummaryReporter.a(() -> "Failed to parse JFR recording", var5);
                return;
            }
            try {
                SummaryReporter.a(jfrStatsResult::b);
                Path path = outputPath.resolveSibling("jfr-report-" + StringUtils.substringBefore((String)outputPath.getFileName().toString(), (String)".jfr") + ".json");
                Files.writeString(path, (CharSequence)jfrStatsResult.b(), StandardOpenOption.CREATE);
                SummaryReporter.a(() -> "Dumped recording summary to " + String.valueOf(path));
            }
            catch (Throwable var4) {
                SummaryReporter.a(() -> "Failed to output JFR report", var4);
            }
        }
    }

    private static void a(Supplier<String> message) {
        if (LogUtils.isLoggerActive()) {
            a.info(message.get());
        } else {
            DispenserRegistry.a(message.get());
        }
    }

    private static void a(Supplier<String> message, Throwable throwable) {
        if (LogUtils.isLoggerActive()) {
            a.warn(message.get(), throwable);
        } else {
            DispenserRegistry.a(message.get());
            throwable.printStackTrace(DispenserRegistry.a);
        }
    }
}

