/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.ChunkIdentification;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.IoSummary;
import net.minecraft.util.profiling.jfr.stats.PacketIdentification;
import net.minecraft.util.profiling.jfr.stats.StructureGenStat;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;
import net.minecraft.util.profiling.jfr.stats.TimedStatSummary;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class JfrResultJsonSerializer {
    private static final String b = "bytesPerSecond";
    private static final String c = "count";
    private static final String d = "durationNanosTotal";
    private static final String e = "totalBytes";
    private static final String f = "countPerSecond";
    final Gson a = new GsonBuilder().setPrettyPrinting().setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).create();

    private static void a(PacketIdentification packetIdentification, JsonObject json) {
        json.addProperty("protocolId", packetIdentification.b());
        json.addProperty("packetId", packetIdentification.c());
    }

    private static void a(ChunkIdentification chunkIdentification, JsonObject json) {
        json.addProperty("level", chunkIdentification.a());
        json.addProperty("dimension", chunkIdentification.b());
        json.addProperty("x", (Number)chunkIdentification.c());
        json.addProperty("z", (Number)chunkIdentification.d());
    }

    public String a(JfrStatsResult result) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("startedEpoch", (Number)result.c().toEpochMilli());
        jsonObject.addProperty("endedEpoch", (Number)result.d().toEpochMilli());
        jsonObject.addProperty("durationMs", (Number)result.e().toMillis());
        Duration duration = result.f();
        if (duration != null) {
            jsonObject.addProperty("worldGenDurationMs", (Number)duration.toMillis());
        }
        jsonObject.add("heap", this.a(result.i()));
        jsonObject.add("cpuPercent", this.d(result.h()));
        jsonObject.add("network", this.c(result));
        jsonObject.add("fileIO", this.b(result));
        jsonObject.add("serverTick", this.c(result.g()));
        jsonObject.add("threadAllocation", this.a(result.j()));
        jsonObject.add("chunkGen", this.b(result.a()));
        jsonObject.add("structureGen", this.a(result.r()));
        return this.a.toJson((JsonElement)jsonObject);
    }

    private JsonElement a(GcHeapStat.a summary) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("allocationRateBytesPerSecond", (Number)summary.e());
        jsonObject.addProperty("gcCount", (Number)summary.d());
        jsonObject.addProperty("gcOverHeadPercent", (Number)Float.valueOf(summary.a()));
        jsonObject.addProperty("gcTotalDurationMs", (Number)summary.c().toMillis());
        return jsonObject;
    }

    private JsonElement a(List<StructureGenStat> stats) {
        JsonObject jsonObject = new JsonObject();
        TimedStatSummary<StructureGenStat> timedStatSummary = TimedStatSummary.a(stats);
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("structure", (JsonElement)jsonArray);
        stats.stream().collect(Collectors.groupingBy(StructureGenStat::c)).forEach((string, list) -> {
            JsonObject jsonObject1 = new JsonObject();
            jsonArray.add((JsonElement)jsonObject1);
            jsonObject1.addProperty("name", string);
            TimedStatSummary timedStatSummary1 = TimedStatSummary.a(list);
            jsonObject1.addProperty(c, (Number)timedStatSummary1.d());
            jsonObject1.addProperty(d, (Number)timedStatSummary1.f().toNanos());
            jsonObject1.addProperty("durationNanosAvg", (Number)(timedStatSummary1.f().toNanos() / (long)timedStatSummary1.d()));
            JsonObject jsonObject2 = SystemUtils.a(new JsonObject(), (? super T jsonObject3) -> jsonObject1.add("durationNanosPercentiles", (JsonElement)jsonObject3));
            timedStatSummary1.e().forEach((integer, _double) -> jsonObject2.addProperty("p" + integer, (Number)_double));
            Function<StructureGenStat, JsonElement> function = structureGenStat -> {
                JsonObject jsonObject3 = new JsonObject();
                jsonObject3.addProperty("durationNanos", (Number)structureGenStat.a().toNanos());
                jsonObject3.addProperty("chunkPosX", (Number)structureGenStat.b().h);
                jsonObject3.addProperty("chunkPosZ", (Number)structureGenStat.b().i);
                jsonObject3.addProperty("structureName", structureGenStat.c());
                jsonObject3.addProperty("level", structureGenStat.d());
                jsonObject3.addProperty("success", Boolean.valueOf(structureGenStat.e()));
                return jsonObject3;
            };
            jsonObject.add("fastest", function.apply((StructureGenStat)timedStatSummary.a()));
            jsonObject.add("slowest", function.apply((StructureGenStat)timedStatSummary.b()));
            jsonObject.add("secondSlowest", (JsonElement)(timedStatSummary.c() != null ? function.apply((StructureGenStat)timedStatSummary.c()) : JsonNull.INSTANCE));
        });
        return jsonObject;
    }

    private JsonElement b(List<Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>>> summary) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(d, (Number)summary.stream().mapToDouble(pair1 -> ((TimedStatSummary)pair1.getSecond()).f().toNanos()).sum());
        JsonArray jsonArray = SystemUtils.a(new JsonArray(), (? super T jsonArray1) -> jsonObject.add("status", (JsonElement)jsonArray1));
        for (Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>> pair : summary) {
            TimedStatSummary timedStatSummary = (TimedStatSummary)pair.getSecond();
            JsonObject jsonObject1 = SystemUtils.a(new JsonObject(), arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            jsonObject1.addProperty("state", ((ChunkStatus)pair.getFirst()).toString());
            jsonObject1.addProperty(c, (Number)timedStatSummary.d());
            jsonObject1.addProperty(d, (Number)timedStatSummary.f().toNanos());
            jsonObject1.addProperty("durationNanosAvg", (Number)(timedStatSummary.f().toNanos() / (long)timedStatSummary.d()));
            JsonObject jsonObject2 = SystemUtils.a(new JsonObject(), (? super T jsonObject3) -> jsonObject1.add("durationNanosPercentiles", (JsonElement)jsonObject3));
            timedStatSummary.e().forEach((integer, _double) -> jsonObject2.addProperty("p" + integer, (Number)_double));
            Function<ChunkGenStat, JsonElement> function = chunkGenStat -> {
                JsonObject jsonObject3 = new JsonObject();
                jsonObject3.addProperty("durationNanos", (Number)chunkGenStat.a().toNanos());
                jsonObject3.addProperty("level", chunkGenStat.e());
                jsonObject3.addProperty("chunkPosX", (Number)chunkGenStat.b().h);
                jsonObject3.addProperty("chunkPosZ", (Number)chunkGenStat.b().i);
                jsonObject3.addProperty("worldPosX", (Number)chunkGenStat.c().c());
                jsonObject3.addProperty("worldPosZ", (Number)chunkGenStat.c().d());
                return jsonObject3;
            };
            jsonObject1.add("fastest", function.apply((ChunkGenStat)timedStatSummary.a()));
            jsonObject1.add("slowest", function.apply((ChunkGenStat)timedStatSummary.b()));
            jsonObject1.add("secondSlowest", (JsonElement)(timedStatSummary.c() != null ? function.apply((ChunkGenStat)timedStatSummary.c()) : JsonNull.INSTANCE));
        }
        return jsonObject;
    }

    private JsonElement a(ThreadAllocationStat.a summary) {
        JsonArray jsonArray = new JsonArray();
        summary.a().forEach((string, _double) -> jsonArray.add((JsonElement)SystemUtils.a(new JsonObject(), (? super T jsonObject) -> {
            jsonObject.addProperty("thread", string);
            jsonObject.addProperty(b, (Number)_double);
        })));
        return jsonArray;
    }

    private JsonElement c(List<TickTimeStat> stats) {
        if (stats.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        double[] doubles = stats.stream().mapToDouble(tickTimeStat -> (double)tickTimeStat.b().toNanos() / 1000000.0).toArray();
        DoubleSummaryStatistics doubleSummaryStatistics = DoubleStream.of(doubles).summaryStatistics();
        jsonObject.addProperty("minMs", (Number)doubleSummaryStatistics.getMin());
        jsonObject.addProperty("averageMs", (Number)doubleSummaryStatistics.getAverage());
        jsonObject.addProperty("maxMs", (Number)doubleSummaryStatistics.getMax());
        Map<Integer, Double> map = Percentiles.a(doubles);
        map.forEach((integer, _double) -> jsonObject.addProperty("p" + integer, (Number)_double));
        return jsonObject;
    }

    private JsonElement b(JfrStatsResult result) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("write", this.a(result.o()));
        jsonObject.add("read", this.a(result.p()));
        jsonObject.add("chunksRead", this.a(result.n(), JfrResultJsonSerializer::a));
        jsonObject.add("chunksWritten", this.a(result.m(), JfrResultJsonSerializer::a));
        return jsonObject;
    }

    private JsonElement a(FileIOStat.a summary) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(e, (Number)summary.a());
        jsonObject.addProperty(c, (Number)summary.c());
        jsonObject.addProperty(b, (Number)summary.b());
        jsonObject.addProperty(f, (Number)summary.d());
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("topContributors", (JsonElement)jsonArray);
        summary.f().forEach(pair -> {
            JsonObject jsonObject1 = new JsonObject();
            jsonArray.add((JsonElement)jsonObject1);
            jsonObject1.addProperty("path", (String)pair.getFirst());
            jsonObject1.addProperty(e, (Number)pair.getSecond());
        });
        return jsonObject;
    }

    private JsonElement c(JfrStatsResult result) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("sent", this.a(result.l(), JfrResultJsonSerializer::a));
        jsonObject.add("received", this.a(result.k(), JfrResultJsonSerializer::a));
        return jsonObject;
    }

    private <T> JsonElement a(IoSummary<T> ioSummary, BiConsumer<T, JsonObject> serializer) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(e, (Number)ioSummary.d());
        jsonObject.addProperty(c, (Number)ioSummary.c());
        jsonObject.addProperty(b, (Number)ioSummary.b());
        jsonObject.addProperty(f, (Number)ioSummary.a());
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("topContributors", (JsonElement)jsonArray);
        ioSummary.e().forEach(pair -> {
            JsonObject jsonObject1 = new JsonObject();
            jsonArray.add((JsonElement)jsonObject1);
            Object first = pair.getFirst();
            IoSummary.a countAndSize = (IoSummary.a)pair.getSecond();
            serializer.accept(first, jsonObject1);
            jsonObject1.addProperty(e, (Number)countAndSize.c());
            jsonObject1.addProperty(c, (Number)countAndSize.b());
            jsonObject1.addProperty("averageSize", (Number)Float.valueOf(countAndSize.a()));
        });
        return jsonObject;
    }

    private JsonElement d(List<CpuLoadStat> stats) {
        JsonObject jsonObject = new JsonObject();
        BiFunction<List, ToDoubleFunction, JsonObject> biFunction = (list, toDoubleFunction) -> {
            JsonObject jsonObject1 = new JsonObject();
            DoubleSummaryStatistics doubleSummaryStatistics = list.stream().mapToDouble(toDoubleFunction).summaryStatistics();
            jsonObject1.addProperty("min", (Number)doubleSummaryStatistics.getMin());
            jsonObject1.addProperty("average", (Number)doubleSummaryStatistics.getAverage());
            jsonObject1.addProperty("max", (Number)doubleSummaryStatistics.getMax());
            return jsonObject1;
        };
        jsonObject.add("jvm", (JsonElement)biFunction.apply(stats, CpuLoadStat::a));
        jsonObject.add("userJvm", (JsonElement)biFunction.apply(stats, CpuLoadStat::b));
        jsonObject.add("system", (JsonElement)biFunction.apply(stats, CpuLoadStat::c));
        return jsonObject;
    }
}

