/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics.profiling;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.IntStream;
import net.minecraft.SystemReport;
import net.minecraft.util.profiling.GameProfilerFillerActive;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.MetricsSamplerProvider;
import net.minecraft.util.profiling.metrics.profiling.ProfilerSamplerAdapter;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class ServerMetricsSamplersProvider
implements MetricsSamplerProvider {
    private static final Logger a = LogUtils.getLogger();
    private final Set<MetricSampler> b = new ObjectOpenHashSet();
    private final ProfilerSamplerAdapter c = new ProfilerSamplerAdapter();

    public ServerMetricsSamplersProvider(LongSupplier timeSource, boolean dedicatedServer) {
        this.b.add(ServerMetricsSamplersProvider.a(timeSource));
        if (dedicatedServer) {
            this.b.addAll(ServerMetricsSamplersProvider.a());
        }
    }

    public static Set<MetricSampler> a() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        try {
            a cpuStats = new a();
            IntStream.range(0, cpuStats.a).mapToObj(i2 -> MetricSampler.a("cpu#" + i2, MetricCategory.h, () -> cpuStats.a(i2))).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        catch (Throwable var2) {
            a.warn("Failed to query cpu, no cpu stats will be recorded", var2);
        }
        builder.add((Object)MetricSampler.a("heap MiB", MetricCategory.e, () -> SystemReport.a(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())));
        builder.addAll(MetricsRegistry.a.a());
        return builder.build();
    }

    @Override
    public Set<MetricSampler> a(Supplier<GameProfilerFillerActive> profiles) {
        this.b.addAll(this.c.a(profiles));
        return this.b;
    }

    public static MetricSampler a(final LongSupplier timeSource) {
        Stopwatch stopwatch = Stopwatch.createUnstarted((Ticker)new Ticker(){

            public long read() {
                return timeSource.getAsLong();
            }
        });
        ToDoubleFunction<Stopwatch> toDoubleFunction = stopwatch1 -> {
            if (stopwatch1.isRunning()) {
                stopwatch1.stop();
            }
            long l2 = stopwatch1.elapsed(TimeUnit.NANOSECONDS);
            stopwatch1.reset();
            return l2;
        };
        MetricSampler.d valueIncreasedByPercentage = new MetricSampler.d(2.0f);
        return MetricSampler.a("ticktime", MetricCategory.d, toDoubleFunction, stopwatch).a(Stopwatch::start).a(valueIncreasedByPercentage).a();
    }

    static class a {
        private final SystemInfo b = new SystemInfo();
        private final CentralProcessor c = this.b.getHardware().getProcessor();
        public final int a = this.c.getLogicalProcessorCount();
        private long[][] d = this.c.getProcessorCpuLoadTicks();
        private double[] e = this.c.getProcessorCpuLoadBetweenTicks(this.d);
        private long f;

        a() {
        }

        public double a(int index) {
            long l2 = System.currentTimeMillis();
            if (this.f == 0L || this.f + 501L < l2) {
                this.e = this.c.getProcessorCpuLoadBetweenTicks(this.d);
                this.d = this.c.getProcessorCpuLoadTicks();
                this.f = l2;
            }
            return this.e[index] * 100.0;
        }
    }
}

