/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.TaskScheduler;
import org.slf4j.Logger;

public abstract class IAsyncTaskHandler<R extends Runnable>
implements ProfilerMeasured,
TaskScheduler<R>,
Executor {
    public static final long l = 100000L;
    private final String b;
    private static final Logger c = LogUtils.getLogger();
    private final Queue<R> d = Queues.newConcurrentLinkedQueue();
    private int e;

    protected IAsyncTaskHandler(String name) {
        this.b = name;
        MetricsRegistry.a.a(this);
    }

    public final void executeAllRecentInternalTasks() {
        Runnable run;
        int pending = this.d.size();
        for (int i2 = 0; i2 < pending && (run = (Runnable)this.d.poll()) != null; ++i2) {
            this.d(run);
        }
    }

    protected abstract boolean e(R var1);

    public boolean bO() {
        return Thread.currentThread() == this.aA();
    }

    protected abstract Thread aA();

    protected boolean az() {
        return !this.bO();
    }

    public int bP() {
        return this.d.size();
    }

    @Override
    public String B_() {
        return this.b;
    }

    public <V> CompletableFuture<V> a(Supplier<V> supplier) {
        return this.az() ? CompletableFuture.supplyAsync(supplier, this) : CompletableFuture.completedFuture(supplier.get());
    }

    private CompletableFuture<Void> b(Runnable task) {
        return CompletableFuture.supplyAsync(() -> {
            task.run();
            return null;
        }, this);
    }

    @CheckReturnValue
    public CompletableFuture<Void> g(Runnable task) {
        if (this.az()) {
            return this.b(task);
        }
        task.run();
        return CompletableFuture.completedFuture(null);
    }

    public void h(Runnable task) {
        if (!this.bO()) {
            this.b(task).join();
        } else {
            task.run();
        }
    }

    public void scheduleOnMain(Runnable runnable) {
        this.a_(this.f(runnable));
    }

    @Override
    public void a_(R task) {
        this.d.add(task);
        LockSupport.unpark(this.aA());
    }

    @Override
    public void execute(Runnable task) {
        if (this.az()) {
            this.a_(this.f(task));
        } else {
            task.run();
        }
    }

    public void c(Runnable task) {
        this.execute(task);
    }

    protected void bQ() {
        this.d.clear();
    }

    protected void bR() {
        while (this.G()) {
        }
    }

    protected boolean bS() {
        return this.e > 0;
    }

    public boolean G() {
        Runnable runnable = (Runnable)this.d.peek();
        if (runnable == null) {
            return false;
        }
        if (!this.bS() && !this.e(runnable)) {
            return false;
        }
        this.d((Runnable)this.d.remove());
        return true;
    }

    public void b(BooleanSupplier isDone) {
        ++this.e;
        try {
            while (!isDone.getAsBoolean()) {
                if (this.G()) continue;
                this.F();
            }
        }
        finally {
            --this.e;
        }
    }

    protected void F() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void d(R task) {
        block8: {
            try (Zone zone = TracyClient.beginZone((String)"Task", (boolean)SharedConstants.be);){
                task.run();
            }
            catch (Exception var7) {
                c.error(LogUtils.FATAL_MARKER, "Error executing task on {}", (Object)this.B_(), (Object)var7);
                if (!IAsyncTaskHandler.a(var7)) break block8;
                throw var7;
            }
        }
    }

    @Override
    public List<MetricSampler> bN() {
        return ImmutableList.of((Object)MetricSampler.a(this.b + "-pending-tasks", MetricCategory.b, this::bP));
    }

    public static boolean a(Throwable error) {
        boolean bl;
        if (error instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)error;
            bl = IAsyncTaskHandler.a(reportedException.getCause());
        } else {
            bl = error instanceof OutOfMemoryError || error instanceof StackOverflowError;
        }
        return bl;
    }
}

