/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.mojang.logging.LogUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger a = LogUtils.getLogger();
    private final ThreadGroup b;
    private final AtomicInteger c = new AtomicInteger(1);
    private final String d;

    public NamedThreadFactory(String namePrefix) {
        SecurityManager securityManager = System.getSecurityManager();
        this.b = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.d = namePrefix + "-";
    }

    @Override
    public Thread newThread(Runnable task) {
        Thread thread = new Thread(this.b, task, this.d + this.c.getAndIncrement(), 0L);
        thread.setUncaughtExceptionHandler((thread1, exception) -> {
            a.error("Caught exception in thread {} from {}", (Object)thread1, (Object)task);
            a.error("", exception);
        });
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

