/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class TrapezoidFloat
extends FloatProvider {
    public static final MapCodec<TrapezoidFloat> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("min").forGetter(trapezoidFloat -> Float.valueOf(trapezoidFloat.b)), (App)Codec.FLOAT.fieldOf("max").forGetter(trapezoidFloat -> Float.valueOf(trapezoidFloat.d)), (App)Codec.FLOAT.fieldOf("plateau").forGetter(trapezoidFloat -> Float.valueOf(trapezoidFloat.e))).apply((Applicative)instance, TrapezoidFloat::new)).validate(trapezoidFloat -> {
        if (trapezoidFloat.d < trapezoidFloat.b) {
            return DataResult.error(() -> "Max must be larger than min: [" + trapezoidFloat.b + ", " + trapezoidFloat.d + "]");
        }
        return trapezoidFloat.e > trapezoidFloat.d - trapezoidFloat.b ? DataResult.error(() -> "Plateau can at most be the full span: [" + trapezoidFloat.b + ", " + trapezoidFloat.d + "]") : DataResult.success((Object)trapezoidFloat);
    });
    private final float b;
    private final float d;
    private final float e;

    public static TrapezoidFloat a(float min, float max, float plateau) {
        return new TrapezoidFloat(min, max, plateau);
    }

    private TrapezoidFloat(float min, float max, float plateau) {
        this.b = min;
        this.d = max;
        this.e = plateau;
    }

    @Override
    public float a(RandomSource random) {
        float f2 = this.d - this.b;
        float f1 = (f2 - this.e) / 2.0f;
        float f22 = f2 - f1;
        return this.b + random.i() * f22 + random.i() * f1;
    }

    @Override
    public float a() {
        return this.b;
    }

    @Override
    public float b() {
        return this.d;
    }

    @Override
    public FloatProviderType<?> c() {
        return FloatProviderType.d;
    }

    public String toString() {
        return "trapezoid(" + this.e + ") in [" + this.b + "-" + this.d + "]";
    }
}

