/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.destroystokyo.paper.loottable.PaperLootableInventory;
import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.jetbrains.annotations.Contract;

public interface RandomizableContainer
extends IInventory {
    public static final String b = "LootTable";
    public static final String c = "LootTableSeed";

    @Nullable
    public ResourceKey<LootTable> az_();

    public void a(@Nullable ResourceKey<LootTable> var1);

    default public void a(@Nullable ResourceKey<LootTable> lootTable, long seed) {
        this.a(lootTable);
        this.a(seed);
    }

    public long aC_();

    public void a(long var1);

    public BlockPosition aD_();

    @Nullable
    public World j();

    public static void a(IBlockAccess level, RandomSource random, BlockPosition pos, ResourceKey<LootTable> lootTable) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof RandomizableContainer) {
            RandomizableContainer randomizableContainer = (RandomizableContainer)((Object)tileEntity);
            randomizableContainer.a(lootTable, random.g());
        }
    }

    default public boolean c_(ValueInput input) {
        ResourceKey resourceKey = input.a(b, LootTable.a).orElse(null);
        this.a(resourceKey);
        if (this.lootableData() != null && resourceKey != null) {
            this.lootableData().loadNbt(input);
        }
        this.a(input.a(c, 0L));
        return resourceKey != null && this.lootableData() == null;
    }

    default public boolean d_(ValueOutput output) {
        long lootTableSeed;
        ResourceKey<LootTable> lootTable = this.az_();
        if (lootTable == null) {
            return false;
        }
        output.a(b, LootTable.a, lootTable);
        if (this.lootableData() != null) {
            this.lootableData().saveNbt(output);
        }
        if ((lootTableSeed = this.aC_()) != 0L) {
            output.a(c, lootTableSeed);
        }
        return this.lootableData() == null;
    }

    default public void e_(@Nullable EntityHuman player) {
        this.unpackLootTable(player, false);
    }

    default public void unpackLootTable(@Nullable EntityHuman player, boolean forceClearLootTable) {
        World level = this.j();
        BlockPosition blockPos = this.aD_();
        ResourceKey<LootTable> lootTable = this.az_();
        if (lootTable != null && level != null && level.q() != null) {
            if (this.lootableData() != null && !this.lootableData().shouldReplenish(this, PaperLootableInventoryData.CONTAINER, player)) {
                if (forceClearLootTable) {
                    this.a((ResourceKey<LootTable>)null);
                }
            } else {
                LootTable lootTable1 = level.q().bi().a(lootTable);
                if (player instanceof EntityPlayer) {
                    CriterionTriggers.Q.a((EntityPlayer)player, lootTable);
                }
                if (forceClearLootTable || this.lootableData() == null || this.lootableData().shouldClearLootTable(this, PaperLootableInventoryData.CONTAINER, player)) {
                    this.a((ResourceKey<LootTable>)null);
                }
                LootParams.a builder = new LootParams.a((WorldServer)level).a(LootContextParameters.h, Vec3D.b(blockPos));
                if (player != null) {
                    builder.a(player.ew()).a(LootContextParameters.a, player);
                }
                lootTable1.a(this, builder.a(LootContextParameterSets.c), this.aC_());
            }
        }
    }

    @Nullable
    @Contract(pure=true)
    default public PaperLootableInventoryData lootableData() {
        return null;
    }

    default public PaperLootableInventory getLootableInventory() {
        CraftBlock block = CraftBlock.at(Objects.requireNonNull(this.j(), "Cannot manage loot tables on block entities not in world"), this.aD_());
        return (PaperLootableInventory)block.getState(false);
    }
}

