/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import com.google.common.collect.Lists;
import io.papermc.paper.world.damagesource.PaperCombatTrackerWrapper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.CommonLinks;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.damagesource.FallLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import org.purpurmc.purpur.PurpurConfig;

public class CombatTracker {
    public static final int a = 100;
    public static final int b = 300;
    private static final ChatModifier c = ChatModifier.a.a(new ChatClickable.OpenUrl(CommonLinks.w)).a(new ChatHoverable.e(IChatBaseComponent.b("MCPE-28723")));
    public final List<CombatEntry> d = Lists.newArrayList();
    public final EntityLiving e;
    private int f;
    private int g;
    private int h;
    public boolean i;
    public boolean j;
    public final PaperCombatTrackerWrapper paperCombatTracker;

    public CombatTracker(EntityLiving mob) {
        this.e = mob;
        this.paperCombatTracker = new PaperCombatTrackerWrapper(this);
    }

    public void a(DamageSource source, float damage) {
        this.c();
        FallLocation currentFallLocation = FallLocation.a(this.e);
        CombatEntry combatEntry = new CombatEntry(source, damage, currentFallLocation, (float)this.e.an);
        this.recordDamageAndCheckCombatState(combatEntry);
    }

    public void recordDamageAndCheckCombatState(CombatEntry combatEntry) {
        DamageSource source = combatEntry.a();
        this.d.add(combatEntry);
        this.f = this.e.at;
        this.j = true;
        if (!this.i && this.e.bX() && CombatTracker.a(source)) {
            this.i = true;
            this.h = this.g = this.e.at;
            this.e.i_();
        }
    }

    private static boolean a(DamageSource source) {
        return source.d() instanceof EntityLiving;
    }

    private IChatBaseComponent a(Entity entity, IChatBaseComponent entityDisplayName, String hasWeaponTranslationKey, String noWeaponTranslationKey) {
        ItemStack itemStack;
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            itemStack = livingEntity.fq();
        } else {
            itemStack = ItemStack.l;
        }
        ItemStack itemStack2 = itemStack;
        return !itemStack2.f() && (PurpurConfig.playerDeathsAlwaysShowItem || itemStack2.c(DataComponents.g)) ? IChatBaseComponent.a(hasWeaponTranslationKey, this.e.S_(), entityDisplayName, itemStack2.K()) : IChatBaseComponent.a(noWeaponTranslationKey, this.e.S_(), entityDisplayName);
    }

    private IChatBaseComponent a(CombatEntry combatEntry, @Nullable Entity entity) {
        DamageSource damageSource = combatEntry.a();
        if (!damageSource.a(DamageTypeTags.m) && !damageSource.a(DamageTypeTags.s)) {
            IChatBaseComponent displayName = CombatTracker.a(entity);
            Entity entity1 = damageSource.d();
            IChatBaseComponent displayName1 = CombatTracker.a(entity1);
            if (displayName1 != null && !displayName1.equals(displayName)) {
                return this.a(entity1, displayName1, "death.fell.assist.item", "death.fell.assist");
            }
            return displayName != null ? this.a(entity, displayName, "death.fell.finish.item", "death.fell.finish") : IChatBaseComponent.a("death.fell.killer", this.e.S_());
        }
        FallLocation fallLocation = Objects.requireNonNullElse(combatEntry.c(), FallLocation.a);
        return IChatBaseComponent.a(fallLocation.a(), this.e.S_());
    }

    @Nullable
    private static IChatBaseComponent a(@Nullable Entity entity) {
        return entity == null ? null : entity.S_();
    }

    public IChatBaseComponent a() {
        if (this.d.isEmpty()) {
            return IChatBaseComponent.a("death.attack.generic", this.e.S_());
        }
        CombatEntry combatEntry = this.d.get(this.d.size() - 1);
        DamageSource damageSource = combatEntry.a();
        CombatEntry mostSignificantFall = this.d();
        DeathMessageType deathMessageType = damageSource.k().e();
        if (deathMessageType == DeathMessageType.b && mostSignificantFall != null) {
            return this.a(mostSignificantFall, damageSource.d());
        }
        if (deathMessageType == DeathMessageType.c) {
            String string = "death.attack." + damageSource.f();
            IChatMutableComponent component = ChatComponentUtils.a(IChatBaseComponent.c(string + ".link")).c(c);
            return IChatBaseComponent.a(string + ".message", this.e.S_(), component);
        }
        if (damageSource.isScissors()) {
            return damageSource.getLocalizedDeathMessage(PurpurConfig.deathMsgRunWithScissors, this.e);
        }
        if (damageSource.isStonecutter()) {
            return damageSource.getLocalizedDeathMessage(PurpurConfig.deathMsgStonecutter, this.e);
        }
        return damageSource.a(this.e);
    }

    @Nullable
    public CombatEntry d() {
        CombatEntry combatEntry = null;
        CombatEntry combatEntry1 = null;
        float f2 = 0.0f;
        float f1 = 0.0f;
        for (int i2 = 0; i2 < this.d.size(); ++i2) {
            float f22;
            CombatEntry combatEntry2 = this.d.get(i2);
            CombatEntry combatEntry3 = i2 > 0 ? this.d.get(i2 - 1) : null;
            DamageSource damageSource = combatEntry2.a();
            boolean isAlwaysMostSignificantFall = damageSource.a(DamageTypeTags.s);
            float f3 = f22 = isAlwaysMostSignificantFall ? Float.MAX_VALUE : combatEntry2.d();
            if ((damageSource.a(DamageTypeTags.m) || isAlwaysMostSignificantFall) && f22 > 0.0f && (combatEntry == null || f22 > f1)) {
                combatEntry = i2 > 0 ? combatEntry3 : combatEntry2;
                f1 = f22;
            }
            if (combatEntry2.c() == null || combatEntry1 != null && !(combatEntry2.b() > f2)) continue;
            combatEntry1 = combatEntry2;
            f2 = combatEntry2.b();
        }
        if (f1 > 5.0f && combatEntry != null) {
            return combatEntry;
        }
        return f2 > 5.0f && combatEntry1 != null ? combatEntry1 : null;
    }

    public int b() {
        return this.i ? this.e.at - this.g : this.h - this.g;
    }

    public void c() {
        int i2;
        int n2 = i2 = this.i ? 300 : 100;
        if (this.j && (!this.e.bX() || this.e.at - this.f > i2)) {
            this.resetCombatState();
        }
    }

    public void resetCombatState() {
        boolean flag = this.i;
        this.j = false;
        this.i = false;
        this.h = this.e.at;
        if (flag) {
            this.e.Q_();
        }
        this.d.clear();
    }
}

