/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import java.util.function.ToIntFunction;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.joml.Vector3f;

class InfestedMobEffect
extends MobEffectList {
    private final float c;
    private final ToIntFunction<RandomSource> d;

    protected InfestedMobEffect(MobEffectInfo category, int color, float chanceToSpawn, ToIntFunction<RandomSource> spawnedCount) {
        super(category, color, Particles.H);
        this.c = chanceToSpawn;
        this.d = spawnedCount;
    }

    @Override
    public void a(WorldServer level, EntityLiving entity, int amplifier, DamageSource damageSource, float amount) {
        if (entity.ek().i() <= this.c) {
            int i2 = this.d.applyAsInt(entity.ek());
            for (int i1 = 0; i1 < i2; ++i1) {
                this.a(level, entity, entity.dK(), entity.dM() + (double)entity.dB() / 2.0, entity.dQ());
            }
        }
    }

    private void a(WorldServer level, EntityLiving entity, double x2, double y2, double z2) {
        EntitySilverfish silverfish = EntityTypes.bj.a(level, EntitySpawnReason.k);
        if (silverfish != null) {
            RandomSource random = entity.ek();
            float f2 = 1.5707964f;
            float f1 = MathHelper.b(random, -1.5707964f, 1.5707964f);
            Vector3f vector3f = entity.cf().l().mul(0.3f).mul(1.0f, 1.5f, 1.0f).rotateY(f1);
            silverfish.b(x2, y2, z2, level.I_().i() * 360.0f, 0.0f);
            silverfish.k(new Vec3D(vector3f));
            if (!level.addFreshEntity(silverfish, CreatureSpawnEvent.SpawnReason.POTION_EFFECT)) {
                return;
            }
            silverfish.a(SoundEffects.ze);
        }
    }
}

