/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import ca.spottedleaf.moonrise.common.util.ThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerEntity;
import com.destroystokyo.paper.event.entity.EntityTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.entity.activation.ActivationRange;
import io.papermc.paper.entity.activation.ActivationType;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.SizeLimitedSet;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.debug.DebugEntityBlockIntersection;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements SyncedDataHolder,
DebugValueSource,
INamableTileEntity,
ItemOwner,
EntityAccess,
ScoreHolder,
DataComponentGetter,
ChunkSystemEntity,
EntityTrackerEntity {
    public static ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("rhino");
    private static final int CURRENT_LEVEL = 2;
    public static RandomSource SHARED_RANDOM = new RandomRandomSource();
    @Nullable
    public CreatureSpawnEvent.SpawnReason spawnReason;
    @Nullable
    private volatile CraftEntity bukkitEntity;
    private static final Logger b = LogUtils.getLogger();
    public static final String v = "id";
    public static final String w = "UUID";
    public static final String x = "Passengers";
    public static final String y = "data";
    public static final String z = "Pos";
    public static final String A = "Motion";
    public static final String B = "Rotation";
    public static final String C = "PortalCooldown";
    public static final String D = "NoGravity";
    public static final String E = "Air";
    public static final String F = "OnGround";
    public static final String G = "fall_distance";
    public static final String H = "Fire";
    public static final String I = "Silent";
    public static final String J = "Glowing";
    public static final String K = "Invulnerable";
    public static final String L = "CustomName";
    private static final AtomicInteger c = new AtomicInteger();
    public static final int M = 0;
    public static final int N = 60;
    public static final int O = 300;
    public static final int P = 1024;
    private static final Codec<List<String>> d = Codec.STRING.sizeLimitedListOf(1024);
    public static final float Q = 0.2f;
    public static final double R = 0.500001;
    public static final double S = 0.999999;
    public static final int T = 140;
    public static final int U = 40;
    public static final int V = 3;
    private static final AxisAlignedBB e = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double r = 0.014;
    private static final double s = 0.007;
    private static final double t = 0.0023333333333333335;
    private static final int u = 16;
    private static final double aN = 8.0;
    private static double aO = 1.0;
    private final EntityTypes<?> aP;
    private boolean aQ;
    private int aR = c.incrementAndGet();
    public boolean W;
    public ImmutableList<Entity> aS = ImmutableList.of();
    protected int X;
    @Nullable
    private Entity aT;
    private net.minecraft.world.level.World aU;
    public double Y;
    public double Z;
    public double aa;
    private Vec3D aV;
    private BlockPosition aW;
    private ChunkCoordIntPair aX;
    private Vec3D aY = Vec3D.c;
    private float aZ;
    private float ba;
    public float ab;
    public float ac;
    private AxisAlignedBB bb = e;
    public boolean bc;
    public boolean ad;
    public boolean ae;
    public boolean af;
    public boolean ag;
    public boolean ah;
    protected Vec3D ai = Vec3D.c;
    @Nullable
    private RemovalReason bd;
    public static final float aj = 0.6f;
    public static final float ak = 1.8f;
    public float al;
    public float am;
    public double an;
    private float be = 1.0f;
    public double ao;
    public double ap;
    public double aq;
    public float maxUpStep;
    public boolean ar;
    public final RandomSource as;
    public int at;
    private int bf;
    public boolean au;
    protected Object2DoubleMap<TagKey<FluidType>> av = new Object2DoubleArrayMap(2);
    protected boolean aw;
    private final Set<TagKey<FluidType>> bg = new HashSet<TagKey<FluidType>>();
    public int ax;
    protected boolean ay = true;
    protected final DataWatcher az;
    protected static final DataWatcherObject<Byte> aA = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int aB = 0;
    private static final int bh = 1;
    private static final int bi = 3;
    private static final int bj = 4;
    public static final int bk = 5;
    protected static final int aC = 6;
    protected static final int aD = 7;
    private static final DataWatcherObject<Integer> bl = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> bm = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> bn = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bo = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bp = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> aE = DataWatcher.a(Entity.class, DataWatcherRegistry.v);
    public static final DataWatcherObject<Integer> bq = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback br = EntityInLevelCallback.a;
    private final VecDeltaCodec bs = new VecDeltaCodec();
    public boolean aF;
    @Nullable
    public PortalProcessor aG;
    public int bt;
    private boolean bu;
    protected UUID aH;
    protected String aI;
    private boolean bv;
    private final Set<String> bw = new SizeLimitedSet(new ObjectOpenHashSet(), 1024);
    private final double[] bx = new double[]{0.0, 0.0, 0.0};
    private long by;
    protected EntitySize bz;
    private float bA;
    public boolean aJ;
    public boolean aK;
    public Optional<BlockPosition> aL = Optional.empty();
    private boolean bB = false;
    private float bC;
    private int bD;
    public TriState visualFire = TriState.NOT_SET;
    @Nullable
    private IBlockData bF = null;
    public static final int aM = 100;
    private final ArrayDeque<c> bG = new ArrayDeque(100);
    private final List<c> bH = new ObjectArrayList();
    private final LongSet bI = new LongOpenHashSet();
    private final InsideBlockEffectApplier.a bJ = new InsideBlockEffectApplier.a();
    private CustomData bK = CustomData.a;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    @Nullable
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    @Nullable
    public BlockPosition lastLavaContact;
    public boolean pluginRemoved = false;
    protected int numCollisions = 0;
    public boolean fromNetherPortal;
    public boolean spawnedViaMobSpawner;
    @Nullable
    public Vec3D origin;
    @Nullable
    public UUID originWorld;
    public boolean freezeLocked = false;
    public boolean fixedPose = false;
    private final int despawnTime;
    public int totalEntityAge;
    public final ActivationType activationType = ActivationType.activationTypeFor(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    @Nullable
    public Boolean immuneToFire = null;
    private final boolean isHardColliding = this.moonrise$isHardCollidingUncached();
    private FullChunkStatus chunkStatus;
    private ChunkData chunkData;
    private int sectionX = Integer.MIN_VALUE;
    private int sectionY = Integer.MIN_VALUE;
    private int sectionZ = Integer.MIN_VALUE;
    private boolean updatingSectionStatus;
    private PlayerChunkMap.EntityTracker trackedEntity;
    public final Object posLock = new Object();
    @Nullable
    private Vec3D moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;
    public BlockPosition portalPos = BlockPosition.c;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return Entity.this.getBukkitEntity();
        }

        @Override
        public boolean z_() {
            return ((WorldServer)Entity.this.an()).S().c(GameRules.q);
        }

        @Override
        public boolean A_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }
    };
    @Nullable
    private EntityHuman rider = null;

    static boolean isLevelAtLeast(ValueInput input, int level) {
        return input.a("Bukkit.updateLevel", 2) >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            Entity entity = this;
            synchronized (entity) {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = CraftEntity.getEntity(this.aU.getCraftServer(), this);
                    return this.bukkitEntity;
                }
            }
        }
        return this.bukkitEntity;
    }

    @Nullable
    public CraftEntity getBukkitEntityRaw() {
        return this.bukkitEntity;
    }

    public void inactiveTick() {
    }

    public final AxisAlignedBB getBoundingBoxAt(double x2, double y2, double z2) {
        return this.bz.a(x2, y2, z2);
    }

    @Override
    public final boolean moonrise$isHardColliding() {
        return this.isHardColliding;
    }

    @Override
    public final FullChunkStatus moonrise$getChunkStatus() {
        return this.chunkStatus;
    }

    @Override
    public final void moonrise$setChunkStatus(FullChunkStatus status) {
        this.chunkStatus = status;
    }

    @Override
    public final ChunkData moonrise$getChunkData() {
        return this.chunkData;
    }

    @Override
    public final void moonrise$setChunkData(ChunkData chunkData) {
        this.chunkData = chunkData;
    }

    @Override
    public final int moonrise$getSectionX() {
        return this.sectionX;
    }

    @Override
    public final void moonrise$setSectionX(int x2) {
        this.sectionX = x2;
    }

    @Override
    public final int moonrise$getSectionY() {
        return this.sectionY;
    }

    @Override
    public final void moonrise$setSectionY(int y2) {
        this.sectionY = y2;
    }

    @Override
    public final int moonrise$getSectionZ() {
        return this.sectionZ;
    }

    @Override
    public final void moonrise$setSectionZ(int z2) {
        this.sectionZ = z2;
    }

    @Override
    public final boolean moonrise$isUpdatingSectionStatus() {
        return this.updatingSectionStatus;
    }

    @Override
    public final void moonrise$setUpdatingSectionStatus(boolean to) {
        this.updatingSectionStatus = to;
    }

    @Override
    public final boolean moonrise$hasAnyPlayerPassengers() {
        if (this.aS.isEmpty()) {
            return false;
        }
        return this.J().anyMatch(entity -> entity instanceof EntityHuman);
    }

    private static float[] calculateStepHeights(AxisAlignedBB box, List<VoxelShape> voxels, List<AxisAlignedBB> aabbs, float stepHeight, float collidedY) {
        Object shape;
        int i2;
        FloatArraySet ret = new FloatArraySet();
        int len = voxels.size();
        for (i2 = 0; i2 < len; ++i2) {
            double yUnoffset;
            double y2;
            float step;
            shape = voxels.get(i2);
            double[] yCoords = shape.moonrise$rootCoordinatesY();
            double yOffset = shape.moonrise$offsetY();
            double[] dArray = yCoords;
            int n2 = dArray.length;
            for (int i3 = 0; i3 < n2 && !((step = (float)((y2 = (yUnoffset = dArray[i3]) + yOffset) - box.b)) > stepHeight); ++i3) {
                if (step < 0.0f || step == collidedY) continue;
                ret.add(step);
            }
        }
        len = aabbs.size();
        for (i2 = 0; i2 < len; ++i2) {
            shape = aabbs.get(i2);
            float step1 = (float)(((AxisAlignedBB)shape).b - box.b);
            float step2 = (float)(((AxisAlignedBB)shape).e - box.b);
            if (!(step1 < 0.0f) && step1 != collidedY && !(step1 > stepHeight)) {
                ret.add(step1);
            }
            if (step2 < 0.0f || step2 == collidedY || step2 > stepHeight) continue;
            ret.add(step2);
        }
        float[] steps = ret.toFloatArray();
        FloatArrays.unstableSort((float[])steps);
        return steps;
    }

    @Override
    public final PlayerChunkMap.EntityTracker moonrise$getTrackedEntity() {
        return this.trackedEntity;
    }

    @Override
    public final void moonrise$setTrackedEntity(PlayerChunkMap.EntityTracker trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    private static void collectIndirectPassengers(List<Entity> into, List<Entity> from) {
        for (Entity passenger : from) {
            into.add(passenger);
            Entity.collectIndirectPassengers(into, passenger.aS);
        }
    }

    public boolean canSaveToDisk() {
        return true;
    }

    public boolean gC() {
        if (this.an().aa() && !this.an().D_()) {
            boolean flag;
            float lightLevelDependentMagicValue = this.bK();
            BlockPosition blockPos = BlockPosition.a(this.dK(), this.dO(), this.dQ());
            boolean bl = flag = this.bw() || this.aJ || this.aK;
            if (lightLevelDependentMagicValue > 0.5f && this.as.i() * 30.0f < (lightLevelDependentMagicValue - 0.4f) * 2.0f && !flag && this.an().h(blockPos)) {
                return true;
            }
        }
        return false;
    }

    public Entity(EntityTypes<?> type, net.minecraft.world.level.World level) {
        this.aP = type;
        this.aU = level;
        this.bz = type.n();
        this.as = level == null || level.purpurConfig.entitySharedRandom ? SHARED_RANDOM : RandomSource.a();
        this.aH = MathHelper.a(this.as);
        this.aI = this.aH.toString();
        this.aV = Vec3D.c;
        this.aW = BlockPosition.c;
        this.aX = ChunkCoordIntPair.e;
        this.defaultActivationState = level != null ? ActivationRange.initializeEntityActivationState(this, level.spigotConfig) : false;
        DataWatcher.a builder = new DataWatcher.a(this);
        builder.a(aA, (byte)0);
        builder.a(bl, this.cE());
        builder.a(bn, false);
        builder.a(bm, Optional.empty());
        builder.a(bo, false);
        builder.a(bp, false);
        builder.a(aE, EntityPose.a);
        builder.a(bq, 0);
        this.a(builder);
        this.az = builder.a();
        this.a_(0.0, 0.0, 0.0);
        this.bA = this.bz.c();
        this.despawnTime = level == null || type == EntityTypes.bX ? -1 : ((IntOr.Disabled)level.paperConfig().entities.spawning.despawnTime.getOrDefault(type, (Object)IntOr.Disabled.DISABLED)).or(-1);
    }

    public boolean a(BlockPosition pos, IBlockData state) {
        VoxelShape voxelShape = state.b((IBlockAccess)this.an(), pos, VoxelShapeCollision.a(this)).a(pos);
        return VoxelShapes.c(voxelShape, VoxelShapes.a(this.de()), OperatorBoolean.i);
    }

    public int j_() {
        ScoreboardTeam team = this.cD();
        return team != null && ((ScoreboardTeamBase)team).o().f() != null ? ((ScoreboardTeamBase)team).o().f() : 0xFFFFFF;
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public boolean at() {
        return false;
    }

    public boolean au() {
        return this.bX() && !this.ec() && !this.at();
    }

    public final void av() {
        if (this.cm()) {
            this.ca();
        }
        if (this.cl()) {
            this.cb();
        }
    }

    public void e(double x2, double y2, double z2) {
        this.bs.e(new Vec3D(x2, y2, z2));
    }

    public VecDeltaCodec aw() {
        return this.bs;
    }

    public EntityTypes<?> ax() {
        return this.aP;
    }

    public boolean ay() {
        return this.aQ;
    }

    public void c(boolean requiresPrecisePosition) {
        this.aQ = requiresPrecisePosition;
    }

    @Override
    public int az() {
        return this.aR;
    }

    public void e(int id) {
        this.aR = id;
    }

    public Set<String> aA() {
        return this.bw;
    }

    public boolean a(String tag) {
        return this.bw.add(tag);
    }

    public boolean b(String tag) {
        return this.bw.remove(tag);
    }

    public void c(WorldServer level) {
        this.remove(RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.c(GameEvent.p);
    }

    public final void aB() {
        this.discard(null);
    }

    public final void discard(@Nullable EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.b, cause);
    }

    protected abstract void a(DataWatcher.a var1);

    public DataWatcher aC() {
        return this.az;
    }

    public void refreshEntityData(EntityPlayer to) {
        List<DataWatcher.c<?>> list = this.az.packAll();
        if (to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            to.g.b(new PacketPlayOutEntityMetadata(this.az(), list));
        }
    }

    public void resendPossiblyDesyncedEntityData(EntityPlayer player) {
        if (player.getBukkitEntity().canSee(this.getBukkitEntity())) {
            PlayerChunkMap.EntityTracker tracker;
            WorldServer world = (WorldServer)this.an();
            PlayerChunkMap.EntityTracker entityTracker = tracker = world == null ? null : (PlayerChunkMap.EntityTracker)world.n().a.J.get(this.az());
            if (tracker == null) {
                return;
            }
            EntityTrackerEntry serverEntity = tracker.b;
            ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
            serverEntity.a(player, list::add);
            player.g.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        }
    }

    public void resendPossiblyDesyncedDataValues(List<DataWatcherObject<?>> keys, EntityPlayer to) {
        if (!to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            return;
        }
        ArrayList values = new ArrayList(keys.size());
        for (DataWatcherObject<?> key : keys) {
            DataWatcher.Item<?> synchedValue = this.az.b(key);
            values.add(synchedValue.e());
        }
        to.g.b(new PacketPlayOutEntityMetadata(this.aR, values));
    }

    public boolean equals(Object other) {
        return other instanceof Entity && ((Entity)other).aR == this.aR;
    }

    public int hashCode() {
        return this.aR;
    }

    public void a(RemovalReason reason) {
        this.remove(reason, null);
    }

    public void remove(RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        this.setRemoved(reason, eventCause);
    }

    public void aD() {
    }

    public void b(RemovalReason reason) {
    }

    public void c(EntityPose pose) {
        if (this.fixedPose) {
            return;
        }
        if (pose == this.aE()) {
            return;
        }
        if (!this.generation) {
            this.aU.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[pose.ordinal()]));
        }
        this.az.a(aE, pose);
    }

    public EntityPose aE() {
        return this.az.a(aE);
    }

    public boolean d(EntityPose pose) {
        return this.aE() == pose;
    }

    public boolean a(Entity entity, double distance) {
        return this.dD().a((IPosition)entity.dD(), distance);
    }

    public boolean a(Entity entity, double horizontalDistance, double verticalDistance) {
        double d2 = entity.dK() - this.dK();
        double d1 = entity.dM() - this.dM();
        double d22 = entity.dQ() - this.dQ();
        return MathHelper.e(d2, d22) < MathHelper.l(horizontalDistance) && MathHelper.l(d1) < MathHelper.l(verticalDistance);
    }

    public void a(float yRot, float xRot) {
        if (Float.isNaN(yRot)) {
            yRot = 0.0f;
        }
        if (yRot == Float.POSITIVE_INFINITY || yRot == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.aU.getCraftServer().getLogger().warning(this.cV() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yRot = 0.0f;
        }
        if (Float.isNaN(xRot)) {
            xRot = 0.0f;
        }
        if (xRot == Float.POSITIVE_INFINITY || xRot == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.aU.getCraftServer().getLogger().warning(this.cV() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            xRot = 0.0f;
        }
        this.v(yRot % 360.0f);
        this.w(xRot % 360.0f);
    }

    public final void b(Vec3D pos) {
        this.a_(pos.a(), pos.b(), pos.c());
    }

    public void a_(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, true);
    }

    protected final AxisAlignedBB aF() {
        return this.c(this.aV);
    }

    protected AxisAlignedBB c(Vec3D position) {
        return this.bz.a(position);
    }

    protected void aG() {
        this.a_(this.aV.g, this.aV.h, this.aV.i);
    }

    public void b(double yRot, double xRot) {
        float f2 = (float)xRot * 0.15f;
        float f1 = (float)yRot * 0.15f;
        this.w(this.dZ() + f2);
        this.v(this.dX() + f1);
        this.w(MathHelper.a(this.dZ(), -90.0f, 90.0f));
        this.ac += f2;
        this.ab += f1;
        this.ac = MathHelper.a(this.ac, -90.0f, 90.0f);
        if (this.aT != null) {
            this.aT.l(this);
        }
    }

    public void g() {
        if (this.despawnTime >= 0 && this.totalEntityAge >= this.despawnTime) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
        this.aH();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer) && this.bX()) {
            this.ci();
        }
    }

    public void aH() {
        Object object;
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("entityBaseTick");
        if (this.ay && (object = this) instanceof IEntityAngerable) {
            IEntityAngerable neutralMob = (IEntityAngerable)object;
            neutralMob.tickInitialPersistentAnger(this.aU);
        }
        this.bF = null;
        if (this.cl() && this.du().ec()) {
            this.cb();
        }
        if (this.X > 0) {
            --this.X;
        }
        if (this instanceof EntityPlayer) {
            this.ci();
        }
        if (this.bH()) {
            this.bI();
        }
        this.aK = this.aJ;
        this.aJ = false;
        this.bC();
        this.H();
        this.bB();
        object = this.an();
        if (object instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)object;
            if (this.bf > 0) {
                if (this.bt()) {
                    this.aQ();
                } else {
                    if (this.bf % 20 == 0 && !this.bJ()) {
                        this.a(serverLevel, this.ei().d(), 1.0f);
                    }
                    this.h(this.bf - 1);
                }
            }
        } else {
            this.aQ();
        }
        if (this.bJ()) {
            this.an *= 0.5;
        } else {
            this.lastLavaContact = null;
        }
        this.aI();
        if (!this.an().D_()) {
            this.d(this.bf > 0);
        }
        this.ay = false;
        object = this.an();
        if (object instanceof WorldServer) {
            WorldServer serverLevelx = (WorldServer)object;
            if (this instanceof Leashable) {
                Leashable.a_(serverLevelx, (Entity)((Object)((Leashable)((Object)this))));
            }
        }
        profilerFiller.c();
    }

    public void d(boolean isOnFire) {
        this.b(0, this.visualFire.toBooleanOrElse(isOnFire));
    }

    public void aI() {
        block7: {
            Entity entity;
            block6: {
                if (!this.aU.getWorld().isVoidDamageEnabled()) {
                    return;
                }
                if (this.dM() < (double)this.aU.M_() + this.aU.getWorld().getVoidDamageMinBuildHeightOffset()) break block6;
                if (this.aU.getWorld().getEnvironment() != World.Environment.NETHER || !this.aU.paperConfig().environment.netherCeilingVoidDamageHeight.test(v2 -> this.dM() >= (double)v2)) break block7;
                Entity entity2 = this;
                if (!(entity2 instanceof EntityHuman)) break block6;
                EntityHuman player = (EntityHuman)entity2;
                if (player.gC().a) break block7;
            }
            if (this.aU.purpurConfig.teleportOnNetherCeilingDamage && this.aU.getWorld().getEnvironment() == World.Environment.NETHER && (entity = this) instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                player.teleport(CraftLocation.toBukkit((BaseBlockPosition)this.aU.A.a().b(), this.aU));
            } else {
                this.aR();
            }
        }
    }

    public void aJ() {
        this.bt = this.cj();
    }

    public void f(int portalCooldown) {
        this.bt = portalCooldown;
    }

    public int aK() {
        return this.bt;
    }

    public boolean aL() {
        return this.bt > 0;
    }

    protected void O() {
        if (this.aL()) {
            --this.bt;
        }
    }

    public void aM() {
        this.lavaIgnite(this.lastLavaContact);
    }

    public void lavaIgnite(@Nullable BlockPosition pos) {
        if (!this.bt()) {
            if (this instanceof EntityLiving && this.bf <= 0) {
                CraftEntity damagee;
                CraftBlock damager = pos == null ? null : CraftBlock.at(this.aU, pos);
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)(damagee = this.getBukkitEntity()), 15.0f);
                if (combustEvent.callEvent()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
        }
    }

    public void aN() {
        this.lavaHurt(this.lastLavaContact);
    }

    public void lavaHurt(@Nullable BlockPosition pos) {
        WorldServer serverLevel;
        net.minecraft.world.level.World world;
        if (!this.bt() && (world = this.an()) instanceof WorldServer && this.a(serverLevel = (WorldServer)world, this.ei().e().eventBlockDamager(this.aU, pos), 4.0f) && this.aO() && !this.bm()) {
            serverLevel.a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.ls, this.dw(), 0.4f, 2.0f + this.as.i() * 0.4f);
        }
    }

    protected boolean aO() {
        return true;
    }

    public final void e(float seconds) {
        this.igniteForSeconds(seconds, true);
    }

    public final void igniteForSeconds(float seconds, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), seconds);
            if (!event.callEvent()) {
                return;
            }
            seconds = event.getDuration();
        }
        this.g(MathHelper.d(seconds * 20.0f));
    }

    public void g(int ticks) {
        if (this.bf < ticks) {
            this.h(ticks);
        }
        this.cG();
    }

    public void h(int remainingFireTicks) {
        this.bf = remainingFireTicks;
    }

    public int aP() {
        return this.bf;
    }

    public void aQ() {
        this.h(Math.min(0, this.aP()));
    }

    protected void aR() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean f(double x2, double y2, double z2) {
        return this.b(this.de().d(x2, y2, z2));
    }

    private boolean b(AxisAlignedBB box) {
        return this.an().a(this, box) && !this.an().d(box);
    }

    public void e(boolean onGround) {
        this.bc = onGround;
        this.b(onGround, null);
    }

    public void a(boolean onGround, Vec3D movement) {
        this.a(onGround, this.ad, movement);
    }

    public void a(boolean onGround, boolean horizontalCollision, Vec3D movement) {
        this.bc = onGround;
        this.ad = horizontalCollision;
        this.b(onGround, movement);
    }

    public boolean d(BlockPosition pos) {
        return this.aL.isPresent() && this.aL.get().equals(pos);
    }

    protected void b(boolean onGround, @Nullable Vec3D movement) {
        if (onGround) {
            AxisAlignedBB boundingBox = this.de();
            AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.a, boundingBox.b - 1.0E-6, boundingBox.c, boundingBox.d, boundingBox.b, boundingBox.f);
            Optional<BlockPosition> optional = this.aU.h(this, aabb);
            if (optional.isPresent() || this.bB) {
                this.aL = optional;
            } else if (movement != null) {
                AxisAlignedBB aabb1 = aabb.d(-movement.g, 0.0, -movement.i);
                optional = this.aU.h(this, aabb1);
                this.aL = optional;
            }
            this.bB = optional.isEmpty();
        } else {
            this.bB = false;
            if (this.aL.isPresent()) {
                this.aL = Optional.empty();
            }
        }
    }

    public boolean aS() {
        return this.bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(EnumMoveType type, Vec3D movement) {
        Vec3D originalMovement = movement;
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.dK();
            this.moveStartY = this.dM();
            this.moveStartZ = this.dQ();
            this.moveVector = movement;
        }
        try {
            if (this.ar) {
                this.a_(this.dK() + movement.g, this.dM() + movement.h, this.dQ() + movement.i);
                this.ad = false;
                this.ae = false;
                this.af = false;
                this.ag = false;
            } else {
                if (type == EnumMoveType.c) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.e(movement)).equals(Vec3D.c)) {
                        return;
                    }
                }
                GameProfilerFiller profilerFiller = Profiler.a();
                profilerFiller.a("move");
                if (this.ai.h() > 1.0E-7) {
                    if (type != EnumMoveType.c) {
                        movement = movement.h(this.ai);
                    }
                    this.ai = Vec3D.c;
                    this.k(Vec3D.c);
                }
                if (this.isTemporarilyActive && !(this instanceof EntityItem) && movement == this.dI() && type == EnumMoveType.a) {
                    this.k(Vec3D.c);
                    profilerFiller.c();
                    return;
                }
                Vec3D vec3 = this.a(movement = this.a(movement, type));
                double d2 = vec3.h();
                if (d2 > 1.0E-7 || movement.h() - d2 < 1.0E-7) {
                    if (this.an != 0.0 && d2 >= 1.0) {
                        double min = Math.min(vec3.g(), 8.0);
                        Vec3D vec31 = this.dD().e(vec3.d().c(min));
                        MovingObjectPositionBlock blockHitResult = this.an().a(new RayTrace(this.dD(), vec31, RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this));
                        if (blockHitResult.d() != MovingObjectPosition.EnumMovingObjectType.a) {
                            this.l();
                        }
                    }
                    Vec3D vec32 = this.dD();
                    Vec3D vec33 = vec32.e(vec3);
                    this.a(new c(vec32, vec33, movement));
                    this.b(vec33);
                }
                profilerFiller.c();
                profilerFiller.a("rest");
                boolean flag = !MathHelper.b(movement.g, vec3.g);
                boolean flag1 = !MathHelper.b(movement.i, vec3.i);
                boolean bl = this.ad = flag || flag1;
                if (Math.abs(movement.h) > 0.0 || this.dq()) {
                    this.ae = movement.h != vec3.h;
                    this.af = this.ae && movement.h < 0.0;
                    this.a(this.af, this.ad, vec3);
                }
                this.ag = this.ad ? this.d(vec3) : false;
                BlockPosition onPosLegacy = this.ba();
                IBlockData blockState = this.an().a_(onPosLegacy);
                if (this.dq()) {
                    this.a(vec3.h, this.aS(), blockState, onPosLegacy);
                }
                if (this.ec()) {
                    profilerFiller.c();
                } else {
                    MovementEmission movementEmission;
                    if (this.ad) {
                        Vec3D deltaMovement = this.dI();
                        this.m(flag ? 0.0 : deltaMovement.g, deltaMovement.h, flag1 ? 0.0 : deltaMovement.i);
                    }
                    if (this.ds()) {
                        Block block = blockState.b();
                        if (movement.h != vec3.h) {
                            block.a(this.an(), this);
                        }
                    }
                    if (this.ad && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block block = this.aU.getWorld().getBlockAt(MathHelper.a(this.dK()), MathHelper.a(this.dM()), MathHelper.a(this.dQ()));
                        if (movement.g > vec3.g) {
                            block = block.getRelative(BlockFace.EAST);
                        } else if (movement.g < vec3.g) {
                            block = block.getRelative(BlockFace.WEST);
                        } else if (movement.i > vec3.i) {
                            block = block.getRelative(BlockFace.SOUTH);
                        } else if (movement.i < vec3.i) {
                            block = block.getRelative(BlockFace.NORTH);
                        }
                        if (!block.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, block, CraftVector.toBukkit(originalMovement));
                            event.callEvent();
                        }
                    }
                    if ((!this.an().D_() || this.dq()) && (movementEmission = this.br()).a() && !this.cl()) {
                        this.a(movementEmission, vec3, onPosLegacy, blockState);
                    }
                    float blockSpeedFactor = this.be();
                    this.k(this.dI().d(blockSpeedFactor, 1.0, blockSpeedFactor));
                    profilerFiller.c();
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    private void a(MovementEmission movementEmission, Vec3D movement, BlockPosition pos, IBlockData state) {
        float f2 = 0.6f;
        float f1 = (float)(movement.g() * (double)0.6f);
        float f22 = (float)(movement.i() * (double)0.6f);
        BlockPosition onPos = this.bc();
        IBlockData blockState = this.an().a_(onPos);
        boolean isStateClimbable = this.c(blockState);
        this.al += isStateClimbable ? f1 : f22;
        this.am += f1;
        if (this.al > this.be && !blockState.l()) {
            boolean flag = onPos.equals(pos);
            boolean flag1 = this.a(pos, state, movementEmission.c(), flag, movement);
            if (!flag) {
                flag1 |= this.a(onPos, blockState, false, movementEmission.b(), movement);
            }
            if (flag1) {
                this.be = this.bf();
            } else if (this.bu()) {
                this.be = this.bf();
                if (movementEmission.c()) {
                    this.bj();
                }
                if (movementEmission.b()) {
                    this.c(GameEvent.Q);
                }
            }
        } else if (blockState.l()) {
            this.aZ();
        }
    }

    protected void aT() {
        this.bH.clear();
        this.bH.addAll(this.bG);
        this.bG.clear();
        if (this.bH.isEmpty()) {
            this.bH.add(new c(this.bO(), this.dD()));
        } else if (this.bH.getLast().b.g(this.dD()) > 9.999999439624929E-11) {
            this.bH.add(new c(this.bH.getLast().b, this.dD()));
        }
        this.b(this.bH);
    }

    private void a(c movement) {
        if (this.bG.size() >= 100) {
            c movement1 = this.bG.removeFirst();
            c movement2 = this.bG.removeFirst();
            c movement3 = new c(movement1.a(), movement2.b());
            this.bG.addFirst(movement3);
        }
        this.bG.add(movement);
    }

    public void aU() {
        if (!this.bG.isEmpty()) {
            this.bG.removeLast();
        }
    }

    protected void aV() {
        this.bG.clear();
    }

    public void a(Vec3D oldPosition, Vec3D position) {
        this.b(List.of(new c(oldPosition, position)));
    }

    private void b(List<c> movements) {
        if (this.aW()) {
            boolean flag;
            if (this.aS()) {
                BlockPosition onPosLegacy = this.ba();
                IBlockData blockState = this.an().a_(onPosLegacy);
                blockState.b().a(this.an(), onPosLegacy, blockState, this);
            }
            boolean isOnFire = this.ck();
            boolean isFreezing = this.dW();
            int remainingFireTicks = this.aP();
            this.a(movements, this.bJ);
            this.bJ.a(this);
            if (this.isInRain0()) {
                this.aQ();
            }
            if (isOnFire && !this.ck() || isFreezing && !this.dW()) {
                this.aX();
            }
            boolean bl = flag = this.aP() > remainingFireTicks;
            if (!(this.an().D_() || this.ck() || flag)) {
                this.h(-this.dx());
            }
        }
    }

    public boolean aW() {
        return !this.ec() && !this.ar;
    }

    private boolean c(IBlockData state) {
        return state.a(TagsBlock.bd) || state.a(Blocks.rP);
    }

    private boolean a(BlockPosition pos, IBlockData state, boolean playStepSound, boolean broadcastGameEvent, Vec3D entityPos) {
        if (state.l()) {
            return false;
        }
        boolean isStateClimbable = this.c(state);
        if ((this.aS() || isStateClimbable || this.cu() && entityPos.h == 0.0 || this.cC()) && !this.cw()) {
            if (playStepSound) {
                this.c(pos, state);
            }
            if (broadcastGameEvent) {
                this.an().a(GameEvent.P, this.dD(), GameEvent.a.a(this, state));
            }
            return true;
        }
        return false;
    }

    protected boolean d(Vec3D deltaMovement) {
        return false;
    }

    protected void aX() {
        if (!this.aU.D_()) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.lx, this.dw(), 0.7f, 1.6f + (this.as.i() - this.as.i()) * 0.4f);
        }
    }

    public void aY() {
        if (this.ck()) {
            this.aX();
        }
        this.aQ();
    }

    protected void aZ() {
        if (this.bl()) {
            this.bk();
            if (this.br().b()) {
                this.c(GameEvent.x);
            }
        }
    }

    @Deprecated
    public BlockPosition ba() {
        return this.f(0.2f);
    }

    public BlockPosition bb() {
        return this.f(0.500001f);
    }

    public BlockPosition bc() {
        return this.f(1.0E-5f);
    }

    protected BlockPosition f(float yOffset) {
        if (this.aL.isPresent() && this.an().getChunkIfLoadedImmediately(this.aL.get()) != null) {
            BlockPosition blockPos = this.aL.get();
            if (!(yOffset > 1.0E-5f)) {
                return blockPos;
            }
            IBlockData blockState = this.an().a_(blockPos);
            return !((double)yOffset <= 0.5 && blockState.a(TagsBlock.S) || blockState.a(TagsBlock.I) || blockState.b() instanceof BlockFenceGate) ? blockPos.h(MathHelper.a(this.aV.h - (double)yOffset)) : blockPos;
        }
        int floor = MathHelper.a(this.aV.g);
        int floor1 = MathHelper.a(this.aV.h - (double)yOffset);
        int floor2 = MathHelper.a(this.aV.i);
        return new BlockPosition(floor, floor1, floor2);
    }

    protected float bd() {
        float jumpFactor = this.an().a_(this.dF()).b().j();
        float jumpFactor1 = this.an().a_(this.bb()).b().j();
        return (double)jumpFactor == 1.0 ? jumpFactor1 : jumpFactor;
    }

    protected float be() {
        IBlockData blockState = this.an().a_(this.dF());
        float speedFactor = blockState.b().i();
        if (!blockState.a(Blocks.J) && !blockState.a(Blocks.oa)) {
            return (double)speedFactor == 1.0 ? this.an().a_(this.bb()).b().i() : speedFactor;
        }
        return speedFactor;
    }

    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        return movement;
    }

    protected Vec3D e(Vec3D pos) {
        if (pos.h() <= 1.0E-7) {
            return pos;
        }
        long gameTime = this.an().ag();
        if (gameTime != this.by) {
            Arrays.fill(this.bx, 0.0);
            this.by = gameTime;
        }
        if (pos.g != 0.0) {
            double d2 = this.a(EnumDirection.EnumAxis.a, pos.g);
            return Math.abs(d2) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(d2, 0.0, 0.0);
        }
        if (pos.h != 0.0) {
            double d3 = this.a(EnumDirection.EnumAxis.b, pos.h);
            return Math.abs(d3) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, d3, 0.0);
        }
        if (pos.i != 0.0) {
            double d4 = this.a(EnumDirection.EnumAxis.c, pos.i);
            return Math.abs(d4) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, 0.0, d4);
        }
        return Vec3D.c;
    }

    private double a(EnumDirection.EnumAxis axis, double distance) {
        int ordinal = axis.ordinal();
        double d2 = MathHelper.a(distance + this.bx[ordinal], -0.51, 0.51);
        distance = d2 - this.bx[ordinal];
        this.bx[ordinal] = d2;
        return distance;
    }

    public double b(double distance) {
        AxisAlignedBB boundingBox = this.de();
        AxisAlignedBB aabb = boundingBox.b(boundingBox.b - distance).e(boundingBox.b);
        List<VoxelShape> list = Entity.a(this, this.aU, aabb);
        return list.isEmpty() ? distance : -VoxelShapes.a(EnumDirection.EnumAxis.b, boundingBox, list, -distance);
    }

    private Vec3D a(Vec3D movement) {
        double stepHeight;
        boolean collidedDownwards;
        Vec3D collided;
        ArrayList<AxisAlignedBB> entityAABBs;
        AxisAlignedBB currentBox;
        block7: {
            block6: {
                double d2;
                boolean zZero;
                boolean xZero = movement.g == 0.0;
                boolean yZero = movement.h == 0.0;
                boolean bl = zZero = movement.i == 0.0;
                if (xZero & yZero & zZero) {
                    return movement;
                }
                currentBox = this.de();
                ArrayList<VoxelShape> potentialCollisionsVoxel = new ArrayList<VoxelShape>();
                ArrayList<AxisAlignedBB> potentialCollisionsBB = new ArrayList<AxisAlignedBB>();
                AxisAlignedBB initialCollisionBox = xZero & zZero ? (movement.h < 0.0 ? CollisionUtil.cutDownwards(currentBox, movement.h) : CollisionUtil.cutUpwards(currentBox, movement.h)) : currentBox.b(movement);
                entityAABBs = new ArrayList<AxisAlignedBB>();
                CollisionUtil.getEntityHardCollisions(this.aU, this, initialCollisionBox, entityAABBs, 0, null);
                CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.aU, this, initialCollisionBox, potentialCollisionsVoxel, potentialCollisionsBB, 4, null);
                potentialCollisionsBB.addAll(entityAABBs);
                collided = CollisionUtil.performCollisions(movement, currentBox, potentialCollisionsVoxel, potentialCollisionsBB);
                boolean collidedX = collided.g != movement.g;
                boolean collidedY = collided.h != movement.h;
                boolean collidedZ = collided.i != movement.i;
                boolean bl2 = collidedDownwards = collidedY && movement.h < 0.0;
                if (!collidedDownwards && !this.bc || !collidedX && !collidedZ) break block6;
                stepHeight = this.eb();
                if (!(d2 <= 0.0)) break block7;
            }
            return collided;
        }
        AxisAlignedBB collidedYBox = collidedDownwards ? currentBox.d(0.0, collided.h, 0.0) : currentBox;
        AxisAlignedBB stepRetrievalBox = collidedYBox.b(movement.g, stepHeight, movement.i);
        if (!collidedDownwards) {
            stepRetrievalBox = stepRetrievalBox.b(0.0, -1.0E-5f, 0.0);
        }
        ArrayList<VoxelShape> stepVoxels = new ArrayList<VoxelShape>();
        ArrayList<AxisAlignedBB> stepAABBs = entityAABBs;
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.aU, this, stepRetrievalBox, stepVoxels, stepAABBs, 4, null);
        for (float step : Entity.calculateStepHeights(collidedYBox, stepVoxels, stepAABBs, (float)stepHeight, (float)collided.h)) {
            Vec3D stepResult = CollisionUtil.performCollisions(new Vec3D(movement.g, step, movement.i), collidedYBox, stepVoxels, stepAABBs);
            if (!(stepResult.j() > collided.j())) continue;
            return stepResult.b(0.0, collidedYBox.b - currentBox.b, 0.0);
        }
        return collided;
    }

    private static float[] a(AxisAlignedBB box, List<VoxelShape> colliders, float deltaY, float maxUpStep) {
        FloatArraySet set = new FloatArraySet(4);
        block0: for (VoxelShape voxelShape : colliders) {
            DoubleListIterator doubleListIterator = voxelShape.a(EnumDirection.EnumAxis.b).iterator();
            while (doubleListIterator.hasNext()) {
                double d2 = (Double)doubleListIterator.next();
                float f2 = (float)(d2 - box.b);
                if (f2 < 0.0f || f2 == maxUpStep) continue;
                if (f2 > deltaY) continue block0;
                set.add(f2);
            }
        }
        float[] floats = set.toFloatArray();
        FloatArrays.unstableSort((float[])floats);
        return floats;
    }

    public static Vec3D a(@Nullable Entity entity, Vec3D vec, AxisAlignedBB collisionBox, net.minecraft.world.level.World level, List<VoxelShape> potentialHits) {
        List<VoxelShape> list = Entity.a(entity, level, potentialHits, collisionBox.b(vec));
        return Entity.a(vec, collisionBox, list);
    }

    public static List<VoxelShape> a(@Nullable Entity entity, net.minecraft.world.level.World level, AxisAlignedBB boundingBox) {
        List<VoxelShape> entityCollisions = level.c(entity, boundingBox);
        return Entity.a(entity, level, entityCollisions, boundingBox);
    }

    private static List<VoxelShape> a(@Nullable Entity entity, net.minecraft.world.level.World level, List<VoxelShape> collisions, AxisAlignedBB boundingBox) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        WorldBorder worldBorder = level.u();
        boolean bl = flag = entity != null && worldBorder.a(entity, boundingBox);
        if (flag) {
            builder.add((Object)worldBorder.a());
        }
        builder.addAll(level.e(entity, boundingBox));
        return builder.build();
    }

    private static Vec3D a(Vec3D deltaMovement, AxisAlignedBB entityBB, List<VoxelShape> shapes) {
        if (shapes.isEmpty()) {
            return deltaMovement;
        }
        Vec3D vec3 = Vec3D.c;
        for (EnumDirection.EnumAxis axis : EnumDirection.b(deltaMovement)) {
            double d2 = deltaMovement.a(axis);
            if (d2 == 0.0) continue;
            double d1 = VoxelShapes.a(axis, entityBB.c(vec3), shapes, d2);
            vec3 = vec3.a(axis, d1);
        }
        return vec3;
    }

    protected float bf() {
        return (int)this.al + 1;
    }

    public SoundEffect bg() {
        return SoundEffects.lB;
    }

    public SoundEffect bh() {
        return SoundEffects.lA;
    }

    public SoundEffect bi() {
        return SoundEffects.lA;
    }

    private void a(List<c> movements, InsideBlockEffectApplier.a stepBasedCollector) {
        if (this.aW()) {
            LongSet set = this.bI;
            for (c movement : movements) {
                Vec3D vec3 = movement.a;
                Vec3D vec31 = movement.b().d(movement.a());
                int i2 = 16;
                if (movement.c().isPresent() && vec31.h() > 0.0) {
                    for (EnumDirection.EnumAxis axis : EnumDirection.b(movement.c().get())) {
                        double d2 = vec31.a(axis);
                        if (d2 == 0.0) continue;
                        Vec3D vec32 = vec3.a(axis.e(), d2);
                        i2 -= this.a(vec3, vec32, stepBasedCollector, set, i2);
                        vec3 = vec32;
                    }
                } else {
                    i2 -= this.a(movement.a(), movement.b(), stepBasedCollector, set, 16);
                }
                if (i2 > 0) continue;
                this.a(movement.b(), movement.b(), stepBasedCollector, set, 1);
            }
            set.clear();
        }
    }

    private int a(Vec3D from, Vec3D to, InsideBlockEffectApplier.a stepBasedCollector, LongSet visited, int maxSteps) {
        WorldServer serverLevel;
        AxisAlignedBB aabb = this.c(to).h(1.0E-5f);
        boolean flag = from.g(to) > MathHelper.l(0.9999900000002526);
        net.minecraft.world.level.World world = this.aU;
        boolean flag1 = world instanceof WorldServer && (serverLevel = (WorldServer)world).q().bA().a(DebugSubscriptions.g);
        AtomicInteger atomicInteger = new AtomicInteger();
        IBlockAccess.a(from, to, aabb, (BlockPosition pos, int index) -> {
            if (!this.bX()) {
                return false;
            }
            if (index >= maxSteps) {
                return false;
            }
            atomicInteger.set(index);
            IBlockData blockState = this.an().a_(pos);
            if (blockState.l()) {
                if (flag1) {
                    this.a((WorldServer)this.an(), pos.j(), false, false);
                }
                return true;
            }
            VoxelShape entityInsideCollisionShape = blockState.a((IBlockAccess)this.an(), pos, this);
            boolean flag2 = entityInsideCollisionShape == VoxelShapes.b() || this.a(from, to, entityInsideCollisionShape.a(new Vec3D(pos)).e());
            boolean flag3 = this.a(blockState.y(), pos, from, to);
            if ((flag2 || flag3) && visited.add(pos.a())) {
                if (flag2) {
                    try {
                        boolean flag4 = flag || aabb.b(pos);
                        stepBasedCollector.advanceStep(index, pos);
                        blockState.a(this.an(), pos, this, stepBasedCollector, flag4);
                        this.a(blockState);
                    }
                    catch (Throwable var20) {
                        CrashReport crashReport = CrashReport.a(var20, "Colliding entity with block");
                        CrashReportSystemDetails crashReportCategory = crashReport.a("Block being collided with");
                        CrashReportSystemDetails.a(crashReportCategory, this.an(), pos, blockState);
                        CrashReportSystemDetails crashReportCategory1 = crashReport.a("Entity being checked for collision");
                        this.a(crashReportCategory1);
                        throw new ReportedException(crashReport);
                    }
                }
                if (flag3) {
                    stepBasedCollector.advanceStep(index, pos);
                    blockState.y().a(this.an(), pos, this, stepBasedCollector);
                }
                if (flag1) {
                    this.a((WorldServer)this.an(), pos.j(), flag2, flag3);
                }
                return true;
            }
            return true;
        });
        return atomicInteger.get() + 1;
    }

    private void a(WorldServer level, BlockPosition pos, boolean inBlock, boolean inFluid) {
        DebugEntityBlockIntersection debugEntityBlockIntersection = inFluid ? DebugEntityBlockIntersection.b : (inBlock ? DebugEntityBlockIntersection.a : DebugEntityBlockIntersection.c);
        level.U().a(pos, DebugSubscriptions.g, debugEntityBlockIntersection);
    }

    public boolean a(Fluid fluid, BlockPosition pos, Vec3D from, Vec3D to) {
        AxisAlignedBB aabb = fluid.e(this.an(), pos);
        return aabb != null && this.a(from, to, List.of(aabb));
    }

    public boolean a(Vec3D from, Vec3D to, List<AxisAlignedBB> boxes) {
        AxisAlignedBB aabb = this.c(from);
        Vec3D vec3 = to.d(from);
        return aabb.a(vec3, boxes);
    }

    protected void a(IBlockData state) {
    }

    public BlockPosition a(WorldServer level, BlockPosition pos) {
        BlockPosition blockPos = level.A().b();
        Vec3D center = blockPos.b();
        int i2 = level.m(blockPos).a(HeightMap.Type.f, blockPos.u(), blockPos.w()) + 1;
        return BlockPosition.a(center.g, (double)i2, center.i);
    }

    public void a(Holder<GameEvent> gameEvent, @Nullable Entity entity) {
        this.an().a(entity, gameEvent, this.aV);
    }

    public void c(Holder<GameEvent> gameEvent) {
        this.a(gameEvent, this);
    }

    private void c(BlockPosition pos, IBlockData state) {
        this.b(pos, state);
        if (this.d(state)) {
            this.k();
        }
    }

    protected void bj() {
        Entity entity = Objects.requireNonNullElse(this.dg(), this);
        float f2 = entity == this ? 0.35f : 0.4f;
        Vec3D deltaMovement = entity.dI();
        float min = Math.min(1.0f, (float)Math.sqrt(deltaMovement.g * deltaMovement.g * (double)0.2f + deltaMovement.h * deltaMovement.h + deltaMovement.i * deltaMovement.i * (double)0.2f) * f2);
        this.g(min);
    }

    protected BlockPosition e(BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        IBlockData blockState = this.an().a_(blockPos);
        return !blockState.a(TagsBlock.bz) && !blockState.a(TagsBlock.bA) ? pos : blockPos;
    }

    protected void a(IBlockData primaryState, IBlockData secondaryState) {
        SoundEffectType soundType = primaryState.A();
        this.a(soundType.d(), soundType.a() * 0.15f, soundType.b());
        this.b(secondaryState);
    }

    protected void b(IBlockData state) {
        SoundEffectType soundType = state.A();
        this.a(soundType.d(), soundType.a() * 0.05f, soundType.b() * 0.8f);
    }

    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffectType soundType = state.A();
        this.a(soundType.d(), soundType.a() * 0.15f, soundType.b());
    }

    private boolean d(IBlockData state) {
        return state.a(TagsBlock.by) && this.at >= this.bD + 20;
    }

    private void k() {
        this.bC *= (float)Math.pow(0.997, this.at - this.bD);
        this.bC = Math.min(1.0f, this.bC + 0.07f);
        float f2 = 0.5f + this.bC * this.as.i() * 1.2f;
        float f1 = 0.1f + this.bC * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bD = this.at;
    }

    protected void g(float volume) {
        this.a(this.bg(), volume, 1.0f + (this.as.i() - this.as.i()) * 0.4f);
    }

    protected void bk() {
    }

    protected boolean bl() {
        return false;
    }

    public void a(SoundEffect sound, float volume, float pitch) {
        if (!this.bm()) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), sound, this.dw(), volume, pitch);
        }
    }

    public void a(SoundEffect sound) {
        if (!this.bm()) {
            this.a(sound, 1.0f, 1.0f);
        }
    }

    public boolean bm() {
        return this.az.a(bo);
    }

    public void f(boolean isSilent) {
        this.az.a(bo, isSilent);
    }

    public boolean bn() {
        return this.az.a(bp);
    }

    public void g(boolean noGravity) {
        this.az.a(bp, noGravity);
    }

    protected double bo() {
        return 0.0;
    }

    public final double bp() {
        return this.bn() ? 0.0 : this.bo();
    }

    protected void bq() {
        double gravity = this.bp();
        if (gravity != 0.0) {
            this.k(this.dI().b(0.0, -gravity, 0.0));
        }
    }

    protected MovementEmission br() {
        return MovementEmission.d;
    }

    public boolean bs() {
        return false;
    }

    public final void a(double x2, double y2, double z2, boolean onGround) {
        if (!this.dy()) {
            this.b(onGround, new Vec3D(x2, y2, z2));
            BlockPosition onPosLegacy = this.ba();
            IBlockData blockState = this.an().a_(onPosLegacy);
            this.a(y2, onGround, blockState, onPosLegacy);
        }
    }

    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (!this.bu() && y2 < 0.0) {
            this.an -= (double)((float)y2);
        }
        if (onGround) {
            if (this.an > 0.0) {
                state.b().a(this.an(), state, pos, this, this.an);
                this.an().a(GameEvent.A, this.aV, GameEvent.a.a(this, this.aL.map(supportingPos -> this.an().a_((BlockPosition)supportingPos)).orElse(state)));
            }
            this.l();
        }
    }

    public boolean bt() {
        return this.immuneToFire != null ? this.immuneToFire.booleanValue() : this.ax().d();
    }

    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.aP.a(TagsEntity.o)) {
            return false;
        }
        this.b(fallDistance, damageMultiplier, damageSource);
        return false;
    }

    protected void b(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.cm()) {
            for (Entity entity : this.di()) {
                entity.a(fallDistance, damageMultiplier, damageSource);
            }
        }
    }

    public boolean bu() {
        return this.au;
    }

    public boolean isInRain0() {
        BlockPosition blockPos = this.dF();
        return this.an().r(blockPos) || this.an().r(BlockPosition.a((double)blockPos.u(), this.de().e, (double)blockPos.w()));
    }

    public boolean bw() {
        return this.bu() || this.isInRain0();
    }

    public boolean bx() {
        return this.bu() || this.bJ();
    }

    public boolean by() {
        return this.aw && this.bu();
    }

    public boolean bz() {
        return this.bu() && !this.by();
    }

    public boolean bA() {
        Optional<Integer> optional = this.aU.H_().t();
        if (optional.isEmpty()) {
            return false;
        }
        int i2 = optional.get();
        if (this.dM() + (double)this.dB() < (double)i2) {
            return false;
        }
        int i1 = i2 + 4;
        return this.dM() <= (double)i1;
    }

    public void bB() {
        if (this.cw()) {
            this.j(this.cv() && this.bu() && !this.cl());
        } else {
            this.j(this.cv() && this.by() && !this.cl() && this.an().b_(this.aW).a(TagsFluid.a));
        }
    }

    protected boolean bC() {
        this.av.clear();
        this.bD();
        double d2 = this.an().H_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d2);
        return this.bu() || flag;
    }

    public void bD() {
        AbstractBoat abstractBoat;
        Entity entity = this.du();
        if (entity instanceof AbstractBoat && !(abstractBoat = (AbstractBoat)entity).by()) {
            this.au = false;
        } else if (this.a(TagsFluid.a, 0.014)) {
            if (!this.au && !this.ay) {
                this.bE();
            }
            this.l();
            this.au = true;
        } else {
            this.au = false;
        }
    }

    private void H() {
        AbstractBoat abstractBoat;
        this.aw = this.a(TagsFluid.a);
        this.bg.clear();
        double eyeY = this.dO();
        Entity entity = this.du();
        if (!(entity instanceof AbstractBoat) || (abstractBoat = (AbstractBoat)entity).by() || !(abstractBoat.de().e >= eyeY) || !(abstractBoat.de().b <= eyeY)) {
            BlockPosition blockPos = BlockPosition.a(this.dK(), eyeY, this.dQ());
            Fluid fluidState = this.an().b_(blockPos);
            double d2 = (float)blockPos.v() + fluidState.a(this.an(), blockPos);
            if (d2 > eyeY) {
                fluidState.k().forEach(this.bg::add);
            }
        }
    }

    protected void bE() {
        double d1;
        double d2;
        Entity entity = Objects.requireNonNullElse(this.dg(), this);
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D deltaMovement = entity.dI();
        float min = Math.min(1.0f, (float)Math.sqrt(deltaMovement.g * deltaMovement.g * (double)0.2f + deltaMovement.h * deltaMovement.h + deltaMovement.i * deltaMovement.i * (double)0.2f) * f2);
        if (min < 0.25f) {
            this.a(this.bh(), min, 1.0f + (this.as.i() - this.as.i()) * 0.4f);
        } else {
            this.a(this.bi(), min, 1.0f + (this.as.i() - this.as.i()) * 0.4f);
        }
        float f1 = MathHelper.a(this.dM());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.bz.a() * 20.0f) {
            d2 = (this.as.j() * 2.0 - 1.0) * (double)this.bz.a();
            d1 = (this.as.j() * 2.0 - 1.0) * (double)this.bz.a();
            this.an().a(Particles.d, this.dK() + d2, (double)(f1 + 1.0f), this.dQ() + d1, deltaMovement.g, deltaMovement.h - this.as.j() * (double)0.2f, deltaMovement.i);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.bz.a() * 20.0f) {
            d2 = (this.as.j() * 2.0 - 1.0) * (double)this.bz.a();
            d1 = (this.as.j() * 2.0 - 1.0) * (double)this.bz.a();
            this.an().a(Particles.aq, this.dK() + d2, (double)(f1 + 1.0f), this.dQ() + d1, deltaMovement.g, deltaMovement.h, deltaMovement.i);
            ++i2;
        }
        this.c(GameEvent.O);
    }

    @Deprecated
    protected IBlockData bF() {
        return this.an().a_(this.ba());
    }

    public IBlockData bG() {
        return this.an().a_(this.bc());
    }

    public boolean bH() {
        return this.cv() && !this.bu() && !this.at() && !this.cu() && !this.bJ() && this.bX();
    }

    protected void bI() {
        BlockPosition onPosLegacy = this.ba();
        IBlockData blockState = this.an().a_(onPosLegacy);
        if (blockState.o() != EnumRenderType.a) {
            Vec3D deltaMovement = this.dI();
            BlockPosition blockPos = this.dF();
            double d2 = this.dK() + (this.as.j() - 0.5) * (double)this.bz.a();
            double d1 = this.dQ() + (this.as.j() - 0.5) * (double)this.bz.a();
            if (blockPos.u() != onPosLegacy.u()) {
                d2 = MathHelper.a(d2, (double)onPosLegacy.u(), (double)onPosLegacy.u() + 1.0);
            }
            if (blockPos.w() != onPosLegacy.w()) {
                d1 = MathHelper.a(d1, (double)onPosLegacy.w(), (double)onPosLegacy.w() + 1.0);
            }
            this.an().a(new ParticleParamBlock(Particles.b, blockState), d2, this.dM() + 0.1, d1, deltaMovement.g * -4.0, 1.5, deltaMovement.i * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> fluidTag) {
        return this.bg.contains(fluidTag);
    }

    public boolean bJ() {
        return !this.ay && this.av.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float amount, Vec3D relative) {
        Vec3D inputVector = Entity.a(relative, amount, this.dX());
        this.k(this.dI().e(inputVector));
    }

    protected static Vec3D a(Vec3D relative, float motionScaler, float facing) {
        double d2 = relative.h();
        if (d2 < 1.0E-7) {
            return Vec3D.c;
        }
        Vec3D vec3 = (d2 > 1.0 ? relative.d() : relative).c((double)motionScaler);
        float sin = MathHelper.a(facing * ((float)Math.PI / 180));
        float cos = MathHelper.b(facing * ((float)Math.PI / 180));
        return new Vec3D(vec3.g * (double)cos - vec3.i * (double)sin, vec3.h, vec3.i * (double)cos + vec3.g * (double)sin);
    }

    @Deprecated
    public float bK() {
        return this.an().f(this.dJ(), this.dP()) ? this.an().z(BlockPosition.a(this.dK(), this.dO(), this.dQ())) : 0.0f;
    }

    public void a(double x2, double y2, double z2, float yRot, float xRot) {
        this.g(x2, y2, z2);
        this.b(yRot, xRot);
    }

    public void b(float yRot, float xRot) {
        this.v(yRot % 360.0f);
        this.w(MathHelper.a(xRot, -90.0f, 90.0f) % 360.0f);
        this.ab = this.dX();
        this.ac = this.dZ();
        this.r(yRot);
    }

    public void g(double x2, double y2, double z2) {
        double d2 = MathHelper.a(x2, -3.0E7, 3.0E7);
        double d1 = MathHelper.a(z2, -3.0E7, 3.0E7);
        this.Y = d2;
        this.Z = y2;
        this.aa = d1;
        this.a_(d2, y2, d1);
        if (this.valid) {
            this.aU.d((int)Math.floor(this.dK()) >> 4, (int)Math.floor(this.dQ()) >> 4);
        }
    }

    public void f(Vec3D pos) {
        this.d(pos.g, pos.h, pos.i);
    }

    public void d(double x2, double y2, double z2) {
        this.b(x2, y2, z2, this.dX(), this.dZ());
    }

    public void a(BlockPosition pos, float yRot, float xRot) {
        this.b(pos.c(), yRot, xRot);
    }

    public void b(Vec3D pos, float yRot, float xRot) {
        this.b(pos.g, pos.h, pos.i, yRot, xRot);
    }

    public void b(double x2, double y2, double z2, float yRot, float xRot) {
        this.n(x2, y2, z2);
        this.v(yRot);
        this.w(xRot);
        this.bL();
        this.aG();
        this.r(yRot);
    }

    public final void bL() {
        this.bM();
        this.bN();
    }

    public final void c(Vec3D pos, float yRot, float xRot) {
        this.m(pos);
        this.f(yRot, xRot);
    }

    protected void bM() {
        this.m(this.aV);
    }

    public void bN() {
        this.f(this.dX(), this.dZ());
    }

    private void m(Vec3D pos) {
        this.Y = this.ao = pos.g;
        this.Z = this.ap = pos.h;
        this.aa = this.aq = pos.i;
    }

    private void f(float yRot, float xRot) {
        this.ab = yRot;
        this.ac = xRot;
    }

    public final Vec3D bO() {
        return new Vec3D(this.ao, this.ap, this.aq);
    }

    public float f(Entity entity) {
        float f2 = (float)(this.dK() - entity.dK());
        float f1 = (float)(this.dM() - entity.dM());
        float f22 = (float)(this.dQ() - entity.dQ());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double h(double x2, double y2, double z2) {
        double d2 = this.dK() - x2;
        double d1 = this.dM() - y2;
        double d22 = this.dQ() - z2;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public double g(Entity entity) {
        return this.g(entity.dD());
    }

    public double g(Vec3D pos) {
        double d2 = this.dK() - pos.g;
        double d1 = this.dM() - pos.h;
        double d22 = this.dQ() - pos.i;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public void a_(EntityHuman player) {
    }

    public void h(Entity entity) {
        if (!(this.A(entity) || entity.ar || this.ar)) {
            double d1;
            if (this.aU.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityPlayer) && !(this instanceof EntityPlayer)) {
                return;
            }
            double d2 = entity.dK() - this.dK();
            double max = MathHelper.a(d2, d1 = entity.dQ() - this.dQ());
            if (max >= (double)0.01f) {
                max = Math.sqrt(max);
                d2 /= max;
                d1 /= max;
                double d22 = 1.0 / max;
                if (d22 > 1.0) {
                    d22 = 1.0;
                }
                d2 *= d22;
                d1 *= d22;
                d2 *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.cm() && this.bU()) {
                    this.i(-d2, 0.0, -d1);
                }
                if (!entity.cm() && entity.bU()) {
                    entity.i(d2, 0.0, d1);
                }
            }
        }
    }

    public void h(Vec3D vector) {
        this.i(vector.g, vector.h, vector.i);
    }

    public void i(double x2, double y2, double z2) {
        this.push(x2, y2, z2, null);
    }

    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        Vector delta = new Vector(x2, y2, z2);
        if (pushingEntity != null) {
            EntityPushedByEntityAttackEvent event = new EntityPushedByEntityAttackEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityKnockbackEvent.Cause.PUSH, (org.bukkit.entity.Entity)pushingEntity.getBukkitEntity(), delta);
            if (!event.callEvent()) {
                return;
            }
            delta = event.getKnockback();
        }
        this.k(this.dI().b(delta.getX(), delta.getY(), delta.getZ()));
        this.aF = true;
    }

    protected void bP() {
        this.ah = true;
    }

    @Deprecated
    public final void a(DamageSource damageSource, float amount) {
        net.minecraft.world.level.World world = this.aU;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, damageSource, amount);
        }
    }

    @Deprecated
    public final boolean b(DamageSource damageSource, float amount) {
        boolean bl;
        net.minecraft.world.level.World world = this.aU;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            bl = this.a(serverLevel, damageSource, amount);
        } else {
            bl = this.b(damageSource);
        }
        return bl;
    }

    public abstract boolean a(WorldServer var1, DamageSource var2, float var3);

    public boolean b(DamageSource damageSource) {
        return false;
    }

    public final Vec3D h(float partialTick) {
        return this.c(this.i(partialTick), this.j(partialTick));
    }

    public EnumDirection bQ() {
        return EnumDirection.a(this.h(1.0f));
    }

    public float i(float partialTick) {
        return this.k(partialTick);
    }

    public float j(float partialTick) {
        return this.l(partialTick);
    }

    public float k(float partialTick) {
        return partialTick == 1.0f ? this.dZ() : MathHelper.h(partialTick, this.ac, this.dZ());
    }

    public float l(float partialTick) {
        return partialTick == 1.0f ? this.dX() : MathHelper.i(partialTick, this.ab, this.dX());
    }

    public final Vec3D c(float xRot, float yRot) {
        float f2 = xRot * ((float)Math.PI / 180);
        float f1 = -yRot * ((float)Math.PI / 180);
        float cos = MathHelper.b(f1);
        float sin = MathHelper.a(f1);
        float cos1 = MathHelper.b(f2);
        float sin1 = MathHelper.a(f2);
        return new Vec3D(sin * cos1, -sin1, cos * cos1);
    }

    public final Vec3D m(float partialTick) {
        return this.d(this.i(partialTick), this.j(partialTick));
    }

    protected final Vec3D d(float xRot, float yRot) {
        return this.c(xRot - 90.0f, yRot);
    }

    public final Vec3D bR() {
        return new Vec3D(this.dK(), this.dO(), this.dQ());
    }

    public final Vec3D n(float partialTick) {
        double d2 = MathHelper.d((double)partialTick, this.Y, this.dK());
        double d1 = MathHelper.d((double)partialTick, this.Z, this.dM()) + (double)this.df();
        double d22 = MathHelper.d((double)partialTick, this.aa, this.dQ());
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D o(float partialTick) {
        return this.n(partialTick);
    }

    public final Vec3D p(float partialTick) {
        double d2 = MathHelper.d((double)partialTick, this.Y, this.dK());
        double d1 = MathHelper.d((double)partialTick, this.Z, this.dM());
        double d22 = MathHelper.d((double)partialTick, this.aa, this.dQ());
        return new Vec3D(d2, d1, d22);
    }

    public MovingObjectPosition a(double hitDistance, float partialTick, boolean hitFluids) {
        Vec3D eyePosition = this.n(partialTick);
        Vec3D viewVector = this.h(partialTick);
        Vec3D vec3 = eyePosition.b(viewVector.g * hitDistance, viewVector.h * hitDistance, viewVector.i * hitDistance);
        return this.an().a(new RayTrace(eyePosition, vec3, RayTrace.BlockCollisionOption.b, hitFluids ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bS() {
        return this.bX() && this.bT();
    }

    public boolean bT() {
        return false;
    }

    public boolean bU() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bU();
    }

    public void a(Entity entity, DamageSource damageSource) {
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.d.a((EntityPlayer)entity, this, damageSource);
        }
    }

    public boolean j(double x2, double y2, double z2) {
        double d2 = this.dK() - x2;
        double d1 = this.dM() - y2;
        double d22 = this.dQ() - z2;
        double d3 = d2 * d2 + d1 * d1 + d22 * d22;
        return this.a(d3);
    }

    public boolean a(double distance) {
        double size = this.de().a();
        if (Double.isNaN(size)) {
            size = 1.0;
        }
        return distance < (size *= 64.0 * aO) * size;
    }

    public boolean b(ValueOutput output) {
        return this.saveAsPassenger(output, true, false, false);
    }

    public boolean saveAsPassenger(ValueOutput output, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        if (this.bd != null && !this.bd.b() && !forceSerialization) {
            return false;
        }
        String encodeId = this.getEncodeId(includeNonSaveable);
        if (!this.persist && !forceSerialization || encodeId == null) {
            return false;
        }
        output.a(v, encodeId);
        this.saveWithoutId(output, includeAll, includeNonSaveable, forceSerialization);
        return true;
    }

    public boolean c(ValueOutput output) {
        return !this.cl() && this.b(output);
    }

    public void d(ValueOutput output) {
        this.saveWithoutId(output, true, false, false);
    }

    public void saveWithoutId(ValueOutput output, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        try {
            int ticksFrozen;
            if (includeAll) {
                if (this.aT != null) {
                    output.a(z, Vec3D.a, new Vec3D(this.aT.dK(), this.dM(), this.aT.dQ()));
                } else {
                    output.a(z, Vec3D.a, this.dD());
                }
            }
            this.k(MCUtil.sanitizeNanInf(this.aY, 0.0));
            output.a(A, Vec3D.a, this.dI());
            if (Float.isNaN(this.aZ)) {
                this.aZ = 0.0f;
            }
            if (Float.isNaN(this.ba)) {
                this.ba = 0.0f;
            }
            output.a(B, Vec2F.i, new Vec2F(this.dX(), this.dZ()));
            output.a(G, this.an);
            output.a(H, (short)this.bf);
            output.a(E, (short)this.cF());
            output.a(F, this.aS());
            output.a(K, this.bu);
            output.a(C, this.bt);
            if (includeAll) {
                output.a(w, UUIDUtil.a, this.cT());
                output.a("WorldUUIDLeast", this.aU.getWorld().getUID().getLeastSignificantBits());
                output.a("WorldUUIDMost", this.aU.getWorld().getUID().getMostSignificantBits());
            }
            output.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                output.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                output.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                output.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                output.a("Bukkit.MaxAirSupply", this.cE());
            }
            output.a("Spigot.ticksLived", this.totalEntityAge);
            output.b(L, ComponentSerialization.a, this.ar());
            if (this.cY()) {
                output.a("CustomNameVisible", this.cY());
            }
            if (this.bm()) {
                output.a(I, this.bm());
            }
            if (this.bn()) {
                output.a(D, this.bn());
            }
            if (this.bv) {
                output.a(J, true);
            }
            if ((ticksFrozen = this.cH()) > 0) {
                output.a("TicksFrozen", this.cH());
            }
            if (this.visualFire.equals((Object)TriState.TRUE)) {
                output.a("HasVisualFire", true);
            }
            output.a("Paper.FireOverride", this.visualFire.name());
            if (!this.bw.isEmpty()) {
                output.a("Tags", d, List.copyOf(this.bw));
            }
            if (!this.bK.a()) {
                output.a(y, CustomData.c, this.bK);
            }
            this.addAdditionalSaveData(output, includeAll);
            if (this.cm()) {
                ValueOutput.b valueOutputList = output.b(x);
                for (Entity entity : this.di()) {
                    ValueOutput valueOutput;
                    if (entity.saveAsPassenger(valueOutput = valueOutputList.a(), includeAll, includeNonSaveable, forceSerialization)) continue;
                    valueOutputList.b();
                }
                if (valueOutputList.c()) {
                    output.c(x);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(output);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.aU != null ? this.aU.getWorld().getUID() : null);
                if (originWorld != null) {
                    output.a("Paper.OriginWorld", UUIDUtil.a, originWorld);
                }
                output.a("Paper.Origin", Vec3D.a, this.origin);
            }
            if (this.spawnReason != null) {
                output.a("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                output.a("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                output.a("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                output.a("Paper.FreezeLock", true);
            }
            if (this.immuneToFire != null) {
                output.a("Purpur.FireImmune", this.immuneToFire);
            }
        }
        catch (Throwable var7) {
            CrashReport crashReport = CrashReport.a(var7, "Saving entity NBT");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Entity being saved");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    public void d(ValueInput input) {
        try {
            Vec3D vec3 = input.a(z, Vec3D.a).orElse(Vec3D.c);
            Vec3D vec31 = input.a(A, Vec3D.a).orElse(Vec3D.c);
            vec31 = MCUtil.sanitizeNanInf(vec31, 0.0);
            Vec2F vec2 = input.a(B, Vec2F.i).orElse(Vec2F.a);
            this.m(Math.abs(vec31.g) > 10.0 ? 0.0 : vec31.g, Math.abs(vec31.h) > 10.0 ? 0.0 : vec31.h, Math.abs(vec31.i) > 10.0 ? 0.0 : vec31.i);
            this.aF = true;
            double d2 = 3.0000512E7;
            this.n(MathHelper.a(vec3.g, -3.0000512E7, 3.0000512E7), MathHelper.a(vec3.h, -2.0E7, 2.0E7), MathHelper.a(vec3.i, -3.0000512E7, 3.0000512E7));
            this.v(vec2.j);
            this.w(vec2.k);
            this.bL();
            this.r(this.dX());
            this.s(this.dX());
            this.an = input.a(G, 0.0);
            this.bf = input.a(H, (short)0);
            this.j(input.a(E, this.cE()));
            this.bc = input.a(F, false);
            this.bu = input.a(K, false);
            this.bt = input.a(C, 0);
            input.a(w, UUIDUtil.a).ifPresent(uuid -> {
                this.aH = uuid;
                this.aI = this.aH.toString();
            });
            if (!(Double.isFinite(this.dK()) && Double.isFinite(this.dM()) && Double.isFinite(this.dQ()))) {
                throw new IllegalStateException("Entity has invalid position");
            }
            if (Double.isFinite(this.dX()) && Double.isFinite(this.dZ())) {
                this.aG();
                this.a(this.dX(), this.dZ());
                this.b((IChatBaseComponent)input.a(L, ComponentSerialization.a).orElse(null));
                this.p(input.a("CustomNameVisible", false));
                this.f(input.a(I, false));
                this.g(input.a(D, false));
                this.k(input.a(J, false));
                this.k(input.a("TicksFrozen", 0));
                input.g("Paper.FireOverride").ifPresentOrElse(override -> {
                    try {
                        this.visualFire = TriState.valueOf((String)override);
                    }
                    catch (Exception ignored) {
                        b.error("Unknown fire override {} for {}", override, (Object)this);
                    }
                }, () -> {
                    this.visualFire = input.a("HasVisualFire", Codec.BOOL).map(TriState::byBoolean).orElse(TriState.NOT_SET);
                });
                this.bK = input.a(y, CustomData.c).orElse(CustomData.a);
                this.bw.clear();
                input.a("Tags", d).ifPresent(this.bw::addAll);
                this.a(input);
                if (this.bV()) {
                    this.aG();
                }
            } else {
                throw new IllegalStateException("Entity has invalid rotation");
            }
            if (this instanceof EntityLiving) {
                this.totalEntityAge = input.a("Spigot.ticksLived", 0);
            }
            this.persist = input.a("Bukkit.persist", true);
            this.visibleByDefault = input.a("Bukkit.visibleByDefault", true);
            this.maxAirTicks = input.a("Bukkit.MaxAirSupply", this.maxAirTicks);
            this.getBukkitEntity().readBukkitValues(input);
            input.a("Bukkit.invisible", Codec.BOOL).ifPresent(bukkitInvisible -> {
                this.l((boolean)bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            });
            Optional<Vec3D> originVec = input.a("Paper.Origin", Vec3D.a);
            if (originVec.isPresent()) {
                this.originWorld = input.a("Paper.OriginWorld", UUIDUtil.a).orElse(this.aU != null ? this.aU.getWorld().getUID() : null);
                this.origin = originVec.get();
            }
            this.spawnedViaMobSpawner = input.a("Paper.FromMobSpawner", false);
            this.fromNetherPortal = input.a("Paper.FromNetherPortal", false);
            input.g("Paper.SpawnReason").ifPresent(spawnReasonName -> {
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    b.error("Unknown SpawnReason " + spawnReasonName + " for " + String.valueOf(this));
                }
            });
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof EntityInsentient && (this instanceof EntityAnimal || this instanceof EntityFish) && !((EntityInsentient)this).i(0.0) && !input.a("PersistenceRequired", false)) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            this.freezeLocked = input.a("Paper.FreezeLock", false);
            this.immuneToFire = input.a("Purpur.FireImmune", Codec.BOOL).orElse(null);
        }
        catch (Throwable var7) {
            CrashReport crashReport = CrashReport.a(var7, "Loading entity NBT");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Entity being loaded");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    protected boolean bV() {
        return true;
    }

    @Nullable
    public final String bW() {
        return this.getEncodeId(false);
    }

    @Nullable
    public final String getEncodeId(boolean includeNonSaveable) {
        EntityTypes<?> type = this.ax();
        MinecraftKey key = EntityTypes.a(type);
        return type.b() || includeNonSaveable ? key.toString() : null;
    }

    protected abstract void a(ValueInput var1);

    protected void addAdditionalSaveData(ValueOutput output, boolean includeAll) {
        this.a(output);
    }

    protected abstract void a(ValueOutput var1);

    @Nullable
    public EntityItem a(WorldServer level, IMaterial item) {
        return this.a(level, new ItemStack(item), 0.0f);
    }

    @Nullable
    public EntityItem a(WorldServer level, ItemStack stack) {
        return this.a(level, stack, 0.0f);
    }

    @Nullable
    public EntityItem a(WorldServer level, ItemStack stack, Vec3D offset) {
        return this.spawnAtLocation(level, stack, offset, null);
    }

    @Nullable
    public EntityItem spawnAtLocation(WorldServer level, ItemStack stack, Vec3D offset, @Nullable Consumer<? super EntityItem> delayedAddConsumer) {
        if (stack.f()) {
            return null;
        }
        if (this instanceof EntityLiving && !this.forceDrops) {
            ((EntityLiving)this).drops.add(new DefaultDrop(stack, itemStack -> {
                EntityItem itemEntity = new EntityItem(this.aU, this.dK() + offset.g, this.dM() + offset.h, this.dQ() + offset.i, (ItemStack)itemStack);
                itemEntity.i();
                this.aU.b(itemEntity);
                if (delayedAddConsumer != null) {
                    delayedAddConsumer.accept(itemEntity);
                }
            }));
            return null;
        }
        EntityItem itemEntity = new EntityItem(level, this.dK() + offset.g, this.dM() + offset.h, this.dQ() + offset.i, stack.v());
        stack.e(0);
        itemEntity.i();
        return this.spawnAtLocation(level, itemEntity);
    }

    @Nullable
    public EntityItem spawnAtLocation(WorldServer level, EntityItem itemEntity) {
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        level.b(itemEntity);
        return itemEntity;
    }

    @Nullable
    public EntityItem a(WorldServer level, ItemStack stack, float yOffset) {
        return this.a(level, stack, new Vec3D(0.0, yOffset, 0.0));
    }

    public boolean bX() {
        return !this.ec();
    }

    public boolean bY() {
        if (this.ar) {
            return false;
        }
        double reducedWith = this.bz.a() * 0.8f;
        AxisAlignedBB boundingBox = AxisAlignedBB.a(this.bR(), reducedWith, 1.0E-6, reducedWith);
        net.minecraft.world.level.World world = this.aU;
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        int minBlockX = MathHelper.a(boundingBox.a);
        int minBlockY = MathHelper.a(boundingBox.b);
        int minBlockZ = MathHelper.a(boundingBox.c);
        int maxBlockX = MathHelper.a(boundingBox.d);
        int maxBlockY = MathHelper.a(boundingBox.e);
        int maxBlockZ = MathHelper.a(boundingBox.f);
        int minChunkX = minBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkY = maxBlockY >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minSection = WorldUtil.getMinSection(world);
        IChunkProvider chunkSource = world.X();
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkSection[] sections = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, true).d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).c()) continue;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.q(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.r(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                VoxelShape collisionShape;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.p(blockX);
                                IBlockData blockState = blocks.a(currX | currZ << 4 | currY << 8);
                                if (blockState.moonrise$emptyCollisionShape() || !blockState.j(world, mutablePos) || (collisionShape = blockState.g(world, mutablePos)).c()) continue;
                                AxisAlignedBB toCollide = boundingBox.d(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AxisAlignedBB singleAABB = collisionShape.moonrise$getSingleAABBRepresentation();
                                if (!(singleAABB != null ? CollisionUtil.voxelShapeIntersect(singleAABB, toCollide) : CollisionUtil.voxelShapeIntersectNoEmpty(collisionShape, toCollide))) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        Entity flag2;
        ItemStack itemInHand;
        Object list;
        EntityLiving livingEntity;
        Leashable leashable;
        Entity entity;
        if (!this.an().D_() && player.gp() && (entity = this) instanceof Leashable && (leashable = (Leashable)((Object)entity)).v() && this.bX() && (!((entity = this) instanceof EntityLiving) || !(livingEntity = (EntityLiving)entity).g_()) && !(list = Leashable.a(this, (Leashable leashable3) -> leashable3.ak_() == player)).isEmpty()) {
            boolean flag2 = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PlayerLeashEntityEvent event;
                Leashable leashable1 = (Leashable)iterator.next();
                if (!leashable1.b_(this) || (event = CraftEventFactory.callPlayerLeashEntityEvent(leashable1, this, player, hand)) != null && event.isCancelled()) continue;
                leashable1.a_(this, true);
                flag2 = true;
            }
            if (flag2) {
                this.an().a(GameEvent.u, this.dF(), GameEvent.a.a(player));
                this.a(SoundEffects.pG);
                return EnumInteractionResult.b.b();
            }
        }
        if ((itemInHand = player.b(hand)).a(Items.tZ) && this.shearOffAllLeashConnections(player, hand)) {
            itemInHand.a(1, (EntityLiving)player, hand);
            return EnumInteractionResult.a;
        }
        list = this;
        if (list instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)list;
            if (itemInHand.a(Items.tZ) && mob.a(player) && !player.gp() && this.a(player, hand, itemInHand, mob)) {
                return EnumInteractionResult.a;
            }
        }
        if (this.bX() && (flag2 = this) instanceof Leashable) {
            Leashable leashable2 = (Leashable)((Object)flag2);
            if (leashable2.ak_() == player) {
                if (!this.an().D_()) {
                    if (hand == EnumHand.b && (this.an().purpurConfig.villagerCanBeLeashed || this.an().purpurConfig.wanderingTraderCanBeLeashed) && this instanceof EntityVillagerAbstract) {
                        return EnumInteractionResult.c;
                    }
                    if (!CraftEventFactory.handlePlayerUnleashEntityEvent(leashable2, player, hand, !player.gk(), true)) {
                        return EnumInteractionResult.e;
                    }
                    this.a(GameEvent.r, (Entity)player);
                    this.a(SoundEffects.pF);
                }
                return EnumInteractionResult.a.b();
            }
            ItemStack itemInHand1 = player.b(hand);
            if (itemInHand1.a(Items.wU) && !(leashable2.ak_() instanceof EntityHuman)) {
                if (!this.an().D_() && leashable2.b_(player)) {
                    if (leashable2.T_() && !CraftEventFactory.handlePlayerUnleashEntityEvent(leashable2, player, hand, true, true)) {
                        return EnumInteractionResult.e;
                    }
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, (Entity)player, player, hand).isCancelled()) {
                        ((EntityPlayer)player).g.b(new PacketPlayOutAttachEntity(this, leashable2.ak_()));
                        return EnumInteractionResult.e;
                    }
                    leashable2.a_(player, true);
                    this.a(SoundEffects.pG);
                    itemInHand1.h(1);
                }
                return EnumInteractionResult.a;
            }
        }
        return EnumInteractionResult.e;
    }

    public boolean c(@Nullable EntityHuman player) {
        return this.shearOffAllLeashConnections(player, null);
    }

    public boolean shearOffAllLeashConnections(@Nullable EntityHuman player, @Nullable EnumHand interactionHand) {
        net.minecraft.world.level.World world;
        boolean flag = this.dropAllLeashConnections(player, interactionHand);
        if (flag && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.a(null, this.dF(), SoundEffects.yw, player != null ? player.dw() : this.dw());
        }
        return flag;
    }

    public boolean d(@Nullable EntityHuman player) {
        return this.dropAllLeashConnections(player, null);
    }

    public boolean dropAllLeashConnections(@Nullable EntityHuman player, @Nullable EnumHand interactionHand) {
        Leashable leashable;
        List<Leashable> list = Leashable.c_(this);
        boolean flag = false;
        Entity entity = this;
        if (entity instanceof Leashable && (leashable = (Leashable)((Object)entity)).T_()) {
            flag |= CraftEventFactory.handlePlayerUnleashEntityEvent(this, player, interactionHand, true, true);
        }
        for (Leashable leashable1 : list) {
            flag |= CraftEventFactory.handlePlayerUnleashEntityEvent(leashable1, player, interactionHand, true, true);
        }
        if (flag) {
            this.a(GameEvent.M, (Entity)player);
            return true;
        }
        return false;
    }

    private boolean a(EntityHuman player, EnumHand hand, ItemStack stack, EntityInsentient mob) {
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            ItemStack itemBySlot = mob.a(equipmentSlot);
            Equippable equippable = itemBySlot.a(DataComponents.D);
            if (equippable == null || !equippable.k() || EnchantmentManager.a(itemBySlot, EnchantmentEffectComponents.E) && !player.gQ()) continue;
            stack.a(1, (EntityLiving)player, hand.a());
            Vec3D average = this.bz.d().a(EntityAttachment.a);
            mob.b(equipmentSlot, ItemStack.l);
            this.a(GameEvent.M, (Entity)player);
            this.a(equippable.l().a());
            net.minecraft.world.level.World world = this.an();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                this.forceDrops = true;
                this.a(serverLevel, itemBySlot, average);
                this.forceDrops = false;
                CriterionTriggers.U.a((EntityPlayer)player, itemBySlot, mob);
            }
            return true;
        }
        return false;
    }

    public boolean i(Entity entity) {
        return entity.j(this) && !this.A(entity);
    }

    public boolean j(@Nullable Entity entity) {
        return false;
    }

    public void t() {
        this.k(Vec3D.c);
        this.g();
        if (this.cl()) {
            this.du().k(this);
        }
    }

    public final void k(Entity passenger) {
        if (this.z(passenger)) {
            this.a(passenger, Entity::a_);
        }
    }

    protected void a(Entity passenger, MoveFunction callback) {
        Vec3D passengerRidingPosition = this.n(passenger);
        Vec3D vehicleAttachmentPoint = passenger.m(this);
        callback.accept(passenger, passengerRidingPosition.g - vehicleAttachmentPoint.g, passengerRidingPosition.h - vehicleAttachmentPoint.h, passengerRidingPosition.i - vehicleAttachmentPoint.i);
    }

    public void l(Entity entityToUpdate) {
    }

    public Vec3D m(Entity entity) {
        return this.dC().b(EntityAttachment.b, 0, this.aZ);
    }

    public Vec3D n(Entity entity) {
        return this.dD().e(this.a(entity, this.bz, 1.0f));
    }

    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return Entity.a(this, entity, dimensions.d());
    }

    protected static Vec3D a(Entity vehicle, Entity passenger, EntityAttachments attachments) {
        int index = vehicle.di().indexOf(passenger);
        return attachments.c(EntityAttachment.a, index, vehicle.aZ);
    }

    public final boolean o(Entity entity) {
        return this.a(entity, false, true);
    }

    public boolean bZ() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean force, boolean triggerEvents) {
        if (entity == this.aT || entity.aU != this.aU) {
            return false;
        }
        if (!entity.cc()) {
            return false;
        }
        if (!(force || this.an().D_() || entity.aP.b())) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.aT != null) {
            if (entity1.aT == this) {
                return false;
            }
            entity1 = entity1.aT;
        }
        if (force || this.p(entity) && entity.s(this)) {
            EntityMountEvent event;
            if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
                event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
                if (this.valid) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return false;
                }
            }
            event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
            if (this.cl()) {
                this.cb();
            }
            this.c(EntityPose.a);
            this.aT = entity;
            this.aT.q(this);
            if (triggerEvents) {
                this.an().a(this, GameEvent.s, this.aT.aV);
                entity.J().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.V.a((EntityPlayer)entity2));
            }
            return true;
        }
        return false;
    }

    protected boolean p(Entity vehicle) {
        return !this.cp() && this.X <= 0;
    }

    public void ca() {
        for (int i2 = this.aS.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.aS.get(i2)).cb();
        }
    }

    public void ad() {
        this.removeVehicle(false);
    }

    public void removeVehicle(boolean suppressCancellation) {
        if (this.aT != null) {
            RemovalReason removalReason;
            Entity entity = this.aT;
            this.aT = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.aT = entity;
            }
            if ((removalReason = this.ed()) == null || removalReason.a()) {
                this.an().a(this, GameEvent.q, entity.aV);
            }
        }
    }

    public void cb() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        this.removeVehicle(suppressCancellation);
    }

    protected void q(Entity passenger) {
        if (passenger.du() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.aS.isEmpty()) {
            this.aS = ImmutableList.of((Object)passenger);
        } else {
            ArrayList list = Lists.newArrayList(this.aS);
            if (!this.an().D_() && passenger instanceof EntityHuman && !(this.dj() instanceof EntityHuman)) {
                list.add(0, passenger);
            } else {
                list.add(passenger);
            }
            this.aS = ImmutableList.copyOf((Collection)list);
        }
        if (this.isRidable() && this.aS.get(0) == passenger && passenger instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)passenger;
            this.onMount(player);
            this.rider = player;
        }
    }

    protected boolean removePassenger(Entity passenger) {
        return this.removePassenger(passenger, false);
    }

    protected boolean removePassenger(Entity passenger, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (passenger.du() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)passenger.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && passenger.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)passenger.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)passenger.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)passenger.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.rider != null && this.aS.get(0) == this.rider) {
            this.onDismount(this.rider);
            this.rider = null;
        }
        this.aS = this.aS.size() == 1 && this.aS.get(0) == passenger ? ImmutableList.of() : (ImmutableList)this.aS.stream().filter(entity -> entity != passenger).collect(ImmutableList.toImmutableList());
        passenger.X = 60;
        return true;
    }

    protected boolean s(Entity passenger) {
        return this.aS.isEmpty();
    }

    protected boolean cc() {
        return true;
    }

    public final boolean cd() {
        return this.n_() != null && this.n_().d();
    }

    public final void d(Vec3D pos, float yRot, float xRot) {
        this.a(Optional.of(pos), Optional.of(Float.valueOf(yRot)), Optional.of(Float.valueOf(xRot)));
    }

    public final void e(float yRot, float xRot) {
        this.a(Optional.empty(), Optional.of(Float.valueOf(yRot)), Optional.of(Float.valueOf(xRot)));
    }

    public final void i(Vec3D pos) {
        this.a(Optional.of(pos), Optional.empty(), Optional.empty());
    }

    public final void a(Optional<Vec3D> pos, Optional<Float> yRot, Optional<Float> xRot) {
        InterpolationHandler interpolation = this.n_();
        if (interpolation != null) {
            interpolation.a(pos.orElse(interpolation.a()), yRot.orElse(Float.valueOf(interpolation.b())).floatValue(), xRot.orElse(Float.valueOf(interpolation.c())).floatValue());
        } else {
            pos.ifPresent(this::b);
            yRot.ifPresent(_float -> this.v(_float.floatValue() % 360.0f));
            xRot.ifPresent(_float -> this.w(_float.floatValue() % 360.0f));
        }
    }

    @Nullable
    public InterpolationHandler n_() {
        return null;
    }

    public void a(float yRot, int steps) {
        this.r(yRot);
    }

    public float ce() {
        return 0.0f;
    }

    public Vec3D cf() {
        return this.c(this.dZ(), this.dX());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof EntityHuman)) {
            return Vec3D.c;
        }
        EntityHuman player = (EntityHuman)entity;
        boolean flag = player.fr().a(item) && !player.fq().a(item);
        EnumMainHand humanoidArm = flag ? player.as().e() : player.as();
        return this.c(0.0f, this.dX() + (float)(humanoidArm == EnumMainHand.b ? 80 : -80)).c(0.5);
    }

    public Vec2F cg() {
        return new Vec2F(this.dZ(), this.dX());
    }

    public Vec3D ch() {
        return Vec3D.a(this.cg());
    }

    public void a(Portal portal, BlockPosition pos) {
        if (this.aL()) {
            if (!this.an().purpurConfig.playerFixStuckPortal || !(this instanceof EntityHuman) || pos.equals(this.portalPos)) {
                this.aJ();
            }
        } else if (this.aU.purpurConfig.entitiesCanUsePortals || this instanceof EntityPlayer) {
            if (this.aG == null || !this.aG.a(portal)) {
                this.aG = new PortalProcessor(portal, pos.j());
            } else if (!this.aG.e()) {
                this.aG.a(pos.j());
                this.aG.a(true);
                this.portalPos = BlockPosition.c;
            }
        }
    }

    protected void ci() {
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.O();
            if (this.aG != null) {
                if (this.aG.a(serverLevel, this, this.o(false))) {
                    GameProfilerFiller profilerFiller = Profiler.a();
                    profilerFiller.a("portal");
                    this.aJ();
                    TeleportTransition portalDestination = this.aG.a(serverLevel, this);
                    if (portalDestination != null) {
                        WorldServer level = portalDestination.b();
                        if (this instanceof EntityPlayer || level != null && (level.al() == serverLevel.al() || this.a((net.minecraft.world.level.World)serverLevel, (net.minecraft.world.level.World)level))) {
                            this.b(portalDestination);
                        }
                    }
                    profilerFiller.c();
                } else if (this.aG.b()) {
                    this.aG = null;
                }
            }
        }
    }

    public int cj() {
        Entity firstPassenger = this.dj();
        return firstPassenger instanceof EntityPlayer ? firstPassenger.cj() : 300;
    }

    public void j(Vec3D movement) {
        this.k(movement);
    }

    public void c(DamageSource damageSource) {
    }

    public void b(byte id) {
        switch (id) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void q(float yaw) {
    }

    public boolean ck() {
        boolean flag = this.an() != null && this.an().D_();
        return !this.bt() && (this.bf > 0 || flag && this.i(0));
    }

    public boolean cl() {
        return this.du() != null;
    }

    public boolean cm() {
        return !this.aS.isEmpty();
    }

    public boolean cn() {
        return this.ax().a(TagsEntity.p);
    }

    public boolean co() {
        return !this.ax().a(TagsEntity.q);
    }

    public void h(boolean keyDown) {
        this.b(1, keyDown);
    }

    public boolean cp() {
        return this.i(1);
    }

    public boolean cq() {
        return this.cp();
    }

    public boolean cr() {
        return this.cp();
    }

    public boolean cs() {
        return this.cp();
    }

    public boolean ct() {
        return this.cp();
    }

    public boolean cu() {
        return this.d(EntityPose.f);
    }

    public boolean cv() {
        return this.i(3);
    }

    public void i(boolean sprinting) {
        this.b(3, sprinting);
    }

    public boolean cw() {
        return this.i(4);
    }

    public boolean cx() {
        return this.d(EntityPose.d);
    }

    public boolean cy() {
        return this.cx() && !this.bu();
    }

    public void j(boolean swimming) {
        if (this.valid && this.cw() != swimming && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, swimming).isCancelled()) {
            return;
        }
        this.b(4, swimming);
    }

    public final boolean cz() {
        return this.bv;
    }

    public final void k(boolean hasGlowingTag) {
        this.bv = hasGlowingTag;
        this.b(6, this.cA());
    }

    public boolean cA() {
        return this.an().D_() ? this.i(6) : this.bv;
    }

    public boolean cB() {
        return this.i(5);
    }

    public boolean e(EntityHuman player) {
        if (player.at()) {
            return false;
        }
        ScoreboardTeam team = this.cD();
        return (team == null || player == null || player.cD() != team || !((ScoreboardTeamBase)team).j()) && this.cB();
    }

    public boolean cC() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> listenerConsumer) {
    }

    @Nullable
    public ScoreboardTeam cD() {
        if (!this.an().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
            return null;
        }
        return this.an().W().e(this.cV());
    }

    public final boolean t(@Nullable Entity entity) {
        return entity != null && (this == entity || this.u(entity) || entity.u(this));
    }

    protected boolean u(Entity entity) {
        return this.a(entity.cD());
    }

    public boolean a(@Nullable ScoreboardTeamBase team) {
        return this.cD() != null && this.cD().a(team);
    }

    public void l(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.b(5, invisible);
        }
    }

    public boolean i(int flag) {
        return (this.az.a(aA) & 1 << flag) != 0;
    }

    public void b(int flag, boolean set) {
        byte b2 = this.az.a(aA);
        if (set) {
            this.az.a(aA, (byte)(b2 | 1 << flag));
        } else {
            this.az.a(aA, (byte)(b2 & ~(1 << flag)));
        }
    }

    public int cE() {
        return this.aU == null ? this.maxAirTicks : this.an().purpurConfig.drowningAirTicks;
    }

    public int cF() {
        return this.az.a(bl);
    }

    public void j(int airSupply) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), airSupply);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.cF() != airSupply) {
            this.az.markDirty(bl);
            return;
        }
        this.az.a(bl, event.getAmount());
    }

    public void cG() {
        if (this.freezeLocked) {
            return;
        }
        this.k(0);
    }

    public int cH() {
        return this.az.a(bq);
    }

    public void k(int ticksFrozen) {
        this.az.a(bq, ticksFrozen);
    }

    public float cI() {
        int ticksRequiredToFreeze = this.cK();
        return (float)Math.min(this.cH(), ticksRequiredToFreeze) / (float)ticksRequiredToFreeze;
    }

    public boolean cJ() {
        return this.cH() >= this.cK();
    }

    public int cK() {
        return 140;
    }

    public void a(WorldServer level, EntityLightning lightning) {
        this.h(this.bf + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.bf == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            } else {
                this.h(this.bf - 1);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.bt()) {
            return;
        }
        if (!this.a(level, this.ei().c().eventEntityDamager(lightning), 5.0f)) {
            return;
        }
    }

    public void a(boolean downwards, BlockPosition pos) {
        Entity.a(this, downwards, pos);
    }

    protected static void a(Entity entity, boolean downwards, BlockPosition pos) {
        Vec3D deltaMovement = entity.dI();
        double max = downwards ? Math.max(-0.9, deltaMovement.h - 0.03) : Math.min(1.8, deltaMovement.h + 0.1);
        entity.m(deltaMovement.g, max, deltaMovement.i);
        Entity.a(entity.aU, pos);
    }

    protected static void a(net.minecraft.world.level.World level, BlockPosition pos) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            for (int i2 = 0; i2 < 2; ++i2) {
                serverLevel.a(Particles.aq, (double)pos.u() + level.z.j(), (double)(pos.v() + 1), (double)pos.w() + level.z.j(), 1, 0.0, 0.0, 0.0, 1.0);
                serverLevel.a(Particles.d, (double)pos.u() + level.z.j(), (double)(pos.v() + 1), (double)pos.w() + level.z.j(), 1, 0.0, 0.01, 0.0, 0.2);
            }
        }
    }

    public void m(boolean downwards) {
        Entity.a(this, downwards);
    }

    protected static void a(Entity entity, boolean downwards) {
        Vec3D deltaMovement = entity.dI();
        double max = downwards ? Math.max(-0.3, deltaMovement.h - 0.03) : Math.min(0.7, deltaMovement.h + 0.06);
        entity.m(deltaMovement.g, max, deltaMovement.i);
        entity.l();
    }

    public boolean a(WorldServer level, EntityLiving entity, DamageSource damageSource) {
        return true;
    }

    public void cL() {
        if (this.dI().b() > -0.5 && this.an > 1.0) {
            this.an = 1.0;
        }
    }

    public void l() {
        this.an = 0.0;
    }

    protected void k(double x2, double y2, double z2) {
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        Vec3D vec3 = new Vec3D(x2 - (double)blockPos.u(), y2 - (double)blockPos.v(), z2 - (double)blockPos.w());
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        EnumDirection direction = EnumDirection.b;
        double d2 = Double.MAX_VALUE;
        for (EnumDirection direction1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d22;
            mutableBlockPos.a((BaseBlockPosition)blockPos, direction1);
            if (this.an().a_(mutableBlockPos).m(this.an(), mutableBlockPos)) continue;
            double d1 = vec3.a(direction1.o());
            double d3 = d22 = direction1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d1 : d1;
            if (!(d22 < d2)) continue;
            d2 = d22;
            direction = direction1;
        }
        float f2 = this.as.i() * 0.2f + 0.1f;
        float f1 = direction.f().a();
        Vec3D vec31 = this.dI().c(0.75);
        if (direction.o() == EnumDirection.EnumAxis.a) {
            this.m(f1 * f2, vec31.h, vec31.i);
        } else if (direction.o() == EnumDirection.EnumAxis.b) {
            this.m(vec31.g, f1 * f2, vec31.i);
        } else if (direction.o() == EnumDirection.EnumAxis.c) {
            this.m(vec31.g, vec31.h, f1 * f2);
        }
    }

    public void a(IBlockData state, Vec3D motionMultiplier) {
        this.l();
        this.ai = motionMultiplier;
    }

    private static IChatBaseComponent a(IChatBaseComponent name) {
        IChatMutableComponent mutableComponent = name.e().b(name.a().a((ChatClickable)null));
        for (IChatBaseComponent component : name.c()) {
            mutableComponent.b(Entity.a(component));
        }
        return mutableComponent;
    }

    @Override
    public IChatBaseComponent ao() {
        IChatBaseComponent customName = this.ar();
        return customName != null ? Entity.a(customName) : this.cM();
    }

    protected IChatBaseComponent cM() {
        return this.aP.h();
    }

    public boolean v(Entity entity) {
        return this == entity;
    }

    public float cN() {
        return 0.0f;
    }

    public void r(float yHeadRot) {
    }

    public void s(float yBodyRot) {
    }

    public boolean cO() {
        return true;
    }

    public boolean w(Entity entity) {
        return false;
    }

    public String toString() {
        String string = this.an() == null ? "~NULL~" : this.an().toString();
        return this.bd != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.ap(), this.aR, this.aH, string, this.dK(), this.dM(), this.dQ(), this.dH(), this.at, this.valid, this.bd}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.ap(), this.aR, this.aH, string, this.dK(), this.dM(), this.dQ(), this.dH(), this.at, this.valid);
    }

    public final boolean d(DamageSource damageSource) {
        return this.ec() || this.bu && !damageSource.a(DamageTypeTags.d) && !damageSource.h() || damageSource.a(DamageTypeTags.i) && this.bt() || damageSource.a(DamageTypeTags.m) && this.ax().a(TagsEntity.o);
    }

    public boolean cP() {
        return this.bu;
    }

    public void n(boolean invulnerable) {
        this.bu = invulnerable;
    }

    public void x(Entity entity) {
        this.b(entity.dK(), entity.dM(), entity.dQ(), entity.dX(), entity.dZ());
    }

    public void y(Entity entity) {
        CraftEntity bukkitEntity = entity.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(this.en(), b);){
            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, entity.ej());
            entity.d(tagValueOutput);
            this.d(TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)this.ej(), tagValueOutput.b()));
        }
        this.bt = entity.bt;
        this.aG = entity.aG;
    }

    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        if (!(this.bX() && this.valid || teleportTransition.b() == this.aU)) {
            b.warn("Illegal Entity Teleport {} to {}:{}", new Object[]{this, teleportTransition.b(), teleportTransition.c(), new Throwable()});
            return null;
        }
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (!this.ec()) {
                boolean flag;
                EntityTeleportEvent teleEvent;
                TileEntity tileEntity;
                PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTransition), teleportTransition.i());
                Vec3D velocity = absolutePosition.b();
                Location to = CraftLocation.toBukkit(absolutePosition.a(), (net.minecraft.world.level.World)teleportTransition.b(), absolutePosition.c(), absolutePosition.d());
                if (this.aG != null && this.aG.a((BlockEndGateway)Blocks.lB) && (tileEntity = this.aU.c_(this.aG.c())) instanceof TileEntityEndGateway) {
                    TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
                    teleEvent = new EntityTeleportEndGatewayEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), this.getBukkitEntity().getLocation(), to, (EndGateway)new CraftEndGateway(to.getWorld(), theEndGatewayBlockEntity));
                    teleEvent.callEvent();
                } else {
                    teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                }
                if (teleEvent.isCancelled() || teleEvent.getTo() == null) {
                    return null;
                }
                if (!to.equals((Object)teleEvent.getTo())) {
                    to = teleEvent.getTo();
                    teleportTransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3(to), Vec3D.c, to.getYaw(), to.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
                    velocity = Vec3D.c;
                }
                if (this.aG != null) {
                    CraftEntity bukkitEntity = this.getBukkitEntity();
                    Vector before = bukkitEntity.getVelocity();
                    Vector after = CraftVector.toBukkit(velocity);
                    EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), to.clone(), before, after);
                    event.callEvent();
                    if (event.isCancelled() || !to.equals((Object)event.getTo()) || !after.equals((Object)event.getAfter())) {
                        if (event.isCancelled() || event.getTo() == null) {
                            World toWorld = to.getWorld();
                            to = event.getFrom().clone();
                            to.setWorld(toWorld);
                            velocity = CraftVector.toVec3(event.getBefore());
                        } else {
                            to = event.getTo().clone();
                            velocity = CraftVector.toVec3(event.getAfter());
                        }
                        teleportTransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3(to), velocity, to.getYaw(), to.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
                    }
                }
                if (this.ec()) {
                    return null;
                }
                WorldServer level = teleportTransition.b();
                boolean bl = flag = level.al() != serverLevel.al();
                if (!teleportTransition.h()) {
                    this.cb();
                }
                return flag ? this.a(serverLevel, level, teleportTransition) : this.a(serverLevel, teleportTransition);
            }
        }
        return null;
    }

    private Entity a(WorldServer level, TeleportTransition teleportTransition) {
        for (Entity entity : this.di()) {
            entity.b(this.a(teleportTransition, entity));
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("teleportSameDimension");
        this.a(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        if (!teleportTransition.h()) {
            this.a(teleportTransition);
        }
        teleportTransition.j().onTransition(this);
        profilerFiller.c();
        return this;
    }

    @Nullable
    private Entity a(WorldServer oldLevel, WorldServer newLevel, TeleportTransition teleportTransition) {
        List<Entity> passengers = this.di();
        ArrayList<Entity> list = new ArrayList<Entity>(passengers.size());
        this.ca();
        for (Entity entity : passengers) {
            Entity entity1 = entity.b(this.a(teleportTransition, entity));
            if (entity1 == null) continue;
            list.add(entity1);
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("teleportCrossDimension");
        Object entityx = this.ax().a(newLevel, EntitySpawnReason.s);
        if (entityx == null) {
            profilerFiller.c();
            return null;
        }
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            leashable.w();
        }
        ((Entity)entityx).y(this);
        this.cQ();
        ((Entity)entityx).a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        if (this.inWorld) {
            newLevel.d((Entity)entityx);
        }
        for (Entity entity2 : list) {
            entity2.a((Entity)entityx, true, false);
        }
        newLevel.j();
        teleportTransition.j().onTransition((Entity)entityx);
        this.a(teleportTransition, oldLevel);
        profilerFiller.c();
        return entityx;
    }

    protected void a(TeleportTransition teleportTransition, WorldServer oldLevel) {
        for (EntityPlayer serverPlayer : List.copyOf(oldLevel.C())) {
            if (serverPlayer.N() != this) continue;
            serverPlayer.a(teleportTransition);
            serverPlayer.d((Entity)null);
        }
    }

    private TeleportTransition a(TeleportTransition teleportTransition, Entity entity) {
        float f2 = teleportTransition.e() + (teleportTransition.i().contains((Object)Relative.d) ? 0.0f : entity.dX() - this.dX());
        float f1 = teleportTransition.f() + (teleportTransition.i().contains((Object)Relative.e) ? 0.0f : entity.dZ() - this.dZ());
        Vec3D vec3 = entity.dD().d(this.dD());
        Vec3D vec31 = teleportTransition.c().b(teleportTransition.i().contains((Object)Relative.a) ? 0.0 : vec3.a(), teleportTransition.i().contains((Object)Relative.b) ? 0.0 : vec3.b(), teleportTransition.i().contains((Object)Relative.c) ? 0.0 : vec3.c());
        return teleportTransition.a(vec31).a(f2, f1).a();
    }

    private void a(TeleportTransition teleportTransition) {
        EntityLiving controllingPassenger = this.dg();
        for (Entity entity : this.dm()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (controllingPassenger != null && serverPlayer.az() == controllingPassenger.az()) {
                serverPlayer.g.b(PacketPlayOutEntityTeleport.a(this.az(), PositionMoveRotation.a(teleportTransition), teleportTransition.i(), this.bc));
                continue;
            }
            serverPlayer.g.b(PacketPlayOutEntityTeleport.a(this.az(), PositionMoveRotation.a(this), Set.of(), this.bc));
        }
    }

    public void a(PositionMoveRotation positionMovementRotation, Set<Relative> relatives) {
        this.a(PositionMoveRotation.a(this), positionMovementRotation, relatives);
    }

    public void a(PositionMoveRotation currentPos, PositionMoveRotation afterPos, Set<Relative> relatives) {
        PositionMoveRotation positionMoveRotation = PositionMoveRotation.a(currentPos, afterPos, relatives);
        this.n(positionMoveRotation.a().g, positionMoveRotation.a().h, positionMoveRotation.a().i);
        this.v(positionMoveRotation.c());
        this.r(positionMoveRotation.c());
        this.w(positionMoveRotation.d());
        this.aG();
        this.bL();
        this.k(positionMoveRotation.b());
        this.aV();
    }

    public void a(float yRot, boolean yRelative, float xRot, boolean xRelative) {
        Set<Relative> set = Relative.a(yRelative, xRelative);
        PositionMoveRotation positionMoveRotation = PositionMoveRotation.a(this);
        PositionMoveRotation positionMoveRotation1 = positionMoveRotation.a(yRot, xRot);
        PositionMoveRotation positionMoveRotation2 = PositionMoveRotation.a(positionMoveRotation, positionMoveRotation1, set);
        this.v(positionMoveRotation2.c());
        this.r(positionMoveRotation2.c());
        this.w(positionMoveRotation2.d());
        this.bN();
    }

    public void f(BlockPosition pos) {
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.n().b(TicketType.m, new ChunkCoordIntPair(pos), 3);
        }
    }

    protected void cQ() {
        Object object;
        Leashable leashable;
        this.setRemoved(RemovalReason.e, null);
        Entity entity = this;
        if (entity instanceof Leashable && (leashable = (Leashable)((Object)entity)).T_()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
            event.callEvent();
            if (!event.isDropLeash()) {
                leashable.x();
            } else {
                leashable.w();
            }
        }
        if ((object = this) instanceof WaypointTransmitter) {
            WaypointTransmitter waypointTransmitter = (WaypointTransmitter)object;
            object = this.aU;
            if (object instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)object;
                serverLevel.h().c(waypointTransmitter);
            }
        }
    }

    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return BlockPortalShape.a(portal, axis, this.dD(), this.a(this.aE()));
    }

    public boolean o(boolean allowPassengers) {
        return !(!allowPassengers && this.cl() || !this.bX() || !this.aU.purpurConfig.entitiesCanUsePortals && !(this instanceof EntityPlayer));
    }

    public boolean a(net.minecraft.world.level.World fromLevel, net.minecraft.world.level.World toLevel) {
        if (!this.bX() || !this.valid) {
            return false;
        }
        if (fromLevel.al() == net.minecraft.world.level.World.j && toLevel.al() == net.minecraft.world.level.World.h) {
            for (Entity entity : this.di()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                if (serverPlayer.i) continue;
                return false;
            }
        }
        return true;
    }

    public float a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData state, Fluid fluidState, float explosionPower) {
        return explosionPower;
    }

    public boolean a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData state, float explosionPower) {
        return true;
    }

    public int cR() {
        return 3;
    }

    public boolean o_() {
        return false;
    }

    public void a(CrashReportSystemDetails category) {
        category.a("Entity Type", () -> String.valueOf(EntityTypes.a(this.ax())) + " (" + this.getClass().getCanonicalName() + ")");
        category.a("Entity ID", this.aR);
        category.a("Entity Name", () -> this.ap());
        category.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dK(), this.dM(), this.dQ()));
        category.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.an(), MathHelper.a(this.dK()), MathHelper.a(this.dM()), MathHelper.a(this.dQ())));
        Vec3D deltaMovement = this.dI();
        category.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", deltaMovement.g, deltaMovement.h, deltaMovement.i));
        category.a("Entity's Passengers", () -> this.di().toString());
        category.a("Entity's Vehicle", () -> String.valueOf(this.du()));
    }

    public boolean cS() {
        return this.ck() && !this.at();
    }

    public void a_(UUID uuid) {
        this.aH = uuid;
        this.aI = this.aH.toString();
    }

    @Override
    public UUID cT() {
        return this.aH;
    }

    public String cU() {
        return this.aI;
    }

    @Override
    public String cV() {
        return this.aI;
    }

    public boolean cW() {
        return true;
    }

    public static double cX() {
        return aO;
    }

    public static void c(double renderDistWeight) {
        aO = renderDistWeight;
    }

    @Override
    public IChatBaseComponent S_() {
        return ScoreboardTeam.a(this.cD(), this.ao()).a(style -> style.a(this.dd()).a(this.cU()));
    }

    public void b(@Nullable IChatBaseComponent name) {
        this.az.a(bm, Optional.ofNullable(name));
    }

    @Override
    @Nullable
    public IChatBaseComponent ar() {
        return this.az.a(bm).orElse(null);
    }

    @Override
    public boolean k_() {
        return this.az.a(bm).isPresent();
    }

    public void p(boolean visible) {
        this.az.a(bn, visible);
    }

    public boolean cY() {
        return this.az.a(bn);
    }

    public final boolean a(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera) {
        return this.teleportTo(level, x2, y2, z2, relativeMovements, yaw, pitch, setCamera, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleportTo(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera, PlayerTeleportEvent.TeleportCause cause) {
        Entity entity = this.b(new TeleportTransition(level, new Vec3D(x2, y2, z2), Vec3D.c, yaw, pitch, relativeMovements, TeleportTransition.a, cause));
        return entity != null;
    }

    public void l(double x2, double y2, double z2) {
        this.b(x2, y2, z2);
    }

    public void b(double x2, double y2, double z2) {
        if (this.an() instanceof WorldServer) {
            this.b(x2, y2, z2, this.dX(), this.dZ());
            this.I();
        }
    }

    public void I() {
        this.dk().forEach(entity -> {
            for (Entity entity1 : entity.aS) {
                entity.a(entity1, Entity::d);
            }
        });
    }

    public void c(double dx, double dy, double dz) {
        this.b(this.dK() + dx, this.dM() + dy, this.dQ() + dz);
    }

    public boolean cZ() {
        return this.cY();
    }

    @Override
    public void a(List<DataWatcher.c<?>> dataValues) {
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (aE.equals(key)) {
            this.l_();
        }
    }

    @Deprecated
    protected void da() {
        EntitySize dimensions;
        EntityPose pose = this.aE();
        this.bz = dimensions = this.a(pose);
        this.bA = dimensions.c();
    }

    public void l_() {
        boolean flag;
        EntitySize dimensions;
        EntitySize entityDimensions = this.bz;
        EntityPose pose = this.aE();
        this.bz = dimensions = this.a(pose);
        this.bA = dimensions.c();
        this.aG();
        boolean bl = flag = dimensions.a() <= 4.0f && dimensions.b() <= 4.0f;
        if (!(this.aU.D_() || this.ay || this.ar || !flag || !(dimensions.a() > entityDimensions.a()) && !(dimensions.b() > entityDimensions.b()) || this instanceof EntityHuman)) {
            this.a(entityDimensions);
        }
    }

    public boolean a(EntitySize dimensions) {
        VoxelShape voxelShape1;
        Optional<Vec3D> optional1;
        double d1;
        double d2;
        EntitySize dimensions1 = this.a(this.aE());
        Vec3D vec3 = this.dD().b(0.0, (double)dimensions.b() / 2.0, 0.0);
        VoxelShape voxelShape = VoxelShapes.a(AxisAlignedBB.a(vec3, d2 = (double)Math.max(0.0f, dimensions1.a() - dimensions.a()) + 1.0E-6, d1 = (double)Math.max(0.0f, dimensions1.b() - dimensions.b()) + 1.0E-6, d2));
        Optional<Vec3D> optional = this.aU.a(this, voxelShape, vec3, (double)dimensions1.a(), (double)dimensions1.b(), (double)dimensions1.a());
        if (optional.isPresent()) {
            this.b(optional.get().b(0.0, (double)(-dimensions1.b()) / 2.0, 0.0));
            return true;
        }
        if (dimensions1.a() > dimensions.a() && dimensions1.b() > dimensions.b() && (optional1 = this.aU.a(this, voxelShape1 = VoxelShapes.a(AxisAlignedBB.a(vec3, d2, 1.0E-6, d2)), vec3, (double)dimensions1.a(), (double)dimensions.b(), (double)dimensions1.a())).isPresent()) {
            this.b(optional1.get().b(0.0, (double)(-dimensions.b()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public EnumDirection db() {
        return EnumDirection.a(this.dX());
    }

    public EnumDirection dc() {
        return this.db();
    }

    protected ChatHoverable dd() {
        return new ChatHoverable.c(new ChatHoverable.b(this.ax(), this.cT(), this.ao()));
    }

    public boolean a(EntityPlayer player) {
        return true;
    }

    @Override
    public final AxisAlignedBB de() {
        return this.bb;
    }

    public final void a(AxisAlignedBB bb) {
        double minX = bb.a;
        double minY = bb.b;
        double minZ = bb.c;
        double maxX = bb.d;
        double maxY = bb.e;
        double maxZ = bb.f;
        double len = bb.d - bb.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = bb.e - bb.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = bb.f - bb.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.bb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float e(EntityPose pose) {
        return this.a(pose).c();
    }

    public final float df() {
        return this.bA;
    }

    public SlotAccess a_(int slot) {
        return SlotAccess.a;
    }

    public EnumInteractionResult a(EntityHuman player, Vec3D vec, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    public boolean a(Explosion explosion) {
        return false;
    }

    public void d(EntityPlayer player) {
    }

    public void e(EntityPlayer player) {
        if (PlayerUntrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerUntrackEntityEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity()).callEvent();
        }
    }

    public float a(EnumBlockRotation transformRotation) {
        float f2 = MathHelper.h(this.dX());
        return switch (transformRotation) {
            case EnumBlockRotation.c -> f2 + 180.0f;
            case EnumBlockRotation.d -> f2 + 270.0f;
            case EnumBlockRotation.b -> f2 + 90.0f;
            default -> f2;
        };
    }

    public float a(EnumBlockMirror transformMirror) {
        float f2 = MathHelper.h(this.dX());
        return switch (transformMirror) {
            case EnumBlockMirror.c -> -f2;
            case EnumBlockMirror.b -> 180.0f - f2;
            default -> f2;
        };
    }

    public ProjectileDeflection a(IProjectile projectile) {
        return this.ax().a(TagsEntity.r) ? ProjectileDeflection.b : ProjectileDeflection.a;
    }

    @Nullable
    public EntityLiving dg() {
        return null;
    }

    public final boolean dh() {
        return this.dg() != null;
    }

    public final List<Entity> di() {
        return this.aS;
    }

    @Nullable
    public Entity dj() {
        return this.aS.isEmpty() ? null : (Entity)this.aS.get(0);
    }

    public boolean z(Entity entity) {
        return this.aS.contains((Object)entity);
    }

    public boolean a(Predicate<Entity> predicate) {
        for (Entity entity : this.aS) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> J() {
        if (this.aS.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.aS.stream().flatMap(Entity::dk);
    }

    public Stream<Entity> dk() {
        if (this.aS.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.J());
    }

    public Stream<Entity> dl() {
        if (this.aS.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.aS.stream().flatMap(Entity::dl), Stream.of(this));
    }

    public Iterable<Entity> dm() {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        if (this.aS.isEmpty()) {
            return ret;
        }
        Entity.collectIndirectPassengers(ret, this.aS);
        return ret;
    }

    public int dn() {
        return (int)this.J().filter(entity -> entity instanceof EntityHuman).count();
    }

    public boolean do() {
        if (this.aS.isEmpty()) {
            return false;
        }
        return this.dn() == 1;
    }

    public Entity dp() {
        Entity entity = this;
        while (entity.cl()) {
            entity = entity.du();
        }
        return entity;
    }

    public boolean A(Entity entity) {
        return this.dp() == entity.dp();
    }

    public boolean B(Entity entity) {
        if (!entity.cl()) {
            return false;
        }
        Entity vehicle = entity.du();
        return vehicle == this || this.B(vehicle);
    }

    public final boolean dq() {
        return this.aU.D_() ? this.dr() : !this.ab_();
    }

    protected boolean dr() {
        EntityLiving controllingPassenger = this.dg();
        return controllingPassenger != null && controllingPassenger.dr();
    }

    public boolean ab_() {
        EntityLiving controllingPassenger = this.dg();
        return controllingPassenger != null && controllingPassenger.ab_();
    }

    public boolean ds() {
        return this.dq();
    }

    public boolean dt() {
        return this.dq();
    }

    protected static Vec3D a(double vehicleWidth, double passengerWidth, float yRot) {
        double d2 = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f2 = -MathHelper.a(yRot * ((float)Math.PI / 180));
        float cos = MathHelper.b(yRot * ((float)Math.PI / 180));
        float max = Math.max(Math.abs(f2), Math.abs(cos));
        return new Vec3D((double)f2 * d2 / (double)max, 0.0, (double)cos * d2 / (double)max);
    }

    public Vec3D b(EntityLiving passenger) {
        return new Vec3D(this.dK(), this.de().e, this.dQ());
    }

    @Nullable
    public Entity du() {
        return this.aT;
    }

    @Nullable
    public Entity dv() {
        return this.aT != null && this.aT.dg() == this ? this.aT : null;
    }

    public EnumPistonReaction p_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory dw() {
        return SoundCategory.g;
    }

    public int dx() {
        return 0;
    }

    public CommandListenerWrapper d(WorldServer level) {
        return new CommandListenerWrapper(this.commandSource, this.dD(), this.cg(), level, 0, this.ap(), this.S_(), level.q(), this);
    }

    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        Vec3D vec3 = anchor.a(this);
        double d2 = target.g - vec3.g;
        double d1 = target.h - vec3.h;
        double d22 = target.i - vec3.i;
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        this.w(MathHelper.h((float)(-(MathHelper.d(d1, squareRoot) * 180.0 / 3.1415927410125732))));
        this.v(MathHelper.h((float)(MathHelper.d(d22, d2) * 180.0 / 3.1415927410125732) - 90.0f));
        this.r(this.dX());
        this.ac = this.dZ();
        this.ab = this.dX();
    }

    public float t(float partialTick) {
        return MathHelper.h(partialTick, this.ab, this.aZ);
    }

    public AxisAlignedBB getAxisForFluidCheck() {
        return this.de().h(0.001);
    }

    public boolean a(TagKey<FluidType> fluid, double flowScale) {
        if (this.dy()) {
            return false;
        }
        AxisAlignedBB boundingBox = this.de().h(0.001);
        net.minecraft.world.level.World world = this.aU;
        int minSection = WorldUtil.getMinSection(world);
        int minBlockX = MathHelper.a(boundingBox.a);
        int minBlockY = Math.max(minSection << 4, MathHelper.a(boundingBox.b));
        int minBlockZ = MathHelper.a(boundingBox.c);
        int maxBlockX = MathHelper.c(boundingBox.d) - 1;
        int maxBlockY = Math.min(WorldUtil.getMaxSection(world) << 4 | 0xF, MathHelper.c(boundingBox.e) - 1);
        int maxBlockZ = MathHelper.c(boundingBox.f) - 1;
        boolean isPushable = this.cW();
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        Vec3D pushVector = Vec3D.c;
        double totalPushes = 0.0;
        double maxHeightDiff = 0.0;
        boolean inFluid = false;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        IChunkProvider chunkSource = world.X();
        int chunkLenX = maxChunkX - minChunkX + 1;
        int chunkOffset = -(minChunkX + chunkLenX * minChunkZ);
        ChunkSection[][] sections = new ChunkSection[chunkLenX * (maxChunkZ - minChunkZ + 1)][];
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                sections[currChunkX + chunkLenX * currChunkZ + chunkOffset] = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, false).d();
            }
        }
        for (int currX = minBlockX; currX <= maxBlockX; ++currX) {
            for (int currY = minBlockY; currY <= maxBlockY; ++currY) {
                for (int currZ = minBlockZ; currZ <= maxBlockZ; ++currZ) {
                    double height;
                    double diff;
                    Fluid fluidState = sections[(currX >> 4) + chunkLenX * (currZ >> 4) + chunkOffset][(currY >> 4) - minSection].h.a(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8).y();
                    if (fluidState.c() || !fluidState.a(fluid)) continue;
                    mutablePos.d(currX, currY, currZ);
                    if (fluid == TagsFluid.b) {
                        this.lastLavaContact = mutablePos.j();
                    }
                    if ((diff = (height = (double)((float)currY + fluidState.a(world, mutablePos))) - boundingBox.b) < 0.0) continue;
                    inFluid = true;
                    maxHeightDiff = Math.max(maxHeightDiff, diff);
                    if (!isPushable) continue;
                    totalPushes += 1.0;
                    Vec3D flow = fluidState.c(world, mutablePos);
                    pushVector = maxHeightDiff < 0.4 ? pushVector.e(flow.c(maxHeightDiff)) : pushVector.e(flow);
                }
            }
        }
        this.av.put(fluid, maxHeightDiff);
        if (pushVector == Vec3D.c) {
            return inFluid;
        }
        pushVector = pushVector.c(1.0 / totalPushes);
        Vec3D currMovement = this.dI();
        if (!(this instanceof EntityHuman)) {
            pushVector = pushVector.d();
        }
        pushVector = pushVector.c(flowScale);
        if (Math.abs(currMovement.g) < 0.003 && Math.abs(currMovement.i) < 0.003 && pushVector.g() < 0.0045000000000000005) {
            pushVector = pushVector.d().c(0.0045000000000000005);
        }
        this.k(currMovement.e(pushVector));
        return true;
    }

    public boolean dy() {
        AxisAlignedBB aabb = this.de().g(1.0);
        int floor = MathHelper.a(aabb.a);
        int ceil = MathHelper.c(aabb.d);
        int floor1 = MathHelper.a(aabb.c);
        int ceil1 = MathHelper.c(aabb.f);
        return !this.an().b(floor, floor1, ceil, ceil1);
    }

    public double b(TagKey<FluidType> fluidTag) {
        return this.av.getDouble(fluidTag);
    }

    public double dz() {
        return (double)this.df() < 0.4 ? 0.0 : 0.4;
    }

    public final float dA() {
        return this.bz.a();
    }

    public final float dB() {
        return this.bz.b();
    }

    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity(this, entity);
    }

    public EntitySize a(EntityPose pose) {
        return this.aP.n();
    }

    public final EntityAttachments dC() {
        return this.bz.d();
    }

    @Override
    public Vec3D dD() {
        return this.aV;
    }

    public Vec3D dE() {
        return this.dD();
    }

    @Override
    public BlockPosition dF() {
        return this.aW;
    }

    public IBlockData dG() {
        if (this.bF == null) {
            this.bF = this.an().a_(this.dF());
        }
        return this.bF;
    }

    public ChunkCoordIntPair dH() {
        return this.aX;
    }

    public Vec3D dI() {
        return this.aY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void k(Vec3D deltaMovement) {
        Object object = this.posLock;
        synchronized (object) {
            this.aY = deltaMovement;
        }
    }

    public void l(Vec3D addend) {
        this.k(this.dI().e(addend));
    }

    public void m(double x2, double y2, double z2) {
        this.k(new Vec3D(x2, y2, z2));
    }

    public final int dJ() {
        return this.aW.u();
    }

    public final double dK() {
        return this.aV.g;
    }

    public double d(double scale) {
        return this.aV.g + (double)this.dA() * scale;
    }

    public double e(double scale) {
        return this.d((2.0 * this.as.j() - 1.0) * scale);
    }

    public final int dL() {
        return this.aW.v();
    }

    public final double dM() {
        return this.aV.h;
    }

    public double f(double scale) {
        return this.aV.h + (double)this.dB() * scale;
    }

    public double dN() {
        return this.f(this.as.j());
    }

    public double dO() {
        return this.aV.h + (double)this.bA;
    }

    public final int dP() {
        return this.aW.w();
    }

    public final double dQ() {
        return this.aV.i;
    }

    public double g(double scale) {
        return this.aV.i + (double)this.dA() * scale;
    }

    public double h(double scale) {
        return this.g((2.0 * this.as.j() - 1.0) * scale);
    }

    public static boolean checkPosition(Entity entity, double newX, double newY, double newZ) {
        String entityInfo;
        if (Double.isFinite(newX) && Double.isFinite(newY) && Double.isFinite(newZ)) {
            return true;
        }
        try {
            entityInfo = entity.toString();
        }
        catch (Exception ex) {
            entityInfo = "[Entity info unavailable] ";
        }
        b.error("New entity position is invalid! Tried to set invalid position ({},{},{}) for entity {} located at {}, entity info: {}", new Object[]{newX, newY, newZ, entity.getClass().getName(), entity.dD(), entityInfo, new Throwable()});
        return false;
    }

    public final void n(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x2, double y2, double z2, boolean forceBoundingBoxUpdate) {
        if (this.updatingSectionStatus) {
            b.error("Refusing to update position for entity " + String.valueOf(this) + " to position " + String.valueOf(new Vec3D(x2, y2, z2)) + " since it is processing a section status update", new Throwable());
            return;
        }
        if (!Entity.checkPosition(this, x2, y2, z2)) {
            return;
        }
        if (this.aV.g != x2 || this.aV.h != y2 || this.aV.i != z2) {
            net.minecraft.world.level.World world;
            Object object = this.posLock;
            synchronized (object) {
                this.aV = new Vec3D(x2, y2, z2);
            }
            int floor = MathHelper.a(x2);
            int floor1 = MathHelper.a(y2);
            int floor2 = MathHelper.a(z2);
            if (floor != this.aW.u() || floor1 != this.aW.v() || floor2 != this.aW.w()) {
                this.aW = new BlockPosition(floor, floor1, floor2);
                this.bF = null;
                if (SectionPosition.a(floor) != this.aX.h || SectionPosition.a(floor2) != this.aX.i) {
                    this.aX = new ChunkCoordIntPair(this.aW);
                }
            }
            this.br.a();
            if (!this.ay && (world = this.aU) instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (!this.ec()) {
                    EntityPlayer serverPlayer;
                    WaypointTransmitter waypointTransmitter;
                    Entity entity = this;
                    if (entity instanceof WaypointTransmitter && (waypointTransmitter = (WaypointTransmitter)((Object)entity)).gm()) {
                        serverLevel.h().b(waypointTransmitter);
                    }
                    if ((entity = this) instanceof EntityPlayer && (serverPlayer = (EntityPlayer)entity).o() && serverPlayer.g != null) {
                        serverLevel.h().b(serverPlayer);
                    }
                }
            }
            if (this.ax().p() == Integer.MAX_VALUE) {
                this.aF = true;
            }
        }
        if (!(this instanceof EntityHanging) && (forceBoundingBoxUpdate || this.aV.g != x2 || this.aV.h != y2 || this.aV.i != z2)) {
            this.a(this.aF());
        }
    }

    public void dR() {
    }

    public Vec3D[] dS() {
        return Leashable.a(this, 0.0, 0.5, 0.5, 0.0);
    }

    public boolean dT() {
        return false;
    }

    public void a(Leashable leashHolder) {
    }

    public void b(Leashable leashHolder) {
    }

    public Vec3D u(float partialTick) {
        return this.p(partialTick).b(0.0, (double)this.bA * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packet) {
        int id = packet.b();
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        this.e(x2, y2, z2);
        this.b(x2, y2, z2, packet.l(), packet.k());
        this.e(id);
        this.a_(packet.e());
        this.k(packet.j());
    }

    @Nullable
    public ItemStack dU() {
        return null;
    }

    public void q(boolean isInPowderSnow) {
        this.aJ = isInPowderSnow;
    }

    public boolean dV() {
        return !this.ax().a(TagsEntity.k);
    }

    public boolean dW() {
        return this.cH() > 0;
    }

    public float getBukkitYaw() {
        return this.aZ;
    }

    public float dX() {
        return this.aZ;
    }

    @Override
    public float dY() {
        return this.dX();
    }

    public void v(float yRot) {
        if (!Float.isFinite(yRot)) {
            SystemUtils.b("Invalid entity rotation: " + yRot + ", discarding.");
        } else {
            this.aZ = yRot;
        }
    }

    public float dZ() {
        return this.ba;
    }

    public void w(float xRot) {
        if (!Float.isFinite(xRot)) {
            SystemUtils.b("Invalid entity rotation: " + xRot + ", discarding.");
        } else {
            this.ba = Math.clamp(xRot % 360.0f, -90.0f, 90.0f);
        }
    }

    public boolean ea() {
        return false;
    }

    public float eb() {
        return this.maxUpStep;
    }

    public void a(@Nullable Entity entity) {
    }

    @Override
    public final boolean ec() {
        return this.bd != null;
    }

    @Nullable
    public RemovalReason ed() {
        return this.bd;
    }

    @Override
    public final void setRemoved(RemovalReason removalReason, @Nullable EntityRemoveEvent.Cause cause) {
        boolean alreadyRemoved;
        if (!this.aU.moonrise$getEntityLookup().canRemoveEntity(this)) {
            b.warn("Entity " + String.valueOf(this) + " is currently prevented from being removed from the world since it is processing section status updates", new Throwable());
            return;
        }
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        boolean bl = alreadyRemoved = this.bd != null;
        if (this.bd == null) {
            this.bd = removalReason;
        }
        if (this.bd.a()) {
            this.cb();
        }
        if (this.bd != RemovalReason.c) {
            this.di().forEach(Entity::cb);
        }
        this.br.a(removalReason);
        this.b(removalReason);
        if (!(this instanceof EntityPlayer) && removalReason != RemovalReason.e && !alreadyRemoved) {
            this.retireScheduler();
        }
    }

    public void ee() {
        this.bd = null;
    }

    public final void retireScheduler() {
        this.getBukkitEntity().taskScheduler.retire();
    }

    public final void registerScheduler() {
        this.getBukkitEntity().taskScheduler.registerTo(MinecraftServer.getServer().entitySchedulerTickList);
    }

    @Override
    public void a(EntityInLevelCallback levelCallback) {
        this.br = levelCallback;
    }

    @Override
    public boolean ef() {
        return !(this.bd != null && !this.bd.b() || this.cl() || this.cm() && this.moonrise$hasAnyPlayerPassengers());
    }

    @Override
    public boolean eg() {
        return false;
    }

    public boolean c(WorldServer level, BlockPosition pos) {
        return true;
    }

    public boolean eh() {
        return false;
    }

    @Override
    public net.minecraft.world.level.World an() {
        return this.aU;
    }

    public void a(net.minecraft.world.level.World level) {
        this.aU = level;
    }

    public DamageSources ei() {
        return this.an().an();
    }

    public IRegistryCustom ej() {
        return this.an().L_();
    }

    protected void a(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
        double d2 = 1.0 / (double)steps;
        double d1 = MathHelper.d(d2, this.dK(), targetX);
        double d22 = MathHelper.d(d2, this.dM(), targetY);
        double d3 = MathHelper.d(d2, this.dQ(), targetZ);
        float f2 = (float)MathHelper.e(d2, (double)this.dX(), targetYRot);
        float f1 = (float)MathHelper.d(d2, (double)this.dZ(), targetXRot);
        this.a_(d1, d22, d3);
        this.a(f2, f1);
    }

    public RandomSource ek() {
        return this.as;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vec3D ag() {
        Vec3D vec3D;
        EntityLiving entityLiving = this.dg();
        if (entityLiving instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entityLiving;
            if (this.bX()) {
                vec3D = player.ag();
                return vec3D;
            }
        }
        vec3D = this.dI();
        return vec3D;
    }

    @Nullable
    public ItemStack el() {
        return null;
    }

    public Optional<ResourceKey<LootTable>> em() {
        return this.aP.j();
    }

    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.g);
        this.a(componentGetter, DataComponents.b);
    }

    public final void c(ItemStack stack) {
        this.a(stack.a());
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        if (component == DataComponents.g) {
            return Entity.c(component, this.ar());
        }
        return component == DataComponents.b ? (T)Entity.c(component, this.bK) : null;
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    protected static <T> T c(DataComponentType<T> component, @Nullable Object value) {
        return (T)value;
    }

    public <T> void d(DataComponentType<T> component, T value) {
        this.b(component, value);
    }

    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.g) {
            this.b(Entity.c(DataComponents.g, value));
            return true;
        }
        if (component == DataComponents.b) {
            this.bK = Entity.c(DataComponents.b, value);
            return true;
        }
        return false;
    }

    protected <T> boolean a(DataComponentGetter componentGetter, DataComponentType<T> component) {
        T object = componentGetter.a(component);
        return object != null && this.b(component, object);
    }

    public ProblemReporter.f en() {
        return new a(this);
    }

    @Override
    public void a(WorldServer level, DebugValueSource.a registrar) {
    }

    public static int nextEntityId() {
        return c.incrementAndGet();
    }

    public boolean isTicking() {
        return ((WorldServer)this.an()).f(this.dF());
    }

    @Nullable
    public EntityHuman getRider() {
        return this.rider;
    }

    public boolean isRidable() {
        return false;
    }

    public boolean isControllable() {
        return true;
    }

    public void onMount(EntityHuman rider) {
        if (this instanceof EntityInsentient) {
            ((EntityInsentient)this).setTarget(null, null);
            ((EntityInsentient)this).S().n();
        }
        rider.t(false);
    }

    public void onDismount(EntityHuman player) {
    }

    public boolean onSpacebar() {
        return false;
    }

    public boolean onClick(EnumHand hand) {
        return false;
    }

    public boolean processClick(EnumHand hand) {
        return false;
    }

    public static final class RemovalReason
    extends Enum<RemovalReason> {
        public static final /* enum */ RemovalReason a = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason b = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason c = new RemovalReason(false, true);
        public static final /* enum */ RemovalReason d = new RemovalReason(false, false);
        public static final /* enum */ RemovalReason e = new RemovalReason(false, false);
        private final boolean f;
        private final boolean g;
        private static final /* synthetic */ RemovalReason[] h;

        public static RemovalReason[] values() {
            return (RemovalReason[])h.clone();
        }

        public static RemovalReason valueOf(String name) {
            return Enum.valueOf(RemovalReason.class, name);
        }

        private RemovalReason(boolean destroy, boolean save) {
            this.f = destroy;
            this.g = save;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }

        private static /* synthetic */ RemovalReason[] c() {
            return new RemovalReason[]{a, b, c, d, e};
        }

        static {
            h = RemovalReason.c();
        }
    }

    record c(Vec3D a, Vec3D b, Optional<Vec3D> c) {
        public c(Vec3D from, Vec3D to, Vec3D axisDependentOriginalMovement) {
            this(from, to, Optional.of(axisDependentOriginalMovement));
        }

        public c(Vec3D from, Vec3D to) {
            this(from, to, Optional.empty());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "from;to;axisDependentOriginalMovement", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "from;to;axisDependentOriginalMovement", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "from;to;axisDependentOriginalMovement", "a", "b", "c"}, this, o2);
        }
    }

    public static final class MovementEmission
    extends Enum<MovementEmission> {
        public static final /* enum */ MovementEmission a = new MovementEmission(false, false);
        public static final /* enum */ MovementEmission b = new MovementEmission(true, false);
        public static final /* enum */ MovementEmission c = new MovementEmission(false, true);
        public static final /* enum */ MovementEmission d = new MovementEmission(true, true);
        final boolean e;
        final boolean f;
        private static final /* synthetic */ MovementEmission[] g;

        public static MovementEmission[] values() {
            return (MovementEmission[])g.clone();
        }

        public static MovementEmission valueOf(String name) {
            return Enum.valueOf(MovementEmission.class, name);
        }

        private MovementEmission(boolean sounds, boolean events) {
            this.e = sounds;
            this.f = events;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }

        private static /* synthetic */ MovementEmission[] d() {
            return new MovementEmission[]{a, b, c, d};
        }

        static {
            g = MovementEmission.d();
        }
    }

    public record DefaultDrop(net.minecraft.world.item.Item item, org.bukkit.inventory.ItemStack stack, @Nullable Consumer<ItemStack> dropConsumer) {
        public DefaultDrop(ItemStack stack, Consumer<ItemStack> dropConsumer) {
            this(stack.h(), CraftItemStack.asCraftMirror(stack), dropConsumer);
        }

        public void runConsumer(Consumer<org.bukkit.inventory.ItemStack> fallback) {
            if (this.dropConsumer == null || CraftItemType.bukkitToMinecraft(this.stack.getType()) != this.item) {
                fallback.accept(this.stack);
            } else {
                this.dropConsumer.accept(CraftItemStack.asNMSCopy(this.stack));
            }
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    record a(Entity a) implements ProblemReporter.f
    {
        @Override
        public String get() {
            return this.a.toString();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "entity", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "entity", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "entity", "a"}, this, o2);
        }
    }

    private static final class RandomRandomSource
    extends ThreadUnsafeRandom {
        private boolean locked = false;

        public RandomRandomSource() {
            this(RandomSupport.a());
        }

        public RandomRandomSource(long seed) {
            super(seed);
        }

        @Override
        public synchronized void b(long seed) {
            if (this.locked) {
                b.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.b(seed);
                this.locked = true;
            }
        }
    }
}

