/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DespawnRange;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.util.PaperCodecs;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.debug.DebugBrainDump;
import net.minecraft.util.debug.DebugGoalInfo;
import net.minecraft.util.debug.DebugPathInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.inventory.InventoryHolder;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.controller.MoveControllerWASD;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    protected static final int r = 1;
    private static final BaseBlockPosition e = new BaseBlockPosition(1, 0, 1);
    private static final List<EnumItemSlot> cs = List.of(EnumItemSlot.f, EnumItemSlot.e, EnumItemSlot.d, EnumItemSlot.c);
    public static final float s = 0.15f;
    public static final float t = 0.1087f;
    public static final float ca = 3.0f;
    public static final float cb = 0.55f;
    public static final float cc = 0.5f;
    public static final float cd = 0.25f;
    public static final int ce = 2;
    private static final double ct = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean cu = false;
    private static final boolean cv = false;
    private static final boolean cw = false;
    private static final boolean cx = false;
    protected static final MinecraftKey cf = MinecraftKey.b("random_spawn_bonus");
    public static final String cg = "drop_chances";
    public static final String ch = "LeftHanded";
    public static final String ci = "CanPickUpLoot";
    public static final String cj = "NoAI";
    public int ck;
    protected int cl;
    protected ControllerLook cm;
    protected ControllerMove cn;
    protected ControllerJump co;
    private final EntityAIBodyControl cy;
    protected NavigationAbstract cp;
    public PathfinderGoalSelector cq;
    @Nullable
    public PathfinderGoalFloat goalFloat;
    public PathfinderGoalSelector cr;
    @Nullable
    private EntityLiving cz;
    private final EntitySenses cA;
    private DropChances cB = DropChances.d;
    private boolean cC = false;
    private boolean cD = false;
    private final Map<PathType, Float> cE = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> cF = Optional.empty();
    public long cG;
    @Nullable
    private Leashable.a cH;
    private BlockPosition cI = BlockPosition.c;
    private int cJ = -1;
    public boolean aware = true;
    public TriState despawnInPeacefulOverride = TriState.NOT_SET;
    public int ticksSinceLastInteraction;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> type, World level) {
        super((EntityTypes<? extends EntityLiving>)type, level);
        this.cq = new PathfinderGoalSelector();
        this.cr = new PathfinderGoalSelector();
        this.cm = new LookControllerWASD(this);
        this.cn = new MoveControllerWASD(this);
        this.co = new ControllerJump(this);
        this.cy = this.N();
        this.cp = this.b(level);
        this.cA = new EntitySenses(this);
        if (level instanceof WorldServer) {
            this.H();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.cD = persistenceRequired;
    }

    protected void H() {
    }

    public static AttributeProvider.Builder I() {
        return EntityLiving.es().a(GenericAttributes.n, 16.0);
    }

    protected NavigationAbstract b(World level) {
        return new Navigation(this, level);
    }

    protected boolean J() {
        return false;
    }

    public float a(PathType pathType) {
        EntityInsentient mob;
        Entity entity = this.dv();
        EntityInsentient mob1 = entity instanceof EntityInsentient && (mob = (EntityInsentient)entity).J() ? mob : this;
        Float _float = mob1.cE.get((Object)pathType);
        return _float == null ? pathType.a() : _float.floatValue();
    }

    public void a(PathType pathType, float malus) {
        this.cE.put(pathType, Float.valueOf(malus));
    }

    public void K() {
    }

    @Override
    public void L() {
    }

    protected EntityAIBodyControl N() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook P() {
        return this.cm;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.cq.inactiveTick()) {
            this.cq.a();
        }
        if (this.cr.inactiveTick()) {
            this.cr.a();
        }
    }

    public ControllerMove Q() {
        ControllerMove controllerMove;
        Entity entity = this.dv();
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            controllerMove = mob.Q();
        } else {
            controllerMove = this.cn;
        }
        return controllerMove;
    }

    public ControllerJump R() {
        return this.co;
    }

    public NavigationAbstract S() {
        NavigationAbstract navigationAbstract;
        Entity entity = this.dv();
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            navigationAbstract = mob.S();
        } else {
            navigationAbstract = this.cp;
        }
        return navigationAbstract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public EntityLiving dg() {
        Entity firstPassenger = this.dj();
        if (this.gx()) return null;
        if (!(firstPassenger instanceof EntityInsentient)) return null;
        EntityInsentient mob = (EntityInsentient)firstPassenger;
        if (!firstPassenger.co()) return null;
        EntityInsentient entityInsentient = mob;
        return entityInsentient;
    }

    public EntitySenses T() {
        return this.cA;
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.cz;
    }

    @Nullable
    protected final EntityLiving U() {
        return this.eq().c(MemoryModuleType.p).orElse(null);
    }

    public void g(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN);
    }

    public boolean setTarget(@Nullable EntityLiving target, @Nullable EntityTargetEvent.TargetReason reason) {
        if (this.e() == target) {
            return false;
        }
        if (reason != null) {
            EntityTargetLivingEntityEvent event;
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.e() != null && target == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.e().bX() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.an().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (target != null) {
                ctarget = (CraftLivingEntity)target.getBukkitEntity();
            }
            if (!(event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason)).callEvent()) {
                return false;
            }
            target = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        if (target instanceof EntityPlayer) {
            this.ticksSinceLastInteraction = 0;
        }
        this.cz = target;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return type != EntityTypes.ag;
    }

    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return false;
    }

    public void V() {
        this.c(GameEvent.m);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)0);
    }

    public int W() {
        return 80;
    }

    public void X() {
        this.b(this.p());
    }

    @Override
    public void aH() {
        super.aH();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("mobBaseTick");
        if (this.bX() && this.as.a(1000) < this.ck++) {
            this.k();
            this.X();
        }
        profilerFiller.c();
        this.incrementTicksSinceLastInteraction();
    }

    private void incrementTicksSinceLastInteraction() {
        ++this.ticksSinceLastInteraction;
        if (this.getRider() != null) {
            this.ticksSinceLastInteraction = 0;
            return;
        }
        if (this.an().purpurConfig.entityLifeSpan <= 0) {
            return;
        }
        if (!this.i(0.0) || this.gr() || this.ae() || this.k_()) {
            return;
        }
        if (this.ticksSinceLastInteraction > this.an().purpurConfig.entityLifeSpan) {
            this.discard(EntityRemoveEvent.Cause.DISCARD);
        }
    }

    @Override
    protected void h(DamageSource damageSource) {
        this.k();
        super.h(damageSource);
    }

    private void k() {
        this.ck = -this.W();
    }

    @Override
    protected int f(WorldServer level) {
        if (this.cl > 0) {
            int i2 = this.cl;
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                ItemStack itemBySlot;
                if (!equipmentSlot.g() || (itemBySlot = this.a(equipmentSlot)).f() || !(this.cB.b(equipmentSlot) <= 1.0f)) continue;
                i2 += 1 + this.as.a(3);
            }
            return i2;
        }
        return this.cl;
    }

    public void Y() {
        if (this.an().D_()) {
            this.fn();
        } else {
            this.an().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 20) {
            this.Y();
        } else {
            super.b(id);
        }
    }

    @Override
    public void g() {
        super.g();
        if (!this.an().D_() && this.at % 5 == 0) {
            this.Z();
        }
    }

    protected void Z() {
        boolean flag = !(this.dg() instanceof EntityInsentient);
        boolean flag1 = !(this.du() instanceof AbstractBoat);
        this.cq.a(PathfinderGoal.Type.a, flag);
        this.cq.a(PathfinderGoal.Type.c, flag && flag1);
        this.cq.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected void C(float yBodyRot) {
        this.cy.a();
    }

    @Nullable
    public SoundEffect p() {
        return null;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(ci, this.gc());
        output.a("PersistenceRequired", this.cD);
        if (!this.cB.equals(DropChances.d)) {
            output.a(cg, DropChances.e, this.cB);
        }
        this.a(output, this.cH);
        if (this.gw()) {
            output.a("home_radius", this.cJ);
            output.a("home_pos", BlockPosition.a, this.cI);
        }
        output.a(ch, this.gy());
        this.cF.ifPresent(resourceKey -> output.a("DeathLootTable", LootTable.a, resourceKey));
        if (this.cG != 0L) {
            output.a("DeathLootTableSeed", this.cG);
        }
        if (this.gx()) {
            output.a(cj, this.gx());
        }
        output.a("Bukkit.Aware", this.aware);
        if (this.despawnInPeacefulOverride != TriState.NOT_SET) {
            output.a("Paper.DespawnInPeacefulOverride", this.despawnInPeacefulOverride.name());
        }
        output.a("Purpur.ticksSinceLastInteraction", this.ticksSinceLastInteraction);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        boolean canPickUpLoot = input.a(ci, false);
        if (EntityInsentient.isLevelAtLeast(input, 1) || canPickUpLoot) {
            this.a_(canPickUpLoot);
        }
        boolean persistenceRequired = input.a("PersistenceRequired", false);
        if (EntityInsentient.isLevelAtLeast(input, 1) || persistenceRequired) {
            this.cD = persistenceRequired;
        }
        this.cB = input.a(cg, DropChances.e).orElse(DropChances.d);
        this.b(input);
        this.cJ = input.a("home_radius", -1);
        if (this.cJ >= 0) {
            this.cI = input.a("home_pos", BlockPosition.a).orElse(BlockPosition.c);
        }
        this.v(input.a(ch, false));
        this.cF = input.a("DeathLootTable", LootTable.a);
        this.cG = input.a("DeathLootTableSeed", 0L);
        this.u(input.a(cj, false));
        this.aware = input.a("Bukkit.Aware", true);
        this.ticksSinceLastInteraction = input.a("Purpur.ticksSinceLastInteraction", 0);
        this.despawnInPeacefulOverride = EntityInsentient.readDespawnInPeacefulOverride(input);
    }

    public static TriState readDespawnInPeacefulOverride(ValueInput input) {
        return input.a("Paper.DespawnInPeacefulOverride", PaperCodecs.TRI_STATE_CODEC).orElse(TriState.NOT_SET);
    }

    @Override
    protected void b(WorldServer level, DamageSource damageSource, boolean playerKill) {
        super.b(level, damageSource, playerKill);
        this.cF = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> em() {
        return this.cF.isPresent() ? this.cF : super.em();
    }

    @Override
    public long eX() {
        return this.cG;
    }

    public void G(float amount) {
        this.bO = amount;
    }

    public void H(float amount) {
        this.bN = amount;
    }

    public void I(float amount) {
        this.bM = amount;
    }

    @Override
    public void B(float speed) {
        super.B(speed);
        this.G(speed);
    }

    public void aa() {
        this.S().n();
        this.I(0.0f);
        this.H(0.0f);
        this.B(0.0f);
        this.m(0.0, 0.0, 0.0);
        this.gE();
    }

    @Override
    public void e_() {
        super.e_();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("looting");
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.gc() && this.bX() && !this.bI && serverLevel.S().getBoolean(GameRules.d, serverLevel.purpurConfig.entitiesPickUpLootMobGriefingOverride)) {
                BaseBlockPosition pickupReach = this.ab();
                for (EntityItem itemEntity : this.an().a(EntityItem.class, this.de().c(pickupReach.u(), pickupReach.v(), pickupReach.w()))) {
                    if (itemEntity.ec() || itemEntity.e().f() || itemEntity.n() || !this.c(serverLevel, itemEntity.e()) || !itemEntity.canMobPickup) continue;
                    this.a(serverLevel, itemEntity);
                }
            }
        }
        profilerFiller.c();
    }

    protected BaseBlockPosition ab() {
        return e;
    }

    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.e();
        ItemStack itemStack = this.equipItemIfPossible(level, item.v(), entity);
        if (!itemStack.f()) {
            this.a(entity);
            this.a((Entity)entity, itemStack.M());
            item.h(itemStack.M());
            if (item.f()) {
                entity.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack b(WorldServer level, ItemStack stack) {
        return this.equipItemIfPossible(level, stack, null);
    }

    public ItemStack equipItemIfPossible(WorldServer level, ItemStack stack, @Nullable EntityItem entity) {
        boolean canPickup;
        EnumItemSlot equipmentSlotForItem = this.f(stack);
        if (!this.a(stack, equipmentSlotForItem)) {
            return ItemStack.l;
        }
        ItemStack itemBySlot = this.a(equipmentSlotForItem);
        boolean canReplaceCurrentItem = this.a(stack, itemBySlot, equipmentSlotForItem);
        if (equipmentSlotForItem.f() && !canReplaceCurrentItem) {
            equipmentSlotForItem = EnumItemSlot.a;
            itemBySlot = this.a(equipmentSlotForItem);
            canReplaceCurrentItem = itemBySlot.f();
        }
        boolean bl = canPickup = canReplaceCurrentItem && this.g(stack);
        if (entity != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d2 = this.cB.b(equipmentSlotForItem);
            if (!itemBySlot.f() && (double)Math.max(this.as.i() - 0.1f, 0.0f) < d2) {
                this.forceDrops = true;
                this.a(level, itemBySlot);
                this.forceDrops = false;
            }
            ItemStack itemStack = equipmentSlotForItem.a(stack);
            this.b(equipmentSlotForItem, itemStack);
            return itemStack;
        }
        return ItemStack.l;
    }

    protected void b(EnumItemSlot slot, ItemStack stack) {
        this.a(slot, stack);
        this.g(slot);
        this.cD = true;
    }

    protected boolean a(EntityHuman player) {
        return !this.cm();
    }

    public void g(EnumItemSlot slot) {
        this.cB = this.cB.a(slot);
    }

    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (currentItem.f()) {
            return true;
        }
        return slot.f() ? this.b(newItem, currentItem, slot) : slot == EnumItemSlot.a && this.c(newItem, currentItem, slot);
    }

    private boolean b(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (EnchantmentManager.a(currentItem, EnchantmentEffectComponents.E)) {
            return false;
        }
        double approximateAttributeWith = this.a(newItem, GenericAttributes.a, slot);
        double approximateAttributeWith1 = this.a(currentItem, GenericAttributes.a, slot);
        double approximateAttributeWith2 = this.a(newItem, GenericAttributes.b, slot);
        double approximateAttributeWith3 = this.a(currentItem, GenericAttributes.b, slot);
        if (approximateAttributeWith != approximateAttributeWith1) {
            return approximateAttributeWith > approximateAttributeWith1;
        }
        return approximateAttributeWith2 != approximateAttributeWith3 ? approximateAttributeWith2 > approximateAttributeWith3 : this.b(newItem, currentItem);
    }

    private boolean c(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        double approximateAttributeWith1;
        double approximateAttributeWith;
        TagKey<Item> preferredWeaponType = this.ac();
        if (preferredWeaponType != null) {
            if (currentItem.a(preferredWeaponType) && !newItem.a(preferredWeaponType)) {
                return false;
            }
            if (!currentItem.a(preferredWeaponType) && newItem.a(preferredWeaponType)) {
                return true;
            }
        }
        return (approximateAttributeWith = this.a(newItem, GenericAttributes.c, slot)) != (approximateAttributeWith1 = this.a(currentItem, GenericAttributes.c, slot)) ? approximateAttributeWith > approximateAttributeWith1 : this.b(newItem, currentItem);
    }

    private double a(ItemStack item, Holder<AttributeBase> attribute, EnumItemSlot slot) {
        double d2 = this.fp().b(attribute) ? this.j(attribute) : 0.0;
        ItemAttributeModifiers itemAttributeModifiers = item.a(DataComponents.o, ItemAttributeModifiers.a);
        return itemAttributeModifiers.a(d2, slot);
    }

    public boolean b(ItemStack candidate, ItemStack existing) {
        int damageValue1;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set = existing.a(DataComponents.l, ItemEnchantments.a).b();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set1 = candidate.a(DataComponents.l, ItemEnchantments.a).b();
        if (set1.size() != set.size()) {
            return set1.size() > set.size();
        }
        int damageValue = candidate.o();
        return damageValue != (damageValue1 = existing.o()) ? damageValue < damageValue1 : candidate.c(DataComponents.g) && !existing.c(DataComponents.g);
    }

    public boolean g(ItemStack stack) {
        return true;
    }

    public boolean c(WorldServer level, ItemStack stack) {
        return this.g(stack);
    }

    @Nullable
    public TagKey<Item> ac() {
        return null;
    }

    public boolean i(double distanceToClosestPlayer) {
        return true;
    }

    public boolean ae() {
        return this.cl();
    }

    public final boolean shouldDespawnInPeaceful() {
        return this.despawnInPeacefulOverride.toBooleanOrElse(!this.ax().isTypeAllowedInPeaceful());
    }

    @Override
    public void dR() {
        if (this.an().aq() == EnumDifficulty.a && this.shouldDespawnInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.gr() && !this.ae()) {
            EntityHuman nearestPlayer = this.an().findNearbyPlayer(this, -1.0, IEntitySelector.PLAYER_AFFECTS_SPAWNING);
            if (nearestPlayer != null) {
                WorldConfiguration.Entities.Spawning.DespawnRangePair despawnRangePair = this.an().paperConfig().entities.spawning.despawnRanges.get(this.ax().f());
                DespawnRange.Shape shape = this.an().paperConfig().entities.spawning.despawnRangeShape;
                double dy = Math.abs(nearestPlayer.dM() - this.dM());
                double dySqr = MathHelper.l(dy);
                double dxSqr = MathHelper.l(nearestPlayer.dK() - this.dK());
                double dzSqr = MathHelper.l(nearestPlayer.dQ() - this.dQ());
                double distanceSquared = dxSqr + dzSqr + dySqr;
                if (despawnRangePair.hard().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy) && this.i(distanceSquared)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                if (despawnRangePair.soft().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy)) {
                    if (this.bJ > 600 && this.as.a(800) == 0 && this.i(distanceSquared)) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    }
                } else {
                    this.bJ = 0;
                }
            }
        } else {
            this.bJ = 0;
        }
    }

    @Override
    protected final void fK() {
        ++this.bJ;
        if (!this.aware) {
            if (this.goalFloat != null) {
                if (this.goalFloat.b()) {
                    this.goalFloat.a();
                }
                this.R().b();
            }
            return;
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("sensing");
        this.cA.a();
        profilerFiller.c();
        int i2 = this.at + this.az();
        if (i2 % 2 != 0 && this.at > 1) {
            profilerFiller.a("targetSelector");
            this.cr.a(false);
            profilerFiller.c();
            profilerFiller.a("goalSelector");
            this.cq.a(false);
            profilerFiller.c();
        } else {
            profilerFiller.a("targetSelector");
            this.cr.a();
            profilerFiller.c();
            profilerFiller.a("goalSelector");
            this.cq.a();
            profilerFiller.c();
        }
        profilerFiller.a("navigation");
        this.cp.d();
        profilerFiller.c();
        profilerFiller.a("mob tick");
        this.a((WorldServer)this.an());
        profilerFiller.c();
        profilerFiller.a("controls");
        profilerFiller.a("move");
        this.cn.a();
        profilerFiller.b("look");
        this.cm.a();
        profilerFiller.b("jump");
        this.co.b();
        profilerFiller.c();
        profilerFiller.c();
    }

    protected void a(WorldServer level) {
    }

    public int af() {
        return 40;
    }

    public int ah() {
        return 75;
    }

    protected void ai() {
        float f2 = this.ah();
        float yHeadRot = this.cN();
        float f1 = MathHelper.h(this.bB - yHeadRot);
        float f22 = MathHelper.a(MathHelper.h(this.bB - yHeadRot), -f2, f2);
        float f3 = yHeadRot + f1 - f22;
        this.r(f3);
    }

    public int aj() {
        return 10;
    }

    public void a(Entity entity, float maxYRotIncrease, float maxXRotIncrease) {
        double d2;
        double d3 = entity.dK() - this.dK();
        double d1 = entity.dQ() - this.dQ();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            d2 = livingEntity.dO() - this.dO();
        } else {
            d2 = (entity.de().b + entity.de().e) / 2.0 - this.dO();
        }
        double squareRoot = Math.sqrt(d3 * d3 + d1 * d1);
        float f2 = (float)(MathHelper.d(d1, d3) * 180.0 / 3.1415927410125732) - 90.0f;
        float f1 = (float)(-(MathHelper.d(d2, squareRoot) * 180.0 / 3.1415927410125732));
        this.w(this.a(this.dZ(), f1, maxXRotIncrease));
        this.v(this.a(this.dX(), f2, maxYRotIncrease));
    }

    private float a(float angle, float targetAngle, float maxIncrease) {
        float f2 = MathHelper.h(targetAngle - angle);
        if (f2 > maxIncrease) {
            f2 = maxIncrease;
        }
        if (f2 < -maxIncrease) {
            f2 = -maxIncrease;
        }
        return angle + f2;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition blockPos = pos.e();
        return EntitySpawnReason.a(spawnReason) || level.a_(blockPos).a((IBlockAccess)level, blockPos, entityType);
    }

    public boolean a(GeneratorAccess level, EntitySpawnReason spawnReason) {
        return true;
    }

    public boolean a(IWorldReader level) {
        return !level.d(this.de()) && level.f(this);
    }

    public int ak() {
        return 4;
    }

    public boolean q(int size) {
        return false;
    }

    @Override
    public int cR() {
        if (this.e() == null) {
            return this.y(0.0f);
        }
        int i2 = (int)(this.eU() - this.fj() * 0.33f);
        if ((i2 -= (3 - this.an().aq().a()) * 4) < 0) {
            i2 = 0;
        }
        return this.y(i2);
    }

    public ItemStack al() {
        return this.a(EnumItemSlot.g);
    }

    public boolean am() {
        return this.i(EnumItemSlot.h);
    }

    public boolean go() {
        return this.i(EnumItemSlot.g);
    }

    private boolean i(EnumItemSlot slot) {
        return this.d(slot) && this.a(this.a(slot), slot);
    }

    public void h(ItemStack stack) {
        this.b(EnumItemSlot.g, stack);
    }

    public IInventory h(final EnumItemSlot slot) {
        return new ContainerSingleItem(){
            private final List<HumanEntity> viewers = new ArrayList<HumanEntity>();
            private int maxStackSize = 99;

            @Override
            public ItemStack g() {
                return EntityInsentient.this.a(slot);
            }

            @Override
            public void b(ItemStack item) {
                EntityInsentient.this.a(slot, item);
                if (!item.f()) {
                    EntityInsentient.this.g(slot);
                    EntityInsentient.this.gq();
                }
            }

            @Override
            public void e() {
            }

            @Override
            public boolean a(EntityHuman player) {
                return player.du() == EntityInsentient.this || player.b((Entity)EntityInsentient.this, 4.0);
            }

            @Override
            public int ap_() {
                return this.maxStackSize;
            }

            @Override
            public List<ItemStack> getContents() {
                return Arrays.asList(this.g());
            }

            @Override
            public void onOpen(CraftHumanEntity player) {
                this.viewers.add(player);
            }

            @Override
            public void onClose(CraftHumanEntity player) {
                this.viewers.remove(player);
            }

            @Override
            public List<HumanEntity> getViewers() {
                return this.viewers;
            }

            @Override
            @Nullable
            public InventoryHolder getOwner() {
                CraftEntity craftEntity = EntityInsentient.this.getBukkitEntity();
                if (craftEntity instanceof InventoryHolder) {
                    InventoryHolder inventoryHolder = (InventoryHolder)craftEntity;
                    return inventoryHolder;
                }
                return null;
            }

            @Override
            public void setMaxStackSize(int size) {
                this.maxStackSize = size;
            }

            @Override
            public Location getLocation() {
                return EntityInsentient.this.getBukkitEntity().getLocation();
            }
        };
    }

    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return false;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            if (this.shouldSkipLoot(equipmentSlot)) continue;
            ItemStack itemBySlot = this.a(equipmentSlot);
            float f2 = this.cB.b(equipmentSlot);
            if (f2 == 0.0f) continue;
            boolean isPreserved = this.cB.c(equipmentSlot);
            Object object = damageSource.d();
            if (object instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)object;
                object = this.an();
                if (object instanceof WorldServer) {
                    WorldServer serverLevel = (WorldServer)object;
                    f2 = EnchantmentManager.a(serverLevel, livingEntity, damageSource, f2);
                }
            }
            if (itemBySlot.f() || EnchantmentManager.a(itemBySlot, EnchantmentEffectComponents.D) || !recentlyHit && !isPreserved || !(this.as.i() < f2)) continue;
            if (!isPreserved && itemBySlot.m()) {
                itemBySlot.b(itemBySlot.p() - this.as.a(1 + this.as.a(Math.max(itemBySlot.p() - 3, 1))));
            }
            this.a(level, itemBySlot);
            if (this.clearEquipmentSlots) {
                this.a(equipmentSlot, ItemStack.l);
                continue;
            }
            this.clearedEquipmentSlots.add(equipmentSlot);
        }
    }

    public DropChances gp() {
        return this.cB;
    }

    public void b(WorldServer level) {
        this.a(level, (ItemStack itemStack) -> true);
    }

    public Set<EnumItemSlot> a(WorldServer level, Predicate<ItemStack> filter) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (itemBySlot.f()) continue;
            if (!filter.test(itemBySlot)) {
                set.add(equipmentSlot);
                continue;
            }
            if (!this.cB.c(equipmentSlot)) continue;
            this.a(equipmentSlot, ItemStack.l);
            this.forceDrops = true;
            this.a(level, itemBySlot);
            this.forceDrops = false;
        }
        return set;
    }

    private LootParams h(WorldServer level) {
        return new LootParams.a(level).a(LootContextParameters.h, this.dD()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
    }

    public void a(EquipmentTable equipmentTable) {
        this.a(equipmentTable.a(), equipmentTable.b());
    }

    public void a(ResourceKey<LootTable> equipmentLootTable, Map<EnumItemSlot, Float> slotDropChances) {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(equipmentLootTable, this.h(serverLevel), slotDropChances);
        }
    }

    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (random.i() < 0.15f * difficulty.d()) {
            int randomInt = random.a(3);
            int i2 = 1;
            while ((float)i2 <= 3.0f) {
                if (random.i() < 0.1087f) {
                    ++randomInt;
                }
                ++i2;
            }
            float f2 = this.an().aq() == EnumDifficulty.d ? 0.1f : 0.25f;
            boolean flag = true;
            for (EnumItemSlot equipmentSlot : cs) {
                Item equipmentForSlot;
                ItemStack itemBySlot = this.a(equipmentSlot);
                if (!flag && random.i() < f2) break;
                flag = false;
                if (!itemBySlot.f() || (equipmentForSlot = EntityInsentient.a(equipmentSlot, randomInt)) == null) continue;
                this.a(equipmentSlot, new ItemStack(equipmentForSlot));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot slot, int chance) {
        switch (slot) {
            case f: {
                if (chance == 0) {
                    return Items.re;
                }
                if (chance == 1) {
                    return Items.ri;
                }
                if (chance == 2) {
                    return Items.ry;
                }
                if (chance == 3) {
                    return Items.rm;
                }
                if (chance == 4) {
                    return Items.rq;
                }
                if (chance == 5) {
                    return Items.ru;
                }
            }
            case e: {
                if (chance == 0) {
                    return Items.rf;
                }
                if (chance == 1) {
                    return Items.rj;
                }
                if (chance == 2) {
                    return Items.rz;
                }
                if (chance == 3) {
                    return Items.rn;
                }
                if (chance == 4) {
                    return Items.rr;
                }
                if (chance == 5) {
                    return Items.rv;
                }
            }
            case d: {
                if (chance == 0) {
                    return Items.rg;
                }
                if (chance == 1) {
                    return Items.rk;
                }
                if (chance == 2) {
                    return Items.rA;
                }
                if (chance == 3) {
                    return Items.ro;
                }
                if (chance == 4) {
                    return Items.rs;
                }
                if (chance == 5) {
                    return Items.rw;
                }
            }
            case c: {
                if (chance == 0) {
                    return Items.rh;
                }
                if (chance == 1) {
                    return Items.rl;
                }
                if (chance == 2) {
                    return Items.rB;
                }
                if (chance == 3) {
                    return Items.rp;
                }
                if (chance == 4) {
                    return Items.rt;
                }
                if (chance != 5) break;
                return Items.rx;
            }
        }
        return null;
    }

    protected void a(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        this.b(level, random, difficulty);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            if (equipmentSlot.a() != EnumItemSlot.Function.b) continue;
            this.a(level, random, equipmentSlot, difficulty);
        }
    }

    protected void b(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(level, EnumItemSlot.a, random, 0.25f, difficulty);
    }

    protected void a(WorldAccess level, RandomSource random, EnumItemSlot slot, DifficultyDamageScaler difficulty) {
        this.a(level, slot, random, 0.5f, difficulty);
    }

    private void a(WorldAccess level, EnumItemSlot slot, RandomSource random, float enchantChance, DifficultyDamageScaler difficulty) {
        ItemStack itemBySlot = this.a(slot);
        if (!itemBySlot.f() && random.i() < enchantChance * difficulty.d()) {
            EnchantmentManager.a(itemBySlot, level.L_(), VanillaEnchantmentProviders.a, difficulty, random);
            this.a(slot, itemBySlot);
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.I_();
        AttributeModifiable attributeInstance = Objects.requireNonNull(this.h(GenericAttributes.n));
        if (!attributeInstance.b(cf)) {
            attributeInstance.d(new AttributeModifier(cf, random.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        }
        this.v(random.i() < level.a().purpurConfig.entityLeftHandedChance);
        return spawnGroupData;
    }

    public void gq() {
        this.cD = true;
    }

    @Override
    public void a(EnumItemSlot slot, float chance) {
        this.cB = this.cB.a(slot, chance);
    }

    @Override
    public boolean gc() {
        return this.cC;
    }

    public void a_(boolean canPickUpLoot) {
        this.cC = canPickUpLoot;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return this.gc();
    }

    public boolean gr() {
        return this.cD;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (!this.bX()) {
            return EnumInteractionResult.e;
        }
        EnumInteractionResult interactionResult = this.c(player, hand);
        if (interactionResult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return interactionResult;
        }
        EnumInteractionResult interactionResult1 = super.a(player, hand);
        if (interactionResult1 != EnumInteractionResult.e) {
            return interactionResult1;
        }
        interactionResult = this.b(player, hand);
        if (interactionResult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return interactionResult;
        }
        return EnumInteractionResult.e;
    }

    private EnumInteractionResult c(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult;
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.wV) && (interactionResult = itemInHand.a(player, (EntityLiving)this, hand)).a()) {
            return interactionResult;
        }
        if (itemInHand.h() instanceof ItemMonsterEgg) {
            if (this.an() instanceof WorldServer) {
                ItemMonsterEgg spawnEggItem = (ItemMonsterEgg)itemInHand.h();
                Optional<EntityInsentient> optional = spawnEggItem.a(player, this, this.ax(), (WorldServer)this.an(), this.dD(), itemInHand);
                optional.ifPresent(mob -> this.a(player, (EntityInsentient)mob));
                if (optional.isEmpty()) {
                    return EnumInteractionResult.e;
                }
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman player, EntityInsentient child) {
    }

    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return this.tryRide(player, hand);
    }

    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        int count = stack.M();
        UseRemainder useRemainder = stack.a(DataComponents.x);
        stack.a(1, (EntityLiving)player);
        if (useRemainder != null) {
            ItemStack itemStack = useRemainder.a(stack, count, player.gk(), player::b);
            player.a(hand, itemStack);
        }
    }

    public boolean gs() {
        return this.a(this.dF());
    }

    public boolean a(BlockPosition pos) {
        return this.cJ == -1 || this.cI.j(pos) < (double)(this.cJ * this.cJ);
    }

    public boolean a(Vec3D pos) {
        return this.cJ == -1 || this.cI.b(pos) < (double)(this.cJ * this.cJ);
    }

    public void a(BlockPosition pos, int radius) {
        this.cI = pos;
        this.cJ = radius;
    }

    public BlockPosition gt() {
        return this.cI;
    }

    public int gu() {
        return this.cJ;
    }

    public void gv() {
        this.cJ = -1;
    }

    public boolean gw() {
        return this.cJ != -1;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.a<T> afterConversion) {
        return this.convertTo(entityType, conversionParams, spawnReason, afterConversion, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.a<T> afterConversion, @Nullable EntityTransformEvent.TransformReason transformReason, @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)this.convertTo(entityType, conversionParams, spawnReason, (T e2) -> {
            afterConversion.finalizeConversion(e2);
            return true;
        }, transformReason, creatureSpawnReason);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.CancellingAfterConversion<T> afterConversion, @Nullable EntityTransformEvent.TransformReason transformReason, @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        if (this.ec()) {
            return null;
        }
        EntityInsentient mob = (EntityInsentient)entityType.a(this.an(), spawnReason);
        if (mob == null) {
            return null;
        }
        conversionParams.a().a(this, mob, conversionParams);
        if (!afterConversion.finalizeConversionOrCancel(mob)) {
            return null;
        }
        if (transformReason == null) {
            return (T)mob;
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, mob, transformReason).isCancelled()) {
            return null;
        }
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.addFreshEntity(mob, creatureSpawnReason);
        }
        if (conversionParams.a().a()) {
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        }
        return (T)mob;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, ConversionParams conversionParams, ConversionParams.a<T> afterConversion) {
        return this.convertTo(entityType, conversionParams, afterConversion, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, ConversionParams.a<T> afterConversion, @Nullable EntityTransformEvent.TransformReason transformReason, @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)this.convertTo(entityType, conversionParams, (T e2) -> {
            afterConversion.finalizeConversion(e2);
            return true;
        }, transformReason, creatureSpawnReason);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, ConversionParams.CancellingAfterConversion<T> afterConversion, @Nullable EntityTransformEvent.TransformReason transformReason, @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return this.convertTo(entityType, conversionParams, EntitySpawnReason.i, afterConversion, transformReason, creatureSpawnReason);
    }

    @Override
    @Nullable
    public Leashable.a U_() {
        return this.cH;
    }

    private void gE() {
        if (this.cH != null) {
            this.cH.d = 0.0;
        }
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.cH = leashData;
    }

    @Override
    public void y() {
        if (this.U_() == null) {
            this.gv();
        }
    }

    @Override
    public void C() {
        Leashable.super.C();
        this.cq.a(PathfinderGoal.Type.a);
    }

    @Override
    public boolean v() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean a(Entity entity, boolean force, boolean triggerEvents) {
        boolean flag = super.a(entity, force, triggerEvents);
        if (flag && this.T_()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, true);
            if (!event.callEvent()) {
                return flag;
            }
            if (event.isDropLeash()) {
                this.w();
            } else {
                this.x();
            }
        }
        return flag;
    }

    @Override
    public boolean dt() {
        return super.dt() && !this.gx();
    }

    public void u(boolean noAi) {
        byte b2 = this.az.a(a);
        this.az.a(a, noAi ? (byte)(b2 | 1) : (byte)(b2 & 0xFFFFFFFE));
    }

    public void v(boolean leftHanded) {
        byte b2 = this.az.a(a);
        this.az.a(a, leftHanded ? (byte)(b2 | 2) : (byte)(b2 & 0xFFFFFFFD));
    }

    public void w(boolean aggressive) {
        byte b2 = this.az.a(a);
        this.az.a(a, aggressive ? (byte)(b2 | 4) : (byte)(b2 & 0xFFFFFFFB));
    }

    public boolean gx() {
        return (this.az.a(a) & 1) != 0;
    }

    public boolean gy() {
        return (this.az.a(a) & 2) != 0;
    }

    public boolean gz() {
        return (this.az.a(a) & 4) != 0;
    }

    public void a(boolean baby) {
    }

    @Override
    public EnumMainHand as() {
        return this.gy() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean h(EntityLiving entity) {
        return this.gA().c(entity.fb());
    }

    protected AxisAlignedBB gA() {
        AxisAlignedBB aabb;
        Entity vehicle = this.du();
        if (vehicle != null) {
            AxisAlignedBB boundingBox = vehicle.de();
            AxisAlignedBB boundingBox1 = this.de();
            aabb = new AxisAlignedBB(Math.min(boundingBox1.a, boundingBox.a), boundingBox1.b, Math.min(boundingBox1.c, boundingBox.c), Math.max(boundingBox1.d, boundingBox.d), boundingBox1.e, Math.max(boundingBox1.f, boundingBox.f));
        } else {
            aabb = this.de();
        }
        return aabb.c(ct, 0.0, ct);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        boolean flag;
        float f2 = (float)this.i(GenericAttributes.c);
        ItemStack weaponItem = this.el();
        DamageSource damageSource = Optional.ofNullable(weaponItem.h().a(this)).orElse(this.ei().b(this));
        f2 = EnchantmentManager.a(level, weaponItem, target, damageSource, f2);
        if (flag = target.a(level, damageSource, f2 += weaponItem.h().a(target, f2, damageSource))) {
            EntityLiving livingEntity;
            float knockback = this.b(target, damageSource);
            if (knockback > 0.0f && target instanceof EntityLiving) {
                livingEntity = (EntityLiving)target;
                livingEntity.knockback(knockback * 0.5f, MathHelper.a(this.dX() * ((float)Math.PI / 180)), -MathHelper.b(this.dX() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                this.k(this.dI().d(0.6, 1.0, 0.6));
            }
            if (target instanceof EntityLiving) {
                livingEntity = (EntityLiving)target;
                weaponItem.a(livingEntity, (EntityLiving)this);
            }
            EnchantmentManager.a(level, target, damageSource);
            this.C(target);
            this.gB();
        }
        if (target instanceof EntityPlayer) {
            this.ticksSinceLastInteraction = 0;
        }
        return flag;
    }

    protected void gB() {
    }

    @Override
    public boolean gC() {
        return super.gC();
    }

    @Override
    protected void c(TagKey<FluidType> fluidTag) {
        if (this.S().p()) {
            super.c(fluidTag);
        } else {
            this.k(this.dI().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void gD() {
        this.c((PathfinderGoal goal) -> true);
        this.eq().h();
    }

    public void c(Predicate<PathfinderGoal> filter) {
        this.cq.a(filter);
    }

    @Override
    protected void cQ() {
        super.cQ();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (itemBySlot.f()) continue;
            itemBySlot.e(0);
        }
    }

    @Override
    @Nullable
    public ItemStack dU() {
        ItemMonsterEgg spawnEggItem = ItemMonsterEgg.a(this.ax());
        return spawnEggItem == null ? null : new ItemStack(spawnEggItem);
    }

    @Override
    protected void a(Holder<AttributeBase> attribute) {
        super.a(attribute);
        if (attribute.a(GenericAttributes.n) || attribute.a(GenericAttributes.F)) {
            this.S().f();
        }
    }

    @Override
    public void a(WorldServer level, DebugValueSource.a registrar) {
        registrar.a(DebugSubscriptions.f, () -> {
            PathEntity path = this.S().j();
            return path != null && path.k() != null ? new DebugPathInfo(path.n(), this.S().q()) : null;
        });
        registrar.a(DebugSubscriptions.e, () -> {
            Set<PathfinderGoalWrapped> availableGoals = this.cq.b();
            ArrayList<DebugGoalInfo.a> list = new ArrayList<DebugGoalInfo.a>(availableGoals.size());
            availableGoals.forEach(wrappedGoal -> list.add(new DebugGoalInfo.a(wrappedGoal.i(), wrappedGoal.h(), wrappedGoal.k().getClass().getSimpleName())));
            return new DebugGoalInfo(list);
        });
        if (!this.bY.j()) {
            registrar.a(DebugSubscriptions.c, () -> DebugBrainDump.a(level, this));
        }
    }

    public double getMaxY() {
        return this.an().N_();
    }

    public EnumInteractionResult tryRide(EntityHuman player, EnumHand hand) {
        return this.tryRide(player, hand, EnumInteractionResult.e);
    }

    public EnumInteractionResult tryRide(EntityHuman player, EnumHand hand, EnumInteractionResult result) {
        EntityAgeable ageable;
        if (!this.isRidable()) {
            return result;
        }
        if (hand != EnumHand.a) {
            return EnumInteractionResult.e;
        }
        if (player.cp()) {
            return EnumInteractionResult.e;
        }
        if (!player.b(hand).f()) {
            return EnumInteractionResult.e;
        }
        if (!((Entity)this).aS.isEmpty() || player.cl()) {
            return EnumInteractionResult.e;
        }
        EntityInsentient entityInsentient = this;
        if (entityInsentient instanceof EntityTameableAnimal) {
            EntityTameableAnimal tamable = (EntityTameableAnimal)entityInsentient;
            if (tamable.m() && !tamable.j(player)) {
                return EnumInteractionResult.e;
            }
            if (!tamable.m() && !this.an().purpurConfig.untamedTamablesAreRidable) {
                return EnumInteractionResult.e;
            }
        }
        if ((entityInsentient = this) instanceof EntityAgeable && (ageable = (EntityAgeable)entityInsentient).g_() && !this.an().purpurConfig.babiesAreRidable) {
            return EnumInteractionResult.e;
        }
        if (!player.getBukkitEntity().hasPermission("allow.ride." + BuiltInRegistries.g.b(this.ax()).a())) {
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                serverPlayer.sendMiniMessage(PurpurConfig.cannotRideMob);
            }
            return EnumInteractionResult.e;
        }
        player.v(this.dX());
        player.w(this.dZ());
        if (player.o(this)) {
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }
}

