/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JavaOps;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityAttemptSpinAttackEvent;
import io.papermc.paper.event.entity.EntityEquipmentChangedEvent;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.purpurmc.purpur.event.entity.RidableMoveEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable,
WaypointTransmitter {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "active_effects";
    public static final String u = "attributes";
    public static final String aN = "sleeping_pos";
    public static final String aO = "equipment";
    public static final String aP = "Brain";
    public static final String aQ = "FallFlying";
    public static final String aR = "HurtTime";
    public static final String aS = "DeathTime";
    public static final String aT = "HurtByTimestamp";
    public static final String aU = "Health";
    private static final MinecraftKey c = MinecraftKey.b("powder_snow");
    private static final MinecraftKey d = MinecraftKey.b("sprinting");
    private static final AttributeModifier e = new AttributeModifier(d, 0.3f, AttributeModifier.Operation.c);
    public static final int aV = 98;
    public static final int aW = 100;
    public static final int aX = 105;
    public static final int aY = 106;
    public static final int aZ = 6;
    public static final int ba = 100;
    private static final int r = 40;
    public static final double bb = 0.003;
    public static final double bc = 0.08;
    public static final int bd = 20;
    protected static final float be = 0.98f;
    private static final int s = 10;
    private static final int t = 2;
    public static final float bf = 0.42f;
    private static final double ca = 128.0;
    protected static final int bg = 1;
    protected static final int bh = 2;
    public static final int bi = 4;
    protected static final DataWatcherObject<Byte> bj = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> cb = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<List<ParticleParam>> cc = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> ce = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cf = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> cg = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.p);
    private static final int ch = 15;
    protected static final EntitySize bk = EntitySize.c(0.2f, 0.2f).b(0.2f);
    public static final float bl = 0.5f;
    public static final float bm = 0.5f;
    public static final Predicate<EntityLiving> bn = entity -> {
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            ItemStack itemBySlot = player.a(EnumItemSlot.f);
            return !itemBySlot.a(TagsItem.cH);
        }
        return true;
    };
    private static final Dynamic<?> ci = new Dynamic(JavaOps.INSTANCE, Map.of("memories", Map.of()));
    private final AttributeMapBase cj;
    public CombatTracker ck = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> cl = Maps.newHashMap();
    private final Map<EnumItemSlot, ItemStack> cm = SystemUtils.a(EnumItemSlot.class, (K slot) -> ItemStack.l);
    public boolean bo;
    private boolean cn = false;
    public EnumHand bp;
    public int bq;
    public int br;
    public int bs;
    public int bt;
    public int bu;
    public int bv;
    public float bw;
    public float bx;
    protected int by;
    public final WalkAnimationState bz = new WalkAnimationState();
    public int bA = 20;
    public float bB;
    public float bC;
    public float bD;
    public float bE;
    public final ElytraAnimationState bF = new ElytraAnimationState(this);
    @Nullable
    public EntityReference<EntityHuman> bG;
    public int bH;
    protected boolean bI;
    protected int bJ;
    public float bK;
    public boolean bL;
    public float bM;
    public float bN;
    public float bO;
    protected InterpolationHandler bP = new InterpolationHandler(this);
    protected double bQ;
    protected int bR;
    public boolean co = true;
    @Nullable
    public EntityReference<EntityLiving> cp;
    public int cq;
    @Nullable
    private EntityLiving cr;
    private int cs;
    private float ct;
    private int cu;
    private float cv;
    protected ItemStack bS = ItemStack.l;
    public int bT;
    protected int bU;
    private BlockPosition cw;
    private Optional<BlockPosition> cx = Optional.empty();
    @Nullable
    private DamageSource cy;
    private long cz;
    protected int bV;
    protected float bW;
    @Nullable
    protected ItemStack bX;
    private float cA;
    private float cB;
    protected BehaviorController<?> bY;
    protected boolean cC;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> cD = new EnumMap(EnumItemSlot.class);
    protected final EntityEquipment bZ;
    private Waypoint.a cE = new Waypoint.a();
    public int expToDrop;
    public List<Entity.DefaultDrop> drops = new ArrayList<Entity.DefaultDrop>();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    protected boolean shouldBurnInDay = false;
    private boolean isTickingEffects = false;
    private final List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EnumItemSlot> clearedEquipmentSlots = new HashSet<EnumItemSlot>();
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;

    public float getStrafeMot() {
        return this.bM;
    }

    public void setStrafeMot(float strafe) {
        this.bM = strafe;
    }

    public float getVerticalMot() {
        return this.bN;
    }

    public void setVerticalMot(float vertical) {
        this.bN = vertical;
    }

    public float getForwardMot() {
        return this.bO;
    }

    public void setForwardMot(float forward) {
        this.bO = forward;
    }

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    public boolean shouldBurnInDay() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> type, net.minecraft.world.level.World level) {
        super(type, level);
        this.cj = new AttributeMapBase(AttributeDefaults.a(type), this);
        this.initAttributes();
        this.craftAttributes = new CraftAttributeMap(this.cj);
        this.az.a(cb, Float.valueOf(this.fj()));
        this.bZ = this.ep();
        this.W = true;
        this.aG();
        this.v((float)(Math.random() * 6.2831854820251465));
        this.bD = this.dX();
        this.bY = this.a(ci);
    }

    @Override
    @Nullable
    public EntityLiving eo() {
        return this;
    }

    @Contract(pure=true)
    protected EntityEquipment ep() {
        return new EntityEquipment();
    }

    protected void initAttributes() {
    }

    public BehaviorController<?> eq() {
        return this.bY;
    }

    protected BehaviorController.b<?> er() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.er().a(dynamic);
    }

    @Override
    public void c(WorldServer level) {
        this.a(level, this.ei().y(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> entityType) {
        return true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(bj, (byte)0);
        builder.a(cc, List.of());
        builder.a(cd, false);
        builder.a(ce, 0);
        builder.a(cf, 0);
        builder.a(cb, Float.valueOf(1.0f));
        builder.a(cg, Optional.empty());
    }

    public static AttributeProvider.Builder es() {
        return AttributeProvider.a().a(GenericAttributes.t).a(GenericAttributes.q).a(GenericAttributes.w).a(GenericAttributes.a).a(GenericAttributes.b).a(GenericAttributes.s).a(GenericAttributes.C).a(GenericAttributes.z).a(GenericAttributes.o).a(GenericAttributes.y).a(GenericAttributes.l).a(GenericAttributes.p).a(GenericAttributes.x).a(GenericAttributes.h).a(GenericAttributes.j).a(GenericAttributes.G).a(GenericAttributes.v).a(GenericAttributes.d).a(GenericAttributes.i).a(GenericAttributes.H);
    }

    public boolean shouldSendAttribute(AttributeBase attribute) {
        return true;
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        net.minecraft.world.level.World world;
        if (!this.bu()) {
            this.bD();
        }
        if ((world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (onGround && this.an > 0.0) {
                this.b(serverLevel, pos);
                double d2 = Math.max(0, MathHelper.a(this.i(this.an)));
                if (d2 > 0.0 && !state.l()) {
                    double d1;
                    double x2 = this.dK();
                    double y1 = this.dM();
                    double z2 = this.dQ();
                    BlockPosition blockPos = this.dF();
                    if (pos.u() != blockPos.u() || pos.w() != blockPos.w()) {
                        d1 = x2 - (double)pos.u() - 0.5;
                        double d22 = z2 - (double)pos.w() - 0.5;
                        double max = Math.max(Math.abs(d1), Math.abs(d22));
                        x2 = (double)pos.u() + 0.5 + d1 / max * 0.5;
                        z2 = (double)pos.w() + 0.5 + d22 / max * 0.5;
                    }
                    d1 = Math.min((double)0.2f + d2 / 15.0, 2.5);
                    int i2 = (int)(150.0 * d1);
                    if (this instanceof EntityPlayer) {
                        serverLevel.sendParticlesSource((EntityPlayer)this, new ParticleParamBlock(Particles.b, state), false, false, x2, y1, z2, i2, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        serverLevel.a(new ParticleParamBlock(Particles.b, state), x2, y1, z2, i2, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                }
            }
        }
        super.a(y2, onGround, state, pos);
        if (onGround) {
            this.cx = Optional.empty();
        }
    }

    public boolean et() {
        return this.ax().a(TagsEntity.m);
    }

    public float b(float partialTick) {
        return MathHelper.h(partialTick, this.cB, this.cA);
    }

    public boolean eu() {
        return this.dI().b() < (double)1.0E-5f && this.bx();
    }

    @Override
    public void aH() {
        EntityLiving lastHurtByMob;
        net.minecraft.world.level.World world;
        net.minecraft.world.level.World world2;
        this.bw = this.bx;
        if (this.ay) {
            this.ge().ifPresent(this::a);
        }
        if ((world2 = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world2;
            EnchantmentManager.b(serverLevel, this);
        }
        super.aH();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("livingEntityBaseTick");
        if (this.bX() && (world = this.an()) instanceof WorldServer) {
            double damagePerBlock;
            double d2;
            WorldServer serverLevel1 = (WorldServer)world;
            boolean flag = this instanceof EntityHuman;
            if (this.bY()) {
                this.a(serverLevel1, this.ei().g(), 1.0f);
            } else if (flag && !serverLevel1.u().a(this.de()) && (d2 = serverLevel1.u().a(this) + serverLevel1.u().n()) < 0.0 && (damagePerBlock = serverLevel1.u().o()) > 0.0) {
                EntityLiving entityLiving;
                if (this.an().purpurConfig.teleportIfOutsideBorder && (entityLiving = this) instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                    serverPlayer.teleport(CraftLocation.toBukkit((BaseBlockPosition)this.an().A.a().b(), this.an()));
                    return;
                }
                this.a(serverLevel1, this.ei().x(), (float)Math.max(1, MathHelper.a(-d2 * damagePerBlock)));
            }
            if (((Entity)this).a(TagsFluid.a) && !serverLevel1.a_(BlockPosition.a(this.dK(), this.dO(), this.dQ())).a(Blocks.oa)) {
                boolean flag1;
                boolean bl = flag1 = !this.et() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).gC().a);
                if (flag1) {
                    this.j(this.l(this.cF()));
                    if (this.ev()) {
                        this.j(0);
                        serverLevel1.a((Entity)this, (byte)67);
                        this.a(serverLevel1, this.ei().i(), (float)this.an().purpurConfig.damageFromDrowning);
                    }
                } else if (this.cF() < this.cE()) {
                    this.j(this.m(this.cF()));
                }
                if (this.cl() && this.du() != null && this.du().cn()) {
                    this.cb();
                }
            } else if (this.cF() < this.cE()) {
                this.j(this.m(this.cF()));
            }
            BlockPosition blockPos = this.dF();
            if (!Objects.equal((Object)this.cw, (Object)blockPos)) {
                this.cw = blockPos;
                this.b(serverLevel1, blockPos);
            }
        }
        if (this.bt > 0) {
            --this.bt;
        }
        if (this.ax > 0 && !(this instanceof EntityPlayer)) {
            --this.ax;
        }
        if (this.eV() && this.an().h(this)) {
            this.eC();
        }
        if (this.bH > 0) {
            --this.bH;
        } else {
            this.bG = null;
        }
        if (this.cr != null && !this.cr.bX()) {
            this.cr = null;
        }
        if ((lastHurtByMob = this.eF()) != null) {
            if (!lastHurtByMob.bX()) {
                this.a((EntityLiving)null);
            } else if (this.at - this.cq > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.eM();
        this.bE = this.bD;
        this.bC = this.bB;
        this.ab = this.dX();
        this.ac = this.dZ();
        profilerFiller.c();
    }

    protected boolean ev() {
        return this.cF() <= -this.an().purpurConfig.drowningDamageInterval;
    }

    @Override
    protected float be() {
        return MathHelper.h((float)this.i(GenericAttributes.v), super.be(), 1.0f);
    }

    public float ew() {
        return 0.0f;
    }

    protected void ex() {
        AttributeModifiable attribute = this.h(GenericAttributes.w);
        if (attribute != null && attribute.a(c) != null) {
            attribute.c(c);
        }
    }

    protected void ey() {
        int ticksFrozen;
        if (!this.bF().l() && (ticksFrozen = this.cH()) > 0) {
            AttributeModifiable attribute = this.h(GenericAttributes.w);
            if (attribute == null) {
                return;
            }
            float f2 = -0.05f * this.cI();
            attribute.b(new AttributeModifier(c, f2, AttributeModifier.Operation.a));
        }
    }

    protected void b(WorldServer level, BlockPosition pos) {
        EnchantmentManager.a(level, this);
    }

    public boolean g_() {
        return false;
    }

    public float ez() {
        return this.g_() ? 0.5f : 1.0f;
    }

    public final float eA() {
        AttributeMapBase attributes = this.fp();
        return attributes == null ? 1.0f : this.c((float)attributes.c(GenericAttributes.z));
    }

    protected float c(float scale) {
        return scale;
    }

    public boolean eB() {
        return true;
    }

    protected void eC() {
        ++this.bv;
        if (this.bv >= 20 && !this.an().D_() && !this.ec()) {
            this.an().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean eD() {
        return !this.g_();
    }

    protected boolean e(WorldServer level) {
        return !this.g_() && level.S().c(GameRules.g);
    }

    protected int l(int currentAirSupply) {
        AttributeModifiable attribute = this.h(GenericAttributes.x);
        double value = attribute != null ? attribute.g() : 0.0;
        return value > 0.0 && this.as.j() >= 1.0 / (value + 1.0) ? currentAirSupply : currentAirSupply - 1;
    }

    protected int m(int currentAirSupply) {
        return Math.min(currentAirSupply + 4, this.cE());
    }

    public final int a(WorldServer level, @Nullable Entity killer) {
        return EnchantmentManager.a(level, killer, (Entity)this, this.f(level));
    }

    protected int f(WorldServer level) {
        return 0;
    }

    protected boolean eE() {
        return false;
    }

    @Nullable
    public EntityLiving eF() {
        return EntityReference.b(this.cp, this.an());
    }

    @Nullable
    public EntityHuman eG() {
        return EntityReference.c(this.bG, this.an());
    }

    @Override
    public EntityLiving h_() {
        return this.eF();
    }

    public int eH() {
        return this.cq;
    }

    public void a(EntityHuman player, int memoryTime) {
        this.a(EntityReference.a(player), memoryTime);
    }

    public void a(UUID uuid, int memoryTime) {
        this.a(EntityReference.a(uuid), memoryTime);
    }

    private void a(EntityReference<EntityHuman> player, int memoryTime) {
        this.bG = player;
        this.bH = memoryTime;
    }

    public void a(@Nullable EntityLiving livingEntity) {
        this.cp = EntityReference.a(livingEntity);
        this.cq = this.at;
    }

    @Nullable
    public EntityLiving eI() {
        return this.cr;
    }

    public int eJ() {
        return this.cs;
    }

    public void C(Entity entity) {
        this.cr = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.cs = this.at;
    }

    public int eK() {
        return this.bJ;
    }

    public void n(int noActionTime) {
        this.bJ = noActionTime;
    }

    public boolean eL() {
        return !this.frictionState.toBooleanOrElse(!this.cn);
    }

    public void r(boolean discardFriction) {
        this.cn = discardFriction;
    }

    protected boolean b(EnumItemSlot slot) {
        return true;
    }

    public void a(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem) {
        this.onEquipItem(slot, oldItem, newItem, false);
    }

    public void onEquipItem(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem, boolean silent) {
        if (!(this.an().D_() || this.at() || ItemStack.c(oldItem, newItem) || this.ay)) {
            Equippable equippable = newItem.a(DataComponents.D);
            if (!this.bm() && equippable != null && slot == equippable.b() && !silent) {
                this.an().a(null, this.dK(), this.dM(), this.dQ(), this.a(slot, newItem, equippable), this.dw(), 1.0f, 1.0f, this.as.g());
            }
            if (this.b(slot)) {
                this.c(equippable != null ? GameEvent.v : GameEvent.S);
            }
        }
    }

    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return equippable.c();
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        net.minecraft.world.level.World world;
        if ((reason == Entity.RemovalReason.a || reason == Entity.RemovalReason.b) && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, reason);
        }
        super.remove(reason, eventCause);
        this.bY.a();
    }

    @Override
    public void b(Entity.RemovalReason reason) {
        super.b(reason);
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.h().c(this);
        }
    }

    protected void a(WorldServer level, Entity.RemovalReason removalReason) {
        for (MobEffect mobEffectInstance : this.eR()) {
            mobEffectInstance.a(level, this, removalReason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.cl.clear();
    }

    @Override
    protected void a(ValueOutput output) {
        if (this.frictionState != TriState.NOT_SET) {
            output.a("Paper.FrictionState", this.frictionState.toString());
        }
        output.a(aU, this.eU());
        output.a(aR, (short)this.bt);
        output.a(aT, this.cq);
        output.a(aS, (short)this.bv);
        output.a("AbsorptionAmount", this.fM());
        output.a(u, AttributeModifiable.a.b, this.fp().d());
        if (!this.cl.isEmpty()) {
            output.a(b, MobEffect.d.listOf(), List.copyOf(this.cl.values()));
        }
        output.a(aQ, this.fY());
        this.ge().ifPresent(blockPos -> output.a(aN, BlockPosition.a, blockPos));
        DataResult dataResult = this.bY.a(DynamicOpsNBT.a).map(tag -> new Dynamic<NBTBase>(DynamicOpsNBT.a, (NBTBase)tag));
        dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(dynamic -> output.a(aP, Codec.PASSTHROUGH, dynamic));
        output.a("Purpur.ShouldBurnInDay", this.shouldBurnInDay);
        if (this.bG != null) {
            this.bG.a(output, "last_hurt_by_player");
            output.a("last_hurt_by_player_memory_time", this.bH);
        }
        if (this.cp != null) {
            this.cp.a(output, "last_hurt_by_mob");
            output.a("ticks_since_last_hurt_by_mob", this.at - this.cq);
        }
        if (!this.bZ.a()) {
            output.a(aO, EntityEquipment.a, this.bZ);
        }
        if (this.cE.a()) {
            output.a("locator_bar_icon", Waypoint.a.a, this.cE);
        }
    }

    @Nullable
    public final EntityItem a(ItemStack stack, boolean randomizeMotion, boolean includeThrower) {
        return this.drop(stack, randomizeMotion, includeThrower, true, null);
    }

    @Nullable
    public EntityItem drop(ItemStack stack, boolean randomizeMotion, boolean includeThrower, boolean callEvent, @Nullable Consumer<Item> entityOperation) {
        if (stack.f()) {
            return null;
        }
        if (this.an().D_()) {
            this.a(EnumHand.a);
            return null;
        }
        EntityItem itemEntity = this.b(stack, randomizeMotion, includeThrower);
        if (itemEntity != null) {
            CraftEntity craftEntity;
            if (entityOperation != null) {
                entityOperation.accept((Item)itemEntity.getBukkitEntity());
            }
            if (callEvent && (craftEntity = this.getBukkitEntity()) instanceof Player) {
                Player player = (Player)craftEntity;
                Item drop = (Item)itemEntity.getBukkitEntity();
                PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
                this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    org.bukkit.inventory.ItemStack inHandItem = player.getInventory().getItemInMainHand();
                    if (includeThrower && inHandItem.getAmount() == 0) {
                        player.getInventory().setItemInMainHand(drop.getItemStack());
                    } else if (includeThrower && inHandItem.isSimilar(drop.getItemStack()) && inHandItem.getAmount() < inHandItem.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                        inHandItem.setAmount(inHandItem.getAmount() + 1);
                        player.getInventory().setItemInMainHand(inHandItem);
                    } else {
                        player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                    }
                    return null;
                }
            }
            this.an().b(itemEntity);
        }
        return itemEntity;
    }

    @Override
    protected void a(ValueInput input) {
        float absorptionAmount = input.a("AbsorptionAmount", 0.0f);
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.F(absorptionAmount);
        input.g("Paper.FrictionState").ifPresent(frictionState -> {
            try {
                this.frictionState = TriState.valueOf((String)frictionState);
            }
            catch (Exception ignored) {
                a.error("Unknown friction state {} for {}", frictionState, (Object)this);
            }
        });
        if (this.an() != null && !this.an().D_()) {
            input.a(u, AttributeModifiable.a.b).ifPresent(this.fp()::a);
        }
        List list = input.a(b, MobEffect.d.listOf()).orElse(List.of());
        this.cl.clear();
        for (MobEffect mobEffectInstance : list) {
            this.cl.put(mobEffectInstance.c(), mobEffectInstance);
        }
        input.a("Bukkit.MaxHealth", Codec.DOUBLE).ifPresent(maxHealth -> this.h(GenericAttributes.t).a((double)maxHealth));
        this.x(input.a(aU, this.fj()));
        this.bt = input.a(aR, (short)0);
        this.bv = input.a(aS, (short)0);
        this.cq = input.a(aT, 0);
        input.g("Team").ifPresent(string -> {
            boolean flag;
            Scoreboard scoreboard = this.an().W();
            ScoreboardTeam playerTeam = scoreboard.b((String)string);
            if (!this.an().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
                playerTeam = null;
            }
            boolean bl = flag = playerTeam != null && scoreboard.a(this.cU(), playerTeam);
            if (!flag) {
                a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", string);
            }
        });
        this.b(7, input.a(aQ, false));
        input.a(aN, BlockPosition.a).ifPresentOrElse(blockPos -> {
            if (this.dD().c(blockPos.u(), blockPos.v(), blockPos.w()) < (double)MathHelper.i(16)) {
                this.g((BlockPosition)blockPos);
                this.az.a(Entity.aE, EntityPose.c);
                if (!this.ay) {
                    this.a((BlockPosition)blockPos);
                }
            }
        }, this::gf);
        input.a(aP, Codec.PASSTHROUGH).ifPresent(dynamic -> {
            this.bY = this.a((Dynamic<?>)((Object)dynamic));
        });
        this.shouldBurnInDay = input.a("Purpur.ShouldBurnInDay", this.shouldBurnInDay);
        this.bG = EntityReference.a(input, "last_hurt_by_player");
        this.bH = input.a("last_hurt_by_player_memory_time", 0);
        this.cp = EntityReference.a(input, "last_hurt_by_mob");
        this.cq = input.a("ticks_since_last_hurt_by_mob", 0) + this.at;
        this.bZ.a(input.a(aO, EntityEquipment.a).orElseGet(EntityEquipment::new));
        this.cE = input.a("locator_bar_icon", Waypoint.a.a).orElseGet(Waypoint.a::new);
    }

    protected void eM() {
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Iterator<Object> iterator = this.cl.keySet().iterator();
            this.isTickingEffects = true;
            try {
                while (iterator.hasNext()) {
                    Holder holder = (Holder)iterator.next();
                    MobEffect mobEffectInstance = this.cl.get(holder);
                    if (!mobEffectInstance.a(serverLevel, this, () -> this.a(mobEffectInstance, true, null))) {
                        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, null, EntityPotionEffectEvent.Cause.EXPIRATION);
                        if (event.isCancelled()) continue;
                        iterator.remove();
                        this.c(List.of(mobEffectInstance));
                        continue;
                    }
                    if (mobEffectInstance.d() % 600 != 0) continue;
                    this.a(mobEffectInstance, false, null);
                }
            }
            catch (ConcurrentModificationException holder) {
                // empty catch block
            }
            this.isTickingEffects = false;
            for (ProcessableEffect effect : this.effectsToProcess) {
                if (effect.effect != null) {
                    this.addEffect(effect.effect, effect.cause);
                    continue;
                }
                this.removeEffect(effect.type, effect.cause);
            }
            this.effectsToProcess.clear();
            if (this.co) {
                this.M();
                this.p();
                this.co = false;
            }
        } else {
            for (MobEffect mobEffectInstance1 : this.cl.values()) {
                mobEffectInstance1.i();
            }
            List<ParticleParam> list = this.az.a(cc);
            if (!list.isEmpty()) {
                int i1;
                boolean flag = this.az.a(cd);
                int i2 = this.cB() ? 15 : 4;
                int n2 = i1 = flag ? 5 : 1;
                if (this.as.a(i2 * i1) == 0) {
                    this.an().a(SystemUtils.a(list, this.as), this.e(0.5), this.dN(), this.h(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    protected void M() {
        if (this.cl.isEmpty()) {
            this.eP();
            this.l(false);
        } else {
            this.l(this.d(MobEffects.n));
            this.k();
        }
    }

    private void k() {
        List<ParticleParam> list = this.cl.values().stream().filter(MobEffect::g).map(MobEffect::a).toList();
        this.az.a(cc, list);
        this.az.a(cd, EntityLiving.d(this.cl.values()));
    }

    private void p() {
        boolean isCurrentlyGlowing = this.cA();
        if (this.i(6) != isCurrentlyGlowing) {
            this.b(6, isCurrentlyGlowing);
        }
    }

    public double D(@Nullable Entity lookingEntity) {
        EntityLiving entityliving;
        double d2 = 1.0;
        if (this.cs()) {
            d2 *= 0.8;
        }
        if (this.cB()) {
            float armorCoverPercentage = this.fs();
            if (armorCoverPercentage < 0.1f) {
                armorCoverPercentage = 0.1f;
            }
            d2 *= 0.7 * (double)armorCoverPercentage;
        }
        if (lookingEntity != null) {
            ItemStack itemBySlot = this.a(EnumItemSlot.f);
            EntityTypes<?> type = lookingEntity.ax();
            if (type == EntityTypes.bk && itemBySlot.a(Items.wt)) {
                d2 *= lookingEntity.an().purpurConfig.skeletonHeadVisibilityPercent;
            } else if (type == EntityTypes.bT && itemBySlot.a(Items.ww)) {
                d2 *= lookingEntity.an().purpurConfig.zombieHeadVisibilityPercent;
            } else if ((type == EntityTypes.aW || type == EntityTypes.aX) && itemBySlot.a(Items.wz)) {
                d2 *= lookingEntity.an().purpurConfig.piglinHeadVisibilityPercent;
            } else if (type == EntityTypes.H && itemBySlot.a(Items.wx)) {
                d2 *= lookingEntity.an().purpurConfig.creeperHeadVisibilityPercent;
            }
        }
        if (lookingEntity instanceof EntityLiving && (entityliving = (EntityLiving)lookingEntity).d(MobEffects.o)) {
            int amplifier = entityliving.e(MobEffects.o).e();
            for (int i2 = 0; i2 < amplifier; ++i2) {
                d2 *= this.an().purpurConfig.mobsBlindnessMultiplier;
            }
        }
        return d2;
    }

    public boolean c(EntityLiving target) {
        return (!(target instanceof EntityHuman) || this.an().aq() != EnumDifficulty.a) && target.eN();
    }

    public boolean eN() {
        return !this.cP() && this.eO();
    }

    public boolean eO() {
        return !this.at() && this.bX();
    }

    public static boolean d(Collection<MobEffect> effects) {
        for (MobEffect mobEffectInstance : effects) {
            if (!mobEffectInstance.g() || mobEffectInstance.f()) continue;
            return false;
        }
        return true;
    }

    protected void eP() {
        this.az.a(cc, List.of());
    }

    public boolean eQ() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.an().D_()) {
            return false;
        }
        if (this.cl.isEmpty()) {
            return false;
        }
        LinkedList<MobEffect> toRemove = new LinkedList<MobEffect>();
        Iterator<MobEffect> iterator = this.cl.values().iterator();
        while (iterator.hasNext()) {
            EntityPotionEffectEvent event;
            MobEffect effect = iterator.next();
            if (cause == EntityPotionEffectEvent.Cause.MILK && !this.an().purpurConfig.milkClearsBeneficialEffects && effect.c().a().j() || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED)).isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.c(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffect> eR() {
        return this.cl.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> eS() {
        return this.cl;
    }

    public boolean d(Holder<MobEffectList> effect) {
        return this.cl.containsKey(effect);
    }

    @Nullable
    public MobEffect e(Holder<MobEffectList> effect) {
        return this.cl.get(effect);
    }

    public float a(Holder<MobEffectList> effect, float partialTick) {
        MobEffect effect1 = this.e(effect);
        return effect1 != null ? effect1.a(this, partialTick) : 0.0f;
    }

    public final boolean a(MobEffect effectInstance) {
        return this.b(effectInstance, (Entity)null);
    }

    public boolean addEffect(MobEffect effectInstance, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, null, cause);
    }

    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return this.addEffect(effectInstance, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, entity, cause, true);
    }

    public boolean addEffect(MobEffect effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause, boolean fireEvent) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effectInstance, cause));
            return true;
        }
        if (!this.b(effectInstance)) {
            return false;
        }
        MobEffect mobEffectInstance = this.cl.get(effectInstance.c());
        boolean flag = false;
        boolean override = false;
        if (mobEffectInstance != null) {
            override = new MobEffect(mobEffectInstance).b(effectInstance);
        }
        if (fireEvent) {
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, effectInstance, cause, override);
            override = event.isOverride();
            if (event.isCancelled()) {
                return false;
            }
        }
        if (mobEffectInstance == null) {
            this.cl.put(effectInstance.c(), effectInstance);
            this.a(effectInstance, entity);
            flag = true;
            effectInstance.b(this);
        } else if (override) {
            mobEffectInstance.b(effectInstance);
            this.a(mobEffectInstance, true, entity);
            flag = true;
        }
        effectInstance.a(this);
        return flag;
    }

    public boolean b(MobEffect effectInstance) {
        if (this.ax().a(TagsEntity.G)) {
            return !effectInstance.a(MobEffects.M);
        }
        return this.ax().a(TagsEntity.F) ? !effectInstance.a(MobEffects.L) : !this.ax().a(TagsEntity.w) || !effectInstance.a(MobEffects.j) && !effectInstance.a(MobEffects.s);
    }

    public void c(MobEffect effectInstance, @Nullable Entity entity) {
        if (this.b(effectInstance)) {
            MobEffect mobEffectInstance = this.cl.put(effectInstance.c(), effectInstance);
            if (mobEffectInstance == null) {
                this.a(effectInstance, entity);
            } else {
                effectInstance.d(mobEffectInstance);
                this.a(effectInstance, true, entity);
            }
        }
    }

    public boolean eT() {
        return this.ax().a(TagsEntity.x);
    }

    @Nullable
    public final MobEffect f(Holder<MobEffectList> effect) {
        return this.removeEffectNoUpdate(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect removeEffectNoUpdate(Holder<MobEffectList> effect, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effect, cause));
            return null;
        }
        MobEffect effectInstance = this.cl.get(effect);
        if (effectInstance == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effectInstance, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.cl.remove(effect);
    }

    public boolean g(Holder<MobEffectList> effect) {
        return this.removeEffect(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> effect, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobEffectInstance = this.removeEffectNoUpdate(effect, cause);
        if (mobEffectInstance != null) {
            this.c(List.of(mobEffectInstance));
            return true;
        }
        return false;
    }

    protected void a(MobEffect effectInstance, @Nullable Entity entity) {
        if (!this.an().D_()) {
            this.co = true;
            effectInstance.c().a().a(this.fp(), effectInstance.e());
            this.c(effectInstance);
        }
    }

    public void c(MobEffect effectInstance) {
        for (Entity entity : this.di()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            serverPlayer.g.b(new PacketPlayOutEntityEffect(this.az(), effectInstance, false));
        }
    }

    protected void a(MobEffect effectInstance, boolean forced, @Nullable Entity entity) {
        if (!this.an().D_()) {
            this.co = true;
            if (forced) {
                MobEffectList mobEffect = effectInstance.c().a();
                mobEffect.a(this.fp());
                mobEffect.a(this.fp(), effectInstance.e());
                this.H();
            }
            this.c(effectInstance);
        }
    }

    protected void c(Collection<MobEffect> effects) {
        if (!this.an().D_()) {
            this.co = true;
            for (MobEffect mobEffectInstance : effects) {
                mobEffectInstance.c().a().a(this.fp());
                for (Entity entity : this.di()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer serverPlayer = (EntityPlayer)entity;
                    serverPlayer.g.b(new PacketPlayOutRemoveEntityEffect(this.az(), mobEffectInstance.c()));
                }
            }
            this.H();
        }
    }

    private void H() {
        Set<AttributeModifiable> attributesToUpdate = this.fp().b();
        for (AttributeModifiable attributeInstance : attributesToUpdate) {
            this.a(attributeInstance.a());
        }
        attributesToUpdate.clear();
    }

    protected void a(Holder<AttributeBase> attribute) {
        net.minecraft.world.level.World maxHealth3;
        if (attribute.a(GenericAttributes.t)) {
            float maxHealth2 = this.fj();
            if (this.eU() > maxHealth2) {
                this.x(maxHealth2);
            }
        } else if (attribute.a(GenericAttributes.s)) {
            float maxHealth3 = this.fk();
            if (this.fM() > maxHealth3) {
                this.E(maxHealth3);
            }
        } else if (attribute.a(GenericAttributes.z)) {
            this.l_();
        } else if (attribute.a(GenericAttributes.H) && (maxHealth3 = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)maxHealth3;
            ServerWaypointManager waypointManager = serverLevel.h();
            if (this.cj.c(attribute) > 0.0) {
                waypointManager.a(this);
            } else {
                waypointManager.c(this);
            }
        }
    }

    public void d(float amount) {
        this.heal(amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float amount, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(amount, regainReason, false);
    }

    public void heal(float amount, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float health = this.eU();
        if (health > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)amount, regainReason, isFastRegen);
            if (this.valid) {
                this.an().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.x((float)((double)this.eU() + event.getAmount()));
            }
        }
    }

    public float eU() {
        EntityLiving entityLiving = this;
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            return (float)player.getBukkitEntity().getHealth();
        }
        return this.az.a(cb).floatValue();
    }

    public void x(float health) {
        if (Float.isNaN(health)) {
            health = this.fj();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.cV() + " had NaN health set");
            }
        }
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.az.a(cb, Float.valueOf(MathHelper.a(health, 0.0f, this.fj())));
    }

    public boolean eV() {
        return this.eU() <= 0.0f;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag2;
        boolean flag;
        Entity entity2;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.ec() || this.bI || this.eU() <= 0.0f) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.i) && this.d(MobEffects.l)) {
            return false;
        }
        if (this.gg()) {
            this.gh();
        }
        if ((entity2 = damageSource.d()) instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity2;
            if (damageSource.d().an().purpurConfig.creativeOnePunch && !damageSource.a(DamageTypeTags.j) && player.gQ()) {
                MutableDouble attackDamage = new MutableDouble();
                player.fq().a(EnumItemSlot.a, (Holder<AttributeBase> attributeHolder, AttributeModifier attributeModifier) -> {
                    if (attributeModifier.c() == AttributeModifier.Operation.a) {
                        attackDamage.addAndGet(attributeModifier.b());
                    }
                });
                if (attackDamage.doubleValue() == 0.0) {
                    amount = 9999.0f;
                }
            }
        }
        this.bJ = 0;
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        ItemStack useItem = this.fQ();
        float originAmount = amount;
        float f1 = this.applyItemBlocking(level, damageSource, amount, true);
        boolean bl = flag = f1 > 0.0f;
        if (Float.isNaN(amount) || Float.isInfinite(amount)) {
            amount = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.ax > (float)this.bA / 2.0f && !damageSource.a(DamageTypeTags.e)) {
            if (amount <= this.bK) {
                return false;
            }
            event = this.handleEntityDamage(damageSource, amount, this.bK);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originAmount == 0.0f) {
                return false;
            }
            this.bK = amount;
            flag1 = false;
        } else {
            event = this.handleEntityDamage(damageSource, amount, 0.0f);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originAmount == 0.0f) {
                return false;
            }
            this.bK = amount;
            this.ax = this.bA;
            this.bt = this.bu = 10;
        }
        this.f(damageSource);
        this.g(damageSource);
        if (flag1) {
            BlocksAttacks blocksAttacks = useItem.a(DataComponents.I);
            if (flag && blocksAttacks != null) {
                blocksAttacks.a(level, this);
            } else {
                level.a((Entity)this, damageSource);
            }
            if (!damageSource.a(DamageTypeTags.r) && !flag) {
                this.bP();
            }
            if (!damageSource.a(DamageTypeTags.z)) {
                double d2 = 0.0;
                double d1 = 0.0;
                Entity entity3 = damageSource.c();
                if (entity3 instanceof IProjectile) {
                    IProjectile projectile = (IProjectile)entity3;
                    DoubleDoubleImmutablePair doubleDoubleImmutablePair = projectile.a_(this, damageSource);
                    d2 = -doubleDoubleImmutablePair.leftDouble();
                    d1 = -doubleDoubleImmutablePair.rightDouble();
                } else if (damageSource.i() != null) {
                    d2 = damageSource.i().a() - this.dK();
                    d1 = damageSource.i().c() - this.dQ();
                }
                if (Math.abs(d2) > 200.0) {
                    d2 = Math.random() - Math.random();
                }
                if (Math.abs(d1) > 200.0) {
                    d1 = Math.random() - Math.random();
                }
                this.knockback(0.4f, d2, d1, damageSource.c(), damageSource.c() == null ? EntityKnockbackEvent.Cause.DAMAGE : EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d2, d1);
                }
            }
        }
        if (this.eV()) {
            if (!this.j(damageSource)) {
                this.silentDeath = !flag1;
                this.a(damageSource);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.h(damageSource);
            this.i(damageSource);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.cy = damageSource;
            this.cz = this.an().ag();
            for (MobEffect mobEffectInstance : this.eR()) {
                mobEffectInstance.a(level, this, damageSource, amount);
            }
        }
        if ((entity = this) instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            CriterionTriggers.i.a(serverPlayer, damageSource, originAmount, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                serverPlayer.a(StatisticList.L, Math.round(f1 * 10.0f));
            }
        }
        if ((entity = damageSource.d()) instanceof EntityPlayer) {
            EntityPlayer serverPlayerx = (EntityPlayer)entity;
            CriterionTriggers.h.a(serverPlayerx, this, damageSource, originAmount, amount, flag);
        }
        return flag2;
    }

    public float b(WorldServer level, DamageSource damageSource, float damageAmount) {
        return this.applyItemBlocking(level, damageSource, damageAmount, false);
    }

    public float applyItemBlocking(WorldServer level, DamageSource damageSource, float damageAmount, boolean dryRun) {
        if (damageAmount <= 0.0f) {
            return 0.0f;
        }
        ItemStack itemBlockingWith = this.fW();
        if (itemBlockingWith == null) {
            return 0.0f;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.a(DataComponents.I);
        if (blocksAttacks != null) {
            if (!blocksAttacks.f().map(damageSource::a).orElse(false).booleanValue()) {
                double acos;
                EntityArrow abstractArrow;
                Entity entity = damageSource.c();
                if (entity instanceof EntityArrow && (abstractArrow = (EntityArrow)entity).s() > 0) {
                    return 0.0f;
                }
                Vec3D sourcePosition = damageSource.i();
                if (sourcePosition != null) {
                    Vec3D vec3 = this.c(0.0f, this.cN());
                    Vec3D vec31 = sourcePosition.d(this.dD());
                    vec31 = new Vec3D(vec31.g, 0.0, vec31.i).d();
                    acos = Math.acos(vec31.b(vec3));
                } else {
                    acos = 3.1415927410125732;
                }
                float f2 = blocksAttacks.a(damageSource, damageAmount, acos);
                if (!dryRun) {
                    EntityLiving livingEntity;
                    Entity entity2;
                    blocksAttacks.a(this.an(), itemBlockingWith, this, this.fP(), f2);
                    if (f2 > 0.0f && !damageSource.a(DamageTypeTags.j) && (entity2 = damageSource.c()) instanceof EntityLiving && (livingEntity = (EntityLiving)entity2).g(this) <= MathHelper.l(200.0)) {
                        this.a(level, livingEntity);
                    }
                }
                return f2;
            }
        }
        return 0.0f;
    }

    public boolean canBlockAttack(DamageSource damageSource, float damageAmount) {
        if (damageAmount <= 0.0f) {
            return false;
        }
        ItemStack itemBlockingWith = this.fW();
        if (itemBlockingWith == null) {
            return false;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.a(DataComponents.I);
        if (blocksAttacks != null) {
            if (!blocksAttacks.f().map(damageSource::a).orElse(false).booleanValue()) {
                EntityArrow abstractArrow;
                Entity entity = damageSource.c();
                return !(entity instanceof EntityArrow) || (abstractArrow = (EntityArrow)entity).s() <= 0;
            }
        }
        return false;
    }

    public float resolveBlockedDamage(DamageSource damageSource, float damageAmount) {
        double acos;
        Vec3D sourcePosition = damageSource.i();
        if (sourcePosition != null) {
            Vec3D vec3 = this.c(0.0f, this.cN());
            Vec3D vec31 = sourcePosition.d(this.dD());
            vec31 = new Vec3D(vec31.g, 0.0, vec31.i).d();
            acos = Math.acos(vec31.b(vec3));
        } else {
            acos = 3.1415927410125732;
        }
        BlocksAttacks blocksAttacks = this.fW().a(DataComponents.I);
        return blocksAttacks.a(damageSource, damageAmount, acos);
    }

    public void blockingItemEffects(WorldServer level, DamageSource damageSource, float f2) {
        EntityLiving livingEntity;
        Entity entity;
        ItemStack itemBlockingWith = this.fW();
        if (itemBlockingWith == null) {
            return;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.a(DataComponents.I);
        if (blocksAttacks == null) {
            return;
        }
        blocksAttacks.a(this.an(), itemBlockingWith, this, this.fP(), f2);
        if (f2 > 0.0f && !damageSource.a(DamageTypeTags.j) && (entity = damageSource.c()) instanceof EntityLiving && (livingEntity = (EntityLiving)entity).g(this) <= MathHelper.l(200.0)) {
            this.a(level, livingEntity);
        }
    }

    public void i(DamageSource damageSource) {
        if (damageSource.a(DamageTypes.P)) {
            SoundCategory soundSource = this instanceof EntityHuman ? SoundCategory.h : SoundCategory.f;
            this.an().a(null, this.dD().g, this.dD().h, this.dD().i, SoundEffects.BQ, soundSource);
        }
    }

    protected void f(DamageSource damageSource) {
        Entity entity = damageSource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            if (!(damageSource.a(DamageTypeTags.q) || damageSource.a(DamageTypes.I) && this.ax().a(TagsEntity.E))) {
                this.a(livingEntity);
            }
        }
    }

    @Nullable
    protected EntityHuman g(DamageSource damageSource) {
        EntityWolf wolf;
        Entity entity = damageSource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            this.a(player, this.an().purpurConfig.mobLastHurtByPlayerTime);
        } else if (entity instanceof EntityWolf && (wolf = (EntityWolf)entity).m()) {
            if (wolf.d() != null) {
                this.a(wolf.d().c(), this.an().purpurConfig.mobLastHurtByPlayerTime);
            } else {
                this.bG = null;
                this.bH = 0;
            }
        }
        return EntityReference.c(this.bG, this.an());
    }

    private float computeAmountFromEntityDamageEvent(EntityDamageEvent event) {
        float amount = 0.0f;
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        return amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
    }

    protected void a(WorldServer level, EntityLiving entity) {
        entity.d(this);
    }

    protected void d(EntityLiving entity) {
        entity.knockback(0.5, entity.dK() - this.dK(), entity.dQ() - this.dQ(), this, EntityKnockbackEvent.Cause.SHIELD_BLOCK);
    }

    private boolean j(DamageSource damageSource) {
        Object object;
        if (damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemStack = null;
        DeathProtection deathProtection = null;
        EnumHand hand = null;
        ItemStack itemInHand = ItemStack.l;
        for (EnumHand interactionHand : EnumHand.values()) {
            itemInHand = this.b(interactionHand);
            deathProtection = itemInHand.a(DataComponents.H);
            if (deathProtection == null) continue;
            hand = interactionHand;
            itemStack = itemInHand.v();
            break;
        }
        if (this.an().purpurConfig.totemOfUndyingWorksInInventory && (object = this) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)object;
            if ((itemStack == null || itemStack.h() != Items.xD) && player.getBukkitEntity().hasPermission("purpur.inventory_totem")) {
                for (ItemStack item : player.gB().j()) {
                    if (item.h() != Items.xD) continue;
                    itemInHand = item;
                    itemStack = item.v();
                    break;
                }
            }
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemStack == null);
        this.an().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            deathProtection = null;
        } else {
            EntityLiving entityLiving;
            if (!itemInHand.f() && itemStack != null) {
                itemInHand.h(1);
            }
            if (deathProtection == null) {
                deathProtection = DeathProtection.c;
            }
            if (itemStack != null && (entityLiving = this) instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                serverPlayer.b(StatisticList.c.b(itemStack.h()));
                CriterionTriggers.C.a(serverPlayer, itemStack);
                this.c(GameEvent.C);
            }
            this.x(1.0f);
            deathProtection.a(itemStack, this);
            this.an().a((Entity)this, (byte)35);
        }
        return deathProtection != null;
    }

    @Nullable
    public DamageSource eW() {
        if (this.an().ag() - this.cz > 40L) {
            this.cy = null;
        }
        return this.cy;
    }

    protected void h(DamageSource damageSource) {
        this.b(this.e(damageSource));
    }

    public void b(@Nullable SoundEffect sound) {
        if (sound != null) {
            this.a(sound, this.ft(), this.fu());
        }
    }

    private void g(ItemStack stack) {
        if (!stack.f()) {
            Holder<SoundEffect> holder = stack.a(DataComponents.au);
            if (holder != null && !this.bm()) {
                this.an().a(this.dK(), this.dM(), this.dQ(), holder.a(), this.dw(), 0.8f, 0.8f + this.an().z.i() * 0.4f, false);
            }
            this.b(stack, 5);
        }
    }

    public void a(DamageSource damageSource) {
        if (!this.ec() && !this.bI) {
            Entity entity = damageSource.d();
            EntityLiving killCredit = this.fi();
            this.bI = true;
            net.minecraft.world.level.World world = this.an();
            if (world instanceof WorldServer) {
                EntityDeathEvent deathEvent;
                WorldServer serverLevel = (WorldServer)world;
                if (entity instanceof EntityCreeper) {
                    EntityCreeper creeper = (EntityCreeper)entity;
                    creeper.a((WorldServer)this.an(), this, damageSource);
                }
                if ((deathEvent = this.dropAllDeathLoot(serverLevel, damageSource)) == null || !deathEvent.isCancelled()) {
                    if (this instanceof EntityInsentient) {
                        for (EnumItemSlot slot : this.clearedEquipmentSlots) {
                            this.a(slot, ItemStack.l);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.gg()) {
                        this.gh();
                    }
                    if (!this.an().D_() && this.k_() && SpigotConfig.logNamedDeaths) {
                        a.info("Named entity {} died: {}", (Object)this, (Object)this.fh().a().getString());
                    }
                    this.fh().c();
                    if (entity != null) {
                        entity.a((WorldServer)this.an(), this, damageSource);
                    }
                    this.c(GameEvent.p);
                } else {
                    this.bI = false;
                    this.x((float)deathEvent.getReviveHealth());
                    if (entity instanceof EntityCreeper) {
                        EntityCreeper creeper = (EntityCreeper)entity;
                        if (creeper.cy) {
                            creeper.cy = false;
                        }
                    }
                }
                this.e(killCredit);
            }
            if (this.bI) {
                this.an().a((Entity)this, (byte)3);
                this.c(EntityPose.h);
            }
        }
    }

    protected void e(@Nullable EntityLiving entitySource) {
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            boolean var6 = false;
            if (this.bI && entitySource instanceof EntityWither) {
                if (serverLevel.S().getBoolean(GameRules.d, serverLevel.purpurConfig.witherMobGriefingOverride)) {
                    BlockPosition blockPos = this.dF();
                    IBlockData blockState = Blocks.cn.m();
                    if (this.an().a_(blockPos).l() && blockState.a((IWorldReader)this.an(), blockPos)) {
                        var6 = CraftEventFactory.handleBlockFormEvent(this.an(), blockPos, blockState, 3, this);
                    }
                }
                if (!var6) {
                    EntityItem itemEntity = new EntityItem(this.an(), this.dK(), this.dM(), this.dQ(), new ItemStack(Items.dJ));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
                    if (!event.callEvent()) {
                        return;
                    }
                    this.an().b(itemEntity);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(WorldServer level, DamageSource damageSource) {
        boolean flag = this.bH > 0;
        this.g(level);
        if (!(!this.e(level) || damageSource.a(DamageTypes.h) && this.an().purpurConfig.disableDropsOnCrammingDeath)) {
            this.b(level, damageSource, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.a(level, damageSource, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, damageSource, this.drops, () -> {
            EntityLiving killer = this.fi();
            if (killer != null) {
                killer.a((Entity)this, damageSource);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList<Entity.DefaultDrop>();
        this.b(level, damageSource.d());
        return deathEvent;
    }

    protected void g(WorldServer level) {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward(WorldServer level, @Nullable Entity entity) {
        if (!this.eZ() && (this.eE() || this.bH > 0 && this.eD() && level.S().c(GameRules.g))) {
            return this.a(level, entity);
        }
        return 0;
    }

    protected void b(WorldServer level, @Nullable Entity entity) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.awardWithDirection(level, this.dD(), Vec3D.c, this.expToDrop, this instanceof EntityPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, entity, this);
            this.expToDrop = 0;
        }
    }

    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
    }

    public long eX() {
        return 0L;
    }

    protected float b(Entity attacker, DamageSource damageSource) {
        float f2;
        float f3 = (float)this.i(GenericAttributes.d);
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            f2 = EnchantmentManager.d(serverLevel, this.el(), attacker, damageSource, f3);
        } else {
            f2 = f3;
        }
        return f2;
    }

    protected void b(WorldServer level, DamageSource damageSource, boolean playerKill) {
        Optional<ResourceKey<LootTable>> lootTable = this.em();
        if (!lootTable.isEmpty()) {
            this.a(level, damageSource, playerKill, lootTable.get());
        }
    }

    public void a(WorldServer level, DamageSource damageSource, boolean playerKill, ResourceKey<LootTable> lootTable) {
        this.a(level, damageSource, playerKill, lootTable, (ItemStack itemStack) -> this.a(level, (ItemStack)itemStack));
    }

    public void a(WorldServer level, DamageSource damageSource, boolean playerKill, ResourceKey<LootTable> lootTable, Consumer<ItemStack> dropConsumer) {
        LootTable lootTable1 = level.q().bi().a(lootTable);
        LootParams.a builder = new LootParams.a(level).a(LootContextParameters.a, this).a(LootContextParameters.h, this.dD()).a(LootContextParameters.e, damageSource).b(LootContextParameters.f, damageSource.d()).b(LootContextParameters.g, damageSource.c());
        EntityHuman lastHurtByPlayer = this.eG();
        if (playerKill && lastHurtByPlayer != null) {
            builder = builder.a(LootContextParameters.d, lastHurtByPlayer).a(lastHurtByPlayer.ew());
        }
        LootParams lootParams = builder.a(LootContextParameterSets.g);
        lootTable1.a(lootParams, this.eX(), dropConsumer);
    }

    public boolean a(WorldServer level, ResourceKey<LootTable> lootTable, @Nullable Entity entity, ItemStack tool, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        return this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.c, this).b(LootContextParameters.b, entity).a(LootContextParameters.k, tool).a(LootContextParameterSets.t), dropConsumer);
    }

    public boolean a(WorldServer level, ResourceKey<LootTable> lootTable, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        return this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.h, this.dD()).a(LootContextParameters.a, this).a(LootContextParameterSets.j), dropConsumer);
    }

    protected void a(WorldServer level, ResourceKey<LootTable> lootTable, ItemStack shears, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.h, this.dD()).a(LootContextParameters.a, this).a(LootContextParameters.k, shears).a(LootContextParameterSets.s), dropConsumer);
    }

    protected boolean a(WorldServer level, ResourceKey<LootTable> lootTable, Function<LootParams.a, LootParams> paramsBuilder, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        LootParams lootParams;
        LootTable lootTable1 = level.q().bi().a(lootTable);
        ObjectArrayList<ItemStack> randomItems = lootTable1.a(lootParams = paramsBuilder.apply(new LootParams.a(level)));
        if (!randomItems.isEmpty()) {
            randomItems.forEach(itemStack -> dropConsumer.accept(level, (ItemStack)itemStack));
            return true;
        }
        return false;
    }

    public void o(double strength, double x2, double z2) {
        this.knockback(strength, x2, z2, null, EntityKnockbackEvent.Cause.UNKNOWN);
    }

    public void knockback(double strength, double x2, double z2, @Nullable Entity attacker, EntityKnockbackEvent.Cause eventCause) {
        strength *= 1.0 - this.i(GenericAttributes.q);
        Vec3D deltaMovement = this.dI();
        while (x2 * x2 + z2 * z2 < (double)1.0E-5f) {
            x2 = (Math.random() - Math.random()) * 0.01;
            z2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3D vec3 = new Vec3D(x2, 0.0, z2).d().c(strength);
        Vec3D finalVelocity = new Vec3D(deltaMovement.g / 2.0 - vec3.g, this.aS() ? Math.min(0.4, deltaMovement.h / 2.0 + strength) : deltaMovement.h, deltaMovement.i / 2.0 - vec3.i);
        Vec3D diff = finalVelocity.d(deltaMovement);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, attacker, eventCause, strength, diff);
        if (event.isCancelled()) {
            return;
        }
        this.aF = true;
        this.k(deltaMovement.b(event.getKnockback().getX(), event.getKnockback().getY(), event.getKnockback().getZ()));
    }

    public void a(double xDistance, double zDistance) {
    }

    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ly;
    }

    @Nullable
    public SoundEffect f_() {
        return SoundEffects.lt;
    }

    public SoundEffect q(int height) {
        return height > 4 ? this.fc().b() : this.fc().a();
    }

    public void eY() {
        this.cC = true;
    }

    public boolean eZ() {
        return this.cC;
    }

    public float fa() {
        return 0.0f;
    }

    protected AxisAlignedBB fb() {
        AxisAlignedBB boundingBox = this.de();
        Entity vehicle = this.du();
        if (vehicle != null) {
            Vec3D passengerRidingPosition = vehicle.n(this);
            return boundingBox.b(Math.max(passengerRidingPosition.h, boundingBox.b));
        }
        return boundingBox;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> c(EnumItemSlot slot) {
        return (Map)this.cD.computeIfAbsent(slot, equipmentSlot -> new Reference2ObjectArrayMap());
    }

    public a fc() {
        return new a(SoundEffects.lz, SoundEffects.lr);
    }

    public Optional<BlockPosition> fd() {
        return this.cx;
    }

    public boolean fe() {
        if (this.at()) {
            return false;
        }
        BlockPosition blockPos = this.dF();
        IBlockData inBlockState = this.dG();
        if (inBlockState.a(TagsBlock.bd)) {
            this.cx = Optional.of(blockPos);
            return true;
        }
        if (inBlockState.b() instanceof BlockTrapdoor && this.c(blockPos, inBlockState)) {
            this.cx = Optional.of(blockPos);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition pos, IBlockData state) {
        if (!state.c(BlockTrapdoor.b).booleanValue()) {
            return false;
        }
        IBlockData blockState = this.an().a_(pos.e());
        return blockState.a(Blocks.dm) && blockState.c(BlockLadder.b) == state.c(BlockFacingHorizontal.f);
    }

    @Override
    public boolean bX() {
        return !this.ec() && this.eU() > 0.0f && !this.bI;
    }

    public boolean a(EntityLiving entity, double tolerance, boolean scaleByDistance, boolean visual, double ... yValues) {
        Vec3D vec3 = entity.h(1.0f).d();
        for (double d2 : yValues) {
            Vec3D vec31 = new Vec3D(this.dK() - entity.dK(), d2 - entity.dO(), this.dQ() - entity.dQ());
            double len = vec31.g();
            vec31 = vec31.d();
            double d1 = vec3.b(vec31);
            double d3 = scaleByDistance ? len : 1.0;
            if (!(d1 > 1.0 - tolerance / d3) || !entity.a(this, visual ? RayTrace.BlockCollisionOption.c : RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, d2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cR() {
        return this.y(0.0f);
    }

    protected final int y(float distanceOffset) {
        return MathHelper.d(distanceOffset + 3.0f);
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        int i2 = this.a(fallDistance, damageMultiplier);
        if (i2 > 0) {
            if (!this.a((WorldServer)this.an(), damageSource, (float)i2)) {
                return true;
            }
            this.a(this.q(i2), 1.0f, 1.0f);
            this.ff();
            return true;
        }
        return flag;
    }

    protected int a(double fallDistance, float damageMultiplier) {
        if (this.ax().a(TagsEntity.o)) {
            return 0;
        }
        double d2 = this.i(fallDistance);
        return MathHelper.a(d2 * (double)damageMultiplier * this.i(GenericAttributes.l));
    }

    private double i(double fallDistance) {
        return fallDistance + 1.0E-6 - this.i(GenericAttributes.y);
    }

    protected void ff() {
        if (!this.bm()) {
            int floor = MathHelper.a(this.dK());
            int floor1 = MathHelper.a(this.dM() - (double)0.2f);
            int floor2 = MathHelper.a(this.dQ());
            IBlockData blockState = this.an().a_(new BlockPosition(floor, floor1, floor2));
            if (!blockState.l()) {
                SoundEffectType soundType = blockState.A();
                this.a(soundType.g(), soundType.a() * 0.5f, soundType.b() * 0.75f);
            }
        }
    }

    @Override
    public void q(float yaw) {
        this.bt = this.bu = 10;
    }

    public int fg() {
        return MathHelper.a(this.i(GenericAttributes.a));
    }

    protected void c(DamageSource damageSource, float damageAmount) {
    }

    protected void d(DamageSource damageSource, float damageAmount) {
    }

    protected void a(DamageSource damageSource, float damageAmount, EnumItemSlot ... slots) {
        if (!(damageAmount <= 0.0f)) {
            int i2 = (int)Math.max(1.0f, damageAmount / 4.0f);
            for (EnumItemSlot equipmentSlot : slots) {
                ItemStack itemBySlot = this.a(equipmentSlot);
                Equippable equippable = itemBySlot.a(DataComponents.D);
                if (equippable == null || !equippable.i() || !itemBySlot.m() || !itemBySlot.a(damageSource)) continue;
                itemBySlot.a(i2, this, equipmentSlot);
            }
        }
    }

    protected float e(DamageSource damageSource, float damageAmount) {
        if (!damageSource.a(DamageTypeTags.b)) {
            damageAmount = CombatMath.a(this, damageAmount, damageSource, this.fg(), (float)this.i(GenericAttributes.b));
        }
        return damageAmount;
    }

    protected float f(DamageSource damageSource, float damageAmount) {
        float damageProtection;
        if (damageSource.a(DamageTypeTags.f)) {
            return damageAmount;
        }
        if (damageAmount <= 0.0f) {
            return 0.0f;
        }
        if (damageSource.a(DamageTypeTags.h)) {
            return damageAmount;
        }
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            damageProtection = EnchantmentManager.b(serverLevel, this, damageSource);
        } else {
            damageProtection = 0.0f;
        }
        if (damageProtection > 0.0f) {
            damageAmount = CombatMath.a(damageAmount, damageProtection);
        }
        return damageAmount;
    }

    private EntityDamageEvent handleEntityDamage(DamageSource damagesource, float amount, float invulnerabilityRelatedLastDamage) {
        float originalDamage = amount;
        com.google.common.base.Function invulnerabilityReductionEquation = mod -> {
            if (invulnerabilityRelatedLastDamage == 0.0f) {
                return 0.0;
            }
            if (mod.floatValue() < invulnerabilityRelatedLastDamage) {
                return 0.0;
            }
            return -invulnerabilityRelatedLastDamage;
        };
        float originalInvulnerabilityReduction = ((Double)invulnerabilityReductionEquation.apply((Object)amount)).floatValue();
        com.google.common.base.Function freezing = mod -> {
            if (damagesource.a(DamageTypeTags.o) && this.ax().a(TagsEntity.l)) {
                return -(mod - mod * 5.0);
            }
            return -0.0;
        };
        float freezingModifier = ((Double)freezing.apply((Object)(amount += originalInvulnerabilityReduction))).floatValue();
        com.google.common.base.Function hardHat = mod -> {
            if (damagesource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                return -(mod - mod * 0.75);
            }
            return -0.0;
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(amount += freezingModifier))).floatValue();
        com.google.common.base.Function blocking = mod -> {
            if (!this.canBlockAttack(damagesource, mod.floatValue())) {
                return 0.0;
            }
            return -this.resolveBlockedDamage(damagesource, mod.floatValue());
        };
        float blockingModifier = ((Double)blocking.apply((Object)(amount += hardHatModifier))).floatValue();
        com.google.common.base.Function armor = mod -> -(mod - (double)this.e(damagesource, mod.floatValue()));
        float armorModifier = ((Double)armor.apply((Object)(amount += blockingModifier))).floatValue();
        com.google.common.base.Function resistance = mod -> {
            if (!damagesource.a(DamageTypeTags.f) && this.d(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                int i2 = (this.e(MobEffects.k).e() + 1) * 5;
                int j2 = 25 - i2;
                float f1 = mod.floatValue() * (float)j2;
                return -(mod - (double)Math.max(f1 / 25.0f, 0.0f));
            }
            return -0.0;
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(amount += armorModifier))).floatValue();
        com.google.common.base.Function magic = mod -> -(mod - (double)this.f(damagesource, mod.floatValue()));
        float magicModifier = ((Double)magic.apply((Object)(amount += resistanceModifier))).floatValue();
        com.google.common.base.Function absorption = mod -> -Math.max(mod - Math.max(mod - (double)this.fM(), 0.0), 0.0);
        float absorptionModifier = ((Double)absorption.apply((Object)(amount += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, (com.google.common.base.Function<Double, Double>)freezing, (com.google.common.base.Function<Double, Double>)hardHat, (com.google.common.base.Function<Double, Double>)blocking, (com.google.common.base.Function<Double, Double>)armor, (com.google.common.base.Function<Double, Double>)resistance, (com.google.common.base.Function<Double, Double>)magic, (com.google.common.base.Function<Double, Double>)absorption, (damageModifierDoubleMap, damageModifierFunctionMap) -> {
            damageModifierFunctionMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, invulnerabilityReductionEquation);
            damageModifierDoubleMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, Double.valueOf(originalInvulnerabilityReduction));
        });
    }

    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.a(level, damageSource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damageSource.d() instanceof EntityHuman) {
                if (damageSource.d() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)damageSource.d();
                    if (new PlayerAttackEntityCooldownResetEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.G(0.0f)).callEvent()) {
                        player.gV();
                    }
                } else {
                    ((EntityHuman)damageSource.d()).gV();
                }
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.N, Math.round(f3 * 10.0f));
                } else if (damageSource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damageSource.d()).a(StatisticList.J, Math.round(f3 * 10.0f));
                }
            }
            if (damageSource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                float helmetDamage = (float)event.getDamage();
                helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION);
                helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
                this.d(damageSource, helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING));
            }
            if (!damageSource.a(DamageTypeTags.b)) {
                float armorDamage = (float)event.getDamage();
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION);
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
                this.c(damageSource, armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.blockingItemEffects(level, damageSource, (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.E(Math.max(this.fM() - absorptionModifier, 0.0f));
            float f1 = absorptionModifier;
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = this) instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                player.a(StatisticList.M, Math.round(f1 * 10.0f));
            }
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = damageSource.d()) instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                serverPlayer.a(StatisticList.I, Math.round(f1 * 10.0f));
            }
            if (amount > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damageSource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (amount < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.K, Math.round(amount * 10.0f));
                    }
                }
                this.fh().a(damageSource, amount);
                this.x(this.eU() - amount);
                if (!human) {
                    this.E(this.fM() - amount);
                }
                this.c(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damageSource, originalDamage, amount, true);
                    f1 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f1 > 0.0f && f1 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.L, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damageSource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damageSource.d(), this, damageSource, originalDamage, amount, true);
                }
                return !GlobalConfiguration.get().unsupportedSettings.skipVanillaDamageTickWhenShieldBlocked;
            }
            return true;
        }
        return true;
    }

    public CombatTracker fh() {
        return this.ck;
    }

    @Nullable
    public EntityLiving fi() {
        if (this.bG != null) {
            return this.bG.a(this.an(), EntityHuman.class);
        }
        return this.cp != null ? this.cp.a(this.an(), EntityLiving.class) : null;
    }

    public final float fj() {
        return (float)this.i(GenericAttributes.t);
    }

    public final float fk() {
        return (float)this.i(GenericAttributes.s);
    }

    public final int fl() {
        return this.az.a(ce);
    }

    public final void o(int count) {
        this.setArrowCount(count, false);
    }

    public final void setArrowCount(int count, boolean reset) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.fl(), count, reset);
        if (event.isCancelled()) {
            return;
        }
        this.az.a(ce, event.getNewAmount());
    }

    public final int fm() {
        return this.az.a(cf);
    }

    public final void p(int stingerCount) {
        this.az.a(cf, stingerCount);
    }

    private int I() {
        if (MobEffectUtil.a(this)) {
            return 6 - (1 + MobEffectUtil.b(this));
        }
        return this.d(MobEffects.d) ? 6 + (1 + this.e(MobEffects.d).e()) * 2 : 6;
    }

    public void a(EnumHand hand) {
        this.a(hand, false);
    }

    public void a(EnumHand hand, boolean updateSelf) {
        if (!this.bo || this.bq >= this.I() / 2 || this.bq < 0) {
            this.bq = -1;
            this.bo = true;
            this.bp = hand;
            if (this.an() instanceof WorldServer) {
                PacketPlayOutAnimation clientboundAnimatePacket = new PacketPlayOutAnimation(this, hand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkSource = ((WorldServer)this.an()).n();
                if (updateSelf) {
                    chunkSource.a(this, clientboundAnimatePacket);
                } else {
                    chunkSource.b(this, clientboundAnimatePacket);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damageSource) {
        this.bz.a(1.5f);
        this.ax = 20;
        this.bt = this.bu = 10;
        SoundEffect hurtSound = this.e(damageSource);
        if (hurtSound != null) {
            this.a(hurtSound, this.ft(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
        }
        this.cy = damageSource;
        this.cz = this.an().ag();
    }

    @Override
    public void b(byte id) {
        switch (id) {
            case 3: {
                SoundEffect deathSound = this.f_();
                if (deathSound != null) {
                    this.a(deathSound, this.ft(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.x(0.0f);
                this.a(this.ei().p());
                break;
            }
            case 46: {
                int i2 = 128;
                for (int i1 = 0; i1 < 128; ++i1) {
                    double d2 = (double)i1 / 127.0;
                    float f2 = (this.as.i() - 0.5f) * 0.2f;
                    float f1 = (this.as.i() - 0.5f) * 0.2f;
                    float f22 = (this.as.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d2, this.Y, this.dK()) + (this.as.j() - 0.5) * (double)this.dA() * 2.0;
                    double d22 = MathHelper.d(d2, this.Z, this.dM()) + this.as.j() * (double)this.dB();
                    double d3 = MathHelper.d(d2, this.aa, this.dQ()) + (this.as.j() - 0.5) * (double)this.dA() * 2.0;
                    this.an().a(Particles.ag, d1, d22, d3, (double)f2, (double)f1, f22);
                }
                break;
            }
            case 47: {
                this.g(this.a(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.g(this.a(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.g(this.a(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.g(this.a(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.g(this.a(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.g(this.a(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.K();
                break;
            }
            case 60: {
                this.fn();
                break;
            }
            case 65: {
                this.g(this.a(EnumItemSlot.g));
                break;
            }
            case 67: {
                this.J();
                break;
            }
            case 68: {
                this.g(this.a(EnumItemSlot.h));
                break;
            }
            default: {
                super.b(id);
            }
        }
    }

    public void fn() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d22 = this.as.k() * 0.02;
            double d3 = 10.0;
            this.an().a(Particles.af, this.e(1.0) - d2 * 10.0, this.dN() - d1 * 10.0, this.h(1.0) - d22 * 10.0, d2, d1, d22);
        }
    }

    private void J() {
        Vec3D deltaMovement = this.dI();
        for (int i2 = 0; i2 < 8; ++i2) {
            double d2 = this.as.a(0.0, 1.0);
            double d1 = this.as.a(0.0, 1.0);
            double d22 = this.as.a(0.0, 1.0);
            this.an().a(Particles.d, this.dK() + d2, this.dM() + d1, this.dQ() + d22, deltaMovement.g, deltaMovement.h, deltaMovement.i);
        }
    }

    private void K() {
        ItemStack itemBySlot = this.a(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.a(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemBySlot);
    }

    @Override
    protected void aR() {
        this.a(this.ei().o(), this.an().getWorld().getVoidDamageAmount());
    }

    protected void fo() {
        int currentSwingDuration = this.I();
        if (this.bo) {
            ++this.bq;
            if (this.bq >= currentSwingDuration) {
                this.bq = 0;
                this.bo = false;
            }
        } else {
            this.bq = 0;
        }
        this.bx = (float)this.bq / (float)currentSwingDuration;
    }

    @Nullable
    public AttributeModifiable h(Holder<AttributeBase> attribute) {
        return this.fp().a(attribute);
    }

    public double i(Holder<AttributeBase> attribute) {
        return this.fp().c(attribute);
    }

    public double j(Holder<AttributeBase> attribute) {
        return this.fp().d(attribute);
    }

    public AttributeMapBase fp() {
        return this.cj;
    }

    public ItemStack fq() {
        return this.a(EnumItemSlot.a);
    }

    public ItemStack fr() {
        return this.a(EnumItemSlot.b);
    }

    public ItemStack b(EnumMainHand arm) {
        return this.as() == arm ? this.fq() : this.fr();
    }

    @Override
    @Nonnull
    public ItemStack el() {
        return this.fq();
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemStack) -> itemStack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.fq()) || predicate.test(this.fr());
    }

    public ItemStack b(EnumHand hand) {
        if (hand == EnumHand.a) {
            return this.a(EnumItemSlot.a);
        }
        if (hand == EnumHand.b) {
            return this.a(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
    }

    public void a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.a) {
            this.a(EnumItemSlot.a, stack);
        } else {
            if (hand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
            }
            this.a(EnumItemSlot.b, stack);
        }
    }

    public boolean d(EnumItemSlot slot) {
        return !this.a(slot).f();
    }

    public boolean e(EnumItemSlot slot) {
        return true;
    }

    public ItemStack a(EnumItemSlot slot) {
        return this.bZ.a(slot);
    }

    public void a(EnumItemSlot slot, ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    public void setItemSlot(EnumItemSlot slot, ItemStack stack, boolean silent) {
        this.onEquipItem(slot, this.bZ.a(slot, stack), stack, silent);
    }

    public float fs() {
        int i2 = 0;
        int i1 = 0;
        for (EnumItemSlot equipmentSlot : EquipmentSlotGroup.i) {
            if (equipmentSlot.a() != EnumItemSlot.Function.b) continue;
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (!itemBySlot.f()) {
                ++i1;
            }
            ++i2;
        }
        return i2 > 0 ? (float)i1 / (float)i2 : 0.0f;
    }

    @Override
    public void i(boolean sprinting) {
        super.i(sprinting);
        AttributeModifiable attribute = this.h(GenericAttributes.w);
        attribute.c(e.a());
        if (sprinting) {
            attribute.b(e);
        }
    }

    public float ft() {
        return 1.0f;
    }

    public float fu() {
        return this.g_() ? (this.as.i() - this.as.i()) * 0.2f + 1.5f : (this.as.i() - this.as.i()) * 0.2f + 1.0f;
    }

    protected boolean fv() {
        return this.eV();
    }

    @Override
    public void h(Entity entity) {
        if (!this.gg()) {
            super.h(entity);
        }
    }

    private void G(Entity vehicle) {
        Vec3D vec3;
        if (this.ec()) {
            vec3 = this.dD();
        } else if (!vehicle.ec() && !this.an().a_(vehicle.dF()).a(TagsBlock.aX)) {
            vec3 = vehicle.b(this);
        } else {
            boolean flag;
            double max = Math.max(this.dM(), vehicle.dM());
            vec3 = new Vec3D(this.dK(), max, this.dQ());
            boolean bl = flag = this.dA() <= 4.0f && this.dB() <= 4.0f;
            if (flag) {
                double d2 = (double)this.dB() / 2.0;
                Vec3D vec31 = vec3.b(0.0, d2, 0.0);
                VoxelShape voxelShape = VoxelShapes.a(AxisAlignedBB.a(vec31, this.dA(), this.dB(), this.dA()));
                vec3 = this.an().a((Entity)this, voxelShape, vec31, (double)this.dA(), (double)this.dB(), (double)this.dA()).map(vec32 -> vec32.b(0.0, -d2, 0.0)).orElse(vec3);
            }
        }
        this.l(vec3.g, vec3.h, vec3.i);
    }

    @Override
    public boolean cZ() {
        return this.cY();
    }

    protected float fw() {
        return this.z(1.0f);
    }

    protected float z(float multiplier) {
        return (float)this.i(GenericAttributes.p) * multiplier * this.bd() + this.fx();
    }

    public float fx() {
        return this.d(MobEffects.h) ? 0.1f * ((float)this.e(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void u() {
        float jumpPower = this.fw();
        if (!(jumpPower <= 1.0E-5f)) {
            Vec3D deltaMovement = this.dI();
            long time = System.nanoTime();
            boolean canCrit = true;
            if (this instanceof EntityHuman) {
                canCrit = false;
                if (time - this.lastJumpTime > 250000000L) {
                    this.lastJumpTime = time;
                    canCrit = true;
                }
            }
            this.m(deltaMovement.g, Math.max((double)jumpPower, deltaMovement.h), deltaMovement.i);
            if (this.cv()) {
                float f2 = this.dX() * ((float)Math.PI / 180);
                if (canCrit) {
                    this.l(new Vec3D((double)(-MathHelper.a(f2)) * 0.2, 0.0, (double)MathHelper.b(f2) * 0.2));
                }
            }
            this.aF = true;
        }
    }

    protected void fy() {
        this.k(this.dI().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> fluidTag) {
        this.k(this.dI().b(0.0, 0.04f, 0.0));
    }

    protected float fz() {
        return 0.8f;
    }

    public boolean a(Fluid fluidState) {
        return false;
    }

    @Override
    protected double bo() {
        return this.i(GenericAttributes.o);
    }

    protected double fA() {
        boolean flag = this.dI().h <= 0.0;
        return flag && this.d(MobEffects.B) ? Math.min(this.bp(), 0.01) : this.bp();
    }

    public void m(Vec3D travelVector) {
        Fluid fluidState = this.an().b_(this.dF());
        if ((this.bu() || this.bJ()) && this.eB() && !this.a(fluidState)) {
            this.o(travelVector);
        } else if (this.fY()) {
            this.p(travelVector);
        } else {
            this.a(travelVector);
        }
    }

    protected void a(Vec3D relative, float amount) {
        this.a(relative, 0.02f, 0.02f, amount);
    }

    protected void a(Vec3D relative, float inWaterAmount, float inLavaAmount, float amount) {
        if (this.bu()) {
            this.a(inWaterAmount, relative);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c((double)0.8f));
        } else if (this.bJ()) {
            this.a(inLavaAmount, relative);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c(0.5));
        } else {
            if (this.getRider() != null && this.isControllable()) {
                float friction = 0.91f;
                if (this.aS()) {
                    friction = this.an().a_(this.bb()).b().g() * 0.91f;
                }
                float frictionCompensation = 0.16277137f / (friction * friction * friction);
                this.a(this.aS() ? 0.1f * frictionCompensation : 0.02f, relative);
                this.a(EnumMoveType.a, this.dI());
                this.k(this.dI().c((double)friction));
                return;
            }
            this.a(amount, relative);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c((double)0.91f));
        }
    }

    private void a(Vec3D travelVector) {
        BlockPosition blockPosBelowThatAffectsMyMovement = this.bb();
        float f2 = this.aS() ? this.an().a_(blockPosBelowThatAffectsMyMovement).b().g() : 1.0f;
        float f1 = f2 * 0.91f;
        Vec3D vec3 = this.b(travelVector, f2);
        double d2 = vec3.h;
        MobEffect effect = this.e(MobEffects.y);
        d2 = effect != null ? (d2 += (0.05 * (double)(effect.e() + 1) - vec3.h) * 0.2) : (!this.an().D_() || this.an().D(blockPosBelowThatAffectsMyMovement) ? (d2 -= this.fA()) : (this.dM() > (double)this.an().M_() ? -0.1 : 0.0));
        if (this.eL()) {
            this.m(vec3.g, d2, vec3.i);
        } else {
            float f22 = this instanceof EntityBird ? f1 : 0.98f;
            this.m(vec3.g * (double)f1, d2 * (double)f22, vec3.i * (double)f1);
        }
    }

    private void o(Vec3D travelVector) {
        boolean flag = this.dI().h <= 0.0;
        double y2 = this.dM();
        double effectiveGravity = this.fA();
        if (this.bu()) {
            float f2 = this.cv() ? 0.9f : this.fz();
            float f1 = 0.02f;
            float f22 = (float)this.i(GenericAttributes.G);
            if (!this.aS()) {
                f22 *= 0.5f;
            }
            if (f22 > 0.0f) {
                f2 += (0.54600006f - f2) * f22;
                f1 += (this.fD() - f1) * f22;
            }
            if (this.d(MobEffects.D)) {
                f2 = 0.96f;
            }
            this.a(f1, travelVector);
            this.a(EnumMoveType.a, this.dI());
            Vec3D deltaMovement = this.dI();
            if (this.ad && this.fe()) {
                deltaMovement = new Vec3D(deltaMovement.g, 0.2, deltaMovement.i);
            }
            deltaMovement = deltaMovement.d(f2, 0.8f, f2);
            this.k(this.a(effectiveGravity, flag, deltaMovement));
        } else {
            this.a(0.02f, travelVector);
            this.a(EnumMoveType.a, this.dI());
            if (this.b(TagsFluid.b) <= this.dz()) {
                this.k(this.dI().d(0.5, 0.8f, 0.5));
                Vec3D fluidFallingAdjustedMovement = this.a(effectiveGravity, flag, this.dI());
                this.k(fluidFallingAdjustedMovement);
            } else {
                this.k(this.dI().c(0.5));
            }
            if (effectiveGravity != 0.0) {
                this.k(this.dI().b(0.0, -effectiveGravity / 4.0, 0.0));
            }
        }
        Vec3D fluidFallingAdjustedMovement = this.dI();
        if (this.ad && this.f(fluidFallingAdjustedMovement.g, fluidFallingAdjustedMovement.h + (double)0.6f - this.dM() + y2, fluidFallingAdjustedMovement.i)) {
            this.m(fluidFallingAdjustedMovement.g, 0.3f, fluidFallingAdjustedMovement.i);
        }
    }

    private void p(Vec3D travelVector) {
        if (this.fe()) {
            this.a(travelVector);
            this.fB();
        } else {
            Vec3D deltaMovement = this.dI();
            double d2 = deltaMovement.i();
            this.k(this.q(deltaMovement));
            this.a(EnumMoveType.a, this.dI());
            if (!this.an().D_()) {
                double d1 = this.dI().i();
                this.c(d2, d1);
            }
        }
    }

    public void fB() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    private Vec3D q(Vec3D deltaMovement) {
        double d1;
        Vec3D lookAngle = this.cf();
        float f2 = this.dZ() * ((float)Math.PI / 180);
        double squareRoot = Math.sqrt(lookAngle.g * lookAngle.g + lookAngle.i * lookAngle.i);
        double d2 = deltaMovement.i();
        double effectiveGravity = this.fA();
        double squared = MathHelper.l(Math.cos(f2));
        deltaMovement = deltaMovement.b(0.0, effectiveGravity * (-1.0 + squared * 0.75), 0.0);
        if (deltaMovement.h < 0.0 && squareRoot > 0.0) {
            d1 = deltaMovement.h * -0.1 * squared;
            deltaMovement = deltaMovement.b(lookAngle.g * d1 / squareRoot, d1, lookAngle.i * d1 / squareRoot);
        }
        if (f2 < 0.0f && squareRoot > 0.0) {
            d1 = d2 * (double)(-MathHelper.a(f2)) * 0.04;
            deltaMovement = deltaMovement.b(-lookAngle.g * d1 / squareRoot, d1 * 3.2, -lookAngle.i * d1 / squareRoot);
        }
        if (squareRoot > 0.0) {
            deltaMovement = deltaMovement.b((lookAngle.g / squareRoot * d2 - deltaMovement.g) * 0.1, 0.0, (lookAngle.i / squareRoot * d2 - deltaMovement.i) * 0.1);
        }
        return deltaMovement.d(0.99f, 0.98f, 0.99f);
    }

    private void c(double oldSpeed, double newSpeed) {
        double d2;
        float f2;
        if (this.ad && (f2 = (float)((d2 = oldSpeed - newSpeed) * 10.0 - 3.0)) > 0.0f) {
            this.a(this.q((int)f2), 1.0f, 1.0f);
            if (this.an().purpurConfig.elytraKineticDamage) {
                this.a(this.ei().n(), f2);
            }
        }
    }

    private void c(EntityHuman player, Vec3D travelVector) {
        Vec3D riddenInput = this.b(player, travelVector);
        this.a(player, riddenInput);
        if (this.ds()) {
            this.B(this.f(player));
            this.m(riddenInput);
        } else {
            this.k(Vec3D.c);
        }
    }

    protected void a(EntityHuman player, Vec3D travelVector) {
    }

    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return travelVector;
    }

    protected float f(EntityHuman player) {
        return this.fD();
    }

    public void s(boolean includeHeight) {
        float f2 = (float)MathHelper.g(this.dK() - this.Y, includeHeight ? this.dM() - this.Z : 0.0, this.dQ() - this.aa);
        if (!this.cl() && this.bX()) {
            this.A(f2);
        } else {
            this.bz.a();
        }
    }

    protected void A(float partialTick) {
        float min = Math.min(partialTick * 4.0f, 1.0f);
        this.bz.a(min, 0.4f, this.g_() ? 3.0f : 1.0f);
    }

    private Vec3D b(Vec3D deltaMovement, float friction) {
        this.a(this.G(friction), deltaMovement);
        this.k(this.r(this.dI()));
        this.a(EnumMoveType.a, this.dI());
        Vec3D deltaMovement1 = this.dI();
        if ((this.ad || this.bL) && (this.fe() || this.aK && PowderSnowBlock.a(this))) {
            deltaMovement1 = new Vec3D(deltaMovement1.g, 0.2, deltaMovement1.i);
        }
        return deltaMovement1;
    }

    public Vec3D a(double gravity, boolean isFalling, Vec3D deltaMovement) {
        if (gravity != 0.0 && !this.cv()) {
            double d2 = isFalling && Math.abs(deltaMovement.h - 0.005) >= 0.003 && Math.abs(deltaMovement.h - gravity / 16.0) < 0.003 ? -0.003 : deltaMovement.h - gravity / 16.0;
            return new Vec3D(deltaMovement.g, d2, deltaMovement.i);
        }
        return deltaMovement;
    }

    private Vec3D r(Vec3D deltaMovement) {
        if (this.fe()) {
            this.l();
            float f2 = 0.15f;
            double d2 = MathHelper.a(deltaMovement.g, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(deltaMovement.i, (double)-0.15f, (double)0.15f);
            double max = Math.max(deltaMovement.h, (double)-0.15f);
            if (max < 0.0 && !this.dG().a(Blocks.oP) && this.fX() && this instanceof EntityHuman) {
                max = 0.0;
            }
            deltaMovement = new Vec3D(d2, max, d1);
        }
        return deltaMovement;
    }

    private float G(float friction) {
        return this.aS() ? this.fD() * (0.21600002f / (friction * friction * friction)) : this.fC();
    }

    protected float fC() {
        return this.dg() instanceof EntityHuman ? this.fD() * 0.1f : 0.02f;
    }

    public float fD() {
        return this.ct;
    }

    public void B(float speed) {
        this.ct = speed;
    }

    public boolean c(WorldServer level, Entity target) {
        this.C(target);
        return false;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bJ;
    }

    @Override
    public void g() {
        super.g();
        this.P();
        this.Q();
        if (!this.an().D_()) {
            int stingerCount;
            int arrowCount = this.fl();
            if (arrowCount > 0) {
                if (this.br <= 0) {
                    this.br = 20 * (30 - arrowCount);
                }
                --this.br;
                if (this.br <= 0) {
                    this.o(arrowCount - 1);
                }
            }
            if ((stingerCount = this.fm()) > 0) {
                if (this.bs <= 0) {
                    this.bs = 20 * (30 - stingerCount);
                }
                --this.bs;
                if (this.bs <= 0) {
                    this.p(stingerCount - 1);
                }
            }
            this.L();
            if (this.at % 20 == 0) {
                this.fh().c();
            }
            if (!(!this.gg() || this.au() && this.R())) {
                this.gh();
            }
        }
        if (!this.ec()) {
            this.e_();
        }
        double d2 = this.dK() - this.Y;
        double d1 = this.dQ() - this.aa;
        float f2 = (float)(d2 * d2 + d1 * d1);
        float f1 = this.bB;
        if (f2 > 0.0025000002f) {
            float f22 = (float)MathHelper.d(d1, d2) * 57.295776f - 90.0f;
            float abs = MathHelper.e(MathHelper.h(this.dX()) - f22);
            f1 = 95.0f < abs && abs < 265.0f ? f22 - 180.0f : f22;
        }
        if (this.bx > 0.0f) {
            f1 = this.dX();
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("headTurn");
        this.C(f1);
        profilerFiller.c();
        profilerFiller.a("rangeChecks");
        this.ab += (float)Math.round((this.dX() - this.ab) / 360.0f) * 360.0f;
        this.bC += (float)Math.round((this.bB - this.bC) / 360.0f) * 360.0f;
        this.ac += (float)Math.round((this.dZ() - this.ac) / 360.0f) * 360.0f;
        this.bE += (float)Math.round((this.bD - this.bE) / 360.0f) * 360.0f;
        profilerFiller.c();
        this.bU = this.fY() ? ++this.bU : 0;
        if (this.gg()) {
            this.w(0.0f);
        }
        this.H();
        this.bF.a();
    }

    public void L() {
        Map<EnumItemSlot, ItemStack> map = this.N();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> N() {
        ItemStack itemBySlot;
        Map map = null;
        EnumMap equipmentChanges = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.j) {
            ItemStack itemStack = this.cm.get(enumItemSlot);
            if (!this.a(itemStack, itemBySlot = this.a(enumItemSlot))) continue;
            org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemStack);
            org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemBySlot);
            if (this instanceof EntityPlayer && enumItemSlot.a() == EnumItemSlot.Function.b) {
                new PlayerArmorChangeEvent((Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumItemSlot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
                equipmentChanges = Maps.newEnumMap(EquipmentSlot.class);
            }
            map.put(enumItemSlot, itemBySlot);
            record EquipmentChangeImpl(org.bukkit.inventory.ItemStack oldItem, org.bukkit.inventory.ItemStack newItem) implements EntityEquipmentChangedEvent.EquipmentChange
            {
                private final org.bukkit.inventory.ItemStack oldItem;
                private final org.bukkit.inventory.ItemStack newItem;

                public org.bukkit.inventory.ItemStack oldItem() {
                    return this.oldItem.clone();
                }

                public org.bukkit.inventory.ItemStack newItem() {
                    return this.newItem.clone();
                }
            }
            equipmentChanges.put(CraftEquipmentSlot.getSlot(enumItemSlot), new EquipmentChangeImpl(oldItem, newItem));
            AttributeMapBase attributes = this.fp();
            if (itemStack.f()) continue;
            this.a(itemStack, enumItemSlot, attributes);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot equipmentSlot1 = (EnumItemSlot)entry.getKey();
                itemBySlot = (ItemStack)entry.getValue();
                if (itemBySlot.f() || itemBySlot.q()) continue;
                itemBySlot.a(equipmentSlot1, (Holder<AttributeBase> holder, AttributeModifier attributeModifier) -> {
                    AttributeModifiable instance = this.cj.a((Holder<AttributeBase>)holder);
                    if (instance != null) {
                        instance.c(attributeModifier.a());
                        instance.b((AttributeModifier)attributeModifier);
                    }
                });
                net.minecraft.world.level.World world = this.an();
                if (!(world instanceof WorldServer)) continue;
                WorldServer serverLevel = (WorldServer)world;
                EnchantmentManager.a(serverLevel, itemBySlot, this, equipmentSlot1);
            }
            new EntityEquipmentChangedEvent((LivingEntity)this.getBukkitLivingEntity(), equipmentChanges).callEvent();
        }
        return map;
    }

    public boolean a(ItemStack oldItem, ItemStack newItem) {
        return !ItemStack.a(newItem, oldItem);
    }

    private void a(Map<EnumItemSlot, ItemStack> hands) {
        ItemStack itemStack = hands.get(EnumItemSlot.a);
        ItemStack itemStack1 = hands.get(EnumItemSlot.b);
        if (itemStack != null && itemStack1 != null && ItemStack.a(itemStack, this.cm.get(EnumItemSlot.b)) && ItemStack.a(itemStack1, this.cm.get(EnumItemSlot.a))) {
            ((WorldServer)this.an()).n().b(this, new PacketPlayOutEntityStatus(this, 55));
            hands.remove(EnumItemSlot.a);
            hands.remove(EnumItemSlot.b);
            this.cm.put(EnumItemSlot.a, itemStack.v());
            this.cm.put(EnumItemSlot.b, itemStack1.v());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> equipment) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipment.size());
        equipment.forEach((equipmentSlot, itemStack) -> {
            ItemStack itemStack1 = itemStack.v();
            list.add(Pair.of((Object)equipmentSlot, (Object)itemStack1));
            this.cm.put((EnumItemSlot)equipmentSlot, itemStack1);
        });
        ((WorldServer)this.an()).n().b(this, new PacketPlayOutEntityEquipment(this.az(), list, true));
    }

    protected void C(float yBodyRot) {
        float f2 = MathHelper.h(yBodyRot - this.bB);
        this.bB += f2 * 0.3f;
        float f1 = MathHelper.h(this.dX() - this.bB);
        float maxHeadRotationRelativeToBody = this.fE();
        if (Math.abs(f1) > maxHeadRotationRelativeToBody) {
            this.bB += f1 - (float)MathHelper.k((double)f1) * maxHeadRotationRelativeToBody;
        }
    }

    protected float fE() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void e_() {
        if (this.cu > 0) {
            --this.cu;
        }
        if (this.cd()) {
            this.n_().e();
        } else if (!this.ds()) {
            this.k(this.dI().c(0.98));
        }
        if (this.bR > 0) {
            this.a(this.bR, this.bQ);
            --this.bR;
        }
        this.bZ.a((Entity)this);
        deltaMovement = this.dI();
        d = deltaMovement.g;
        d1 = deltaMovement.h;
        d2 = deltaMovement.i;
        if (this.ax().equals(EntityTypes.bX)) {
            if (deltaMovement.j() < 9.0E-6) {
                d = 0.0;
                d2 = 0.0;
            }
        } else {
            if (Math.abs(deltaMovement.g) < 0.003) {
                d = 0.0;
            }
            if (Math.abs(deltaMovement.i) < 0.003) {
                d2 = 0.0;
            }
        }
        if (Math.abs(deltaMovement.h) < 0.003) {
            d1 = 0.0;
        }
        this.m(d, d1, d2);
        profilerFiller = Profiler.a();
        profilerFiller.a("ai");
        this.fF();
        if (this.fv()) {
            this.bL = false;
            this.bM = 0.0f;
            this.bO = 0.0f;
        } else if (this.dt() && !this.an().D_()) {
            profilerFiller.a("newAi");
            this.fK();
            profilerFiller.c();
        }
        profilerFiller.c();
        profilerFiller.a("jump");
        if (this.bL && this.eB()) {
            fluidHeight = this.bJ() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.bu() != false && fluidHeight > 0.0;
            fluidJumpThreshold = this.dz();
            if (!flag || this.aS() && !(fluidHeight > fluidJumpThreshold)) {
                if (!this.bJ() || this.aS() && !(fluidHeight > fluidJumpThreshold)) {
                    if ((this.aS() || flag && fluidHeight <= fluidJumpThreshold) && this.cu == 0) {
                        if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                            this.u();
                            this.cu = 10;
                        } else {
                            this.t(false);
                        }
                    }
                } else {
                    this.c(TagsFluid.b);
                }
            } else {
                this.c(TagsFluid.a);
            }
        } else {
            this.cu = 0;
        }
        profilerFiller.c();
        profilerFiller.a("travel");
        if (this.fY()) {
            this.fI();
        }
        boundingBox = this.de();
        vec3 = new Vec3D(this.bM, this.bN, this.bO);
        if (this.d(MobEffects.B) || this.d(MobEffects.y)) {
            this.l();
        }
        if (!((fluidJumpThreshold = this.dg()) instanceof EntityHuman)) ** GOTO lbl-1000
        player = (EntityHuman)fluidJumpThreshold;
        if (this.bX()) {
            this.c(player, vec3);
        } else if (this.ds() && this.dt()) {
            this.m(vec3);
        }
        if (!this.an().D_() || this.dq()) {
            this.aT();
        }
        if (this.an().D_()) {
            this.s(this instanceof EntityBird);
        }
        profilerFiller.c();
        fluidJumpThreshold = this.an();
        if (fluidJumpThreshold instanceof WorldServer) {
            serverLevel = (WorldServer)fluidJumpThreshold;
            profilerFiller.a("freezing");
            if (!(this.aJ && this.dV() || this.freezeLocked)) {
                this.k(Math.max(0, this.cH() - 2));
            }
            this.ex();
            this.ey();
            if (this.at % 40 == 0 && this.cJ() && this.dV()) {
                this.a(serverLevel, this.ei().v(), 1.0f);
            }
            profilerFiller.c();
        }
        profilerFiller.a("push");
        if (this.bV > 0) {
            --this.bV;
            this.a(boundingBox, this.de());
        }
        this.q();
        profilerFiller.c();
        if (this.Y != this.dK() || this.Z != this.dM() || this.aa != this.dQ() || this.ab != this.dX() || this.ac != this.dZ()) {
            if (((WorldServer)this.an()).hasEntityMoveEvent && !(this instanceof EntityHuman)) {
                from = new Location((World)this.an().getWorld(), this.Y, this.Z, this.aa, this.ab, this.ac);
                to = new Location((World)this.an().getWorld(), this.dK(), this.dM(), this.dQ(), this.dX(), this.dZ());
                event = new EntityMoveEvent((LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
                if (!event.callEvent()) {
                    this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
                } else if (!to.equals(event.getTo())) {
                    this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
                }
            }
            if (this.getRider() != null) {
                this.getRider().J();
                if (((WorldServer)this.an()).hasRidableMoveEvent && this instanceof EntityInsentient) {
                    from = new Location((World)this.an().getWorld(), this.Y, this.Z, this.aa, this.ab, this.ac);
                    to = new Location((World)this.an().getWorld(), this.dK(), this.dM(), this.dQ(), this.dX(), this.dZ());
                    event = new RidableMoveEvent((Mob)this.getBukkitLivingEntity(), (Player)this.getRider().getBukkitEntity(), from, to.clone());
                    if (!event.callEvent()) {
                        this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
                    } else if (!to.equals(event.getTo())) {
                        this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
                    }
                }
            }
        }
        if ((to = this.an()) instanceof WorldServer) {
            serverLevel = (WorldServer)to;
            if (this.fG() && this.bw()) {
                this.a(serverLevel, this.ei().i(), 1.0f);
            }
        }
        if (this.bX()) {
            v0 = flag = this.shouldBurnInDay() != false && this.gC() != false;
            if (flag) {
                itemBySlot = this.a(EnumItemSlot.f);
                if (!itemBySlot.f()) {
                    if (itemBySlot.m()) {
                        item = itemBySlot.h();
                        itemBySlot.b(itemBySlot.o() + this.as.a(2));
                        if (itemBySlot.o() >= itemBySlot.p()) {
                            this.a(item, EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.l);
                        }
                    }
                    flag = false;
                }
                if (flag && (this.getRider() == null || !this.isControllable())) {
                    this.e(8.0f);
                }
            }
        }
    }

    protected void fF() {
        this.bM *= 0.98f;
        this.bO *= 0.98f;
    }

    public boolean fG() {
        return false;
    }

    public boolean fH() {
        return this.bL;
    }

    protected void fI() {
        this.cL();
        if (!this.an().D_()) {
            if (!this.fJ()) {
                if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
                return;
            }
            int i2 = this.bU + 1;
            if (i2 % 10 == 0) {
                int i1 = i2 / 10;
                if (i1 % 2 == 0) {
                    double speed;
                    List<EnumItemSlot> list = EnumItemSlot.j.stream().filter(equipmentSlot1 -> EntityLiving.b(this.a((EnumItemSlot)equipmentSlot1), equipmentSlot1)).toList();
                    EnumItemSlot equipmentSlot = SystemUtils.a(list, this.as);
                    int damage = this.an().purpurConfig.elytraDamagePerSecond;
                    if (this.an().purpurConfig.elytraDamageMultiplyBySpeed > 0.0 && (speed = this.dI().h()) > this.an().purpurConfig.elytraDamageMultiplyBySpeed) {
                        damage *= (int)speed;
                    }
                    this.a(equipmentSlot).a(damage, this, equipmentSlot);
                }
                this.c(GameEvent.n);
            }
        }
    }

    public boolean fJ() {
        if (!(this.aS() || this.cl() || this.d(MobEffects.y))) {
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                if (!EntityLiving.b(this.a(equipmentSlot), equipmentSlot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fK() {
    }

    protected void q() {
        if (!this.bU()) {
            return;
        }
        ScoreboardTeam team = this.cD();
        if (team != null && ((ScoreboardTeamBase)team).m() == ScoreboardTeamBase.EnumTeamPush.b) {
            return;
        }
        int _int = ((WorldServer)this.an()).S().d(GameRules.w);
        if (_int <= 0 && this.an().paperConfig().collisions.maxEntityCollisions <= 0) {
            return;
        }
        List<Entity> pushableEntities = this.an().i(this, this.de());
        if (!pushableEntities.isEmpty()) {
            net.minecraft.world.level.World world = this.an();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (_int > 0 && pushableEntities.size() > _int - 1 && this.as.a(4) == 0) {
                    int i2 = 0;
                    for (Entity entity : pushableEntities) {
                        if (entity.cl()) continue;
                        ++i2;
                    }
                    if (i2 > _int - 1) {
                        this.a(serverLevel, this.ei().h(), 6.0f);
                    }
                }
            }
            this.numCollisions = Math.max(0, this.numCollisions - this.an().paperConfig().collisions.maxEntityCollisions);
            for (Entity entity1 : pushableEntities) {
                if (this.numCollisions >= this.an().paperConfig().collisions.maxEntityCollisions) break;
                ++entity1.numCollisions;
                ++this.numCollisions;
                this.E(entity1);
            }
        }
    }

    protected void a(AxisAlignedBB boundingBoxBeforeSpin, AxisAlignedBB boundingBoxAfterSpin) {
        AxisAlignedBB aabb = boundingBoxBeforeSpin.b(boundingBoxAfterSpin);
        List<Entity> entities = this.an().a_(this, aabb);
        int skippedAttackedEntitiesCounter = 0;
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                EntityPlayer serverPlayer;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer && !(serverPlayer = (EntityPlayer)entityLiving).getBukkitEntity().canSee(entity.getBukkitEntity())) {
                    ++skippedAttackedEntitiesCounter;
                    continue;
                }
                if (!(entity instanceof EntityLiving)) continue;
                if (!new EntityAttemptSpinAttackEvent((LivingEntity)this.getBukkitLivingEntity(), (LivingEntity)((EntityLiving)entity).getBukkitLivingEntity()).callEvent()) {
                    ++skippedAttackedEntitiesCounter;
                    continue;
                }
                this.f((EntityLiving)entity);
                this.bV = 0;
                this.k(this.dI().c(-0.2));
                break;
            }
        }
        if (this.ad && skippedAttackedEntitiesCounter == entities.size()) {
            this.bV = 0;
        }
        if (!this.an().D_() && this.bV <= 0) {
            this.c(4, false);
            this.bW = 0.0f;
            this.bX = null;
        }
    }

    protected void E(Entity entity) {
        entity.h(this);
    }

    protected void f(EntityLiving target) {
    }

    public boolean fL() {
        return (this.az.a(bj) & 4) != 0;
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity vehicle = this.du();
        super.stopRiding(suppressCancellation);
        if (vehicle != null && vehicle != this.du() && !this.an().D_() && vehicle.valid) {
            this.G(vehicle);
        }
    }

    @Override
    public void t() {
        super.t();
        this.l();
    }

    @Override
    public InterpolationHandler n_() {
        return this.bP;
    }

    @Override
    public void a(float yRot, int steps) {
        this.bQ = yRot;
        this.bR = steps;
    }

    public void t(boolean jumping) {
        this.bL = jumping;
    }

    public void a(EntityItem itemEntity) {
        Entity owner = EntityReference.getEntity(itemEntity.n, this.an()::getGlobalPlayerByUUID, Entity.class);
        if (owner instanceof EntityPlayer) {
            CriterionTriggers.R.a((EntityPlayer)owner, itemEntity.e(), this);
        }
    }

    public void a(Entity entity, int amount) {
        if (!entity.ec() && !this.an().D_() && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.an()).n().a(entity, new PacketPlayOutCollect(entity.az(), this.az(), amount));
        }
    }

    public boolean F(Entity entity) {
        return this.a(entity, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity.dO());
    }

    public boolean a(Entity entity, RayTrace.BlockCollisionOption block, RayTrace.FluidCollisionOption fluid, double y2) {
        if (entity.an() != this.an()) {
            return false;
        }
        Vec3D vec3 = new Vec3D(this.dK(), this.dO(), this.dQ());
        Vec3D vec31 = new Vec3D(entity.dK(), y2, entity.dQ());
        return !(vec31.g(vec3) > 16384.0) && this.an().a(new RayTrace(vec3, vec31, block, fluid, this)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float j(float partialTick) {
        return partialTick == 1.0f ? this.bD : MathHelper.i(partialTick, this.bE, this.bD);
    }

    public float D(float partialTick) {
        float f2 = this.bx - this.bw;
        if (f2 < 0.0f) {
            f2 += 1.0f;
        }
        return this.bw + f2 * partialTick;
    }

    @Override
    public boolean bT() {
        return !this.ec() && this.collides;
    }

    @Override
    public boolean bU() {
        return this.isCollidable(this.an().paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.bX() && !this.at() && (ignoreClimbing || !this.fe()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bU() && this.collides != this.collidableExemptions.contains(entity.cT());
    }

    @Override
    public float cN() {
        return this.bD;
    }

    @Override
    public void r(float rotation) {
        this.bD = rotation;
    }

    @Override
    public void s(float offset) {
        this.bB = offset;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return EntityLiving.n(super.a(axis, portal));
    }

    public static Vec3D n(Vec3D relativePortalPosition) {
        return new Vec3D(relativePortalPosition.g, relativePortalPosition.h, 0.0);
    }

    public float fM() {
        return this.cv;
    }

    public final void E(float absorptionAmount) {
        this.F(!Float.isNaN(absorptionAmount) ? MathHelper.a(absorptionAmount, 0.0f, this.fk()) : 0.0f);
    }

    protected void F(float absorptionAmount) {
        this.cv = absorptionAmount;
    }

    public void i_() {
    }

    public void Q_() {
    }

    protected void fN() {
        this.co = true;
    }

    public abstract EnumMainHand as();

    public boolean fO() {
        return (this.az.a(bj) & 1) > 0;
    }

    public EnumHand fP() {
        return (this.az.a(bj) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    public void resyncUsingItem(EntityPlayer serverPlayer) {
        this.resendPossiblyDesyncedDataValues(List.of(bj), serverPlayer);
    }

    private void P() {
        if (this.fO()) {
            if (ItemStack.b(this.b(this.fP()), this.bS)) {
                this.bS = this.b(this.fP());
                this.a(this.bS);
            } else {
                this.fU();
            }
        }
    }

    @Nullable
    private EntityItem b(ItemStack stack, boolean randomizeMotion, boolean includeThrower) {
        if (stack.f()) {
            return null;
        }
        double d2 = this.dO() - (double)0.3f;
        ItemStack tmp = stack.v();
        stack.e(0);
        stack = tmp;
        EntityItem itemEntity = new EntityItem(this.an(), this.dK(), d2, this.dQ(), stack);
        itemEntity.b(40);
        if (includeThrower) {
            itemEntity.b((Entity)this);
        }
        if (randomizeMotion) {
            float f2 = this.as.i() * 0.5f;
            float f1 = this.as.i() * ((float)Math.PI * 2);
            itemEntity.m(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dZ() * ((float)Math.PI / 180));
            float cos = MathHelper.b(this.dZ() * ((float)Math.PI / 180));
            float sin = MathHelper.a(this.dX() * ((float)Math.PI / 180));
            float cos1 = MathHelper.b(this.dX() * ((float)Math.PI / 180));
            float f2 = this.as.i() * ((float)Math.PI * 2);
            float f32 = 0.02f * this.as.i();
            itemEntity.m((double)(-sin * cos * 0.3f) + Math.cos(f2) * (double)f32, -f1 * 0.3f + 0.1f + (this.as.i() - this.as.i()) * 0.1f, (double)(cos1 * cos * 0.3f) + Math.sin(f2) * (double)f32);
        }
        return itemEntity;
    }

    protected void a(ItemStack usingItem) {
        boolean shouldLagCompensate;
        usingItem.b(this.an(), this, this.fR());
        boolean bl = shouldLagCompensate = this.bS.c(DataComponents.v) && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (1L + (long)this.totalEatTimeTicks) * 50L * 1000000L;
        if (!(--this.bT != 0 && !shouldLagCompensate || this.an().D_() || usingItem.x())) {
            this.bT = 0;
            this.R_();
        }
    }

    private void Q() {
        this.cB = this.cA;
        this.cA = this.cx() ? Math.min(1.0f, this.cA + 0.09f) : Math.max(0.0f, this.cA - 0.09f);
    }

    public void c(int key, boolean value) {
        int i2 = this.az.a(bj).byteValue();
        i2 = value ? (i2 |= key) : (i2 &= ~key);
        this.az.a(bj, (byte)i2);
    }

    public void c(EnumHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(EnumHand hand, boolean forceUpdate) {
        ItemStack itemInHand = this.b(hand);
        if (!itemInHand.f() && !this.fO() || forceUpdate) {
            this.bS = itemInHand;
            this.bT = this.totalEatTimeTicks = itemInHand.a(this);
            this.eatStartTime = System.nanoTime();
            if (!this.an().D_()) {
                this.c(1, true);
                this.c(2, hand == EnumHand.b);
                this.c(GameEvent.D);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (cg.equals(key)) {
            if (this.an().D_()) {
                this.ge().ifPresent(this::a);
            }
        } else if (bj.equals(key) && this.an().D_()) {
            if (this.fO() && this.bS.f()) {
                this.bS = this.b(this.fP());
                if (!this.bS.f()) {
                    this.bT = this.bS.a(this);
                }
            } else if (!this.fO() && !this.bS.f()) {
                this.bS = ItemStack.l;
                this.totalEatTimeTicks = 0;
                this.bT = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        super.a(anchor, target);
        this.bE = this.bD;
        this.bC = this.bB = this.bD;
    }

    @Override
    public float t(float partialTick) {
        return MathHelper.h(partialTick, this.bC, this.bB);
    }

    public void b(ItemStack stack, int amount) {
        for (int i2 = 0; i2 < amount; ++i2) {
            Vec3D vec3 = new Vec3D(((double)this.as.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.a(-this.dZ() * ((float)Math.PI / 180));
            vec3 = vec3.b(-this.dX() * ((float)Math.PI / 180));
            double d2 = (double)(-this.as.i()) * 0.6 - 0.3;
            Vec3D vec31 = new Vec3D(((double)this.as.i() - 0.5) * 0.3, d2, 0.6);
            vec31 = vec31.a(-this.dZ() * ((float)Math.PI / 180));
            vec31 = vec31.b(-this.dX() * ((float)Math.PI / 180));
            vec31 = vec31.b(this.dK(), this.dO(), this.dQ());
            this.an().a(new ParticleParamItem(Particles.V, stack), vec31.g, vec31.h, vec31.i, vec3.g, vec3.h + 0.05, vec3.i);
        }
    }

    public void R_() {
        if (!this.an().D_() || this.fO()) {
            EnumHand usedItemHand = this.fP();
            if (!this.bS.equals(this.b(usedItemHand))) {
                this.fT();
            } else if (!this.bS.f() && this.fO()) {
                ItemStack itemStack;
                this.startUsingItem(this.fP(), true);
                PlayerItemConsumeEvent event = null;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bS);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(usedItemHand);
                    event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.bS.a(DataComponents.w);
                        if (consumable != null) {
                            consumable.cancelUsingItem(serverPlayer, this.bS);
                        }
                        serverPlayer.cl.forceHeldSlot(this.fP());
                        serverPlayer.getBukkitEntity().updateScaledHealth();
                        this.fU();
                        return;
                    }
                    itemStack = craftItem.equals((Object)event.getItem()) ? this.bS.a(this.an(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.an(), this);
                } else {
                    itemStack = this.bS.a(this.an(), this);
                }
                ItemStack defaultReplacement = itemStack;
                if (event != null && event.getReplacement() != null) {
                    itemStack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemStack != this.bS) {
                    this.a(usedItemHand, itemStack);
                }
                this.fU();
            }
        }
    }

    public void b(ItemStack stack) {
    }

    public ItemStack fQ() {
        return this.bS;
    }

    public int fR() {
        return this.bT;
    }

    public int fS() {
        return this.fO() ? this.bS.a(this) - this.fR() : 0;
    }

    public void fT() {
        ItemStack itemInHand = this.b(this.fP());
        if (!this.bS.f() && ItemStack.b(itemInHand, this.bS)) {
            this.bS = itemInHand;
            if (this instanceof EntityPlayer) {
                new PlayerStopUsingItemEvent((Player)this.getBukkitEntity(), this.bS.asBukkitMirror(), this.fS()).callEvent();
            }
            this.bS.a(this.an(), this, this.fR());
            if (this.bS.x()) {
                this.P();
            }
        }
        this.fU();
    }

    public void fU() {
        if (!this.an().D_()) {
            boolean isUsingItem = this.fO();
            this.c(1, false);
            if (isUsingItem) {
                this.c(GameEvent.C);
            }
        }
        this.bS = ItemStack.l;
        this.totalEatTimeTicks = 0;
        this.bT = 0;
        this.eatStartTime = -1L;
    }

    public boolean fV() {
        return this.fW() != null;
    }

    @Nullable
    public ItemStack fW() {
        int i2;
        if (!this.fO()) {
            return null;
        }
        BlocksAttacks blocksAttacks = this.bS.a(DataComponents.I);
        if (blocksAttacks != null && (i2 = this.bS.h().a(this.bS, this) - this.bT) >= blocksAttacks.a()) {
            return this.bS;
        }
        return null;
    }

    @Override
    public float getBukkitYaw() {
        return this.cN();
    }

    public MovingObjectPosition getRayTrace(int maxDistance, RayTrace.FluidCollisionOption fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = new Vec3D(this.dK(), this.dM() + (double)this.df(), this.dQ());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3D end = new Vec3D(start.g + dir.getX(), start.h + dir.getY(), start.i + dir.getZ());
        RayTrace raytrace = new RayTrace(start, end, RayTrace.BlockCollisionOption.b, fluidCollisionOption, this);
        return this.an().a(raytrace);
    }

    @Nullable
    public MovingObjectPositionEntity getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = this.n(1.0f);
        Vec3D direction = this.cf();
        Vec3D end = start.b(direction.g * (double)maxDistance, direction.h * (double)maxDistance, direction.i * (double)maxDistance);
        List<Entity> entityList = this.an().a((Entity)this, this.de().b(direction.g * (double)maxDistance, direction.h * (double)maxDistance, direction.i * (double)maxDistance).c(1.0, 1.0, 1.0), IEntitySelector.f.and(Entity::bT));
        double distance = 0.0;
        MovingObjectPositionEntity result = null;
        for (Entity entity : entityList) {
            Vec3D rayTrace;
            double distanceTo;
            double inflationAmount = entity.ce();
            AxisAlignedBB aabb = entity.de().c(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3D> rayTraceResult = aabb.b(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.g(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new MovingObjectPositionEntity(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public boolean fX() {
        return this.cp();
    }

    public boolean fY() {
        return this.i(7);
    }

    @Override
    public boolean cx() {
        return super.cx() || !this.fY() && this.d(EntityPose.b);
    }

    public int fZ() {
        return this.bU;
    }

    public boolean b(double x2, double y2, double z2, boolean broadcastTeleport) {
        return this.randomTeleport(x2, y2, z2, broadcastTeleport, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double x2, double y2, double z2, boolean broadcastTeleport, PlayerTeleportEvent.TeleportCause cause) {
        EntityLiving entityLiving;
        double x1 = this.dK();
        double y1 = this.dM();
        double z1 = this.dQ();
        double d2 = y2;
        boolean flag = false;
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        net.minecraft.world.level.World level = this.an();
        if (level.D(blockPos)) {
            boolean flag1 = false;
            while (!flag1 && blockPos.v() > level.M_()) {
                BlockPosition blockPos1 = blockPos.e();
                IBlockData blockState = level.a_(blockPos1);
                if (blockState.d()) {
                    flag1 = true;
                    continue;
                }
                d2 -= 1.0;
                blockPos = blockPos1;
            }
            if (flag1) {
                this.a_(x2, d2, z2);
                if (level.g(this) && !level.d(this.de())) {
                    flag = true;
                }
                this.a_(x1, y1, z1);
                if (flag) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.an().getWorld(), x1, y1, z1), new Location((World)this.an().getWorld(), x2, d2, z2));
                        this.an().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled() || teleport.getTo() == null) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).g.teleport(x2, d2, z2, this.dX(), this.dZ(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag) {
            return Optional.of(false);
        }
        if (broadcastTeleport) {
            level.a((Entity)this, (byte)46);
        }
        if (!((entityLiving = this) instanceof EntityCreature)) return Optional.of(true);
        EntityCreature pathfinderMob = (EntityCreature)entityLiving;
        pathfinderMob.S().n();
        return Optional.of(true);
    }

    public boolean ga() {
        return !this.eV();
    }

    public boolean gb() {
        return true;
    }

    public void a(BlockPosition jukebox, boolean partyParrot) {
    }

    public boolean gc() {
        return false;
    }

    @Override
    public final EntitySize a(EntityPose pose) {
        return pose == EntityPose.c ? bk : this.b(pose).a(this.eA());
    }

    protected EntitySize b(EntityPose pose) {
        return this.ax().n().a(this.ez());
    }

    public ImmutableList<EntityPose> gd() {
        return ImmutableList.of((Object)EntityPose.a);
    }

    public AxisAlignedBB f(EntityPose pose) {
        EntitySize dimensions = this.a(pose);
        return new AxisAlignedBB(-dimensions.a() / 2.0f, 0.0, -dimensions.a() / 2.0f, dimensions.a() / 2.0f, dimensions.b(), dimensions.a() / 2.0f);
    }

    protected boolean g(EntityPose pose) {
        AxisAlignedBB aabb = this.a(pose).a(this.dD());
        return this.an().b(this, aabb);
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return super.o(allowPassengers) && !this.gg();
    }

    public Optional<BlockPosition> ge() {
        return this.az.a(cg);
    }

    public void g(BlockPosition pos) {
        this.az.a(cg, Optional.of(pos));
    }

    public void gf() {
        this.az.a(cg, Optional.empty());
    }

    public boolean gg() {
        return this.ge().isPresent();
    }

    public void b(BlockPosition pos) {
        IBlockData blockState;
        if (this.cl()) {
            this.cb();
        }
        if ((blockState = this.an().a_(pos)).b() instanceof BlockBed) {
            this.an().a(pos, (IBlockData)blockState.b(BlockBed.c, true), 3);
        }
        this.c(EntityPose.c);
        this.a(pos);
        this.g(pos);
        this.k(Vec3D.c);
        this.aF = true;
    }

    private void a(BlockPosition pos) {
        this.a_((double)pos.u() + 0.5, (double)pos.v() + 0.6875, (double)pos.w() + 0.5);
    }

    private boolean R() {
        return this.ge().map(blockPos -> this.an().a_((BlockPosition)blockPos).b() instanceof BlockBed).orElse(false);
    }

    public void gh() {
        this.ge().filter(this.an()::D).ifPresent(blockPos -> {
            IBlockData blockState = this.an().a_((BlockPosition)blockPos);
            if (blockState.b() instanceof BlockBed) {
                EnumDirection direction = blockState.c(BlockFacingHorizontal.f);
                this.an().a((BlockPosition)blockPos, (IBlockData)blockState.b(BlockBed.c, false), 3);
                Vec3D vec31 = BlockBed.a(this.ax(), (ICollisionAccess)this.an(), blockPos, direction, this.dX()).orElseGet(() -> {
                    BlockPosition blockPos1 = blockPos.d();
                    return new Vec3D((double)blockPos1.u() + 0.5, (double)blockPos1.v() + 0.1, (double)blockPos1.w() + 0.5);
                });
                Vec3D vec32 = Vec3D.c(blockPos).d(vec31).d();
                float f2 = (float)MathHelper.e(MathHelper.d(vec32.i, vec32.g) * 180.0 / 3.1415927410125732 - 90.0);
                this.a_(vec31.g, vec31.h, vec31.i);
                this.v(f2);
                this.w(0.0f);
            }
        });
        Vec3D vec3 = this.dD();
        this.c(EntityPose.a);
        this.a_(vec3.g, vec3.h, vec3.i);
        this.gf();
    }

    @Nullable
    public EnumDirection gi() {
        BlockPosition blockPos = this.ge().orElse(null);
        return blockPos != null ? BlockBed.a(this.an(), blockPos) : null;
    }

    @Override
    public boolean bY() {
        return !this.gg() && super.bY();
    }

    public ItemStack d(ItemStack weaponStack) {
        return ItemStack.l;
    }

    public static byte g(EnumItemSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.a -> 47;
            case EnumItemSlot.b -> 48;
            case EnumItemSlot.f -> 49;
            case EnumItemSlot.e -> 50;
            case EnumItemSlot.c -> 52;
            case EnumItemSlot.d -> 51;
            case EnumItemSlot.g -> 65;
            case EnumItemSlot.h -> 68;
        };
    }

    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        this.an().a((Entity)this, EntityLiving.g(slot));
        this.a(this.a(slot), slot, this.cj);
    }

    private void a(ItemStack stack, EnumItemSlot slot, AttributeMapBase attributeMap) {
        stack.a(slot, (Holder<AttributeBase> holder, AttributeModifier attributeModifier) -> {
            AttributeModifiable instance = attributeMap.a((Holder<AttributeBase>)holder);
            if (instance != null) {
                instance.e((AttributeModifier)attributeModifier);
            }
        });
        EnchantmentManager.a(stack, this, slot);
    }

    public final boolean e(ItemStack stack) {
        if (this.bX() && !this.at()) {
            Equippable equippable = stack.a(DataComponents.D);
            if (equippable != null && equippable.g()) {
                EnumItemSlot equipmentSlot = equippable.b();
                return this.e(equipmentSlot) && equippable.a(this.ax()) && this.a(equipmentSlot).f() && this.f(equipmentSlot);
            }
            return false;
        }
        return false;
    }

    protected boolean f(EnumItemSlot slot) {
        return true;
    }

    public final EnumItemSlot f(ItemStack stack) {
        Equippable equippable = stack.a(DataComponents.D);
        return equippable != null && this.e(equippable.b()) ? equippable.b() : EnumItemSlot.a;
    }

    public final boolean a(ItemStack stack, EnumItemSlot slot) {
        Equippable equippable = stack.a(DataComponents.D);
        return equippable == null ? slot == EnumItemSlot.a && this.e(EnumItemSlot.a) : slot == equippable.b() && this.e(equippable.b()) && equippable.a(this.ax());
    }

    @Nullable
    public EnumItemSlot getEquipmentSlotForDispenserItem(ItemStack itemstack) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.k, itemstack) > 0 ? null : this.f(itemstack);
    }

    private static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return slot != EnumItemSlot.f && slot != EnumItemSlot.a && slot != EnumItemSlot.b ? SlotAccess.a(entity, slot, (ItemStack itemStack) -> itemStack.f() || entity.f((ItemStack)itemStack) == slot) : SlotAccess.a(entity, slot);
    }

    @Nullable
    private static EnumItemSlot r(int index) {
        if (index == 100 + EnumItemSlot.f.b()) {
            return EnumItemSlot.f;
        }
        if (index == 100 + EnumItemSlot.e.b()) {
            return EnumItemSlot.e;
        }
        if (index == 100 + EnumItemSlot.d.b()) {
            return EnumItemSlot.d;
        }
        if (index == 100 + EnumItemSlot.c.b()) {
            return EnumItemSlot.c;
        }
        if (index == 98) {
            return EnumItemSlot.a;
        }
        if (index == 99) {
            return EnumItemSlot.b;
        }
        if (index == 105) {
            return EnumItemSlot.g;
        }
        return index == 106 ? EnumItemSlot.h : null;
    }

    @Override
    public SlotAccess a_(int slot) {
        EnumItemSlot equipmentSlot = EntityLiving.r(slot);
        return equipmentSlot != null ? EntityLiving.a(this, equipmentSlot) : super.a_(slot);
    }

    @Override
    public boolean dV() {
        if (this.at()) {
            return false;
        }
        for (EnumItemSlot equipmentSlot : EquipmentSlotGroup.i) {
            if (!this.a(equipmentSlot).a(TagsItem.bH)) continue;
            return false;
        }
        return super.dV();
    }

    @Override
    public boolean cA() {
        return !this.an().D_() && this.d(MobEffects.x) || super.cA();
    }

    @Override
    public float dY() {
        return this.bB;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        float yRot = packet.l();
        float xRot = packet.k();
        this.e(x2, y2, z2);
        this.bB = packet.m();
        this.bD = packet.m();
        this.bC = this.bB;
        this.bE = this.bD;
        this.e(packet.b());
        this.a_(packet.e());
        this.a(x2, y2, z2, yRot, xRot);
        this.k(packet.j());
    }

    public float gj() {
        Weapon weapon = this.el().a(DataComponents.B);
        return weapon != null ? weapon.b() : 0.0f;
    }

    @Override
    public float eb() {
        float f2 = (float)this.i(GenericAttributes.C);
        return this.dg() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D n(Entity entity) {
        return this.dD().e(this.a(entity, this.a(this.aE()), this.eA() * this.ez()));
    }

    protected void a(int steps, double yRot) {
        this.bD = (float)MathHelper.e(1.0 / (double)steps, (double)this.bD, yRot);
    }

    @Override
    public void g(int ticks) {
        super.g(MathHelper.c((double)ticks * this.i(GenericAttributes.h)));
    }

    public boolean gk() {
        return false;
    }

    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.d(damageSource) || EnchantmentManager.a(level, this, damageSource);
    }

    public static boolean b(ItemStack stack, EnumItemSlot slot) {
        if (!stack.c(DataComponents.F)) {
            return false;
        }
        Equippable equippable = stack.a(DataComponents.D);
        return equippable != null && slot == equippable.b() && !stack.r();
    }

    @VisibleForTesting
    public int gl() {
        return this.bH;
    }

    @Override
    public boolean gm() {
        return this.i(GenericAttributes.H) > 0.0;
    }

    @Override
    public Optional<WaypointTransmitter.c> f(EntityPlayer player) {
        if (this.ay || player == this) {
            return Optional.empty();
        }
        if (WaypointTransmitter.a(this, player)) {
            return Optional.empty();
        }
        Waypoint.a icon = this.cE.a(this);
        if (WaypointTransmitter.b(this, player)) {
            return Optional.of(new WaypointTransmitter.d(this, icon, player));
        }
        return !WaypointTransmitter.a(this.dH(), player) ? Optional.of(new WaypointTransmitter.f(this, icon, player)) : Optional.of(new WaypointTransmitter.e(this, icon, player));
    }

    @Override
    public Waypoint.a gn() {
        return this.cE;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

