/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public final class EntityReference<StoredEntityType extends UniquelyIdentifyable> {
    private static final Codec<? extends EntityReference<?>> a = UUIDUtil.a.xmap(EntityReference::new, EntityReference::c);
    private static final StreamCodec<ByteBuf, ? extends EntityReference<?>> b = UUIDUtil.g.a(EntityReference::new, EntityReference::c);
    private Either<UUID, StoredEntityType> c;

    public static <Type extends UniquelyIdentifyable> Codec<EntityReference<Type>> a() {
        return a;
    }

    public static <Type extends UniquelyIdentifyable> StreamCodec<ByteBuf, EntityReference<Type>> b() {
        return b;
    }

    private EntityReference(StoredEntityType entity) {
        this.c = Either.right(entity);
    }

    private EntityReference(UUID uuid) {
        this.c = Either.left(uuid);
    }

    @Nullable
    public static <T extends UniquelyIdentifyable> EntityReference<T> a(@Nullable T entity) {
        return entity != null ? new EntityReference<T>(entity) : null;
    }

    public static <T extends UniquelyIdentifyable> EntityReference<T> a(UUID uuid) {
        return new EntityReference(uuid);
    }

    public UUID c() {
        return this.c.map(uuid -> uuid, UniquelyIdentifyable::cT);
    }

    @Nullable
    public StoredEntityType a(UUIDLookup<? extends UniquelyIdentifyable> uuidLookup, Class<StoredEntityType> entityClass) {
        StoredEntityType uniquelyIdentifyable1;
        Optional<UUID> optional1;
        Optional<StoredEntityType> optional = this.c.right();
        if (optional.isPresent()) {
            UniquelyIdentifyable uniquelyIdentifyable = (UniquelyIdentifyable)optional.get();
            if (!uniquelyIdentifyable.ec()) {
                return (StoredEntityType)uniquelyIdentifyable;
            }
            this.c = Either.left(uniquelyIdentifyable.cT());
        }
        if ((optional1 = this.c.left()).isPresent() && (uniquelyIdentifyable1 = this.a(uuidLookup.lookup(optional1.get()), entityClass)) != null && !uniquelyIdentifyable1.ec()) {
            this.c = Either.right(uniquelyIdentifyable1);
            return uniquelyIdentifyable1;
        }
        return null;
    }

    @Nullable
    public StoredEntityType a(World level, Class<StoredEntityType> entityClass) {
        return EntityHuman.class.isAssignableFrom(entityClass) ? this.a(level::b, entityClass) : this.a(level::a, entityClass);
    }

    @Nullable
    private StoredEntityType a(@Nullable UniquelyIdentifyable entity, Class<StoredEntityType> entityClass) {
        return (StoredEntityType)(entity != null && entityClass.isAssignableFrom(entity.getClass()) ? (UniquelyIdentifyable)entityClass.cast(entity) : null);
    }

    public boolean b(StoredEntityType entity) {
        return this.c().equals(entity.cT());
    }

    public void a(ValueOutput output, String key) {
        output.a(key, UUIDUtil.a, this.c());
    }

    public static void a(@Nullable EntityReference<?> key, ValueOutput output, String uuid) {
        if (key != null) {
            key.a(output, uuid);
        }
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> StoredEntityType a(@Nullable EntityReference<StoredEntityType> reference, World level, Class<StoredEntityType> entityClass) {
        return reference != null ? (StoredEntityType)reference.a(level, entityClass) : null;
    }

    @Nullable
    public static Entity a(@Nullable EntityReference<Entity> reference, World level) {
        return EntityReference.a(reference, level, Entity.class);
    }

    @Nullable
    public static EntityLiving b(@Nullable EntityReference<EntityLiving> reference, World level) {
        return EntityReference.a(reference, level, EntityLiving.class);
    }

    @Nullable
    public static EntityHuman c(@Nullable EntityReference<EntityHuman> reference, World level) {
        return EntityReference.a(reference, level, EntityHuman.class);
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> a(ValueInput input, String key) {
        return input.a(key, EntityReference.a()).orElse(null);
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> a(ValueInput input, String key, World level) {
        Optional<UUID> optional = input.a(key, UUIDUtil.a);
        return optional.isPresent() ? EntityReference.a(optional.get()) : (EntityReference)input.g(key).map(string -> NameReferencingFileConverter.a(level.q(), string)).map(EntityReference::new).orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof EntityReference)) return false;
        EntityReference entityReference = (EntityReference)other;
        if (!this.c().equals(entityReference.c())) return false;
        return true;
    }

    public int hashCode() {
        return this.c().hashCode();
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> StoredEntityType getEntity(@Nullable EntityReference<StoredEntityType> ref, UUIDLookup<? extends UniquelyIdentifyable> uuidLookup, Class<StoredEntityType> entityClass) {
        return ref == null ? null : (StoredEntityType)ref.a(uuidLookup, entityClass);
    }
}

