/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Tameable;
import org.bukkit.event.entity.EntityTeleportEvent;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    public static final int ct = 144;
    private static final int cx = 2;
    private static final int cy = 3;
    private static final int cz = 1;
    private static final boolean cA = false;
    protected static final DataWatcherObject<Byte> cu = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> cv = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.r);
    private boolean cB = false;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cu, (byte)0);
        builder.a(cv, Optional.empty());
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        EntityReference<EntityLiving> ownerReference = this.d();
        EntityReference.a(ownerReference, output, "Owner");
        output.a("Sitting", this.cB);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        EntityReference withOldOwnerConversion = EntityReference.a(input, "Owner", this.an());
        if (withOldOwnerConversion != null) {
            try {
                this.az.a(cv, Optional.of(withOldOwnerConversion));
                this.a(true, false);
            }
            catch (Throwable var4) {
                this.a(false, true);
            }
        } else {
            this.az.a(cv, Optional.empty());
            this.a(false, true);
        }
        this.cB = input.a("Sitting", false);
        this.setInSittingPose(this.cB, false);
    }

    @Override
    public boolean v() {
        return true;
    }

    protected void x(boolean tamed) {
        ParticleType particleOptions = Particles.T;
        if (!tamed) {
            particleOptions = Particles.ai;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d22 = this.as.k() * 0.02;
            this.an().a(particleOptions, this.e(1.0), this.dN() + 0.5, this.h(1.0), d2, d1, d22);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 7) {
            this.x(true);
        } else if (id == 6) {
            this.x(false);
        } else {
            super.b(id);
        }
    }

    public boolean m() {
        return (this.az.a(cu) & 4) != 0;
    }

    public void a(boolean tame, boolean applyTamingSideEffects) {
        byte b2 = this.az.a(cu);
        if (tame) {
            this.az.a(cu, (byte)(b2 | 4));
        } else {
            this.az.a(cu, (byte)(b2 & 0xFFFFFFFB));
        }
        if (applyTamingSideEffects) {
            this.n();
        }
    }

    protected void n() {
    }

    public boolean s() {
        return (this.az.a(cu) & 1) != 0;
    }

    public void y(boolean sitting) {
        this.setInSittingPose(sitting, true);
    }

    public void setInSittingPose(boolean sitting, boolean callEvent) {
        if (callEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        byte b2 = this.az.a(cu);
        if (sitting) {
            this.az.a(cu, (byte)(b2 | 1));
        } else {
            this.az.a(cu, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public EntityReference<EntityLiving> d() {
        return this.az.a(cv).orElse(null);
    }

    public void i(@Nullable EntityLiving owner) {
        this.az.a(cv, Optional.ofNullable(owner).map(EntityReference::a));
    }

    public void a(@Nullable EntityReference<EntityLiving> owner) {
        this.az.a(cv, Optional.ofNullable(owner));
    }

    public void g(EntityHuman player) {
        this.a(true, true);
        this.i(player);
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            CriterionTriggers.y.a(serverPlayer, this);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return !this.j(target) && super.c(target);
    }

    public boolean j(EntityLiving entity) {
        return entity == this.V_();
    }

    public boolean a(EntityLiving target, EntityLiving owner) {
        return true;
    }

    @Override
    @Nullable
    public ScoreboardTeam cD() {
        EntityLiving rootOwner;
        ScoreboardTeam playerTeam = super.cD();
        if (playerTeam != null) {
            return playerTeam;
        }
        if (this.m() && (rootOwner = this.W_()) != null) {
            return rootOwner.cD();
        }
        return null;
    }

    @Override
    protected boolean u(Entity entity) {
        if (this.m()) {
            EntityLiving rootOwner = this.W_();
            if (entity == rootOwner) {
                return true;
            }
            if (rootOwner != null) {
                return rootOwner.u(entity);
            }
        }
        return super.u(entity);
    }

    @Override
    public void a(DamageSource damageSource) {
        WorldServer serverLevel;
        Object object = this.an();
        if (object instanceof WorldServer && (serverLevel = (WorldServer)object).S().c(GameRules.o) && (object = this.V_()) instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)object;
            TameableDeathMessageEvent event = new TameableDeathMessageEvent((Tameable)this.getBukkitEntity(), PaperAdventure.asAdventure(this.fh().a()));
            if (event.callEvent()) {
                serverPlayer.a(PaperAdventure.asVanilla(event.deathMessage()));
            }
        }
        super.a(damageSource);
    }

    public boolean gI() {
        return this.cB;
    }

    public void z(boolean orderedToSit) {
        this.cB = orderedToSit;
    }

    public void gJ() {
        EntityLiving owner = this.V_();
        if (owner != null) {
            this.h(owner.dF());
        }
    }

    public boolean gK() {
        EntityLiving owner = this.V_();
        return owner != null && this.g((Entity)this.V_()) >= 144.0;
    }

    private void h(BlockPosition pos) {
        for (int i2 = 0; i2 < 10; ++i2) {
            int randomInt = this.as.a(-3, 3);
            int randomInt1 = this.as.a(-3, 3);
            if (Math.abs(randomInt) < 2 && Math.abs(randomInt1) < 2) continue;
            int randomInt2 = this.as.a(-1, 1);
            if (!this.a(pos.u() + randomInt, pos.v() + randomInt2, pos.w() + randomInt1)) continue;
            return;
        }
    }

    private boolean a(int x2, int y2, int z2) {
        if (!this.i(new BlockPosition(x2, y2, z2))) {
            return false;
        }
        EntityTeleportEvent event = CraftEventFactory.callEntityTeleportEvent(this, (double)x2 + 0.5, y2, (double)z2 + 0.5);
        if (event.isCancelled() || event.getTo() == null) {
            return false;
        }
        Location to = event.getTo();
        this.b(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
        this.cp.n();
        return true;
    }

    private boolean i(BlockPosition pos) {
        PathType pathTypeStatic = PathfinderNormal.b(this, pos);
        if (pathTypeStatic != PathType.c) {
            return false;
        }
        IBlockData blockState = this.an().a_(pos.e());
        if (!this.gM() && blockState.b() instanceof BlockLeaves) {
            return false;
        }
        BlockPosition blockPos = pos.b(this.dF());
        return this.an().a((Entity)this, this.de().a(blockPos));
    }

    public final boolean gL() {
        return this.gI() || this.cl() || this.o() || this.V_() != null && this.V_().at();
    }

    protected boolean gM() {
        return false;
    }

    public class a
    extends PathfinderGoalPanic {
        public a(double speedModifier, TagKey<DamageType> panicCausingDamageTypes) {
            super((EntityCreature)EntityTameableAnimal.this, speedModifier, panicCausingDamageTypes);
        }

        public a(double speedModifier) {
            super(EntityTameableAnimal.this, speedModifier);
        }

        @Override
        public void a() {
            if (!EntityTameableAnimal.this.gL() && EntityTameableAnimal.this.gK()) {
                EntityTameableAnimal.this.gJ();
            }
            super.a();
        }
    }
}

