/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class GlowSquid
extends EntitySquid {
    private static final DataWatcherObject<Integer> cB = DataWatcher.a(GlowSquid.class, DataWatcherRegistry.b);
    private static final int cC = 0;

    public GlowSquid(EntityTypes<? extends GlowSquid> type, World level) {
        super((EntityTypes<? extends EntitySquid>)type, level);
    }

    @Override
    public boolean canFly() {
        return this.an().purpurConfig.glowSquidsCanFly;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.glowSquidRidable;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.glowSquidControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.glowSquidMaxHealth);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.glowSquidTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.glowSquidAlwaysDropExp;
    }

    @Override
    protected ParticleParam m() {
        return Particles.aT;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cB, 0);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.ak.a(level, EntitySpawnReason.e);
    }

    @Override
    protected SoundEffect n() {
        return SoundEffects.mf;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.mc;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.me;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.md;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("DarkTicksRemaining", this.s());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.s(input.a("DarkTicksRemaining", 0));
    }

    @Override
    public void e_() {
        super.e_();
        int darkTicksRemaining = this.s();
        if (darkTicksRemaining > 0) {
            this.s(darkTicksRemaining - 1);
        }
        this.an().a(Particles.aU, this.e(0.6), this.dN(), this.h(0.6), 0.0, 0.0, 0.0);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag = super.a(level, damageSource, amount);
        if (flag) {
            this.s(100);
        }
        return flag;
    }

    public void s(int darkTicks) {
        this.az.a(cB, darkTicks);
    }

    public int s() {
        return this.az.a(cB);
    }

    public static boolean a(EntityTypes<? extends EntityLiving> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return pos.v() <= level.T() - 33 && level.b(pos, 0) == 0 && level.a_(pos).a(Blocks.J);
    }
}

